// border.h -- Saving information about the simulation.
// 
// Copyright 2005 Per Abrahamsen and KVL.
//
// This file is part of Daisy.
// 
// Daisy is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
// 
// Daisy is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser Public License for more details.
// 
// You should have received a copy of the GNU Lesser Public License
// along with Daisy; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef BORDER_H
#define BORDER_H

class Treelog;

struct Border
{ 
  virtual bool check_z_border (double, Treelog&) const = 0; 
  virtual bool check_x_border (double, Treelog&) const = 0; 
  virtual bool check_y_border (double, Treelog&) const = 0; 
  virtual ~Border ();
};

#endif // BORDER_H
