// groundwater.C
// 
// Copyright 1996-2001 Per Abrahamsen and Sren Hansen
// Copyright 2000-2001 KVL.
//
// This file is part of Daisy.
// 
// Daisy is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
// 
// Daisy is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser Public License for more details.
// 
// You should have received a copy of the GNU Lesser Public License
// along with Daisy; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#define BUILD_DLL

#include "groundwater.h"
#include "geometry.h"
#include "log.h"
#include "block_model.h"
#include "assertion.h"
#include "librarian.h"
#include "frame.h"

const char *const Groundwater::component = "groundwater";

symbol
Groundwater::library_id () const
{
  static const symbol id (component);
  return id;
}

void
Groundwater::accept_bottom (double, const Geometry& geo, size_t edge)
{ daisy_assert (geo.edge_from (edge) == Geometry::cell_below); }

bool 
Groundwater::is_pipe () const
{ return false; }

double 
Groundwater::pipe_height () const
{ daisy_notreached (); }

double 
Groundwater::Z_aquitard () const
{ daisy_notreached (); }

double 
Groundwater::K_aquitard () const
{ daisy_notreached (); }

void 
Groundwater::set_original_bottom (double)
{ daisy_notreached (); }

void
Groundwater::output (Log& log) const
{ 
  output_value (table (), "height", log);
}

Groundwater::Groundwater (const BlockModel& al)
  : ModelDerived (al.type_name ())
{ }

Groundwater::~Groundwater ()
{ }

static struct GroundwaterInit : public DeclareComponent 
{
  GroundwaterInit ()
    : DeclareComponent (Groundwater::component, "\
The 'groundwater' component is responsible for specifying the\n\
groundwater table at each timestep.")
  { }
} Groundwater_init;

static struct GroundwaterBaseSyntax : public DeclareBase
{
  GroundwaterBaseSyntax ()
    : DeclareBase (Groundwater::component, "common", "\
All groundwater models can log height.")
  { }
  void load_frame (Frame& frame) const
  {
   frame.declare ("height", "cm", Attribute::LogOnly,
              "Groundwater level.  Positive numbers indicate free drainage.");
  }
} GroundwaterBase_syntax;

// groundwater.C ends here.
