// net_radiation.h
// 
// Copyright 1996-2001 Per Abrahamsen and Sren Hansen
// Copyright 2000-2001 KVL.
//
// This file is part of Daisy.
// 
// Daisy is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
// 
// Daisy is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser Public License for more details.
// 
// You should have received a copy of the GNU Lesser Public License
// along with Daisy; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#ifndef NET_RADIATION_H
#define NET_RADIATION_H

#include "model_derived.h"

class Weather;
class BlockModel;
class Treelog;

class NetRadiation : public ModelDerived
{
  // Content.
public:
  static const char *const component;
  symbol library_id () const;

  // Simulation.
public:
  virtual void output (Log&) const = 0;
  virtual double net_radiation () const = 0; // [W/m2] (positive downwards)
  virtual double incoming_longwave_radiation () const = 0; // [W/m2] 
  virtual void tick (double Cloudiness /* [0-1] */,
		     double Temp /* [dg C] */, 
		     double VapourPressure /* [kPa] */,
		     double Si /* [W/m2] */, 
		     double Albedo /* [0-1] */,
		     Treelog&) = 0;

  // Create and Destroy.
protected:
  NetRadiation (const BlockModel&);
public:
  ~NetRadiation ();
};

#endif // NET_RADIATION_H
