#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "screen.h"
#include "extkeys.h"
#include "e4h.h"
#include "erofunc.h"

extern struct vcfg cfg;
extern int c5_table_index;
extern int units;

static SMALL_WINDOW *w_ptr;


void get_ero_help( tmp, wc, t, ch )
EROSION *tmp;
WINDOW_CONTROL *wc;
char *t;
int *ch;
{
HELP_WINDOW hw;
LARGE_TEXT_HELP lth;
HELP_WINDOW hwa, hwb;
LARGE_TEXT_HELP ltha, lthb;

   w_ptr = NULL;
   hw.v_row = 0;        /*  virtual row in a window */
   hw.select = 0;       /*  current position in help arrays */
   lth.txt_lines = 0;
   lth.rl = LEFT;
   lth.offset = 0;
   switch (tmp->type) {
      case 4 :
         switch (wc->field) {
            case 2 :
               hw.dply_col = 2;         /* column to start display in win */
               hw.dply_row = 3;         /* row to start display in window */
               hw.line_length = 49;     /* maximum length of help line    */
               hw.avail_lines = 6;      /* num of lines avail for display */
               hw.num_entries = 6;      /* num of help choices in array   */
               hw.ulft_col = 10;        /* upper left col to begin box    */
               hw.ulft_row = 5;         /* upper left row to begin box    */
               hw.total_col = 53;       /* total num of columns in box    */
               hw.total_row = 10;        /* total num of lines in help box */
               master_help( &hw, lth, flgout_tbl, flgout_head, t, ch );
               break;
            case 3 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 40;
               hw.avail_lines = 6;
               hw.num_entries = 6;
               hw.ulft_col = 10;
               hw.ulft_row = 5;
               hw.total_col = 44;
               hw.total_row = 10;
               master_help( &hw, lth, flgseq_tbl, flgseq_head, t, ch );
               break;
         }
         break;
      case 9 :
         switch (wc->field) {
            case 1 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 1;
               hw.avail_lines = 2;
               hw.num_entries = 4;
               hw.ulft_col = 0;
               hw.ulft_row = 3;
               hw.total_col = 80;
               hw.total_row = 15;
               lth.txt_lines = 5;
               lth.rl = RIGHT;
               lth.offset = 75;
               large_text_help( &hw, lth, ctlo_tbl, ctlo_head, t, ch );
               break;
            case 2 :
            case 3 :
               hw.dply_col = 2;         /* CHANGE THIS ONE */
               hw.dply_row = 6;
               hw.line_length = 45;
               hw.avail_lines = 6;
               hw.num_entries = 16;
               hw.ulft_col = 10;
               hw.ulft_row = 5;
               hw.total_col = 49;
               hw.total_row = 13;
               master_help( &hw, lth, ra_tbl, ra_head, t, ch );
               if (*ch == RTURN)
                  fill_card_9( tmp, wc, hw, t );
               break;
         }
         break;
      case 18 :
         hw.dply_col = 2;
         hw.dply_row = 5;
         hw.line_length = 1;
         hw.avail_lines = 3;
         hw.ulft_col = 5;
         hw.ulft_row = 3;
         hw.total_col = 70;
         hw.total_row = 17;
         hwa.v_row = 0;
         hwa.select = 0;
         hwa.dply_col = 2;
         hwa.dply_row = 5;
         hwa.line_length = 30;
         hwa.avail_lines = 4;
         hwa.num_entries = 8;
         hwa.ulft_col = hw.ulft_col;
         hwa.ulft_row = hw.ulft_row;
         hwa.total_col = hw.total_col;
         hwa.total_row = hw.total_row;
         ltha.txt_lines = 2;
         ltha.rl = LEFT;
         ltha.offset = 1;

         hwb.v_row = 0;
         hwb.select = 0;
         hwb.dply_col = 39;
         hwb.dply_row = 5;
         hwb.line_length = 28;
         hwb.avail_lines = 7;
         hwb.num_entries = over_cnt[hwa.select];
         hwb.ulft_col = hw.ulft_col;
         hwb.ulft_row = hw.ulft_row;
         hwb.total_col = hw.total_col;
         hwb.total_row = hw.total_row;
         lthb.txt_lines = 0;
         lthb.rl = LEFT;
         lthb.offset = 0;
         if (units == ENGLISH)
            multiple_text_help( &hw, &hwa, &hwb, &ltha, &lthb, over_head,
                                over_tbl, over_ary, over_cnt, t, ch );
         else
            multiple_text_help( &hw, &hwa, &hwb, &ltha, &lthb, over_head,
                                over_tbl, overm_ary, over_cnt, t, ch );
         break;
      case 20 :
         hw.dply_col = 2;
         hw.dply_row = 5;
         hw.line_length = 1;
         hw.avail_lines = 3;
         hw.ulft_col = 5;
         hw.ulft_row = 3;
         hw.total_col = 70;
         hw.total_row = 17;
         hwa.v_row = 0;
         hwa.select = 0;
         hwa.dply_col = 2;
         hwa.dply_row = 5;
         hwa.line_length = 30;
         hwa.avail_lines = 2;
         hwa.num_entries = 10;
         hwa.ulft_col = hw.ulft_col;
         hwa.ulft_row = hw.ulft_row;
         hwa.total_col = hw.total_col;
         hwa.total_row = hw.total_row;
         ltha.txt_lines = 5;
         ltha.rl = LEFT;
         ltha.offset = 1;

         hwb.v_row = 0;
         hwb.select = 0;
         hwb.dply_col = 39;
         hwb.dply_row = 5;
         hwb.line_length = 28;
         hwb.avail_lines = 7;
         hwb.num_entries = over_cnt[hwa.select];
         hwb.ulft_col = hw.ulft_col;
         hwb.ulft_row = hw.ulft_row;
         hwb.total_col = hw.total_col;
         hwb.total_row = hw.total_row;
         lthb.txt_lines = 0;
         lthb.rl = LEFT;
         lthb.offset = 0;
         if (units == ENGLISH)
            multiple_text_help( &hw, &hwa, &hwb, &ltha, &lthb, chan_head,
                                chan_tbl, chan_ary, chan_cnt, t, ch );
         else
            multiple_text_help( &hw, &hwa, &hwb, &ltha, &lthb, chan_head,
                                chan_tbl, chanm_ary, chan_cnt, t, ch );
         break;
   }
}


void repeat_last_field( tmp, wc, t, max_fields )
EROSION *tmp;
WINDOW_CONTROL *wc;
char *t;
int max_fields;
{
int i;

   i = wc->field - 1;
   if (i < 0)
      i = max_fields;
   setup_field( tmp, i, 8, t );
}


void fill_card_9( tmp, wc, hw, t )
EROSION *tmp;
WINDOW_CONTROL *wc;
HELP_WINDOW hw;
char *t;
{
int i, j, row;
char s[82];

   for (i=0; i<2; i++) {           /* ra = position 3 on card 10 */
      tmp->apd[i+2] = TRUE;
      format_output( c9_info[hw.select].val[i], tmp->line, i+2 );
      tmp->num[i+2] = atof( c9_info[hw.select].val[i] );
   }
   i = 0 + 8 * wc->view;
   strncpy( s, tmp->line+i, 72 );
   s[72] = '\0';
   row = wc->v_row + wc->d_row;
   fast_write(wc->d_col, row, s, NORMAL );
   j = wc->field - 2;
   strcpy( t, c9_info[hw.select].val[j] );
}


void show_help_list( hw, help, row_spacing )
HELP_WINDOW *hw;
TABLE_TYPE *help;
int row_spacing;
{
int row, col, i, j;

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row;
/*   i = hw->v_row;  */
   i = 0;
   j = hw->select - hw->v_row;
   for (; i < hw->avail_lines && j<hw->num_entries; i+=row_spacing, j++, row++)
      fast_write( col, row, help[j].line, NORMAL );
}


void position_cursor( hw, lth, str, un, cc, ch )
HELP_WINDOW *hw;
LARGE_TEXT_HELP lth;
char *str;
int *un, *cc, *ch;
{
int col, row, y, yy;

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row + hw->v_row*(lth.txt_lines+1);
   y  = hw->ulft_row + hw->dply_row;
   yy = hw->ulft_row + hw->dply_row + hw->avail_lines*(lth.txt_lines+1) - 1;
   if (lth.txt_lines)
      --yy;          /* if lth.txt_lines not zero "yy" has to be adjusted */
   *un = FALSE;
   switch (*ch) {
      case UP    :
         if (hw->v_row > 0 && hw->select > 0) {
            if (lth.rl == RIGHT)
               hlight_line( col+lth.offset, row, strlen( str ), NORMAL );
            else
               hlight_line( col, row, strlen( str ), NORMAL );
            --hw->v_row;
            --hw->select;
            *cc = TRUE;
         } else if (hw->v_row == 0 && hw->select > 0) {
            if (lth.rl == RIGHT)
               hlight_line( col+lth.offset, row, strlen( str ), NORMAL );
            else
               hlight_line( col, row, strlen( str ), NORMAL );
            --hw->select;
            scroll_window( -(lth.txt_lines+1), y, col, yy+1,
                              col+lth.offset+hw->line_length, NORMAL );
            *un = TRUE;
            *cc = TRUE;
         }
         break;
      case DOWN :
         if (hw->v_row < hw->avail_lines-1 &&
                                      hw->select < hw->num_entries-1) {
            if (lth.rl == RIGHT)
               hlight_line( col+lth.offset, row, strlen(str), NORMAL );
            else
               hlight_line( col, row, strlen(str), NORMAL );
            ++hw->v_row;
            ++hw->select;
            *cc = TRUE;
         } else if (hw->v_row == hw->avail_lines-1 &&
                                      hw->select < hw->num_entries-1) {
            if (lth.rl == RIGHT)
               hlight_line( col+lth.offset, row, strlen(str), NORMAL );
            else
               hlight_line( col, row, strlen(str), NORMAL );
            ++hw->select;
            scroll_window( lth.txt_lines+1, y, col, yy,
                              col+lth.offset+hw->line_length, NORMAL );
            *un = TRUE;
            *cc = TRUE;
         } else if (hw->select == hw->num_entries - 1 && hw->v_row > 0) {
            --hw->v_row;
            scroll_window( lth.txt_lines+1, y, col, yy,
                              col+hw->line_length, NORMAL );
         }
         break;
   }
}



void master_help( hw, lth, help, help_heading, t, ch )
HELP_WINDOW *hw;
LARGE_TEXT_HELP lth;
TABLE_TYPE *help;
struct screen *help_heading;
char *t;
int *ch;
{
int col, row, i;
int update_name, change_color, draw_page;
char str[50];

   save_and_draw( hw, help_heading );
   show_help_list( hw, help, 1 );

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row + hw->v_row;
   change_color = TRUE;
   *ch = 0;
   while (*ch!=RTURN && *ch!=ESC) {
      draw_page = FALSE;
      for (i=0; str[i] = help[hw->select].line[i]; i++);
      position_cursor( hw, lth, str, &update_name, &change_color, ch );
      switch (*ch) {
         case PGUP :
            if (hw->select > hw->avail_lines-1) {
               hw->select = hw->select - hw->avail_lines;
               if (hw->v_row > hw->select)
                  hw->select = hw->v_row;
               draw_page = TRUE;
            } else if (hw->select - hw->v_row > 0) {
               hw->select = hw->v_row;
               draw_page = TRUE;
            }
            break;
         case PGDN :
            if (hw->select + hw->avail_lines < hw->num_entries) {
               hw->select = hw->select + hw->avail_lines;
               draw_page = TRUE;
            } else if (hw->select + hw->avail_lines - hw->v_row <
                                                         hw->num_entries) {
               hw->select = hw->num_entries - 1;
               draw_page = TRUE;
            }
            if ((hw->num_entries - 1) - hw->select <
                                              hw->avail_lines && draw_page) {
               i = row - hw->v_row;
               scroll_window( 0, i, col, i+hw->avail_lines-1,
                              col+hw->line_length, NORMAL );
            }
            break;
      }
      if (draw_page == TRUE) {
         show_help_list( hw, help, 1 );
         update_name = TRUE;
         change_color = TRUE;
      }
      row = hw->ulft_row + hw->dply_row + hw->v_row;
      if (update_name)
         fast_write( col, row, help[hw->select].line, NORMAL );
      if (change_color)
         hlight_line( col, row, strlen(help[hw->select].line), cfg.hi_i );
      *ch = (*ch = getch()) ? *ch : 0x100 | getch();
      change_color = FALSE;
   } /*
   hlight_line( col, row, strlen(help[hw->select].line), cfg.lo_i );
   */
   c_on( );
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   if (*ch == RTURN)
      for (i=0; t[i] = help[hw->select].value[i]; i++);
   else
      *ch = 0;
}


void save_and_draw( hw, help_heading )
HELP_WINDOW *hw;
struct screen *help_heading;
{
   c_off();
   window_control( &w_ptr, SAVE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   no_buf_make_window( hw->ulft_col, hw->ulft_row, hw->total_col,
                   hw->total_row, NORMAL );
   write_to_window( help_heading, hw->ulft_col, hw->ulft_row, NORMAL );
}


void show_large_text_list( hw, lth, help )
HELP_WINDOW *hw;
LARGE_TEXT_HELP lth;
TEXT_TYPE *help;
{
int row, col, i, j, k;

   col = hw->ulft_col + hw->dply_col;
   i = hw->v_row;
   j = hw->select;
   for (; i < hw->avail_lines && j < hw->num_entries; i++, j++) {
      row = hw->ulft_row + hw->dply_row + i*(lth.txt_lines+1);
      if (lth.rl == RIGHT)
         fast_write( col+lth.offset, row, help[j].line, NORMAL );
      else
         fast_write( col, row, help[j].line, NORMAL );
      for (k=0; k<lth.txt_lines; k++)
         if (lth.rl == RIGHT)
            fast_write( col, row+k, help[j].txt[k], NORMAL );
         else
            fast_write( col+lth.offset, row+k, help[j].txt[k], NORMAL );
   }
}


void large_text_help( hw, lth, help, help_heading, t, ch )
HELP_WINDOW *hw;
LARGE_TEXT_HELP lth;
TEXT_TYPE *help;
struct screen *help_heading;
char *t;
int *ch;
{
int col, row, i;
int update_name, change_color;
char str[50];

   save_and_draw( hw, help_heading );
   show_large_text_list( hw, lth, help );


   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row + hw->v_row*(lth.txt_lines+1);
   change_color = TRUE;
   *ch = 0;
   while (*ch!=RTURN && *ch!=ESC) {
      strcpy( str, help[hw->select].line );
/*    for (i=0; str[i] = help[hw->select].line[i]; i++); */
      position_cursor( hw, lth, str, &update_name, &change_color, ch );
      row = hw->ulft_row + hw->dply_row + hw->v_row*(lth.txt_lines+1);
      if (update_name) {
         if (lth.rl == RIGHT)
            fast_write( col+lth.offset, row, help[hw->select].line, NORMAL );
         else
            fast_write( col, row, help[hw->select].line, NORMAL );
         for (i=0; i<lth.txt_lines; i++)
            if (lth.rl == RIGHT)
               fast_write( col, row+i, help[hw->select].txt[i], NORMAL );
            else
               fast_write( col+lth.offset, row+i,
                                 help[hw->select].txt[i], NORMAL );
      }
      if (change_color) {
         if (lth.rl == RIGHT)
            hlight_line( col+lth.offset, row,
                                 strlen(help[hw->select].line), cfg.hi_i );
         else
            hlight_line( col, row,
                                 strlen(help[hw->select].line), cfg.hi_i );
      }
      *ch = (*ch = getch()) ? *ch : 0x100 | getch();
      change_color = FALSE;
   } /*
   hlight_line( col, row, strlen(help[hw->select].line), cfg.lo_i );
   */
   c_on( );
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   if (*ch == RTURN)
      strcpy( t, help[hw->select].value );
/*    for (i=0; t[i] = help[hw->select].value[i]; i++); */
   else
      *ch = 0;
}


void multiple_text_help( hw, hwa, hwb, ltha, lthb, help_heading, help_tbl,
                                             help_ary, help_cnt, t, ch )
HELP_WINDOW *hw;
HELP_WINDOW *hwa, *hwb;
LARGE_TEXT_HELP *ltha, *lthb;
struct screen *help_heading;
TEXT_TYPE help_tbl[];
TABLE_TYPE *help_ary[];
int help_cnt[];
char *t;
int *ch;
{
TABLE_TYPE *p;
int mult_field;


   save_and_draw( hw, help_heading );
   show_large_text_list( hwa, *ltha, help_tbl );

   *ch = 0;
   mult_field = 0;
   while (*ch!=RTURN && *ch!=ESC) {
      switch (mult_field) {
         case 0 :
            get_large_help( hwa, hwb, *ltha, help_tbl, help_ary, help_cnt, ch );
            if (*ch == F2)
               mult_field = 1;
            break;
         case 1 :
            get_regular_help( *hwa, hwb, *lthb, help_ary, ch );
            if (*ch == F1)
               mult_field = 0;
            break;
      }

   }
   /*
   hlight_line( col, row, strlen(help[hw->select].line), cfg.lo_i );
   */
   c_on( );
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   if (*ch == RTURN) {
      p = help_ary[hwa->select];
      strcpy( t, p[hwb->select].value );
/*    for (i=0; t[i] = p[hwb->select].value[i]; i++); */
   }
   *ch = 0;
}



void get_large_help( hwa, hwb, lth, help_tbl, help_ary, help_cnt, ch )
HELP_WINDOW *hwa, *hwb;
LARGE_TEXT_HELP lth;
TEXT_TYPE *help_tbl;
TABLE_TYPE *help_ary[];
int help_cnt[];
int *ch;
{
TABLE_TYPE *p;
int col, colb, row, i, y, yy;
int update_name, change_color;
char str[80];

   col = hwa->ulft_col + hwa->dply_col;
   row = hwa->ulft_row + hwa->dply_row + hwa->v_row * (lth.txt_lines+1);
   change_color = TRUE;
   *ch = 0;
   while (*ch!=RTURN && *ch!=ESC && *ch!=F1 && *ch!=F2) {
      strcpy( str, help_tbl[hwa->select].line );
/*    for (i=0; str[i] = help_tbl[hwa->select].line[i]; i++); */
      position_cursor( hwa, lth, str, &update_name, &change_color, ch);
      row = hwa->ulft_row + hwa->dply_row + hwa->v_row*(lth.txt_lines+1);
      if (update_name) {
         if (lth.rl == RIGHT)
            fast_write( col+lth.offset, row, help_tbl[hwa->select].line, NORMAL );
         else
            fast_write( col, row, help_tbl[hwa->select].line, NORMAL );
         for (i=0; i<lth.txt_lines; i++)
            if (lth.rl == RIGHT)
               fast_write( col, row+i, help_tbl[hwa->select].txt[i], NORMAL );
            else
               fast_write( col+lth.offset, row+i,
                                 help_tbl[hwa->select].txt[i], NORMAL );
      }
      if (change_color) {
         if (lth.rl == RIGHT)
            hlight_line( col+lth.offset, row,
                              strlen(help_tbl[hwa->select].line), cfg.hi_i );
         else
            hlight_line( col, row,
                              strlen(help_tbl[hwa->select].line), cfg.hi_i );
         y  = hwb->ulft_row + hwb->dply_row;
         yy = hwb->ulft_row + hwb->dply_row + hwb->avail_lines;
         colb = hwb->ulft_col + hwb->dply_col;
     /*  scroll_window(hwb->avail_lines, y, colb, yy-1, colb+hwb->line_length);  */
         scroll_window( 0, y, colb, yy-1, colb+hwb->line_length, NORMAL );
         p = help_ary[hwa->select];
         hwb->num_entries = help_cnt[hwa->select];
         hwb->v_row = hwb->select = 0;
         show_help_list( hwb, p, 1 );
      }
      *ch = (*ch = getch()) ? *ch : 0x100 | getch();
      change_color = FALSE;
   }
   hlight_line( col, row, strlen(help_tbl[hwa->select].line), cfg.lo_i );
}


void get_regular_help( hwa, hwb, lth, help_ary, ch )
HELP_WINDOW hwa, *hwb;
LARGE_TEXT_HELP lth;
TABLE_TYPE *help_ary[];
int *ch;
{
TABLE_TYPE *p;
int col, row;
int update_name, change_color;
char str[80];

   hwb->v_row = hwb->select = 0;
   p = help_ary[hwa.select];
   col = hwb->ulft_col + hwb->dply_col;
   row = hwb->ulft_row + hwb->dply_row + hwb->v_row;
   change_color = TRUE;
   *ch = 0;
   while (*ch!=RTURN && *ch!=ESC && *ch!=F1 && *ch!=F2) {
      strcpy( str, p[hwb->select].line );
/*    for (i=0; str[i] = p[hwb->select].line[i]; i++); */
      position_cursor( hwb, lth, str, &update_name, &change_color, ch );
      row = hwb->ulft_row + hwb->dply_row + hwb->v_row;
      if (update_name)
         fast_write( col, row, p[hwb->select].line, NORMAL );
      if (change_color)
         hlight_line( col, row, strlen(p[hwb->select].line), cfg.hi_i );
      *ch = (*ch = getch()) ? *ch : 0x100 | getch();
      change_color = FALSE;
   }
   hlight_line( col, row, strlen(p[hwb->select].line), NORMAL );
}


void show_mozart( )
{
HELP_WINDOW hw;
int i;

   w_ptr = NULL;
   hw.ulft_col = 20;        /* upper left col to begin box    */
   hw.ulft_row = 9;         /* upper left row to begin box    */
   hw.total_col = 44;       /* total num of columns in box    */
   hw.total_row = 4;        /* total num of lines in help box */
   save_and_draw( &hw, mozart_heading );
   i = 0;
   while (i!=RTURN && i!=ESC) {
      i = (i = getch()) ? i : 0x100 | getch();
   }
   c_on( );
   window_control( &w_ptr, RESTORE, hw.ulft_col, hw.ulft_row,
                   hw.total_col, hw.total_row );
}
