#define VLEFT    0
#define VRIGHT   1

#define ENGLISH  0
#define METRIC   1

#define DATE_LENGTH      5


typedef struct {
   int  beg_vrow;
   int  max_rows;
   int  d_col;
   int  d_row;
   int  offset;
   int  v_row;
   int  r_row;
   int  field;
   int  view;
} WINDOW_CONTROL;


typedef struct ero_node {
   char   line[82];
   float  num[10];
   char   apd[10];
   int    type;
   struct ero_node *n;
   struct ero_node *p;
}EROSION;

#define   TMP_LINE   0
#define   TMP_NUM    1*82
#define   TMP_APD    TMP_NUM+4*10
#define   TMP_TYPE   TMP_APD+1*10
#define   TMP_N      TMP_TYPE+2
#define   TMP_P      TMP_N+4

#define  WC_BEG_VROW   0
#define  WC_MAX_ROWS   2
#define  WC_D_COL      4
#define  WC_D_ROW      6
#define  WC_OFFSET     8
#define  WC_V_ROW      10
#define  WC_R_ROW      12
#define  WC_FIELD      14
#define  WC_VIEW       16



/* table of pointers - pointer takes 2 bytes. so 10 * 2 = 20 */
#define FOOT_PTRS 20


struct card_parse {
  int c_no;
  int flgseq;
  int num_chans;
  int nptso;
  int seen1_9;
  int seen2_9;
  int nyears;
  int ncdates;
  int nxf;
  int over_set;
  int seen19;
  int nxc;
  int chan_set;
  int eof;
};


struct  screen  ero_intro[] = {
   { 2,9, "ͻ" },
   { 3,9, "                                                     " },
   { 4,9, "                                 " },
   { 5,9, "                                          " },
   { 6,9, "                                            " },
   { 7,9, "                                    " },
   { 8,9, "                                         " },
   { 9,9, "                                          " },
   { 10,9,"                                " },
   { 11,9,"                                                     " },
   { 12,9,"                    Version  3.0                     " },
   { 13,9,"                    E R O S I O N                    " },
   { 14,9,"                   Parameter Editor                  " },
   { 15,9,"                   April 30, 1999                    " },
   { 16,9,"                                                     " },
   { 17,9,"    Frank Davis    Walter Knisel    Ralph Leonard    " },
   { 18,9,"                                                     " },
   { 19,9,"                      USDA-ARS                       " },
   { 20,9,"                     Tifton, GA                      " },
   { 21,9,"                                                     " },
   { 22,9,"ͼ" },
   {0,0,NULL}
};

struct screen ero_work[] = {
   {1,1,"Card no.                 Erosion Parameter Worksheet"},
   {2,0,""},
   {19,0,""},
  {0,0,NULL}
};


struct screen tit_foot[] = {
  {20,5,"Title lines are reproduced in the output files.  Each line consists"},
  {21,5,"of an 80 column alphanumeric field which is used in identifying a"},
  {22,5,"a particular parameter set. "},
  {24,0,NULL}
};
