#define VGA             3
#define EGA             2
#define CGA             1
#define MDA             0

#define BLACK      0
#define BLUE       1
#define GREEN      2
#define CYAN       3
#define RED        4
#define MAGENTA    5
#define BROWN      6
#define WHITE      7
#define D_GREY     8
#define L_BLUE     9
#define L_GREEN   10
#define L_CYAN    11
#define L_RED     12
#define L_MAGENTA 13
#define YELLOW    14
#define B_WHITE   15


#define UNDERLINE 1     /* THESE ARE FOR MONOCHROME CARDS */
#define NORMAL    7
#define HI_INTEN  15
#define REVERSE   112

#define PRIMARY_FLD 31
#define SECOND_FLD  71
#define F_KEY_BAR   62


#define TRUE  1
#define FALSE 0

#define SAVE    0
#define RESTORE 1

#define VIDEO_IO 0x10

struct vcfg {
   int color;
   int rescan;
   int far *videomem;
   int mode;
   int rows;
   int adapter;
   int insert_cursor;
   int overw_cursor;
   int hi_i;
   int lo_i;
   int f_bar;
};

struct c_scheme {
   int m_bar;
   int m_alt;
   int m_select;
   int w_outline;
   int w_list;
   int w_select;
};


struct temp_c_scheme {
   int m_bar;
   int m_alt;
   int m_select;
   int w_outline;
   int w_list;
   int w_select;
   int cursor;
   int help_tbl;
   int f_bar;
};

struct win_vars {
   int wid;
   int hgt;
   int d_col;
   int d_row;
   int fld;
   int max_fld;
   int c;
   int r;
   int f_b;
   int f_clr;
   int b_clr;
};


struct sample_vars {
   int left_bar_c;
   int left_bar_r;
   int left_alt_c;
   int left_alt_r;
   int head_c;
   int head_r;
   int right_bar_c;
   int right_bar_r;
   int right_alt_c;
   int right_alt_r;
   int win_c;
   int win_r;
   int win_wid;
   int win_hgt;
   int list1_c;
   int list1_r;
   int select_c;
   int select_r;
   int list2_c;
   int list2_r;
   int cursor_c;
   int cursor_r;
   int help_tbl_c;
   int help_tbl_r;
   int f_bar_c;
   int f_bar_r;
};


typedef struct small_win {
   int x;
   int y;
   int *buf;
   struct small_win *n;
} SMALL_WINDOW;


struct screen {
   unsigned int row;
   unsigned int col;
   unsigned char *text;
};

struct file_position {
   int display;
   int d_row;
   int d_col;
   int color;
   int f_row;
   int f_col;
};


typedef struct {
   int dply_col;
   int dply_row;
   int line_length;
   int avail_lines;
   int v_row;
   int select;
   int num_entries;
   int ulft_col;
   int ulft_row;
   int total_col;
   int total_row;
} HELP_WINDOW;

typedef struct {
   int txt_lines;
   int rl;
   int offset;
} LARGE_TEXT_HELP;


typedef struct {
   char *line;
   char *value;
} TABLE_TYPE;


typedef struct {
   char *txt[5];
   char *line;
   char *value;
} TEXT_TYPE;



/* function prototypes */
/*************************************************************/
void retrace( int );
void show_file_position( struct file_position , int );
void field_editor( char *, int, int, int, int, int, int *, int,
		   struct file_position );
void hlight_line( int, int, int, int );
void set_cur( int, int );
void c_off( void );
void c_on( void );
void write_cur( char );
void insert_cursor( void );
void insert( char far *, int, int );
void delete( char far *, int );
void ftoa( float, int, char * );
void scroll_window( int, int, int, int, int, int );
void cls( void );
void get_vcfg( void );
void fast_write( int, int, char far *, int );
void fast_write_far( int, int, char far *, int );
void wherexy( int *, int * );
int set_color( int, int );
void box( int, int, int, int, int far *, int );
void show_box( int, int, struct screen *, int );


void no_buf_make_window( int, int, int, int, int );
void no_buf_box( int, int, int, int, int );
void no_buf_clear_window( int, int, int, int );
void window_control( SMALL_WINDOW **, int, int, int, int, int );
void save_window( int far *, int, int, int, int );
void restore_window( int far *, int, int, int, int );
/************************************************************/
/* end of function prototypes */


