
c$DEBUG
      SUBROUTINE HYDRIN
C///////////////////////////////////////////////////////////////////////
C    READ IN VALUES FROM CARDS 5-10 FOR HYDROLOGY, CALCULATE THE VALUES/
C    OF THE LAYERS, AND CALL THE SUBS FOR TEMPERATURE AND RADIATION.   /
C///////////////////////////////////////////////////////////////////////

      COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &               VERMNT,BCKEND,flgpen
      COMMON /IRR/ BASEI(366),TOPI(366),bsi,tpi
      COMMON /HONE/ RD,DACRE,RC,SIA,CHS,WLW,CN2,BST,UL(13),satk(12)
      COMMON /BLK1/ EOS,SW1,RAIN,TUL,TU,CONA,ES,EP,MO,IDA,IYR,
     &              NT,UW,JE,J,elev,rlat
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &              LUN15,LUN16
      COMMON /ONEVAR/TMP1(2),TMP2(2),TMP3(2),RAD1,RAD2,RAD3,
     &               wind1,wind2,wind3,dew1,dew2,dew3
      COMMON /ORGMAT/OM(12)
      COMMON /LAYERS/ NS, NOSOHZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,  swet
     &                BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      COMMON /HRZVAL/ BR15RD(5),PORRD(5),FULRD(5),OMRD(5),satkrd(12),
     &                clayrd(5),siltrd(5),phrd(5),bsatrd(5),cco3rd(5)
      COMMON /FREEZE/ IFZBEG,IFZEND,NFRZ,NFZDAY
      COMMON /BACK/   IBACK(20), BCKCNT
      common /swc/ wf(12)
      COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
      common /hydsol/ cly,slt
      common /nuts/ nBYR, nEYR, NUTOUT, FLGROT, NOCROP, ISOIL, flgbal
      COMMON /joeb/ anrcon(366), anrdat(366), anpcon(366), anpdat(366), joeb
     &              antcon(366), antdat(366),
     &              vrmass(366,10),vrvol(366),vpmass(366,10),vpvol(366),
     &              vtmass(366,10),
     &              anrmax(366), anrvol(366), anpmax(366), anpvol(366),
     &              antmax(366),
     &              jhead, jtail, jintvl,
     &              jshead, jstail, jsntvl,
     &              srcon(366), srdat(366), spcon(366), spdat(366),
     &              stcon(366), stdat(366), srvol(366), spvol(366)
      integer anrdat,anpdat,antdat,srdat, spdat,stdat                   joeb
      INTEGER FLGGEN,HBDATE,HYDOUT,FLGNUT,FLGPST,FLGMET,VERMNT,BCKEND,
     &       forest, beggro, endgro, flgrot, flgbal,flgpen
C * *          DECLARE VARIABLES
      REAL FC(5)
      real intcep, intm, inty, intet, intetm, intety
      save
C * *          READ CARD #5 IN HYDROLOGY
      IF (BCKEND .GT. 0) THEN
         READ (LUN02,2020) (IBACK(I),I=1,10)
         READ (LUN02,2020) (IBACK(I),I=11,20)
         DO 5 I=2, 20
            JJ = IBACK(I)
            IF (JJ .NE. 0) THEN
               K = I - 1
3              CONTINUE
               IF (K.GT.0 .AND.(IBACK(K).GT.JJ.OR.IBACK(K).EQ.0)) THEN
                  IBACK(K+1) = IBACK(K)
                  K = K - 1
                  GOTO 3
               ENDIF
               IBACK(K+1) = JJ
            ENDIF
5        CONTINUE
         BCKCNT = 0
         DO 15 K=1, 20
            IF (IBACK(K).GT.0) BCKCNT = BCKCNT + 1
15       CONTINUE
         jintvl = 0
         if (bckcnt .gt. 0) then
           j = 0
           do 60 ji=1, bckcnt
              if (iback(ji).gt.3400 .and. iback(ji).le.3410) then
                 j = iback(ji)
                 goto 70
              endif
60         continue
70         continue
           if (j .gt. 0) then
              jintvl = mod( j, 10 )
              jhead = 1
              jtail = jintvl
           endif
         endif
         jsntvl = 0
         if (bckcnt .gt. 0) then
           j = 0
           do 80 ji=1, bckcnt
              if (iback(ji).gt.3410 .and. iback(ji).le.3420) then
                 j = iback(ji)
                 goto 90
              endif
80         continue
90         continue
           if (j .gt. 0) then
              jsntvl = mod( j, 10 )
              jshead = 1
              jstail = jsntvl
           endif
         endif
      endif
      READ (LUN02,2010) DACRE,RC,BST,CONA,CN2,CHS,WLW,RD,elev,rlat
      SIA    = 0.2
C * *           READ CARD #6 - NUMBER OF HORIZONS (NOSOHZ) AND
C * *           AND DEPTH TO BOTTOM OF EACH HORIZON (BOTHRZ)
      READ (LUN02,2000) isoil,NOSOHZ,(BOTHRZ(I),I=1,NOSOHZ)
      IF (FLGMET .EQ. 1) THEN
         DACRE = DACRE * 2.471
         RC    = RC    / 2.54
         RD    = RD    / 2.54
         DO 10 I=1,NOSOHZ
            BOTHRZ(I)=BOTHRZ(I)/2.54
10       CONTINUE
      ENDIF
      if (flgmet .eq. 0) elev = elev * .3048
      if (nosohz .lt. 1 .or. nosohz .gt. 5) then
         write(*,7005)
         write(lun07,7005)
         stop
      endif
      if (rd .ne. bothrz(nosohz)) then
         write(*,7004) nosohz
         write(lun07,7004) nosohz
      endif
      DO 20 I=1,NOSOHZ
         if (bothrz(i) .le. 0.0) then
            write(*,7007) i
            write(lun07,7007) i
            stop
         endif
         if (i .gt. 1) then
            if (bothrz(i) .le. bothrz(i-1)) then
               write(*,7008) i
               write(lun07,7008) i, i-1
               stop
            endif
         endif
20    continue
C * *           READ CARD #7 THE POROSITY OF EACH OF THE HORIZON (PORRD)
      READ (LUN02,2010) (PORRD(I),I=1,NOSOHZ)
C * *            READ CARD #8 FC  FOR EACH HORIZON (FC)
       READ (LUN02,2010) (FC(I),I=1,NOSOHZ)
C      READ (LUN02,2010) (FULRD(I),I=1,NOSOHZ)
C * *            READ CARD #9 BR15 FOR EACH HORIZON (BR15RD)
      READ (LUN02,2010) (BR15RD(I),I=1,NOSOHZ)
C * *            READ CARD #9 ksat FOR EACH HORIZON (satkRD)
      READ (LUN02,2010) (satkrd(I),I=1,NOSOHZ)
      IF (FLGMET .EQ. 1) THEN
         DO 11 I=1,NOSOHZ
            satkrd(I)=satkrd(I)/2.54
11       CONTINUE
      ENDIF
C * *            READ CARD #10 ORGANIC MATTER FOR EACH HORIZON (OM)
      READ (LUN02,2010) (OMRD(I),I=1,NOSOHZ)
C * *            CONVERT FIELD CAPCITY TO FUL
      read (lun02,2010) (clayrd(i),i=1,nosohz)
      read (lun02,2010) (siltrd(i),i=1,nosohz)
      if (isoil .eq. 1) then
         read(lun02,2010) (cco3rd(i),i=1,nosohz)
      else if (isoil .eq. 2) then
         read (lun02,2010) (phrd(i), i=1,nosohz)
         read(lun02,2010) (bsatrd(i),i=1,nosohz)
      endif
      cly   = clayrd(1)
      slt   = siltrd(1)
      DO 30 I=1,NOSOHZ
         if (porrd(i) .ge. 1.0) then
            write(*,7003)
            write(lun07,7003)
            stop
         endif
         if (br15rd(i) .le. 0.0) then
            write(*,7006)
            write(lun07,7006)
            stop
         endif
         if (fc(i) .ge. porrd(i)) then
            write(*,7000)
            write(lun07,7000)
            stop
         endif
         if (br15rd(i) .ge. fc(i)) then
            write(*,7001)
            write(lun07,7001)
            stop
         endif
         if (clayrd(i) + siltrd(i) .gt. 100.0) then
            write(*,7002)
            write(lun07,7002)
            stop
         endif
         FULRD(I) = (FC(I) - BR15RD(I)) / (PORRD(I) - BR15RD(I))
30    CONTINUE

      CALL FNDLAY
      if (forest .eq. 0 ) then
         IF (CONA .LE. 3.0) THEN
            WRITE (LUN07,3000) CONA
            CONA  =  3.5
         ENDIF
      else
         IF (CONA .lt. 3.0) THEN
            WRITE (LUN07,3001) CONA
            CONA  =  3.0
         ENDIF
      endif

C
C * *     GET TEMPERATURE VALUES
      IF (FLGGEN .NE. 2) CALL GETTMP
C * *     GET RADIATION VALUES
      CALL GETRAD
      call getwnd
      call getdew

      CALL GETLAI
      RETURN
2000  FORMAT(2I8,5F8.2)
2010  FORMAT(10F8.0)
2020  FORMAT(10I8)
3000  FORMAT(3X,'********** NOTE: CONA READ WAS ',F8.2,' DEFAULT',
     1       ' VALUE OF 3.5 SUBSTITUTED **********')
3001  FORMAT(3X,'********** NOTE: CONA READ WAS ',F8.2,' DEFAULT',
     1       ' VALUE OF 3.0 SUBSTITUTED **********')
7000  FORMAT(' ERROR H1: Field capacity must be less than porosity')
7001  FORMAT(' ERROR H2: Wilting point must be less than field',
     &       ' capacity')
7002  FORMAT(' ERROR H3: Clay + silt  must be  <= 100.0')
7003  FORMAT(' ERROR H4: Porosity must be <= 1.0')
7004  FORMAT(' WARNING H1: Effective rooting depth should equal last',
     &       ' bottom of horizon:  ',i2)
7005  FORMAT(' ERROR H5: Number of horizons must be greater than 0',
     &       ' and less than or equal to 5')
7006  FORMAT(' ERROR H7: Porosity must be <= 1.0')
7007  FORMAT(' ERROR H8: Bottom of horizon',i2,' must be > 0.0')
7008  FORMAT(' ERROR H9: Bottom of horizon',i2,' must be greater than'
     &       ' horizon',i2)
      END

      SUBROUTINE FNDLAY
C///////////////////////////////////////////////////////////////////////
C    CALCULATE THE THICKNESS OF THE LAYERS                             /
C///////////////////////////////////////////////////////////////////////
      COMMON /NUTPST/BD(12),FC(12),CONV(12),FUL(12),SOLPOR(12),
     &               BR15(12),OSW(12),SAT(12),OM(12),KD(366,12),
     &               SOILMS(12),cknit(12)
      COMMON /LAYERS/ NS, NHORZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,   swet
     &                BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      COMMON /HRZVAL/ BR15RD(5),PORRD(5),FULRD(5),OMRD(5),satkrd(12),
     &                clayrd(5),siltrd(5),phrd(5),bsatrd(5),cco3rd(5)
      COMMON /HONE/ RD,DACRE,RC,SIA,CHS,WLW,CN2,BST,UL(13),satk(12)
      COMMON /ORGMAT/HYDOM(12)
      common /swc/ wf(12)
      COMMON /SOIL/ PH(12),CLAY(12),CACO3(12),BSAT(12),PSPp(12)
      real   kd
      save

      N = NHORZ
      L = 1

C * * * ALWAYS SET THE BOTTOM OF THE TOP LAYER TO 1 CM
      BOTLAY(L) = 0.3937
      L = L + 1

C * * * THERE ARE TWO SPECIAL CASES WHEN ONLY ONE HORIZON IS GIVEN
C         1.  THE HORIZON IS RELATIVELY LARGE (GREATER THAN TWELVE INCHES)
C                A.  MAKE THE COMPUTATIONAL LAYERS 4 INCHES OR SMALLER
C                    IN THE TOP TWELVE.
C                B.  MAKE REST OF COMPUTATIONAL LAYERS 6 OR SMALLER
C
C         2.  THE HORIZON IS RELATIVELY SMALL (SMALLER THAN FIVE INCHES)
C                A.  DIVIDE THE HORIZON BY 2 SO THAT THERE WILL BE
C                    AT LEAST 3 COMPUTATION LAYERS (ONE IS TOP CM.)

      IF ((N .EQ. 1) .AND. (BOTHRZ(1) .GT. 12.0)) THEN
         PARTN = 4.0
         DO 10 I=1,3
            BOTLAY(L) = PARTN
            PARTN = PARTN + 4.0
            L = L + 1
10       CONTINUE
         BOTHRZ(2) = BOTHRZ(1)
         PORRD(2)  = PORRD(1)
         FULRD(2)  = FULRD(1)
         BR15RD(2) = BR15RD(1)
         OMRD(2)   = OMRD(1)
         N = 2
         K = 2
      ELSE IF ((N .EQ. 1) .AND. (BOTHRZ(1) .LT. 5.0)) THEN
         PARTN = (BOTHRZ(1) - BOTLAY(1)) / 2.0
         DO 20 I=2,3
            BOTLAY(L) = BOTLAY(L-1) + PARTN
            L = L + 1
20       CONTINUE
         BOTLAY(L-1) = BOTHRZ(1)
         N = 2
         K = 3
      ELSE
         K = 1
      ENDIF

C * * * FOR EACH HORIZON CALCULATE THE DEPTH OF THE COMPUTATIONAL LAYERS
      I = K
30    IF (I .LE. N) THEN
         TOP   = BOTLAY(L-1)
         BOTM  = BOTHRZ(I)
         DEPTH = BOTM - TOP
         IF (I .EQ. 1) THEN
            A = 4.0
         ELSE
            A = 6.0
         ENDIF
         B = 1.0
         PARTN = DEPTH / B
40       IF (PARTN .GT. A) THEN
            B = B + 1.0
            PARTN = DEPTH / B
            GOTO 40
         ENDIF
         J = INT(B)
         K = 1
50       IF ((K .LE. J) .AND. (L .LT. 13)) THEN
            BOTLAY(L) = BOTLAY(L-1) + PARTN
            K = K + 1
            L = L + 1
            GOTO 50
         ENDIF
C * * * TO TAKE CARE OF ROUND OFF, SET BOTTOM COMP LAYER = BOTTOM OF HORIZON
C * * * ALSO SET LAST LAYER TO LAST HORIZON
         BOTLAY(L-1) = BOTHRZ(I)
         I = I + 1
         GOTO 30
      ENDIF

C * * * NOW HAVE NUMBER OF COMPUTATIONAL LAYERS
      NS = L - 1

C * * *  FIND DEPTH OF EACH LAYER
      DLAY(1) = .3937
      DO 60 I=2,NS
         DLAY(I) = BOTLAY(I) - BOTLAY(I-1)
60    CONTINUE

C * * *  STORE METRIC CONVERSIONS IN ARRAYS
      DO 70 I=1,NS
         BOTMET(I) =  BOTLAY(I) * 2.54
         NBOTM(I)  =  INT(BOTMET(I))
         DLAYM(I)  =  DLAY(I)   * 2.54
70    CONTINUE

C * * * MAKE EACH COMP LAYER IN A HORIZON HAVE SAME SOIL CHARACTERISTICS
      I = 1
      DO 80 K=1,NS
         IF (BOTLAY(K) .GT. BOTHRZ(I)) THEN
            I = I + 1
         ENDIF
         SOLPOR(K) = PORRD(I)
         FUL(K)    = FULRD(I)
         BR15(K)   = BR15RD(I)
         satk(K)   = satkRD(I)
         HYDOM(K)  = OMRD(I)
         ph(k)     = phrd(i)
         caco3(k)  = cco3rd(i)
         bsat(k)   = bsatrd(i)
         clay(k)   = clayrd(i)
80    CONTINUE

C * * *  CALCULATE WEIGHTING FACTOR FOR EACH LAYER.  PG 15 CREAMS MANUAL
c
c * * *  fmd:   1 - .0156076 = .984392  ;   1 / .984392 = 1.015855
c
      WF(1) = 1.016 * (1.0 - EXP(-4.16 * 0.3937/RD))
      DO 90 I=2,NS
         WF(I) = 1.015855 * (EXP(-4.16 * BOTLAY(I-1)/RD) -
     &                        EXP(-4.16 * BOTLAY(I)/RD))
90    CONTINUE
      if (rd .lt. 24) then
         nevap = ns
      else
         nevap = 2
         DO 100 I=2,NS
            if (botlay(i) .ge. 24.0) then
               nevap = i
               goto 110
            endif
100      CONTINUE
110      CONTINUE
      endif
      do 120 k=2,ns                                                     swet
         if(botlay(k) .le. bothrz(1)) goto 120                          swet
            npl=k-1                                                     swet
            goto 130                                                    swet
120   continue                                                          swet
130   continue                                                          swet
      RETURN
      END

      SUBROUTINE LAIONE
      INTEGER FLAG
      COMMON /IRRIG/IDAY, NOIRR(366), balone(50), begsum, dirr(366),
     &              chtone(50)
      COMMON /BOTH/ ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1              R(366),ALONE,REFF,TMEAN(366), potlai(366),
     1              icindx(366),sumlai,acclai,aideal,sfn,
     1              iccrd(366),ioldcp,cdelta(366),chone,wind(366)
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &              LUN15,LUN16
      common /rotate/ ibyr, ieyr, irot
      COMMON /IRR/ BASEI(366),TOPI(366),bsi,tpi
      COMMON /etest/ etvar
      COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &               VERMNT,BCKEND,flgpen
      COMMON /PNUT/ DF(366),FP(20),FN(20),DEMERG,DHRVST,YP(90),DMY(90),
     &              NF,FNH(20),C1(90),C2(90),LEG(90),CNR(90),RNP(90),
     &              pernnl(90), ibegro(366), iendro(366)
      COMMON /LAYERS/ NS, NHORZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,   swet
     &                BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      COMMON /HONE/ RD,DACRE,RC,SIA,CHS,WLW,CN2,BST,UL(13),satk(12)
        COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                  PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                  TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                  INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
      integer nolai(12), usrtot(12), usrflg(12)
      integer plantd, harvd, truncd, year, skip, outlai
      integer dpreir
      integer pernnl, forest, beggro, endgro
      integer df,demerg,dhrvst
      INTEGER HBDATE,HYDOUT,FLGNUT,FLGPST,FLGGEN,FLGMET,VERMNT,BCKEND
      INTEGER flgpen
      real lai, usrlai(50,12), usrfrc(50,12)
      real intcep, intm, inty, intet, intetm, intety
      real ftom
      real tlai(50), flai(50), mfactr(7)
      real lai1(11,30), lai2(11,30), lai3(11,30), laifor(13,3)
      real lai11(11,15),lai12(11,15), lai21(11,15),lai22(11,15)
      real lai31(11,15), lai32(11,15)
      real forfrc(13)
      real cinc(50), pothgt(90)
      save
      data mfactr/ 1., .9, .83, .75, .67, .58, .5/
      data lai11/
     & .05, .15, .4, 1.0, 1.7, 2.5, 3.0, 3.0, 3.0, 2.9, 2.7,            alfalfa?
     & .05, .15, .4, 1.0, 1.7, 2.5, 3.0, 3.0, 3.0, 2.9, 2.7,            alfalfa?
     & .0, .44, .88, .9, .9, 1.58, 3.0, 3.0, 3.0, 2.14, .0,             w bar g
     & .0, .44, .88, .9, .9, 1.58, 3.0, 3.0, 3.0, 2.14, .0,             w bar g+
     & .0, .34, .58, .9, 1.25, 1.8, 2.5, 3.0, 3.0, 2.25, .0,            s bar g
     & .0, .34, .58, .9, 1.25, 1.8, 2.5, 3.0, 3.0, 2.25, .0,            s bar g+
     & .0, .09, .4, 1.0, 2.0, 2.5, 2.8, 3.0, 2.5, 1.5,  .0,             bean dry
     & .0, .09, .4, 1.0, 2.0, 2.5, 2.8, 3.0, 2.7, 2.0, 1.1,             bean sna
     & .0, .09, .15, .35, .6, 1.2, 1.8, 2.4, 2.7, 3.0, 1.85,            beets
     & .0, .05, .25, .6, 1.1, 1.8, 2.7, 2.9, 3.0, 3.0, 2.8,             bermuda
     & .0, .05, .15, .4,  .9, 1.6, 2.7, 3.0, 3.0, 2.9, 2.5,             blue grs
     & .04, .12, .3, .75, 1.25, 1.8, 2.25, 2.45, 3.0, 2.9, 2.0,         broccoli
     & .0, .05, .15, .45, 1.0, 2.0, 2.8, 3.0, 3.0, 2.8, 2.6,            bromegr
     & .02, .08, .2, .4, 1.0, 1.8, 2.8, 3.0, 3.0, 2.8, 2.5,             brussels
     & .02, .08, .18, .3, .6, 1.0, 1.35, 1.6, 1.8, 1.95, 2.0/           cabbage
      data lai12/
     & .0, .05, .1, .3, .95, 1.35, 2.05, 2.75, 2.8, 2.4, 1.2,           cantalop
     & .0, .09, .15, .35, .6, 1.2, 1.8, 2.1, 2.15, 1.95, 1.85,          carrots
     & .04, .1, .25, .65, 1.1, 1.6, 2.0, 2.4, 2.55, 2.7, 2.2,           caulifl
     & .0, .05, .15, .4, 1.0, 1.7, 2.5, 3.0, 3.0, 2.9, 2.6,             clover
     & .0, .09, .19, .23, .49, 1.16, 2.97, 3.0, 2.72, 1.83, .0,         corn grn
     & .0, .09, .18, .22, .4, 1.05, 2.8, 2.85, 2.8, 1.8, .0,            corn pop
     & .0, .09, .2, .32, .55, 1.3, 3.0, 3.0, 2.9, 2.0, .0,              corn slg
     & .0, .09, .18, .22, .40, 1.05, 2.8, 2.85, 2.9, 1.8, .0,           corn swt
     & .0, .13, .28, 1.05, 2.14, 2.96, 3.0, 2.96, 2.92, 1.78, 1.0,      cotton
     & .0, .15, .45, 1.8, 2.85, 3.0, 2.95, 2.8, 2.2, 1.3, .8,           cowpea h
     & .0, .05, .1, .35, .95, 1.45, 2.1, 2.8, 2.9, 2.5, 2.2,            cukes
     & .05, .18, .6, 1.5, 2.1, 2.8, 3.0, 3.0, 2.95, 2.8, 2.25,          eggplant
     & .0, .1, .4, 1.0, 1.8, 2.45, 2.85, 3.0, 3.0, 2.75, 2.4,           let leaf
     & .0, .09, .25, .45, .75, 1.15, 1.5, 2.0, 2.2, 2.3, 2.4,           let head
     & .0, .05, .15, .4, 1.0, 1.7, 2.5, 3.0, 3.0, 2.9, 2.6/             lespedez
      data lai21/
     & .0, .16, .45, 1.2, 2.1, 2.9, 3.0, 3.0, 2.95, 2.3, 1.8,           mill row
     & .0, .16, .45, 1.2, 2.1, 2.9, 3.0, 3.0, 2.95, 2.3, 1.8,           mill row
     & .0, .2, .6, 1.5, 2.25, 3.0, 3.0, 3.0, 2.96, 2.45, 1.85,          mill bdc
     & .0, .2, .6, 1.5, 2.25, 3.0, 3.0, 3.0, 2.96, 2.45, 1.85,          mill bdc
     & .0, .15, .4, 1.0, 1.8, 2.45, 2.85, 3.0, 3.0, 2.65, 2.2,          mustard
     & .0, .42, .84, .9, .9, .98, 2.62, 3.0, 3.0, 3.0, .0,              w oat g
     & .0, .42, .84, .9, .9, .98, 2.62, 3.0, 3.0, 3.0, .0,              w oat g+
     & .0, .32, .54, .9, 1.2, 1.6, 2.3, 3.0, 3.0, 2.9, .0,              s oat g
     & .0, .32, .54, .9, 1.2, 1.6, 2.3, 3.0, 3.0, 2.9, .0,              s oat g+
     & .02, .15, .45, 1.0, 1.75, 1.9, 2.0, 1.96, 1.5, 1.1, .7,          onions
     & .0, .05, .15, .45, 1.0, 2.0, 2.8, 3.0, 3.0, 2.8, 2.6,            orchardg
     & .0, .15, .45, 1.8, 2.85, 3.0, 2.95, 2.8, 2.2, 1.3, .8,           peas
     & .04, .15, .45, 1.1, 1.9, 2.5, 3.0, 3.0, 3.0, 2.8, 2.2,           pepr bel
     & .0, .15, .42, 1.8, 2.8, 3.0, 3.0, 3.0, 3.0, 2.8, 2.6,            pnut   2
     & .0, .15, .42, 1.8, 2.8, 3.0, 3.0, 3.0, 3.0, 2.8, 2.6/            pnut h 2
      data lai22/
     & .0, .2, .55, 2.0, 2.95, 3.0, 3.0, 3.0, 3.0, 2.85, 2.65,          pnut   4
     & .0, .2, .55, 2.0, 2.95, 3.0, 3.0, 3.0, 3.0, 2.85, 2.65,          pnut h 4
     & .0, .1, .25, .43, .63, 2.23, 2.62, 3.0, 2.76, 2.48, 2.15,        taters i
     & .0, .25, .4, .8, .8, 1.1, 1.8, 2.45, 2.9, 2.9, 2.4,              rape
     & .0, .1, .3, .8, 1.2, 1.75, 2.5, 2.9, 3.0, 3.0, 2.8,              rice
     & .0, .47, .9, .9, .9, .9, 1.75, 3.0, 3.0, 3.0, .0,                w rye g
     & .0, .47, .9, .9, .9, .9, 1.75, 3.0, 3.0, 3.0, .0,                w rye g+
     & .0, .47, .9, .9, .9, .9, 1.75, 3.0, 3.0, 3.0, .0,                s rye g
     & .0, .47, .9, .9, .9, .9, 1.75, 3.0, 3.0, 3.0, .0,                s rye g+
     & .0, .15, .4, 1.5, 2.5, 2.8, 3.0, 3.0, 2.8, 1.2, .5,              safflowr
     & .0, .09, .19, .23, .54, 1.35, 2.98, 3.0, 2.72, 1.84, 1.0,        sorgum g
     & .0, .1, .3, .8, 1.5, 2.8, 3.0, 3.0, 3.0, 2.8, 2.0,               sorgum f
     & .0, .15, .4, 1.9, 2.6, 3.0, 2.96, 2.92, 2.3, 1.15, .5,           soyb row
     & .0, .19, .48, 2.1, 2.7, 3.0, 3.0, 2.95, 2.35, 1.25, .5,          soyb bdc
     & .0, .15, .4, 1.0, 1.8, 2.45, 2.85, 3.0, 3.0, 2.65, 2.2/          spinach
      data lai31/
     & .0, .07, .3, 1.0, 1.8, 2.2, 2.4, 2.5, 2.45, 2.3, 1.8,            squash s
     & .0, .1, .25, .5, 1.95, 2.3, 2.8, 3.0, 3.0, 2.95, 2.4,            sugarbee
     & .0, .8, 2.5, 3.5, 4.5, 5.2, 5.8, 6.0, 6.0, 6.0, 5.8,             sugarcai
     & .0, .15, .4, 1.7, 2.8, 3.0, 3.0, 2.9, 2.7, 2.0, .8,              sunflowr
     & .02, .08, .2, .45, 2.0, 2.8, 3.0, 3.0, 3.0, 2.85, 1.9,           sw tater
     & .0, .05, .15, .45, 1.0, 2.0, 2.8, 3.0, 3.0, 2.8, 2.6,            timothy
     & .05, .18, .4, 1.5, 2.0, 3.0, 3.0, 2.9, 2.7, 1.5, .2,             tobacco
     & .04, .3, .6, 1.2, 2.3, 3.0, 3.0, 2.7, 2.0, 1.0, .4,              tomatoes
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,                      tree con
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,                      tree hrd
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,                      tree c+h
     & .0, .15, .4, 1.0, 1.8, 2.45, 2.85, 3.0, 3.0, 2.65, 2.2,          turnips
     & .0, .05, .1, .3, .9, 1.25, 2.0, 2.7, 2.8, 2.0, 1.0,              h2omelon
     & .0, .47, .9, .9, .9, .9, 1.62, 3.0, 3.0, 3.0, .0,                w wht g
     & .0, .47, .9, .9, .9, .9, 1.62, 3.0, 3.0, 3.0, .0/                w wht g+
      data lai32/
     & .0, .37, .6, .9, 1.28, 1.7, 2.3, 3.0, 3.0, 3.0, .0,              s wht g
     & .0, .37, .6, .9, 1.28, 1.7, 2.3, 3.0, 3.0, 3.0, .0,              s wht g+
     & .0, .1, .2, .4, .4, .4, 1.0, 1.5, 2.0, 2.0, 2.0,                 weeds
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,                      junk
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,                      junk
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0,
     & .0, .0, .0, .0, .0, .0, .0, .0, .0, .0, .0/
      data laifor/
     & 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5,5.5,  conifer
     &  .5,  .5, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0,  .5, .5,  hardwood
     & 2.5, 2.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 2.5,2.5/  con+hard
      data forfrc/
     &  .0,  .1, .15,  .2,  .3,  .4,  .5,  .6,  .7,  .8, .85,  .9,1.0/  fraction
      data pothgt/
     & 1.0, 1.0, 1.0, 1.0, 1.0,  1.0, 0.5, 0.5, 0.4, 0.4,
     & 1.0, 0.6, 1.2, 1.0, 0.4,  0.3, 0.3, 0.6, 1.0, 2.0,
     & 1.8, 2.2, 1.8, 1.5, .75,  0.3, .75, 0.3, 0.3, 0.6,
     & 1.5, 1.5, 1.5, 1.5, 0.4,  1.0, 1.0, 1.0, 1.0, 0.4,
     & 1.2, 0.6, .75, 0.4, 0.4,  0.4, 0.4, 0.6, 0.8, 1.0,
     & 1.0, 1.0, 1.0, 1.0, 1.0,  1.5, 2.0, 1.2, 1.0, 0.3,
     & 0.5, 0.4, 2.5, 2.0, 0.3,  1.5, 1.5, 1.0, 10., 10.,
     & 10., 0.4, 0.3, 1.0, 1.0,  1.0, 1.0, 1.0, 0.0, 0.0,
     & 0.0, 0.0, 0.0, 0.0, 0.0,  0.0, 0.0, 0.0, 0.0, 0.0/


      do 1 i=1,15
         do 2 j=1,11
            lai1(j,i)    = lai11(j,i)
            lai1(j,i+15) = lai12(j,i)
            lai2(j,i)    = lai21(j,i)
            lai2(j,i+15) = lai22(j,i)
            lai3(j,i)    = lai31(j,i)
            lai3(j,i+15) = lai32(j,i)
2        continue
1     continue
      if (flgmet .gt. 0) then
         ftom = 1.0
         WRITE(LUN07,3000)
      else
         ftom = .3048
         WRITE(LUN07,3002)
      endif
c  read lai rotation card
c      read (lun02, 2000) laiflg, ibyr, ieyr, irot
      laiflg = 0
c      read (lun02, 2004) ibcen,ibyr, iecen,ieyr, irot, etvar            y2k
      read (lun02, 2004) ibcen,ibyr, iecen,ieyr, irot, nyrfor           leaf
      iy2k = 0                                                          y2k
      if (ibcen .le. 0) then                                            y2k
         ibcen = 19                                                     y2k
         iy2k = 1                                                       y2k
      endif                                                             y2k
      if (iecen .le. 0) then                                            y2k
         iecen = 19                                                     y2k
         if (ieyr .lt. ibyr) iecen = 20                                 y2k
         iy2k = 1                                                       y2k
      endif                                                             y2k
      ibyr = ibcen * 100 + ibyr                                         y2k
      ieyr = iecen * 100 + ieyr                                         y2k
      if (iy2k .ne. 0) then                                             y2k
         write(lun07,9001) ibyr,ieyr                                    y2k
         write(*,9001) ibyr,ieyr                                        y2k
      endif                                                             y2k
      if (etvar .le. 0) etvar = 1.28
      if (laiflg .eq. 0) then
         open (lun11,status='scratch')
         icard  = 1
         iuserc = 0
         iwrite = 0
         iuserl = 0
         istart = 0
         do 10 i=1, 12
            usrflg(i) = 0
            nolai(i)  = 0
10       continue
         read (lun02, 2001) icrop
c  read crop plant & harvest date, etc...
20       if (icrop .ne. 0) then
            icard = icard + 1
            read (lun02, 2201) irrbeg
            icrop = icrop - 78
            if (icrop .gt. 0) then
               usrflg(icrop) = 1
               iuserl = 1
            endif
            icard = icard + 1
            read (lun02, 2001) icrop
            goto 20
         endif
c  any crop in 79-90 range?
         if (iuserl .gt. 0) then
            do 30 i=1,12
c  read 1) crop id & number of lai updates 2) fraction of season & lai
               if (usrflg(i) .eq. 1) then
                  read (lun02, 2000) icrop, nolai(i)
                  icard  = icard  + 1
                  iuserc = iuserc + 1
                  do 40 j=1, nolai(i)
                     read (lun02, 2002) usrfrc(j,i), usrlai(j,i)
40                continue
                  icard  = icard  + nolai(i)
                  iuserc = iuserc + nolai(i)
               endif
30          continue
         endif
c  backspace until at start of rotation information
         do 50 i=1,icard
            backspace( lun02 )
50       continue
c  now we are ready to expand lai intformation for the rotation period
         year = 1
         do 60 i=1,366
            dlai(i)   = 0.
            potlai(i) = 0.
            dirr(i)   = 0.
            basei(i)  = 0.
            topi(i)   = 0.
            cdelta(i) = 0.
            iendro(i) = 0
            ibegro(i) = 0
            noirr(i)  = 0
            icindx(i) = 0
            iccrd(i)  = nevap
60       continue
         do 70 i=1,50
            balone(i) = 0.
            chtone(i) = 0.
70       continue
         begsum = 0.0
c  top of while icrop != 0 loop
         read (lun02, 2201) icrop, plantd, harvd, truncd,
     &                      ccrd, crphtx, iprnnl, beggro, endgro
         backspace( lun02 )
         if (icrop .lt. 0 .or. icrop .gt. 90) then
            write(*,7001)
            write(lun07,7001)
            stop
         endif
         if (icrop .gt. 0) then

            irotb = plantd / 1000
c   are there any fallow years at the beginning of simulation?
            if (irotb .gt. year) then
               do 80 j=year, irotb-1
                  write (lun11, 4000) (dlai(i),i=1,366)
                  write (lun11, 4101) (potlai(i),i=1,366)
                  write (lun11, 4001) (cdelta(i),i=1,366)
                  write (lun11, 2000) (icindx(i),i=1,366)
                  write (lun11, 4003) (basei(i),i=1,366)
                  write (lun11, 4003) (topi(i),i=1,366)
                  write (lun11, 4002) (noirr(i),i=1,366)
                  write (lun11, 4001) (dirr(i),i=1,366)
                  write (lun11, 4002) (iccrd(i),i=1,366)
                  write (lun11, 4002) (ibegro(i),i=1,366)
                  write (lun11, 4002) (iendro(i),i=1,366)
80             continue
               year = irotb
            endif
         endif
90       read (lun02, 2201) icrop, plantd, harvd, truncd,
     &                      ccrd, crphtx, iprnnl, beggro, endgro
         if (icrop .ne. 0) then
            read (lun02, 2202) iropt,irrbeg, irrend, dpreir, preirr,
     &                         bsi,tpi
            if (flgmet .eq. 1) then
               ccrd   = ccrd / 2.54
               preirr = preirr / 2.54
            endif
            if (ccrd .gt. rd) ccrd = rd
            if (ccrd .le. 0.0) ccrd = rd
            DO 100 ntl=1,NS
               if (BOTLAY(ntl) .GE. ccrd) goto 110
100          CONTINUE
110         continue
            iwrite = 1
            cmax   = 0.0
            icmax = 1
c  get points on lai curve
            if (icrop .ge. 79  .and.  icrop .le. 90) then
               chight = crphtx
               chight = chight * ftom                                    ftom
               pernnl(icrop) = iprnnl
               j = icrop - 78
               laicnt = nolai(j)
               do 120 i=1,laicnt
                  tlai(i) = usrlai(i,j)
                  flai(i) = usrfrc(i,j)
                  if (tlai(i) .gt. cmax) then
                     cmax = tlai(i)
                     icmax = i
                  endif
120            continue
            else
               if (crphtx .gt. 0.) then
                  chight = crphtx * ftom                                ftom
               else
                  chight = pothgt(icrop)
               endif
               laicnt = 11
               beg = 0.0
               if (icrop .ge. 69 .and. icrop .le. 71) then
                  laicnt = 13
                  j = icrop - 68
                  do 130 i=1,13
                     tlai(i) = laifor(i,j)
                     flai(i) = forfrc(i)
                     if (tlai(i) .gt. cmax) then
                        cmax = tlai(i)
                        icmax = 1
                     endif
130               continue
               else if (icrop .gt. 60) then
                  i3indx = icrop - 60
                  do 140 i=1,11
                     tlai(i) = lai3(i,i3indx)
                     flai(i) = beg
                     beg     = beg + .1
                     if (tlai(i) .gt. cmax) then
                        cmax = tlai(i)
                        icmax = i
                     endif
140               continue
               else if (icrop .gt. 30) then
                  i2indx = icrop - 30
                  do 150 i=1,11
                     tlai(i) = lai2(i,i2indx)
                     flai(i) = beg
                     beg     = beg + .1
                     if (tlai(i) .gt. cmax) then
                        cmax = tlai(i)
                        icmax = i
                     endif
150               continue
               else
                  do 160 i=1,11
                     tlai(i) = lai1(i,icrop)
                     flai(i) = beg
                     beg     = beg + .1
                     if (tlai(i) .gt. cmax) then
                        cmax = tlai(i)
                        icmax = i
                     endif
160               continue
               endif
            endif
            do 170 i=1,laicnt
               if (i .le. icmax) then
                  cinc(i) = tlai(i) / cmax * chight
               else
                  cinc(i) = chight
               endif
170         continue

            ib = mod( plantd, 1000 )
            ie = mod( harvd, 1000 )
            if (ie .eq. 365) then
c              if (mod( hbdate+year-1, 4 ) .eq. 0) then                  y2k
               noyear = hbdate/1000 + year - 1                          y2k
               ie = i2kyr( noyear )                                     y2k
            endif
            irotb = plantd / 1000
            irote = harvd / 1000
            if (ie .lt. ib) ie = ie + 366
            irb = mod( irrbeg, 1000 )
            ire = mod( irrend, 1000 )
            if (ire .lt. irb) ire = ire + 366
            if (truncd .gt. 0  .and.  truncd .ne. harvd) then
               ity = mod( truncd, 1000 )
               if (ity .lt. ib) ity = ity + 366
            else
               ity = 0
            endif
            nodays = ie - ib
            sumlai = 0.0
            area1  = tlai(1)
c get starting lai
c           alai   = tlai(1)
            alai   = 0.0
            beglai = tlai(1)
c get starting crop hite
c
            ch     = 0.0
            beghgt = cinc(1)
            chite1 = cinc(1)
            ibeg   = 0
            ibeg1  = 0
            ldate1 = ib
            skip   = 0
c            sumlai = sumlai + alai
            if (ldate1 .le. 366  .and.  irotb .eq. year) then
               k = ldate1
               if (dpreir .gt. 0) then
                  ipirr = mod( dpreir, 1000 )
                  if (flgmet .eq. 0) then
                     dirr(ipirr) = preirr
                  else
                     dirr(ipirr) = preirr / 2.54
                  endif
               endif
            else if (ldate1 .gt. 366  .and.  irote .eq. year) then
               k = ldate1 - 366
            else
               skip = 1
            endif
            outlai = 0
            irflg = 0
            if (istart .eq. 0) then
               if (irotb .eq. 1) istart = 1
            endif
            if (irb .ne. 0) then
               if (k .ge. irb .and. k .le. ire) then
                  if (skip .ne. 1) then
                     irflg = 1
                  endif
               endif
            endif
            if (skip .eq. 0) then
                write (lun07,3001) irflg,year,k,area1,(chite1/ftom)     ftom
               outlai = 2
            endif
            do 180 i=2,laicnt
               area2  = tlai(i)
               ldate2 = ib + nodays * flai(i)
               delta  = (area2 - area1) / (ldate2 - ldate1)
               chite2 = cinc(i)
               cdel   = (chite2 - chite1) / (ldate2 - ldate1)
               do 190 j=ldate1,ldate2
                  irflg = 0
                  skip  = 0
                  if (j .eq. ldate2) then
                     skip = 1
                  endif
                  if (j .le. 366  .and.  irotb .eq. year) then
                     k = j
                  else if (j .gt. 366  .and.  irote .eq. year) then
                     k = j - 366
                  else
                     skip = 1
                  endif
                  if (irb .ne. 0) then
                     if (j .ge. irb .and. j .le. ire) then
                        if (skip .ne. 1) then
                           noirr(k) = 1
                           irflg    = 1
                           basei(k) = bsi
                           topi(k)  = tpi
                        endif
                     endif
                  endif
                  if (k .eq. 1  .and.  skip .ne. 1) then
C                     if (istart .eq. 0) then
                        balone(year) = alai
                        chtone(year) = ch
C                     endif
                     if (outlai .eq. 0) then
                        if (ity .eq. 0) then
                           write (lun07,3001) irflg,year,k,alai,ch/ftom  ftom
                        else
                           if (j .eq. ity) then
                              write (lun07,3001) irflg,year,k,0,0
                           else if (j .lt. ity) then
                            write (lun07,3001) irflg,year,k,alai,ch/ftom ftom
                           endif
                        endif
                        outlai = 1
                     endif
                     if (year .eq. 1)  then
                        if (istart .eq. 0) begsum = sumlai
                     endif
                  endif
                  if (j .ne. ldate2) then
                     alai = alai + delta
                     ch   = ch + cdel
                     if (ibeg1 .eq. 0) then
                        alai = alai + beglai
                        ch   = ch + beghgt
                        ibeg1 = 1
                     endif
                     if (ity .eq. 0) then
                        sumlai = sumlai + alai
                     else if (j .lt. ity) then
                        sumlai = sumlai + alai
                     endif
                     if (skip .ne. 1) then
                        dlai(k)   = delta
                        cdelta(k) = cdel
                        if (ibeg .eq. 0) then
                           if (istart .eq. 1) then
                              dlai(k)   = dlai(k) + beglai
                              cdelta(k) = cdelta(k) + beghgt
                           else
                              istart = 1
                           endif
                           ibeg = 1
                        endif
                        iccrd(k) = ntl
                        ibegro(k) = beggro
                        iendro(k) = endgro
                     endif
                  endif
                  if (k .eq. 366  .and.  skip .ne. 1) then
                     if (ity .eq. 0) then
                        write (lun07,3001) irflg,year,k,alai,ch/ftom     ftom
                     else
                        if (j .eq. ity) then
                           write (lun07,3001) irflg,year,k,0,0
                        else if (j .lt. ity) then
                           write (lun07,3001) irflg,year,k,alai,ch/ftom  ftom
                        endif
                     endif
                     outlai = 1
                  endif
190            continue
               if (outlai .eq. 2) outlai = 0
               skip   = 0
               alai   = area2
               area1  = area2
               ldate1 = ldate2
               ch     = chite2
               chite1 = chite2
               if (ldate1 .le. 366  .and.  irotb .eq. year) then
                  k = ldate1
               else if (ldate1 .gt. 366  .and.  irote .eq. year) then
                  k = ldate1 - 366
               else
                  skip = 1
               endif

               irflg = 0
               if (irb .ne. 0) then
                  if (ldate1 .ge. irb .and. ldate1 .le. ire) then
c                     if (skip .ne. 1) then
                        irflg = 1
c                     endif
                  endif
               endif

               if (skip .eq. 0  .and.  outlai .eq. 0) then
                  if (ity .eq. 0) then
c                     write (lun07,3001) irflg,year,k,area1,chite1       ftom
                     write (lun07,3001) irflg,year,k,area1,chite1/ftom   ftom
                  else if (ldate1 .lt. ity) then
c                     write (lun07,3001) irflg,year,k,area1,chite1       ftom
                     write (lun07,3001) irflg,year,k,area1,chite1/ftom   ftom
                  endif
               endif
               outlai = 0
180         continue
            do 200 i=ib, ie
               skip = 0
               if (i .le. 366  .and.  irotb .eq. year) then
                  j = i
               else if (i .gt. 366  .and.  irote .eq. year) then
                  j = i - 366
               else
                  skip = 1
               endif
               if (skip .eq. 0) then
                  potlai(j) = sumlai
                  icindx(j) = icrop
                  if (i .eq. ib) icindx(j) = icrop + 2000
               endif
200         continue
c            if (truncd .gt. 0  .and.  truncd .ne. harvd) then
            if (truncd .eq. 0) truncd = harvd
            if (truncd .gt. 0) then
c              ity = mod( truncd, 1000 )
               ity = truncd / 1000
               if (ity .le. year) then
                  it = mod( truncd, 1000 )
                  if (ity .lt. year) then
                     balone(year) = 0.
                     chtone(year) = 0.
                  else
                     tozero = balone(year)
                     do 210 i=1,it
                        tozero = tozero + dlai(i)
210                  continue
                  endif
                  if (it .lt. ib) it = it + 366
                  do 220 i=it,ie
                     skip = 0
                     if (i .le. 366  .and.  irotb .eq. year) then
                        j = i
                     else if (i .gt. 366  .and.  irote .eq. year) then
                        j = i - 366
                     else
                        skip = 1
                     endif
                     if (skip .ne. 1) then
c                        potlai(j) = 0.
                        dlai(j)   = 0.
                        cdelta(j) = 0.
                        if (i .ne. it) then
                           iccrd(j)  = nevap
                           icindx(j) = 0
                        endif
                     endif
220               continue
                  if (ity .eq. year) then
                     it       = mod( truncd, 1000 )
c                     dlai(it) = -tozero
                     dlai(it) = -9.9
                     cdelta(it) = -99.9
                  endif
               endif
            endif

            if (irote .gt. year .and.
     &             (irote .le. irot .or. year .lt. irot)) then
               backspace( lun02 )
               backspace( lun02 )
               year = year + 1
               write (lun11, 4000) (dlai(i),i=1,366)
               write (lun11, 4101) (potlai(i),i=1,366)
               write (lun11, 4001) (cdelta(i),i=1,366)
               write (lun11, 2000) (icindx(i),i=1,366)
               write (lun11, 4003) (basei(i),i=1,366)
               write (lun11, 4003) (topi(i),i=1,366)
               write (lun11, 4002) (noirr(i),i=1,366)
               write (lun11, 4001) (dirr(i),i=1,366)
               write (lun11, 4002) (iccrd(i),i=1,366)
               write (lun11, 4002) (ibegro(i),i=1,366)
               write (lun11, 4002) (iendro(i),i=1,366)
               do 230 i=1,366
                  dlai(i)   = 0.
                  potlai(i) = 0.
                  dirr(i)   = 0.
                  cdelta(i) = 0.
                  basei(i)  = 0.
                  topi(i)   = 0.
                  icindx(i) = 0
                  noirr(i)  = 0
                  ibegro(i) = 0
                  iendro(i) = 0
                  iccrd(i)  = nevap
230            continue
               iwrite = 0
               if (irotb .gt. year) then
c are there any fallow years in the middle of simulation?
                  do 240 j=year, irotb-1
                     write (lun11, 4000) (dlai(i),i=1,366)
                     write (lun11, 4101) (potlai(i),i=1,366)
                     write (lun11, 4001) (cdelta(i),i=1,366)
                     write (lun11, 2000) (icindx(i),i=1,366)
                     write (lun11, 4003) (basei(i),i=1,366)
                     write (lun11, 4003) (topi(i),i=1,366)
                     write (lun11, 4002) (noirr(i),i=1,366)
                     write (lun11, 4001) (dirr(i),i=1,366)
                     write (lun11, 4002) (iccrd(i),i=1,366)
                     write (lun11, 4002) (ibegro(i),i=1,366)
                     write (lun11, 4002) (iendro(i),i=1,366)
240               continue
                  year = irotb
               endif
            endif
            if (irotb .gt. year) then
               year = year + 1
               write (lun11, 4000) (dlai(i),i=1,366)
               write (lun11, 4101) (potlai(i),i=1,366)
               write (lun11, 4001) (cdelta(i),i=1,366)
               write (lun11, 2000) (icindx(i),i=1,366)
               write (lun11, 4003) (basei(i),i=1,366)
               write (lun11, 4003) (topi(i),i=1,366)
               write (lun11, 4002) (noirr(i),i=1,366)
               write (lun11, 4001) (dirr(i),i=1,366)
               write (lun11, 4002) (iccrd(i),i=1,366)
               write (lun11, 4002) (ibegro(i),i=1,366)
               write (lun11, 4002) (iendro(i),i=1,366)
               do 250 i=1,366
                  dlai(i)   = 0.
                  potlai(i) = 0.
                  dirr(i)   = 0.
                  cdelta(i) = 0.
                  basei(i)  = 0.
                  topi(i)   = 0.
                  icindx(i) = 0
                  noirr(i)  = 0
                  ibegro(i) = 0
                  iendro(i) = 0
                  iccrd(i)  = nevap
250            continue
               iwrite = 0
            endif
            goto 90
         endif
         if (iwrite .eq. 1) then
            write (lun11, 4000) (dlai(i),i=1,366)
            write (lun11, 4101) (potlai(i),i=1,366)
            write (lun11, 4001) (cdelta(i),i=1,366)
            write (lun11, 2000) (icindx(i),i=1,366)
            write (lun11, 4003) (basei(i),i=1,366)
            write (lun11, 4003) (topi(i),i=1,366)
            write (lun11, 4002) (noirr(i),i=1,366)
            write (lun11, 4001) (dirr(i),i=1,366)
            write (lun11, 4002) (iccrd(i),i=1,366)
            write (lun11, 4002) (ibegro(i),i=1,366)
            write (lun11, 4002) (iendro(i),i=1,366)
         endif

c are there any fallow years at the end of simulation?
         if (irote .lt. irot) then
            do 260 i=1,366
               dlai(i)   = 0.
               potlai(i) = 0.
               dirr(i)   = 0.
               cdelta(i) = 0.
               basei(i)  = 0.
               topi(i)   = 0.
               icindx(i) = 0
               noirr(i)  = 0
               ibegro(i) = 0
               iendro(i) = 0
               iccrd(i)  = nevap
260         continue
            do 270 j=irote, irot
               write (lun11, 4000) (dlai(i),i=1,366)
               write (lun11, 4101) (potlai(i),i=1,366)
               write (lun11, 4001) (cdelta(i),i=1,366)
               write (lun11, 2000) (icindx(i),i=1,366)
               write (lun11, 4003) (basei(i),i=1,366)
               write (lun11, 4003) (topi(i),i=1,366)
               write (lun11, 4002) (noirr(i),i=1,366)
               write (lun11, 4001) (dirr(i),i=1,366)
               write (lun11, 4002) (iccrd(i),i=1,366)
               write (lun11, 4002) (ibegro(i),i=1,366)
               write (lun11, 4002) (iendro(i),i=1,366)
270         continue
         endif
         alone = balone(1)
         chone = chtone(1)
         rewind( lun11 )
         read(lun11, 4000) (dlai(i),i=1,366)
         read(lun11, 4101) (potlai(i),i=1,366)
         read(lun11, 4001) (cdelta(i),i=1,366)
         read(lun11, 2000) (icindx(i),i=1,366)
         read(lun11, 4003) (basei(i),i=1,366)
         read(lun11, 4003) (topi(i),i=1,366)
         read(lun11, 4002) (noirr(i),i=1,366)
         read(lun11, 4001) (dirr(i),i=1,366)
         read(lun11, 4002) (iccrd(i),i=1,366)
         read(lun11, 4002) (ibegro(i),i=1,366)
         read(lun11, 4002) (iendro(i),i=1,366)
         if (iuserc .gt. 0) then
            do 280 j=1, iuserc
               read (lun02, 2003) x
280         continue
         endif
         ioldcp = icindx(1)
         if (ioldcp .gt. 2000) ioldcp = ioldcp - 2000
      endif
      RETURN
2000  FORMAT(10I8)
2001  FORMAT(8I8,f8.0)
2201  FORMAT(4I8,2f8.0,3i8)
2002  FORMAT(2f8.0)
2202  FORMAT(4i8,3f8.0)
2003  FORMAT(f8.0)
c2004  FORMAT(3i8,f8.0)                                                  y2k
c2004  FORMAT(2(i6,i2),i8,f8.0)                                          y2k
2004  FORMAT(2(i6,i2),2i8)                                              leaf
c3000  FORMAT(' ',/,30X,'LEAF AREA INDEX TABLE',//,
c     1  9X,'IRFLG',16X,'   DATE        LAI',/,
c     1  9X,'-----',16X,'   ----       ----')
c3001  FORMAT(' ',10X,I1,22X,I3,6X,F5.2)
3000  FORMAT(/,30X,'LEAF AREA INDEX TABLE',//,
     1  9X,'IRFLG',16X,' YEAR   DATE    LAI   HEIGHT (M)',/,
     1  9X,'-----',16X,' ----   ----   ----   ----------')
3001  FORMAT(11X,I1,20X,I2,5X,I3,3X,F5.2,2x,f5.2)
3002  FORMAT(/,30X,'LEAF AREA INDEX TABLE',//,
     1  9X,'IRFLG',16X,' YEAR   DATE    LAI   HEIGHT (FT)',/,
     1  9X,'-----',16X,' ----   ----   ----   -----------')
4000  FORMAT(10f10.7)
4001  FORMAT(10f8.3)
4002  FORMAT(10I3)
4003  FORMAT(10f6.4)
4101  FORMAT(10f12.7)
7001  FORMAT(' ERROR H6: ICROP must be in the range 0 - 90.')
9001  FORMAT(/,' *** Y2K COMPLIANCE: 2 DIGIT YEAR READ. *** ',/,        y2k
     &         '    ROTATION BEGIN YEAR = ',i5,/,                       y2k
     &         '    ROTATION END YEAR   = ',i5/)                        y2k
      END

       SUBROUTINE EROSA(FLGMET,POR,OM1)
       COMMON /EROS1/BYEAR,EYEAR,CDATE,NDATES,NYEARS,EROOUT,
     &            FLGUPD,FLGSEQ,NPTSO,XPOVR,SPOVR,NPTSC1,XPCHN1,
     &            SPCHN1,NPTSC2,XPCHN2,SPCHN2,DAREA,ELEM,FLGTMP
       COMMON /ROUT/ NXK,XSOIL(4),KSOIL(4),NXF,XFACT(4),CFACT(4,40),
     1               PFACT(4,40),NFACT(4,40),DAOVR,SLNGTH,
     1               NXC1,XCHN1(4),NCHN1(4,40),CCHN1(4,40),SCHN1(4,40),
     1               DCHN1(4,40),WCHN1(4,40),FLAGC1,FLAGS1,CTLO1,
     1               CTLZ1,CTLN1,CTLSL1,RA1,RN1,YBASE1,DACHU1,
     1               DACHL1,Z1,LNGTH1,LEFF1,
     1               NXC2,XCHN2(4),NCHN2(4,40),CCHN2(4,40),SCHN2(4,40),
     1               DCHN2(4,40),WCHN2(4,40),FLAGC2,FLAGS2,CTLO2,
     1               CTLZ2,CTLN2,CTLSL2,RA2,RN2,YBASE2,DACHU2,
     1               DACHL2,Z2,LNGTH2,LEFF2
       COMMON /CHAN/ XSTAR(2,40),DEPA(2,40),DEPB(2,40),WIDA(2,40),
     1               WIDB(2,40),WERA(2,40),WERB(2,40)
       COMMON /FALL/ RE(9),CDRE2(9),CDDRE(9)
      COMMON /joeb2/ indjoe
       REAL REB(9),CDRB(9),CDDB(9),XPOVR(40),SPOVR(40),XPCHN1(40),
     1      SPCHN1(40),XPCHN2(40),SPCHN2(40),TGST(4,10),TGSY(4,10),
     1      TGSM(4,10),GS(10),CONC(10),DAREA(4),LNGTH1,LEFF1,LNGTH2,
     1      LEFF2,KSOIL,NFACT,NCHN1,NCHN2
       INTEGER BYEAR,EYEAR,SDATE,CDATE(41),DNYEAR(40),EROOUT,
     1          FLGUPD,FLGSEQ,WCHMON,DP,ELEM,FLGTMP,FLGMET,
     1          FLAGC1,FLAGS1,CTLO1,FLAGC2,FLAGS2,CTLO2
       save
       DATA REB  /0.001,0.01,0.1,1.0,10.0,100.0,1000.0,
     1            10000.0,100000.0/
       DATA CDRB /0.011,0.22,2.2,22.8,420.0,11000.0,
     1            480000.0,4.0E+07,4.8E+09/
       DATA CDDB /2.05E+07,2.05E+05,2.05E+03,24.0,0.41,
     1            1.05E-02,4.3E-04,4.0E-05,4.4E-06/

       DO 10 J=1,9
           RE(J)    = ALOG(REB(J))
           CDRE2(J) = ALOG(CDRB(J))
           CDDRE(J) = ALOG(CDDB(J))
  10   CONTINUE
C
C
C
C      INIPAR READS THE FILE CONTAINING THE PARAMETERS FOR THE
C      SIMULATION RUN.  IT ALSO PRINTS AN INITIAL OUTPUT THAT PRESENTS
C      THOSE PARAMETERS IN A MORE UNDERSTANDABLE FORM.
C
       CALL INIPAR(BYEAR,EYEAR,CDATE,NDATES,NYEARS,EROOUT,
     &             FLGUPD,FLGSEQ,NPTSO,XPOVR,SPOVR,NPTSC1,XPCHN1,
     &             SPCHN1,NPTSC2,XPCHN2,SPCHN2,DAREA,FLGMET,POR,OM1)
       ELEM=0
       FLGTMP = MOD(EROOUT,2)
       IF (EROOUT.EQ.6) FLGTMP = 1
C
C      THE INITIAL WIDTH AND DEPTH VALUES FOR EACH SEGMENT OF THE
C      CHANNELS MODELED IN THIS SIMULATION ARE SET UP HERE WITH
C      THE CALLS TO SPREAD.   INDXD IS THE INDEX FOR THE ARRAY OF
C      DATES (CDATE) THAT CONTROLS THE PARAMETERS SELECTION.
C
       LINDXD = 1
       INDXD  = 1
       INDXND = 2
       IF (FLGSEQ.LE.2) GO TO 30
       CALL SPREAD(0,1,INDXD,1,NXC1,XCHN1,DCHN1,NPTSC1,XPCHN1,DEPA)
       CALL SPREAD(0,2,INDXD,1,NXC1,XCHN1,DCHN1,NPTSC1,XPCHN1,DEPB)
       CALL SPREAD(0,1,INDXD,1,NXC1,XCHN1,WCHN1,NPTSC1,XPCHN1,WIDA)
       CALL SPREAD(0,2,INDXD,1,NXC1,XCHN1,WCHN1,NPTSC1,XPCHN1,WIDB)
       IF (FLGSEQ.EQ.3.OR.FLGSEQ.EQ.5) GO TO 30
       CALL SPREAD(0,1,INDXD,2,NXC2,XCHN2,DCHN2,NPTSC2,XPCHN2,DEPA)
       CALL SPREAD(0,2,INDXD,2,NXC2,XCHN2,DCHN2,NPTSC2,XPCHN2,DEPB)
       CALL SPREAD(0,1,INDXD,2,NXC2,XCHN2,WCHN2,NPTSC2,XPCHN2,WIDA)
       CALL SPREAD(0,2,INDXD,2,NXC2,XCHN2,WCHN2,NPTSC2,XPCHN2,WIDB)
  30   CONTINUE
       if (flgseq .eq. 1) then
          indjoe = 1
       else if (flgseq.eq.2 .or. flgseq.eq.5 .or. flgseq.eq.6) then
          indjoe = 4
       else if (flgseq .eq. 3) then
          indjoe = 2
       else
          indjoe = 3
       endif
       RETURN
       END

$NODEBUG

C**********************************************************************C
C ***********G L E A M S   PESTICIDE CHEMISTRY*************************C
C ******************** PROGRAM ****************************************C

c initialize soil variables used in both pesticides and nutrients
      SUBROUTINE INIsol
      COMMON /PST1/CONSP(12),SOLPST(366,12),PERPST(366),APRPST(366),
     1             PREPST(366,12),PECON(366),TRNOUT(366)
      COMMON /NUTPST/BD(12),FC(12),CONV(12),FUL(12),SOLPOR(12),
     &               BR15(12),OSW(12),SAT(12),OM(12),KD(366,12),
     &               SOILMS(12),cknit(12)
      COMMON /ANNTOT/ NSTRMY,NRNFFY,NYPER,NSED,YPRECP,YRUNFF,YPERC,
     &                YSED
      COMMON /LAYERS/ NS, NOSOHZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,  swet
     &                BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      common /solt/ tbg(5),itbg,tbgsum,tswc,tma,dbd,aln,scaled,zl(12),
     &              wft(12), tsc(12), tk4(12)
      real kd
      save
      NSTRMY = 0
      NRNFFY = 0
      NYPER  = 0
      NSED   = 0
      YPRECP = 0.0
      YRUNFF = 0.0
      YPERC  = 0.0
      YSED   = 0.0
      tsmass = 0.0
      DO 15 I=1,NS
         BD(I)    = 2.65 * (1.0 - SOLPOR(I))
         CONSP(I) = BD(I) * DLAYM(I) * 100.0
         CONV(I)  = 10.0 / (BD(I) * DLAYM(I))
         FC(I)    = ((FUL(I)*(SOLPOR(I)-BR15(I)))+BR15(I))*DLAYM(I)
         SAT(I)   = SOLPOR(I) * DLAYM(I)
         SOILMS(I)= 100.0 * BD(I) * DLAYM(I)
         cknit(i) = .01429 * soilms(i)
         tsmass   = tsmass + soilms(i)
C * * 100*BD*DLAY = SOILMS IN MEGAGRAMS/HA
c convert cm to m
         if (i .eq. 1) then
            zl(1) = .01
         else
            zl(i) = (botmet(i) + botmet(i-1)) / 100.
         endif
  15  CONTINUE
      abd = tsmass / (100. * botmet(ns))
      dbd = 1.0 + ((2.5 * abd) / (abd + exp( 6.53 - 5.63 * abd )))
c      scaled = (.356 - .144 * abd) * botmet(ns)
c * * * div by 100 to convert cm to m
      scaled = (.356 - .144 * abd) * (botmet(ns) / 100.)
      aln = alog( .5 / dbd )
      RETURN
      END

      SUBROUTINE INIPST (RD,HBDATE)
      COMMON /ERYPST/PSTPAS,PSTOUT,NBDATE,PBDATE,PEDATE,NPEST,
     &               APRATE(366),H2OSOL(366),DECAY(366,12),KOC(366),
     &               FOLFRC(366),SOLFRC(366),FOLRES(366),SOLRES(366,12),
     &               WSHFRC(366), WSHTHR   ,METH(366),TOTPST(366),
     &               FOLRSV(366),DEPINC(366),BETA(366),COFTRN(366),
     &               COFUP(366),METPST(366),DEGRAD(366,12),NEWPST(366),
     &               CHMWAT(366)
      COMMON /PASS1/PAS(2196),IFAP(366)
c      COMMON /PASS1/PAS(2196)
      COMMON /PRCP/ SOLOSS,ENRICH,DP,PERCOL,
     1              AVGTMP,AVGSWC,ACCPEV,POTPEV,ACCSEV,POTSEV,SW(12),
     &               SWPER(13),UP(12),EVP(12),WUP(12),CHMET,solevp,
     &               potevp
      COMMON /PEST/ H2OLOS(366),SEDLOS(366),PRCLOS(366), tottrn(366)
      COMMON /PASS/ SDATE,RNFALL,RUNOFF,EXRAIN,EI
      COMMON /PPST/ ACCLOS(366)
      COMMON /PST1/CONSP(12),SOLPST(366,12),PERPST(366),APRPST(366),
     1             PREPST(366,12),PECON(366),TRNOUT(366)
      COMMON /NUTPST/BD(12),FC(12),CONV(12),FUL(12),SOLPOR(12),
     &               BR15(12),OSW(12),SAT(12),OM(12),KD(366,12),
     &               SOILMS(12),cknit(12)
      COMMON /LAYERS/ NS, NOSOHZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,  swet
     &                BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
      COMMON /PSTVAR/ APDATE,HAFLIF,PSTNAM
      COMMON /FLAG  / FLGRES(366),NFLG
      COMMON /DATES/ LDATE(366)
      COMMON /RESDUE/RES(366,5),RESD(366,12),SHFLIF(366,5)
      COMMON /PSTLIF/psthaf(366,12)
      COMMON /ORGMAT/HYDOM(12)
      COMMON /MONTOT/ MCCLOS,MOTPST,OPRC(366),OWAT(366),OSED(366)
      COMMON /ANNTOT/ NSTRMY,NRNFFY,NYPER,NSED,YPRECP,YRUNFF,YPERC,
     &                YSED
      COMMON /ANNLOS/ YCCLOS(366),YOTPST(366),ANWAT(366),ANSED(366),
     &                ANPRC(366), antrn(366)
      COMMON /GPHINT/HEADNG
      COMMON /c1c2/dk1(366,12),dk11(366,12),solc2p(366,12),             tc
     &             solc2(366,12),sedc2c(366),sedc2m(366),c2mon(366),    tc
     &             c2ann(366),c2acc(366),idelta,deltat,ic2flg           tc
       COMMON /joeb/ anrcon(366), anrdat(366), anpcon(366), anpdat(366), joeb
     &               antcon(366), antdat(366),
     &              vrmass(366,10),vrvol(366),vpmass(366,10),vpvol(366),
     &               vtmass(366,10),
     &               anrmax(366), anrvol(366), anpmax(366), anpvol(366),
     &               antmax(366),
     &               jhead, jtail, jintvl,
     &               jshead, jstail, jsntvl,
     &               srcon(366), srdat(366), spcon(366), spdat(366),
     &               stcon(366), stdat(366), srvol(366), spvol(366)
      REAL HAFLIF(366),KD,KOC,MCCLOS(366),MOTPST(366)
      INTEGER APDATE(366),HBDATE,HEADNG,
     1        FLAGSK,PSTPAS,PSTOUT,PBDATE,PEDATE,PDATE,SDATE,
     1        DP,WCHMON,EYEAR,FLGRES
       integer anrdat,anpdat,antdat,srdat,spdat,stdat                   joeb
      save
      CHARACTER *8 IDASH
      CHARACTER *4 IHEAD (2)
      CHARACTER *16 PSTNAM (366)
      IDASH = '--------'
      IHEAD(1) = ' G/H'
      IHEAD(2) = ' PPM'
      DO 5  I= 1, NS
         OM(I) = HYDOM(I)
 5    CONTINUE

      HEADNG = 1
      idelta = 4                                                        tc
      deltat = .25                                                      tc
      DO 10 I=1,npest                                                   366
         PSTNAM(I) = '                '
         PERPST(I) = 0.0
         APRPST(I) = 0.0
         ACCLOS(I) = 0.0
         TOTPST(I) = 0.0
         FOLRSV(I) = 0.0
         TRNOUT(I) = 0.0
         tottrn(I) = 0.0
         antrn(I)  = 0.0
         APDATE(I) = 0
         IFAP(I)   = 0
         H2OLOS(I) = 0.0
         SEDLOS(I) = 0.0
         PRCLOS(I) = 0.0
         MCCLOS(I) = 0.0
         MOTPST(I) = 0.0
         OPRC(I)   = 0.0
         OWAT(I)   = 0.0
         OSED(I)   = 0.0
         YCCLOS(I) = 0.0
         YOTPST(I) = 0.0
         ANPRC(I)  = 0.0
         ANWAT(I)  = 0.0
         ANSED(I)  = 0.0
         KOC(I)    = 0.0
         WSHFRC(I) = 0.0
         tottrn(i) = 0.0
         antrn(i)  = 0.0
         anrcon(i) = 0.0
         anpcon(i) = 0.0
         antcon(i) = 0.0
         vrvol(i)  = 0.0
         vpvol(i)  = 0.0
         anrmax(i) = 0.0
         antmax(i) = 0.0
         anpmax(i) = 0.0
         anrvol(i) = 0.0
         anpvol(i) = 0.0
         srcon(i)  = 0.0
         spcon(i)  = 0.0
         stcon(i)  = 0.0
         srvol(i)  = 0.0
         spvol(i)  = 0.0
         sedc2c(i) = 0.0                                                tc
         sedc2m(i) = 0.0                                                tc
         c2mon(i)  = 0.0                                                tc
         c2ann(i)  = 0.0                                                tc
         c2acc(i)  = 0.0                                                tc
         anrdat(i) = 0
         anpdat(i) = 0
         antdat(i) = 0
         srdat(i)  = 0
         spdat(i)  = 0
         stdat(i)  = 0
         do 9 k=1,10
            vrmass(i,k) = 0.0
            vpmass(i,k) = 0.0
            vtmass(i,k) = 0.0
9        continue
10    CONTINUE
      CALL INITCH(HBDATE,PBDATE,PEDATE,NPEST,PSTOUT,
     &             PSTPAS,IROT,RD)
c     DO 15 I=1,NS
c        BD(I)    = 2.65 * (1.0 - SOLPOR(I))
c        CONSP(I) = BD(I) * DLAYM(I) * 100.0
c        CONV(I)  = 10.0 / (BD(I) * DLAYM(I))
c        FC(I)    = ((FUL(I)*(SOLPOR(I)-BR15(I)))+BR15(I))*DLAYM(I)
c        SAT(I)   = SOLPOR(I) * DLAYM(I)
c        SOILMS(I)= 100.0 * BD(I) * DLAYM(I)
C * * 100*BD*DLAY = SOILMS IN MEGAGRAMS/HA
c 15  CONTINUE
      DO 20 I=1,npest                                                   366
         DO 18 K=1,5
            RES(I,K)    = 0.0
            SHFLIF(I,K) = 0.0
  18     CONTINUE
         DO 19 K=1,12
            KD(I,K)     = 0.0
            RESD(I,K)   = 0.0
            SOLPST(I,K) = 0.0
            PREPST(I,K) = 0.0
            SOLRES(I,K) = 0.0
            DEGRAD(I,K) = 0.0
            DECAY(I,K)  = 0.0
            psthaf(I,K) = 0.0
            dk1(i,k)    = 0.0                                           tc
            dk11(i,k)   = 0.0                                           tc
            solc2p(i,k) = 0.0                                           tc
            solc2(i,k)  = 0.0                                           tc
  19     CONTINUE
  20  CONTINUE
      NFLG   =  0
      CALL ALLPST
      DO 40 I=1,NPEST
         DO 30 K=1,NS
            SOLPST(I,K)  =  RESD(I,K)
c  Organic Matter already converted to Organic Carbon
c           KD(I,K)      =  KOC(I) * OM(K) * 0.0058
            KD(I,K)      =  KOC(I) * OM(K) * 0.01
            PREPST(I,K)  =  SOLPST(I,K)
 30      CONTINUE
CCCCCC      CALCULATE BETA COEFFICIENTS
         IF (KD(I,1) .LE. 1.0) THEN
            BETA(I) = 0.500
         ELSE IF (KD(I,1) .GT. 1.0 .AND. KD(I,1) .LT. 3.0) THEN
            BETA(I) = 0.7 - 0.2 * KD(I,1)
         ELSE
            BETA(I) = 0.1
         ENDIF
         IF (FLGRES(I) .NE. 0 ) THEN
            LDATE (I)   = PBDATE + 1
            APDATE(I)   = PBDATE + 1
            NFLG        = 1
         ENDIF
 40   CONTINUE

      CALL PESTIN(HBDATE,PEDATE,IROT)
      NORAIN = 0
C
C PESTS
C
      IF (NPEST .GT. 5) THEN
         MPEST = 5
      ELSE
         MPEST = NPEST
      ENDIF

      IF (PSTPAS .EQ. 1) THEN
         WRITE (LUN11,4000)  (PSTNAM(I),I=1,NPEST)
         WRITE (LUN11,4001)  (IDASH, I=1,MPEST)
         WRITE (LUN11,4002)  ((IHEAD(1)), K=1,MPEST)
      ELSE IF (PSTPAS .EQ. 2) THEN
         WRITE (LUN12,4000)   (PSTNAM(I),I=1,NPEST)
         WRITE (LUN12,4001)   (IDASH, I=1,MPEST)
         WRITE (LUN12,4002)   ((IHEAD(I),I=2,2), K=1,MPEST)
      ELSE IF (PSTPAS .EQ. 3) THEN
         WRITE (LUN11,4000)   (PSTNAM(I),I=1,NPEST)
         WRITE (LUN11,4001)   (IDASH, I=1,MPEST)
         WRITE (LUN11,4002)   ((IHEAD(I),I=1,1), K=1,MPEST)
         WRITE (LUN12,4000)   (PSTNAM(I),I=1,NPEST)
         WRITE (LUN12,4001)   (IDASH, I=1,MPEST)
         WRITE (LUN12,4002)   ((IHEAD(I),I=2,2), K=1,MPEST)
      ENDIF

 4000 FORMAT('  DATE   RAIN    RUN   PERC   SDMT ',5(A8,1X) /
     1    35X,                                     5(A8,1X) )
 4001 FORMAT('                                   ',5(A8,1X) )
 4002 FORMAT('          CM     CM     CM     T/H ',5(3X,A4,2X) )
      RETURN
      END
      SUBROUTINE INITCH(HBDATE,PBDATE,PEDATE,NPEST,PSTOUT,
     &                  PSTPAS,IROT,RD)
      COMMON /NUTPST/BD(12),FC(12),CONV(12),FUL(12),SOLPOR(12),
     &               BR15(12),OSW(12),SAT(12),OM(12),KD(366,12),
     &               SOILMS(12),cknit(12)
      COMMON /LAYERS/ NS, NOSOHZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,  swet
     &                BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
      COMMON /FLDCAP/UF(12)
      COMMON /HEAD3/ TITLE3
      COMMON /c1c2/dk1(366,12),dk11(366,12),solc2p(366,12),             tc
     &             solc2(366,12),sedc2c(366),sedc2m(366),c2mon(366),    tc
     &             c2ann(366),c2acc(366),idelta,deltat,ic2flg           tc
      common /pstzcf/zcoef
      REAL KD, AFUL(12)
      INTEGER HBDATE,PSTOUT,PSTPAS,PBDATE,PEDATE
      CHARACTER *80 TITLE3(3)
      save
      WRITE(LUN10,3001)
      DO 10 J=1,3
          READ (LUN05,2002)  TITLE3(J)
          WRITE(LUN10,3002)   TITLE3(J)
  10  CONTINUE
c      READ (LUN05,2000) PBDATE,PEDATE,NPEST,IROT,PSTOUT,PSTPAS,zcoef   tc
      READ (LUN05,2000) PBDATE,PEDATE,NPEST,IROT,PSTOUT,ic2flg          tc
      if (zcoef .le. 0.0) zcoef = 1.

      iy2k = 0                                                          y2k
      if (pbdate .lt. 100000) then                                      y2k
         nbcen  = 19                                                    y2k
         ioldpb = pbdate                                                y2k
         pbdate = (nbcen * 100000) + pbdate                             y2k
         iy2k = 1                                                       y2k
      endif                                                             y2k
      if (pedate .lt. 100000) then                                      y2k
         necen = 19                                                     y2k
         if (pedate .lt. ioldpb) necen = 20                             y2k
         pedate = (necen * 100000) + pedate                             y2k
         iy2k = 1                                                       y2k
      endif                                                             y2k
      if (iy2k .ne. 0) then                                             y2k
         WRITE(LUN10,3011) pbdate,pedate                                y2k
         WRITE(*,3011) pbdate,pedate                                    y2k
      endif                                                             y2k

      IF (PSTPAS.EQ.1) THEN
         WRITE(LUN11,2002)(TITLE3(JJ),JJ=1,3)
      ELSE IF (PSTPAS.EQ.2) THEN
         WRITE(LUN12,2002)(TITLE3(JJ),JJ=1,3)
      ELSE IF (PSTPAS.EQ.3) THEN
          WRITE(LUN11,2002)(TITLE3(JJ),JJ=1,3)
          WRITE(LUN12,2002)(TITLE3(JJ),JJ=1,3)
      ENDIF
C  CONVERT FIELD CAPACITY FROM INCHES TO MILLIMETERS.
      DO 55 K = 1,NS
         AFUL(K) =(FUL(K) * (SOLPOR(K) - BR15(K))) + BR15(K)
 55   CONTINUE
      WRITE(LUN10,3000) HBDATE,RD
      WRITE(LUN10,3006) (M,SOLPOR(M),M=1,NS)
      WRITE(LUN10,3008) (M,AFUL(M),  M=1,NS)
      WRITE(LUN10,3009) (M,BR15(M),  M=1,NS)
      WRITE(LUN10,3004) (KK,OM(KK), KK=1,NS)
      WRITE (LUN10,3010) PBDATE,PEDATE,NPEST
C * * CONVERT FROM ORGANIC MATTER TO ORGANIC CARBON
      DO 60 K = 1,NS
         OM(K) = OM(K) / 1.732
 60   CONTINUE
      RETURN
2000  FORMAT(6I8)
2001  FORMAT(10F8.0)
2002  FORMAT(A80)
3000  FORMAT(/,18X,'STARTING DATE FOR SIMULATION ',I8,                  y2k
     1                ' JULIAN DATE',//,                                y2k
     1            30X,'ROOTING DEPTH   ',F9.2,' MM',//)
3001  FORMAT(    //,12X,'G L E A M S  NONPOINT SOURCE POLLUTION ',
     1               'MODEL (PESTICIDES)',/,
     1           23X,'VERSION 3.0  MAY 1, 1999   TIFTON GA',//)
3002  FORMAT(1X,A80)
3004  FORMAT(/, 6X,'ORGANIC MATTER (%) BY LAYER',/, 6X,12(I3,F6.2))
3006  FORMAT(/, 6X,'POROSITY (CC/CC) BY LAYER',/, 6X,12(I3,F6.3))
3008  FORMAT(/, 6X,'FIELD CAPACITY (MM/MM) BY LAYER',/, 6X,
     1              12(I3,F6.3))
3009  FORMAT(/, 6X,'WILTING POINT (MM/MM) BY LAYER',/, 6X,12(I3,
     &F6.3))
3010  FORMAT(/,33X,'PESTICIDE INPUTS',/,
     1         33X,'----------------',//,
     1         21X,'SIMULATION FOR THE PERIOD',I8,' TO',I8,/,           y2k
     1         21X,'SIMULATION FOR ',I3,' PESTICIDES.',//)
3011  FORMAT(/,' *** Y2K COMPLIANCE: 2 DIGIT YEAR READ. *** ',/,        y2k
     &         '    PESTICIDE BEGIN DATE = ',i8,/,                      y2k
     &         '    PESTICIDE END DATE   = ',i8/)                       y2k
      END

      SUBROUTINE ALLPST
C     ******************************************************************
C     **   READ ALL CONSTANT PESTICIDE CHARACTERISTICS  AND RESIDUES  **
C     **   BY HORIZON.                                                **
C     ******************************************************************
      COMMON /ERYPST/PSTPAS,PSTOUT,NBDATE,PBDATE,PEDATE,NPEST,
     &               APRATE(366),H2OSOL(366),DECAY(366,12),KOC(366),
     &               FOLFRC(366),SOLFRC(366),FOLRES(366),SOLRES(366,12),
     &               WSHFRC(366),   WSHTHR ,METH(366),TOTPST(366),
     &               FOLRSV(366),DEPINC(366),BETA(366),COFTRN(366),
     &               COFUP(366),METPST(366),DEGRAD(366,12),NEWPST(366),
     &               CHMWAT(366)
      COMMON /RESDUE/RES(366,5),RESD(366,12),SHFLIF(366,5)
      COMMON /NUTPST/BD(12),FC(12),CONV(12),FUL(12),SOLPOR(12),         tc
     &               BR15(12),OSW(12),SAT(12),OM(12),KD(366,12),        tc
     &               SOILMS(12),cknit(12)                               tc
      COMMON /c1c2/dk1(366,12),dk11(366,12),solc2p(366,12),             tc
     &             solc2(366,12),sedc2c(366),sedc2m(366),c2mon(366),    tc
     &             c2ann(366),c2acc(366),idelta,deltat,ic2flg           tc
      COMMON /PSTLIF/psthaf(366,12)
      COMMON /PSTVAR/ APDATE,HAFLIF,PSTNAM
      COMMON /FLAG  / FLGRES(366),NFLG
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
      COMMON /LAYERS/ NS, NOSOHZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,  swet
     &                BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      CHARACTER *16 PSTNAM(366)
      INTEGER FLGRES,APDATE(366),META(366),PSTPAS,PSTOUT,PBDATE,
     &        PEDATE,flgc2(366)                                         tc
      REAL KOC,HAFLIF(366)
      save
      WRITE (LUN10,1200)

C * * * READ PESTICIDE NAME AND METABOLITE FLAG
      DO 10 I=1,NPEST
         READ (LUN05,5000) PSTNAM(I), META(I), flgc2(i)                 tc
10    CONTINUE

C * * * FOR EACH PESTICIDE READ CONSTANT AND INITIAL VALUES
C * * * I = INDEX OF PARENT PESTICIDE
      I = 1
20    IF (I .LE. NPEST) THEN
         READ (LUN05,5101) H2OSOL(I), HAFLIF(I), KOC(I),
     &         FOLRES(I), WSHFRC(I), COFTRN(I), COFUP(I),               tc
     &         c1rd, c2rd                                               tc
         IF (COFUP(I) .GT. 1.0)  COFUP(I) = 1.0
         WRITE (LUN10,1201) I, PSTNAM(I), H2OSOL(I), HAFLIF(I),
     &         KOC(I), FOLRES(I), WSHFRC(I), COFTRN(I), COFUP(I)
         if (i + meta(i) .gt. npest) then
            write(*,2020) i
            write(lun10,2020) i
2020        format(' ERROR P1:  Parent plus Metabolites must be less',
     &             ' than NPEST.  Pesticide number: ',i2)
            stop
         endif
         READ (LUN05,5102) (SHFLIF(I,J),J=1,5), (RES(I,J),J=1,5)
         FLGRES(I) = 0
         LIF       = 0
         DO 30 J=1,NOSOHZ
            IF (SHFLIF(I,J) .GT. 0.0) LIF = LIF+1
            IF (RES(I,J) .GT. 0.0) FLGRES(I) = 1
 30      CONTINUE
         IF (LIF .LE. 1) THEN
            DO 35 J=1,NOSOHZ
               SHFLIF(I,J) = SHFLIF(I,1)
 35         CONTINUE
         ENDIF
c         WRITE(LUN10,1203) (J,SHFLIF(I,J),J=1,NOSOHZ)

C * * * SEE HOW MANY SOIL HALF LIVES AND RESIDUE BY HORIZON WERE READ

         IF (FLGRES(I) .GT. 0) WRITE(LUN10,1202) (J,RES(I,J),J=1,NOSOHZ)
         IF (FOLRES(I) .GT. 0.0) FLGRES(I) = 1                          FOLRES
C * * * IF ONLY ONE SOIL HALVE LIFE - USE IT FOR ALL LAYERS
         IF (LIF .LE. 1) THEN
            DO 40 J=1,NS
c               DECAY(I,J) = EXP(-0.693 / SHFLIF(I,1))                  tc
               DECAY(I,J) = 0.693 / SHFLIF(I,1)                         tc
               psthaf(i,j) = shflif(i,1)
 40         CONTINUE
         ELSE
C * * * ELSE SET HALF LIFE FOR EACH HORIZON
            NHZ=1
            AHORZ = BOTHRZ(NHZ) * 2.54
            DO 50 J=1,NS
               IF (BOTMET(J) .LE. AHORZ) THEN
                  THALF = SHFLIF(I,NHZ)
               ELSE
                  NHZ   = NHZ + 1
                  AHORZ = BOTHRZ(NHZ) * 2.54
                  THALF = SHFLIF(I,NHZ)
               ENDIF
c               DECAY(I,J) = EXP(-0.693 / THALF)                        tc
               DECAY(I,J) = 0.693 / THALF                               tc
               psthaf(i,j) = thalf
 50         CONTINUE
         ENDIF

C * * * IF ANY RESIDUE - DISTRIBUTE IT BY HORIZON
         IF (FLGRES(I) .GT. 0) THEN
            NHZ = 1
            AHORZ = BOTHRZ(NHZ) * 2.54
            DO 60 J=1,NS
               IF (BOTMET(J) .LE. AHORZ) THEN
                  RESD(I,J) = RES(I,NHZ)
               ELSE
                  NHZ       = NHZ + 1
                  AHORZ = BOTHRZ(NHZ) * 2.54
                  RESD(I,J) = RES(I,NHZ)
               ENDIF
 60         CONTINUE
         ENDIF
         IF (HAFLIF(I) .GT. 0.0) HAFLIF(I) = EXP(-0.693 / HAFLIF(I))
         IF (KOC(I) .LE. 0.0) KOC(I) = 0.01

c * * *  distribute c1rd and c2rd into computational layers             tc
         DO 70 J=1,NS                                                   tc
            c1 = c1rd                                                   tc
            c2 = c2rd                                                   tc
            if (flgc2(I) .eq. 0) then                                   tc
               c1 = 0.0                                                 tc
               c2 = 0.0                                                 tc
            else if (flgc2(i) .eq. 1) then                              tc
               if (om(j) .le. 0.0  .or.  c1 .le. 0.0) then              tc
                  c1 = 0.0                                              tc
                  c2 = 0.0                                              tc
               endif                                                    tc
            else if (flgc2(I) .eq. 2) then                              tc
               call calcks( DECAY(I,J), c1rd, c2rd, c1, c2 )            tc k,I,m
            endif                                                       tc
            dk1(I,J) = c1                                               tc
            if (om(j) .gt. 0.) then                                     tc
               dk11(I,J) = c2 * (om(1) / om(j))                         tc check
            else                                                        tc divide
               dk11(I,J) = 0.                                           tc by 0
            endif                                                       tc
70       CONTINUE                                                       tc


C * * * IF ANY METABOLITES - READ CONSTANT VALUES
C * * * I + II = INDEX OF CHILD PESTICIDE
         METPST(I) = META(I)
         IF (META(I) .GT. 0) THEN
            DO 80 II=1,META(I)
               READ (LUN05,5101) H2OSOL(I+II), HAFLIF(I+II), KOC(I+II),
     &               FOLRES(I+II), WSHFRC(I+II), COFTRN(I+II),
     &               COFUP(I+II),c1rd,c2rd                              tc
               IF (COFUP(I+II) .GT. 1.0) COFUP(I+II) = 1.0
               WRITE (LUN10,1201) I+II, PSTNAM(I+II), H2OSOL(I+II),
     &               HAFLIF(I+II), KOC(I+II), FOLRES(I+II),
     &               WSHFRC(I+II), COFTRN(I+II), COFUP(I+II)
               READ (LUN05,5102) (SHFLIF(I+ii,J),J=1,5),
     &                           (RES(I+ii,J),J=1,5)                    resdm
               FLGRES(I+ii) = 0                                         resdm
               LIF          = 0
               DO 90 J=1,NOSOHZ
                  IF (SHFLIF(I+II,J) .GT. 0.0) LIF = LIF+1
                  IF (RES(I+ii,J) .GT. 0.0) FLGRES(I+ii) = 1            resdm
 90            CONTINUE
               IF (LIF .LE. 1) THEN
                  DO 100 J=1,NOSOHZ
                     SHFLIF(I+II,J) = SHFLIF(I+II,1)
 100              CONTINUE
               ENDIF
c               WRITE(LUN10,1203) (J,SHFLIF(I+II,J),J=1,NOSOHZ)

C * * * SET METABOLITE SOIL HALF LIFE BY HORIZON
               IF (LIF .LE. 1) THEN
                  DO 110 J=1,NS
c                     DECAY(I+II,J) = EXP(-0.693 / SHFLIF(I+II,1))      tc
                     DECAY(I+II,J) = 0.693 / SHFLIF(I+II,1)             tc
                     psthaf(i+ii,j) = shflif(i+ii,1)
110               CONTINUE
               ELSE
                  NHZ=1
                  AHORZ = BOTHRZ(NHZ) * 2.54
                  DO 120 J=1,NS
                     IF (BOTMET(J) .LE. AHORZ) THEN
                        THALF = SHFLIF(I+II,NHZ)
                     ELSE
                        NHZ   = NHZ + 1
                        AHORZ = BOTHRZ(NHZ) * 2.54
                        THALF = SHFLIF(I+II,NHZ)
                     ENDIF
c                     DECAY(I+II,J) = EXP(-0.693 / THALF)               tc
                     DECAY(I+II,J) = 0.693 / THALF                      tc
                     psthaf(i+ii,j) = thalf
120               CONTINUE
               ENDIF

C * * * IF ANY RESIDUE - DISTRIBUTE IT BY HORIZON
c * * *   Also, set the residue flag on the parent
               IF (FLGRES(I+ii) .GT. 0) THEN
                  flgres(i) = 1
                  NHZ = 1
                  AHORZ = BOTHRZ(NHZ) * 2.54
                  DO 130 J=1,NS
                     IF (BOTMET(J) .LE. AHORZ) THEN
                        RESD(I+ii,J) = RES(I+ii,NHZ)
                     ELSE
                        NHZ   = NHZ + 1
                        AHORZ = BOTHRZ(NHZ) * 2.54
                        RESD(I+ii,J) = RES(I+ii,NHZ)
                     ENDIF
130               CONTINUE
               ENDIF

               IF (HAFLIF(I+II) .GT. 0.0)
     &               HAFLIF(I+II) = EXP(-0.693 / HAFLIF(I+II))
               IF (KOC(I+II) .LE. 0.0)  KOC(I+II) = 0.01
               METPST(I+II) = I * 366 + II                              366

c * * *  distribute c1rd and c2rd into computational layers             tc
               DO 140 J=1,NS                                            tc
                  c1 = c1rd                                             tc
                  c2 = c2rd                                             tc
                                                                        tc
c * * * k1 and k-1 set to zero per RAL.  If anyone wants to look at the
c * * *  labile and stable pest pools for metabolites, uncomment/comment
c * * *  the next lines.
c                  if (flgc2(I+ii) .eq. 0) then                          tc
c                     c1 = 0.0                                           tc
c                     c2 = 0.0                                           tc
c                  else if (flgc2(i+ii) .eq. 1) then                     tc
c                     if (om(j) .le. 0.0  .or.  c1 .le. 0.0) then        tc
c                        c1 = 0.0                                        tc
c                        c2 = 0.0                                        tc
c                     endif                                              tc
c                  else if (flgc2(I+ii) .eq. 2) then                     tc
c                     call calcks( DECAY(I+ii,J), c1rd, c2rd, c1, c2 )   tc k,I,m
c                  endif                                                 tc
c                  dk1(I+ii,J) = c1
c                  if (om(j) .gt. 0.) then
c                     dk11(I+ii,J) = c2 * (om(1) / om(j))                check
c                  else                                                  divide
c                     dk11(I+ii,J) = 0.                                  by 0
c                  endif
c
c              these 2 lines turn off the stable metabolite pest pool.  tc
                  dk1(I+ii,J) = 0.0                                     tc
                  dk11(I+ii,J) = 0.0                                    tc
140            CONTINUE                                                 tc

80          CONTINUE
            I = I + META(I)
         ENDIF
         I = I + 1
         GOTO 20
      ENDIF
      WRITE(LUN10,1210)
      RETURN
5000  FORMAT(8X,A16,2I8)
5101  FORMAT (8X,9F8.0)
5102  FORMAT (10F8.0)
1200  FORMAT(' PEST.  PESTICIDE        WATER   FOLIAR   KOC  ',
     1'   FOLIAR  WSHOFF  COEFF   COEFF',/'  NO.     NAME',
     1'            SOL.   HAFLIF             ',
     1'RES.  FRAC.   TRANS  UPTAKE',
     1/25X,'(PPM)   (DAYS)',11X,'(UG/G)')
1201  FORMAT(/I3,1X,A16,F10.2,F8.1,F10.1,F8.2,3F8.2)
1202  FORMAT(6X,'SOIL RESIDUE   (UG/G) ',5(I2,F 9.4))
1203  FORMAT(6X,'SOIL HALF-LIFE (DAYS) ',I2,F11.2,I2,F11.2,3(I2,F11.2))
1210  FORMAT(//)
       END


c                                                                       tc
c * * * calculate k's                                                   tc
c                                                                       tc
      subroutine calcks( k, I, m, k1, k11 )                             tc
      real k, I, m, k1, k11                                             tc
c                                                                       tc
c * * * equations from the Hamaker paper, page 242                      tc
c         given k, m, and I, calculate k1 and k11                       tc
c                                                                       tc
      R = (2. * I) / 100. - 1.                                          tc
      c = (R*R - 1.) * (m*m)  -  4. * m * k  -  4. * (k*k)              tc
      b = (-4. * (k*k)) / m   -   2. * (R*R + 1.) * k                   tc
      a = ((R*R - 1.) * (k*k)) / (m*m)                                  tc
      k11 = (-b + sqrt( b*b - 4.*a*c )) / (2. * a)                      tc
      k1  = -m - k - (1. + k/m) * k11                                   tc
      return                                                            tc
      end                                                               tc


      SUBROUTINE PESTIN(HBDATE,PEDATE,IROT)
      INTEGER BYR,PEDATE,HBDATE,DATE1,DATE2
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
      character *80 TDATA(366)
      save
      IF (IROT .LE. 0) THEN
         NCY   = 1
      ELSE
         NYR   = (PEDATE/1000)-(HBDATE/1000) + 1
         LDATE = 0
         IF (MOD(NYR,IROT) .GT. 0) THEN
            NCY = (NYR/IROT) + 1
         ELSE
            NCY = NYR/IROT
         ENDIF
      ENDIF
      BYR    = HBDATE/1000
      LYR    = BYR-IROT-1
      ICT    = 0
      irot1  = irot * 1000
      READ (LUN05,100) IYR,IDAY,I1
      BACKSPACE LUN05
      ifirst = IDAY + (lyr+IYR+irot)*1000
      iday   = 1
      DO 25 J=1,NCY
         LYR = LYR+IROT

c   while iday is not equal to zero read each application until the end of file

   26    continue
         if (Iday .ne. 0)  then
            READ (LUN05,100) IYR,IDAY,IPST
  100       FORMAT(I5,I3,I8)
            ICT = ICT + 1
            DATE1 = IDAY + ((IYR+LYR)*1000)
            IF (iday .eq. 0  .and.  irot .ne. 0) THEN
               DO 70 I=1,ICT
                  BACKSPACE LUN05
   70          CONTINUE
               ICT  = 0
               iday = 1
            ELSE if (iday .ne. 0) then
               DO 40 M=1,IPST
                  READ (LUN05,101) TDATA(M)
  101             FORMAT(a80)
                  ICT = ICT + 1
   40          CONTINUE
               READ (LUN05,100) I1,IDAY,I2
               backspace lun05
               if (iday .ne. 0) then
                  if (iday .eq. 1) then
                     i1  = (i1 - 1) + lyr
                     iday = i2kyr( i1 )                                 y2k
                  else
                     iday = iday - 1
                  endif
                  DATE2 = IDAY + ((I1+LYR)*1000)
               else
                  if (irot .le. 0 .or. j .eq. ncy) then
                     date2  = pedate
                  else
                     i1 = mod((ifirst + irot1), 1000)
                     if (i1 .eq. 1) then
                        i2 = (ifirst + irot1 - 1000) / 1000
                        date2 = i2 * 1000 + i2kyr( i2 )                 y2k
                     else
                        date2  = ifirst + irot1 - 1
                     endif
                     ifirst = ifirst + irot1
                  endif
               endif
               WRITE (LUN06,200) DATE1,DATE2,IPST
               DO 80 M=1,IPST
                  WRITE (LUN06,201) TDATA(M)
   80          CONTINUE
            ENDIF
            goto 26
         endif
         iday = 1
   25 CONTINUE
      LCARD = 0
      WRITE(LUN06,202) LCARD
      REWIND LUN06
  202 FORMAT(I16)
  200 FORMAT(3I8)
  201 FORMAT(a80)
      RETURN
      END

      SUBROUTINE INITNT
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &              LUN15,LUN16
CCC LUN04=NUTPAR; LUN09=NUTOUT
      COMMON /NUT/MANAP,MTYPE(366),JDAY,SOLN,SNO3(12),
     &            RATE(366),METAP(366),ICROP,SOILN(12),SOLNH,FERT,
     &            CLABP(12),ORGN(12),AMON(12),METFLG,ATN(366),ANH(366),
     &            DEPIN(366),APHOS(366),AOM(366),frtwat(366),VOLN,SOLP,
     &            PLAB(12),PMINP(12),POTMN(12),CNHKD(12),CPKD(12),
     &            SOILP(12),MFERT(366),CNO3(12),CNH4(12),BETA1,
     &            BETA2,ROOTW,RESDW,YIELD,TN(12),TP(12),ORGP(12),
     &            cPSP(3,12),CSOILP(12),CPMINP(12),fon(12),fop(12),
     &            resdn,resdp,resdue(12),resdwi,aporgn(366),
     &            aporgp(366),ano3(366),nwstyp(366),atsp(366),
     &            sorgp(12),rtn(12)
      COMMON /NUT2/NEWNT,RON,RONH,ROP,SEDN,SEDNH,SEDP,DRAIN,NL,PL,NHL,
     &             VOLTN,TAMO,F,FIXN,RCN,TOTRON,TOTROP,TOTNH,TOTSDN,
     &             TOTSDP,TOSDNH,TOTDRN,TOTNL,TVOL,APMN,AMO,TOTN,TOTP,
     &             RN,TOTDNI,MN,AMN,ARN,PMN,SDNI,TNL,TPL,TNHL,ITILL,
     &             NHVST,PUN,TFERTN,tfernh,TFERTP,YDN,YDP,aANO3,COLP,
     &             DK,DB(12),ADNI,PRED,UPN,UPP,taorgn,tawno3,tawnh4,
     &             taorgp,tawlp,acn,acp,afixn,burnn,burnp,cni,acni,rni,
     &             cpi,acpi,rpi
      COMMON /NUTPST/BD(12),FCC(12),CONV(12),FULL(12),SOLPOR(12),
     &               BRR15(12),OSW(12),SAT(12),OM(12),KD(366,12),
     &               SOILMS(12),cknit(12)
      COMMON /LAYERS/NS, NOSOHZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,   swet
     &               BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      COMMON /ORGMAT/HYDOM(12)
      COMMON /COMPUT/ CONVRF(12)
      COMMON /SOIL/ PH(12),CLAY(12),CACO3(12),BSAT(12),PSPp(12)
      COMMON /res/  Crbx(12),Crbrot(12),crbres,cnrres(12),cprres(12)
      common /nuts/ nBYR, nEYR, NUTOUT, FLGROT, NOCROP, ISOIL, flgbal
      COMMON /SWC/  WF(12)
      COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
      common /nutbal/tno3b,tnhb,tmnb,tsnb,tfnb,tonb,
     &               tno3e,tnhe,tmne,tsne,tfne,tone,
     &               trdnb,tsolnb,tsnhb,tawnb,tawnhb,
     &               aOTRON,aOTROP,aOTSDN,aOTSDP,aOTNL,aOTDNI,aOTAMO,
     &               aNL,aAMN,aPUN,aARN,tPMN,aNHL,aPL,aVOL,aPUP,afix,
     &               aaorgn,aawno3,aawnh4,aaorgp,aawlp,afertn,afernh,
     &               aydn,aydp,pltupn,pltupp,pltfxn,
     &               plabb,pminpb,soilpb,orgpb,fopb,sorgpb,
     &               plabe,pminpe,soilpe,orgpe,fope,sorgpe,
     &               trdpb,tsolpb,tawpb,afertp,
     &               aacni,aacpi
      common /fornut/bpltun,bpltup
      integer flgrot,flgbal
      REAL NL,NHL,MN
      real kd
      real treedm(50)
      DIMENSION SC(12)
c     DIMENSION CNIT(5),CAMON(5),CORGN(5),CPOTMN(5),CSOILN(5),          wkadd
      DIMENSION CNIT(5),CAMON(5),CORGN(5),CPOTMN(5),                    wkadd
     &          TOTALN(5),CLAB(5),CORGP(5),CMINP(5),TOTALP(5),
     &          CN(5),PWF(5),Carbrt(5),Cresn(5),Cresp(5),ctn(5),ctp(5)
      save
      data treedm /1000., 4000., 10000., 20000., 35000., 52500., 70000., leaf
     & 87500., 105000., 122500., 140000., 157500., 175000., 192500.,     leaf
     & 210000., 227500., 245000., 262500., 280000., 297500., 315000.,
     & 332500., 345000., 362500., 380000., 397500., 415000., 432500.,
     & 450000., 467500., 485000., 502500., 520000., 537500., 555000.,
     & 572500., 590000., 607500., 625000., 642500., 660000., 677500.,
     & 695000., 712500., 730000., 747500., 765000., 782500., 800000.,
     & 817500./
      DATA CN/15.0,10.0,7.0,5.0,3.0/
      DATA PWF/0.4,0.25,0.12,0.06,0.03/
      DATA A,B/0.5979,-0.17883/
      DO 10 K=1,NS
         SC(K) = HYDOM(K)/0.1724
         DK    = 24.0*(0.0011*SC(K)+0.0025)
         DB(K) = ALOG(DK)-2.4255
         CONVRF(K)= 10.0 / (BD(K) * DLAYM(K))
 10   CONTINUE
      READ(LUN04,4000) RESDW,RCN,cni,cpi
ccc resdwi initialized as resdw on date simulation begins, the model doesn't
ccc know what the resdwi was at date of harvest prior to beginning simulation.
      resdwi = resdw
CCC RESDW IS IN KG/HA
      WRITE(LUN09,9014) RESDW,RCN,cni,cpi
c   Residue on the surface (RESDW) is assumed to have c:n & c:p ratios
c   favorable for mineralization when simulation begins: cn=25; cp=200
      woodn = 0.0
      woodp = 0.0
      if (forest .gt. 0) then
         if (nyrfor .eq. 0) then
            wtwood = 0.
            olddm = 0.0
         else
            wtwood = treedm(nyrfor) * 0.80
            olddm = wtwood
         endif
         woodn = wtwood * .58 / 330.
         woodp = woodn / 4.5
         if (resdw .eq. 0.0) then
            if (nyrfor .ge. 2) then
               resdw = (treedm(nyrfor) - treedm(nyrfor-1)) * 0.20
            else
               resdw = treedm(nyrfor) * 0.20
            endif
         endif
      endif
      bpltun = woodn
      bpltup = woodp
      crbres = resdw * .58
      resdn = resdw / 1.724 / 25.0
      resdp = resdw / 1.724 / 200.0
      cnres = 25.0
      cpres = 200.0
c  calculate phosphorous sorption coefficient BASE
      do 17 k=1,ns
         GO TO (1,2,3) ISOIL
1        cPSP(1,K)=0.58-0.0061*CACO3(K)
            GO TO 4
c2        cPSP(2,K)=0.0043*BSAT(k)+0.11*PH(K)-0.70
2        cPSP(2,K)=0.0054*BSAT(k)+0.116*PH(K)-0.73
            GO TO 4
c3        cPSP(3,K)=0.39-0.047*ALOG(CLAY(K)-0.03074*hydom(K))
3        cPSP(3,K)=0.46-0.0916*ALOG(CLAY(K))
4        continue
17    CONTINUE

c       soilms is megagrams per hectare
c
c        %
c       --- * soilms * 1000.    ==   %  *  soilms  *  10.
c       100

c               kg         1                      mg
c       ppm =  ----  *  ------  *  1000.     ==  ----   , which is ppm
c               ha      soilms                    kg


      READ(LUN04,4000) (CTN(J),J=1,NOSOHZ)
c * * * ctn is in percent
      READ(LUN04,4000) (CNIT(J),J=1,NOSOHZ)
c * * * cnit is mg/kg
      READ(LUN04,4000) (CPOTMN(J),J=1,NOSOHZ)
c * * * cpotmn is kg/ha
      READ(LUN04,4000) (CORGN(J),J=1,NOSOHZ)
c * * * corgn is in percent
      READ(LUN04,4000) (CTP(J),J=1,NOSOHZ)
c * * * ctp is in percent
      READ(LUN04,4000) (CLAB(J),J=1,NOSOHZ)
c * * * clab is mg/kg
      READ(LUN04,4000) (CORGP(J),J=1,NOSOHZ)
c * * * corgp is in percent

      corgn(1) = corgn(1) * soilms(1) * 10.0
      corgp(1) = corgp(1) * soilms(1) * 10.0
c * * * corgn & corgp are now in kg/ha

      if (clab(1) .le. 0.0) then
         if (isoil .lt. 2) then
            fac  = 0.10
c            pfac = 0.0
         else if (isoil .gt. 2) then
            fac  = 0.056
c            pfac = 0.0045
         else
            fac  = 0.087
c            pfac = 0.0034
         endif
      endif

      NHZ=1
      AHORZ = BOTHRZ(NHZ) * 2.54
      thorz = ahorz
      DO 140 J=1,NS
         IF (BOTMET(J) .gt. AHORZ) THEN
            NHZ   = NHZ + 1
            AHORZ = BOTHRZ(NHZ) * 2.54
            thorz = (bothrz(nhz) - bothrz(nhz-1)) * 2.54
         ENDIF
         dist = dlaym(j) / thorz
         if (ctn(nhz) .le. 0.0) then
            tn(j)  = 0.10 * hydom(j) / 1.724
         else
            tn(j)  = ctn(nhz)
         endif
         if (cnit(nhz) .gt. 0.0) then
            CNO3(J)   = CNIT(NHZ)
         else
            cno3(j)   = 5.
         endif
         SNO3(J)   = CNO3(J)*SOILMS(J)/1000.
         CNH4(j)   = 2.
         AMON(j)   = CNH4(j)*SOILMS(j)/1000.
         if (cpotmn(nhz) .le. 0.0) then
            potmn(j) = tn(j) * 0.17 * soilms(j) * 10.
         else
            POTMN(J)  = CPOTMN(NHZ) * dist
         endif
         fon(j)    = 40. * wf(j)
         fop(j)    = 10. * wf(j)
         crbrot(j) = fon(j) * 25.
         crbx(j)   = crbrot(j) / 0.8
         resdue(j) = crbrot(j) * 1.724
         orgn(j)   = corgn(nhz) * dist
         orgp(j)   = corgp(nhz) * dist
         if (nhz .eq. 1) then
            sorgp(j) = 44.4 + 1130. * tn(j)
         else
            sorgp(j) = 1464. * tn(j)
         endif
         sorgp(j)  = sorgp(j) * soilms(j) / 1000.
         soiln(j)  = (tn(j) * soilms(j) * 10.) - amon(j) - potmn(j) -
     &               fon(j) - orgn(j)
         rtn(j) = potmn(j) / (tn(j) * soilms(j) * 10.)
         if (clab(nhz) .le. 0.0) then
            clabp(j)  = sorgp(j) / soilms(j) * 1000. * fac
         else
            clabp(j)  = clab(nhz)
         endif
         plab(j)   = clabp(j) * soilms(j) / 1000.
         tp(j)     = ctp(nhz)
         if (tp(j) .le. 0.0) then
c            anum     = cpsp(isoil,j) + pfac * clabp(j)
            anum     = cpsp(isoil,j)
            pminp(j) = plab(j) / (anum / (1. - anum))
            tp(j)    = sorgp(j)+orgp(j)+ plab(j) + fop(j) + 5.*pminp(j)
c * * *     tp is in kg/ha
            tp(j)    = tp(j) / (soilms(j) * 10.)
c * * *     tp is in %
         else
            pminp(j) = ((tp(j) * soilms(j) * 10.) - sorgp(j) - orgp(j) -
     &                  plab(j) - fop(j)) * 0.2
         endif
         soilp(j) = 4. * pminp(j)
140   continue

      WRITE(LUN09,9000) (I,TN(I),I=1,NS)                                %
      WRITE(LUN09,9001) (I,SNO3(I),I=1,NS)                              kg/ha
      WRITE(LUN09,9002) (I,CNO3(I),I=1,NS)                              mg/kg
      WRITE(LUN09,9003) (I,AMON(I),I=1,NS)                              kg/ha
      WRITE(LUN09,9004) (I,CNH4(I),I=1,NS)                              mg/kg
      WRITE(LUN09,9005) (I,ORGN(I),I=1,NS)                              kg/ha
      WRITE(LUN09,9006) (I,POTMN(I),I=1,NS)                             kg/ha
      WRITE(LUN09,9007) (I,SOILN(I),I=1,NS)                             kg/ha
      WRITE(LUN09,9008) (I,TP(I),I=1,NS)                                %
      WRITE(LUN09,9009) (I,PLAB(I),I=1,NS)                              kg/ha
      WRITE(LUN09,9010) (I,CLABP(I),I=1,NS)                             mg/kg
      WRITE(LUN09,9011) (I,ORGP(I),I=1,NS)                              kg/ha
      WRITE(LUN09,9012) (I,sorgp(I),I=1,NS)                             kg/ha
      WRITE(LUN09,9022) (I,PMINP(I),I=1,NS)                             kg/ha
      WRITE(LUN09,9013) (I,SOILP(I),I=1,NS)                             kg/ha
      DO 40 J=1,NS
         CPKD(J)  = 100. + (CLAY(j)*2.5)
         CNHKD(J) = 1.34 + (CLAY(j)*0.083)
40    CONTINUE
CCC CALCULATE BETA COEFFICIENTS
CCC BETA1 = EXTRACTION COEFFICIENT FOR AMMONIA
CCC BETA2 = EXTRACTION COEFFICIENT FOR PHOSPHORUS
      BETA1 = A * EXP(B*CNHKD(1))
      IF (CNHKD(1) .GT. 1.0) THEN
         GO TO 50
      ELSE
         BETA1 = 0.500
      ENDIF
      GO TO 60
50    IF (CNHKD(1) .LT. 10.) THEN
         GO TO 60
      ELSE
         BETA1 = 0.10
      ENDIF
60    CONTINUE
      BETA2 = A * EXP(B*CPKD(1))
      IF (CPKD(1) .GT. 1.0) THEN
         GO TO 70
      ELSE
         BETA2 = 0.500
      ENDIF
      GO TO 80
70    IF (CPKD(1) .LT. 10.) THEN
         GO TO 80
      ELSE
         BETA2 = 0.100
      ENDIF
80    CONTINUE
      WRITE(LUN09,9015) BETA1,BETA2
      WRITE(LUN09,9016) (I,CNHKD(I),I=1,NS)
      WRITE(LUN09,9017) (I,CPKD(I),I=1,NS)
      WRITE(LUN09,9018) (I,CLAY(I),I=1,NS)
      WRITE(LUN09,9019) (I,PH(I),I=1,NS)
      WRITE(LUN09,9020) (I,bsat(I),I=1,NS)                              ???
      WRITE(LUN09,9021) (I,CACO3(I),I=1,NS)
      tno3b  = 0.0
      tnhb   = 0.0
      tmnb   = 0.0
      tsnb   = 0.0
      tfnb   = 0.0
      tonb   = 0.0
      plabb  = 0.0
      pminpb = 0.0
      soilpb = 0.0
      orgpb  = 0.0
      fopb   = 0.0
      sorgpb = 0.0
      do 90 i=1,ns

c * * *  check the nitrogen initialization for underflow
         if (tn(i) .lt. 0.0 .or. sno3(i) .lt. 0.0 .or. amon(i) .lt. 0.0
     &       .or. potmn(i) .lt. 0.0 .or. fon(i) .lt. 0.0 .or.
     &       resdue(i) .lt. 0.0 .or. orgn(i) .lt. 0.0 .or. soiln(i) .lt.
     &       0.0) then
            write(*,7000)
            write(lun09,7000)
            stop
         endif

c * * *  check the phosphorus initialization for underflow
         if (plab(i) .lt. 0.0 .or. pminp(i) .lt. 0.0 .or. soilp(i) .lt.
     &       0.0 .or. orgp(i) .lt. 0.0 .or. fop(i) .lt. 0.0 .or.
     &       sorgp(i) .lt. 0.0) then
            write(*,7001)
            write(lun09,7001)
            stop
         endif

         ck = soilms(i) * 1000.0
c * * *  check the nitrogen initialization for overflow, ck is soil in kg/ha
         if (tn(i) .ge. ck .or. sno3(i) .ge. ck .or. amon(i) .ge. ck
     &       .or. potmn(i) .ge. ck .or. fon(i) .ge. ck .or.
     &       resdue(i) .ge. ck .or. orgn(i) .ge. ck .or. soiln(i) .ge.
     &       ck) then
            write(*,7002)
            write(lun09,7002)
            stop
         endif

c * * *  check the phosphorus initialization for overflow
         if (plab(i) .ge. ck .or. pminp(i) .ge. ck .or. soilp(i) .ge.
     &       ck .or. orgp(i) .ge. ck .or. fop(i) .ge. ck .or.
     &       sorgp(i) .ge. ck) then
            write(*,7003)
            write(lun09,7003)
            stop
         endif

         tno3b  = tno3b  + sno3(i)
         tnhb   = tnhb   + amon(i)
         tmnb   = tmnb   + potmn(i)
         tsnb   = tsnb   + soiln(i)
         tfnb   = tfnb   + fon(i)
         tonb   = tonb   + orgn(i)
         plabb  = plabb  + plab(i)
         pminpb = pminpb + pminp(i)
         soilpb = soilpb + soilp(i)
         orgpb  = orgpb  + orgp(i)
         fopb   = fopb   + fop(i)
         sorgpb = sorgpb + sorgp(i)
90    continue
      trdnb  = resdn
      trdpb  = resdp
      tsolnb = soln
      tsnhb  = solnh
      tsolnb = 0.0
      tawnb  = 0.0
      tawnhb = 0.0
      acn    = 0.0
      acp    = 0.0
      totn   = woodn
      totp   = woodp
      acni   = 0.0
      acpi   = 0.0
      afixn  = 0.0
      pltupn = 0.0
      pltupp = 0.0
      pltfxn = 0.0
4000  FORMAT(10F8.0)
7000  FORMAT(' ERROR N1: Underflow in Nitrogen initialization')
7001  FORMAT(' ERROR N2: Underflow in Phosphorus initialization')
7002  FORMAT(' ERROR N3: Overflow in Nitrogen initialization')
7003  FORMAT(' ERROR N4: Overflow in Phosphorus initialization')
9000  FORMAT(//' NITROGEN'/'   TOTAL NITROGEN (percent)'/12(I2,F8.2))
9001  FORMAT(/'   NITRATE (KG/HA)'/,12(I2,F8.2))
9002  FORMAT(/'   NITRATE (MG/KG)'/,12(I2,F8.2))
9003  FORMAT(/'   AMMONIA (KG/HA)'/,12(I2,F8.2))
9004  FORMAT(/'   AMMONIA (MG/KG)'/,12(I2,F8.2))
9005  FORMAT(/'   ORGANIC NITROGEN (KG/HA)'/,12(I2,F8.2))
9006  FORMAT(/'   POTENTIAL MINERALIZABLE NITROGEN (KG/HA)'/,
     &       12(I2,F8.2))
9007  FORMAT(/'   SOIL NITROGEN (KG/HA)'/,12(I2,F8.2))
9008  FORMAT(//' PHOSPHORUS'/'   TOTAL PHOSPHORUS (percent)'/,
     &       12(I2,F8.2))
9009  FORMAT(/'   LABILE PHOSPHORUS (KG/HA)'/,12(I2,F8.2))
9010  FORMAT(/'   LABILE PHOSPHORUS (MG/KG)'/,12(I2,F8.2))
9011  FORMAT(/'   ORGANIC PHOSPHORUS (KG/HA)'/,12(I2,F8.2))
9012  FORMAT(/'   MINERALIZABLE ORGANIC PHOSPHORUS (KG/HA)'/,
     &       12(I2,F8.2))
9022  FORMAT(/'   ACTIVE MINERAL PHOSPHORUS (KG/HA)'/,12(I2,F8.2))
9013  FORMAT(/'   STABLE MINERAL PHOSPHORUS (KG/HA)'/,12(I2,F8.2))
9014  FORMAT(/'   SURFACE RESIDUE ',F8.2,' (KG/HA)'/
     &        '   RAINFALL NITROGEN ',F6.2,' PPM'/
     &        '   IRRIGATION NITROGEN ',F6.2,' PPM'/
     &        '   IRRIGATION PHOSPHORUS ',F6.2,' PPM')
9015  FORMAT(/' EXTRACTION COEFFICIENT FOR AMMONIA    =',F8.4,/
     &        ' EXTRACTION COEFFICIENT FOR PHOSPHORUS =',F8.4)
9016  FORMAT(/' ADSORPTION COEFFICIENT FOR AMMONIA'/,12(I2,F8.2))
9017  FORMAT(/' ADSORPTION COEFFICIENT FOR PHOSPHORUS'/,12(I2,F8.2))
9018  FORMAT(/' CLAY CONTENT, PERCENT'/,12(I2,F8.2))
9019  FORMAT(/' PH '/,12(I2,F8.2))
9020  FORMAT(/' BASE SATURATION, PERCENT'/,12(I2,F8.2))
9021  FORMAT(/' CALCIUM CARBONATE, PERCENT '/,12(I2,F8.2))
      RETURN
      END
      subroutine varin( varble, mising )
      COMMON /LAYERS/ NS, NOSOHZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,  swet
     &                BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &              LUN15,LUN16
      real varble(5)
      integer mising(5)
      character *8 parms(5)
      save
      READ (LUN04,4000) (parms(J),J=1,NOSOHZ)
      backspace LUN04
      READ (LUN04,4001) (varble(J),J=1,NOSOHZ)
      do 10 j=1, nosohz
         if (parms(j) .eq. '       ') then
            mising(j) = 1
         else
            mising(j) = 0
         endif
10    continue
      return
4000  FORMAT(10a8)
4001  FORMAT(10F8.0)
      end
      SUBROUTINE ININUT
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
CCC  LUN04=NUTPAR; LUN09=NUTOUT;               LUN16=DUMMY
      COMMON /NUT/MANAP,MTYPE(366),JDAY,SOLN,SNO3(12),
     &            RATE(366),METAP(366),ICROP,SOILN(12),SOLNH,FERT,
     &            CLABP(12),ORGN(12),AMON(12),METFLG,ATN(366),ANH(366),
     &            DEPIN(366),APHOS(366),AOM(366),frtwat(366),VOLN,SOLP,
     &            PLAB(12),PMINP(12),POTMN(12),CNHKD(12),CPKD(12),
     &            SOILP(12),MFERT(366),CNO3(12),CNH4(12),BETA1,
     &            BETA2,ROOTW,RESDW,YIELD,TN(12),TP(12),ORGP(12),
     &            cPSP(3,12),CSOILP(12),CPMINP(12),fon(12),fop(12),
     &            resdn,resdp,resdue(12),resdwi,aporgn(366),
     &            aporgp(366),ano3(366),nwstyp(366),atsp(366),
     &            sorgp(12),rtn(12)
      COMMON /NUT2/NEWNT,RON,RONH,ROP,SEDN,SEDNH,SEDP,DRAIN,NL,PL,NHL,
     &             VOLTN,TAMO,F,FIXN,RCN,TOTRON,TOTROP,TOTNH,TOTSDN,
     &             TOTSDP,TOSDNH,TOTDRN,TOTNL,TVOL,APMN,AMO,TOTN,TOTP,
     &             RN,TOTDNI,MN,AMN,ARN,PMN,SDNI,TNL,TPL,TNHL,ITILL,
     &             NHVST,PUN,TFERTN,tfernh,TFERTP,YDN,YDP,aANO3,COLP,
     &             DK,DB(12),ADNI,PRED,UPN,UPP,taorgn,tawno3,tawnh4,
     &             taorgp,tawlp,acn,acp,afixn,burnn,burnp,cni,acni,rni,
     &             cpi,acpi,rpi
      common /nuts/nBYR, nEYR, NUTOUT, FLGROT, NOCROP, ISOIL, flgbal
      COMMON /HEAD4/TITLE4
      COMMON /chit/surn,surp,ochit(12),frchit(12),surhit,suroc,sshtnh,  wkakk
     &              ichit
      common /nutbal/tno3b,tnhb,tmnb,tsnb,tfnb,tonb,
     &               tno3e,tnhe,tmne,tsne,tfne,tone,
     &               trdnb,tsolnb,tsnhb,tawnb,tawnhb,
     &               aOTRON,aOTROP,aOTSDN,aOTSDP,aOTNL,aOTDNI,aOTAMO,
     &               aNL,aAMN,aPUN,aARN,tPMN,aNHL,aPL,aVOL,aPUP,afix,
     &               aaorgn,aawno3,aawnh4,aaorgp,aawlp,afertn,afernh,
     &               aydn,aydp,pltupn,pltupp,pltfxn,
     &               plabb,pminpb,soilpb,orgpb,fopb,sorgpb,
     &               plabe,pminpe,soilpe,orgpe,fope,sorgpe,
     &               trdpb,tsolpb,tawpb,afertp,
     &               aacni,aacpi
      common /nutbck/h2ocno,h2ocnh,h2oclp,
     &               arnm,ffnm,ffnhm,ffpm,awno3m,awnhm,awonm,awlpm,
     &               awopm,ronm,ronhm,ropm,sednhm,sedlpm,sednm,sedpm,
     &               bnlm,bnhlm,bplm,volnm,dnim,upnm,uppm,fixnm,
     &               arny,fertny,fernhy,fertpy,awno3y,awnhy,awony,
     &               awlpy,awopy,rony,ronhy,ronp,sednhy,sedlpy,sedny,
     &               sedpy,tnly,amonly,ply,volny,dnia,puna,pupa,fixny
      common /volnh/ incd
      common /testn/ tupn, tupp, demn, demp, dmn1, dmn2
      CHARACTER *80 TITLE4(3)
      INTEGER FLGNUT,LDATE(10),APDATE(10),flgrot,flgbal
      REAL NL,NHL,MN
      dimension pbal(12)
      save
      surn  = 0.0
      surnh = 0.0
      surp  = 0.0
      sshtnh = 0.0
      WRITE (LUN09,4001)
      DO 10 I=1,3
         READ (LUN04,4000) TITLE4(I)
         WRITE(LUN09,9000) TITLE4(I)
10    CONTINUE
c      READ(LUN04,4002)NBYR,NEYR,NUTOUT,FLGROT,flgbal                   y2k
      READ(LUN04,4003)nbcen,NBYR,necen,NEYR,NUTOUT,FLGROT,flgbal        y2k
      iy2k = 0                                                          y2k
      if (nbcen .le. 0) then                                            y2k
         nbcen = 19                                                     y2k
         iy2k = 1                                                       y2k
      endif                                                             y2k
      if (necen .le. 0) then                                            y2k
         necen = 19                                                     y2k
         if (neyr .lt. nbyr) necen = 20                                 y2k
         iy2k = 1                                                       y2k
      endif                                                             y2k
      nbyr = nbcen * 100 + nbyr                                         y2k
      neyr = necen * 100 + neyr                                         y2k
      if (iy2k .ne. 0) then                                             y2k
         WRITE(LUN09,9001) nbyr,neyr                                    y2k
         WRITE(*,9001) nbyr,neyr                                        y2k
      endif                                                             y2k

      DO 20 I=1,366
         RATE(I)  = 0.0
         ATN(I)   = 0.0
         ANH(I)   = 0.0
         DEPIN(I) = 0.0
         APHOS(I) = 0.0
         AOM(I)   = 0.0
20    CONTINUE
      DO 30 J=1,12
         SNO3(J)   = 0.0
         SOILN(J)  = 0.0
         CLABP(J)  = 0.0
         ORGN(J)   = 0.0
         AMON(J)   = 0.0
         ORGP(J)   = 0.0
         PLAB(J)   = 0.0
         sorgp(j)  = 0.0
         PMINP(J)  = 0.0
         POTMN(J)  = 0.0
         SOILP(J)  = 0.0
         CNO3(J)   = 0.0
         CNH4(J)   = 0.0
         TN(J)     = 0.0
         TP(J)     = 0.0
         ochit(j)  = 0.0
         frchit(j) = 0.0
30    CONTINUE
      VOLN   = 0.0
      SOLN   = 0.0
      SOLP   = 0.0
      SOLNH  = 0.0
      ROOTW  = 0.0
      RESDW  = 0.0
      YIELD  = 0.0
      ydn    = 0.0
      ydp    = 0.0
c      totn   = 0.0
c      totp   = 0.0
      fixn   = 0.0
      taorgn = 0.0
      tawno3 = 0.0
      tawnh4 = 0.0
      taorgp = 0.0
      tawlp  = 0.0
      tsolpb = solp
      tawpb  = surp
      MOTRON = 0.0
      MOTROP = 0.0
      MOTSDN = 0.0
      MOTSDP = 0.0
      MOTNL  = 0.0
      MOTDNI = 0.0
      MTNL   = 0.0
      MAMN   = 0.0
      MPUN   = 0.0
      MARN   = 0.0
      MOTPMN = 0.0
      MOTPUP = 0.0
      MOTNHL = 0.0
      MOTPL  = 0.0
      MOTVOL = 0.0
      MOTAMO = 0.0
      mfixn  = 0.0
      burnn  = 0.0
      burnp  = 0.0
      incd   = 0
      dmn1   = 0.0
      dmn2   = 0.0
      CALL INITNT
      CALL UPDNUT
      RETURN
4000  FORMAT(A80)
4001  FORMAT(//,12X,'G L E A M S  NONPOINT SOURCE POLLUTION ',
     &               'MODEL (NUTRIENTS)',/,
     &           23X,'VERSION 3.0   MAY 1, 1999   TIFTON GA',//)
4002  FORMAT(10I8)                                                      y2k
4003  FORMAT(2(i6,i2),8I8)                                              y2k
9000  FORMAT(1X,A80)
9001  FORMAT(/,' *** Y2K COMPLIANCE: 2 DIGIT YEAR READ. *** ',/,        y2k
     &         '    NUTRIENT BEGIN YEAR = ',i5,/,                       y2k
     &         '    NUTRIENT END YEAR   = ',i5/)                        y2k
      END
