c$DEBUG
C * * *  ENDDMY  GIVEN DAY OF YEAR AND YEAR RETURN A CODE (IEOMY) FOR
C * * *          END OF DAY    IEOMY = 1
C * * *          END OF MONTH  IEOMY = 2
C * * *          END OF YEAR   IEOMY = 3
      SUBROUTINE ENDDMY( IDAY )
      COMMON /GDATES/ NMONTH, NYEAR, IEOMY
      INTEGER   IMONTH(12,2), IDAY, J
      save
      DATA IMONTH/31,59,90, 120, 151, 181, 212, 243, 273, 304, 334, 365,
     &            31,60,91, 121, 152, 182, 213, 244, 274, 305, 335, 366/
      IF (i2kyr( nyear ) .EQ. 366) THEN                                 y2k
         LEAP = 2
      ELSE
         LEAP = 1
      ENDIF
      IEOMY = 1
      DO 10 J=1,12
         IF (IDAY .EQ. IMONTH(J, LEAP)) THEN
            IEOMY = 2
            IF (J .EQ. 12) IEOMY = 3
         ENDIF
         IF (IDAY .LE. IMONTH(J, LEAP)) THEN
            NMONTH = J
            GOTO 20
         ENDIF
10    CONTINUE
20    CONTINUE
      RETURN
      END

      SUBROUTINE GETTMP
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &              LUN15,LUN16
      COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &               VERMNT,BCKEND,flgpen
      COMMON /ONEVAR/ACT(2),AT(2),BT(2),B0,B1,B2,wind1,wind2,wind3,
     &               dew1,dew2,dew3
      COMMON /VMTVAR/VACT,VAT,VBT,VB0,VB1,VB2
      COMMON /FREEZE/ IFZBEG,IFZEND,NFRZ,NFZDAY
      COMMON /BCKTMP/ TMPMIN(12),TMPMAX(12),TMPAVG(12),dewpt(12)
      REAL A(12,2),V(12)
      INTEGER HBDATE,HYDOUT,FLGNUT,FLGPST,FLGGEN,FLGMET,VERMNT,BCKEND
      integer flgpen
      save
      NFRZ   =0
      READ (LUN02,2000) (TMPMAX(I),I=1,12)
      READ (LUN02,2000) (TMPMIN(I),I=1,12)
      IF (FLGMET .EQ. 0) THEN
          DO 10 I=1,12
              TMPMAX(I) =(TMPMAX(I)-32.0)*5.0/9.0
              TMPMIN(I) =(TMPMIN(I)-32.0)*5.0/9.0
  10      CONTINUE
      ENDIF
      CALL FORFIT(12,TMPMIN,ACT(1),AT(1),BT(1))
      CALL FORFIT(12,TMPMAX,ACT(2),AT(2),BT(2))
      IF (FLGMET .EQ. 0) THEN
         DO 20 I=1,12
            A(I,1) =32.0+FORFUN(ACT(1),AT(1),BT(1),I,12)*9.0/5.0
            A(I,2) =32.0+FORFUN(ACT(2),AT(2),BT(2),I,12)*9.0/5.0
  20     CONTINUE
         FRZTMP = 32.0
      ELSE IF (FLGMET .EQ. 1) THEN
         DO 30 I=1,12
            A(I,1) = FORFUN(ACT(1),AT(1),BT(1),I,12)
            A(I,2) = FORFUN(ACT(2),AT(2),BT(2),I,12)
  30     CONTINUE
         FRZTMP = 0.0
      ENDIF
      DO 40 I=1,12
         TMPAVG(I) =(A(I,1)+A(I,2))/2.0
         IF (TMPAVG(I) .GE. FRZTMP) GO TO 40
             NFRZ   =1
             GO TO 50
  40  CONTINUE
  50  CONTINUE

      IF (FLGMET .EQ. 0) THEN
         WRITE(LUN07,3001)
         WRITE(LUN07,3000) (A(I,1),I=1,12)
         WRITE(LUN07,3002)
         WRITE(LUN07,3000) (A(I,2),I=1,12)
      ELSE
         WRITE(LUN07,4001)
         WRITE(LUN07,3000) (A(I,1),I=1,12)
         WRITE(LUN07,4002)
         WRITE(LUN07,3000) (A(I,2),I=1,12)
      ENDIF
      RETURN
2000  FORMAT(10F8.0)
3000  FORMAT(3X,6F12.2)
3001  FORMAT(/,18X,    'MONTHLY MEAN MINIMUM TEMPERATURES, DEGREES FAHRE
     1NHEIT')
3002  FORMAT(/,18X,    'MONTHLY MEAN MAXIMUM TEMPERATURES, DEGREES FAHRE
     1NHEIT')
4001  FORMAT(/,18X,    'MONTHLY MEAN MINIMUM TEMPERATURES, DEGREES CENTI
     1GRADE')
4002  FORMAT(/,18X,    'MONTHLY MEAN MAXIMUM TEMPERATURES, DEGREES CENTI
     1GRADE')
      END

      SUBROUTINE GETdew
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &              LUN15,LUN16
      COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &               VERMNT,BCKEND,flgpen
      COMMON /ONEVAR/ACT(2),AT(2),BT(2),B0,B1,B2,wind1,wind2,wind3,
     &               dew1,dew2,dew3
      COMMON /BCKTMP/ TMPMIN(12),TMPMAX(12),TMPAVG(12),dewpt(12)
      real d(12)
      INTEGER HBDATE,HYDOUT,FLGNUT,FLGPST,FLGGEN,FLGMET,VERMNT,BCKEND
      INTEGER flgpen
      save
      read (lun02,2000) (dewpt(i),i=1,12)
      if (flgpen .gt. 0) then
         if (flgmet .eq. 0) then
             do 10 i=1,12
                 dewpt(i) = (dewpt(i) - 32.0) *  5.0 / 9.0
10           continue
         endif
         call forfit( 12, dewpt, dew1, dew2, dew3 )
         if (flgmet .eq. 0) then
            do 20 i=1,12
               d(i) = 32.0 + forfun( dew1, dew2, dew3, i, 12) * 9.0 / 5.0
20          continue
         else if (flgmet .eq. 1) then
            do 30 i=1,12
               d(i) = forfun( dew1, dew2, dew3, i, 12 )
30          continue
         endif

         if (flgmet .eq. 0) then
            write(lun07,3001)
         else
            write(lun07,4001)
         endif
         write(lun07,3000) (d(i),i=1,12)
      endif
      RETURN
2000  FORMAT(10F8.0)
3000  FORMAT(3X,6F12.2)
3001  FORMAT(/,18X,    'MONTHLY MEAN DEW POINT TEMPERATURES, DEGREES FAH
     1RENHEIT')
4001  FORMAT(/,18X,    'MONTHLY MEAN DEW POINT TEMPERATURES, DEGREES CEN
     1TIGRADE')
      END

      SUBROUTINE FORFIT(M,D,AC,A,B)
      REAL D(12)
      save
      PI   = 3.1415926536
      SUMD = 0.0
      AM   = M
      DO 10 I=1,M
         SUMD = SUMD+D(I)
  10  CONTINUE
      AC   = SUMD/AM
      AN   = 1.0
      SUMA = 0.0
      SUMB = 0.0
      DO 20 I=1,M
          TI   = FLOAT(I)-0.5
          TH   = 2.0*PI*AN*TI
          FCOS = COS(TH/AM)
          FSIN = SIN(TH/AM)
          SUMA = SUMA+D(I)*FCOS
          SUMB = SUMB+D(I)*FSIN
20    CONTINUE
      A    = 2.0 / AM * SUMA
      B    = 2.0 / AM * SUMB
      RETURN
      END
      FUNCTION FORFUN(AC,A,B,I,N)
      AI     = FLOAT(I)-0.5
      AN     = FLOAT(N)
      ANG    = 6.283185*AI/AN
      FORFUN = AC+A*COS(ANG)+B*SIN(ANG)
      RETURN
      END

      SUBROUTINE GETLAI
      COMMON /BOTH/ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1             R(366),ALONE,REFF,TMEAN(366), potlai(366),
     1             icindx(366),sumlai,acclai,aideal,sfn,
     1             iccrd(366),ioldcp,cdelta(366),chone,wind(366)
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &              LUN15,LUN16
      COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
      INTEGER FOREST, BEGGRO, ENDGRO                                    FOREST
      REAL INTCEP,INTM,INTY,INTET,INTETM,INTETY                         FOREST
      save
c      READ (LUN02,2000) GR, BEGGRO, ENDGRO
c      if (forest .eq. 3) READ (LUN02,2000) BEGGRO, ENDGRO
      CALL LAIONE
c      WRITE (LUN07,3000) GR,TLA
      RETURN
c2000   FORMAT(F8.0,2I8)                                                FOREST
2000  FORMAT(2I8)                                                       FOREST
3000  FORMAT(/,28X,'WINTER C FACTOR  = ',F7.2,/,
     1         28X,'LAI-DAYS         = ',F7.2)
      END

      SUBROUTINE rdlai( irotyr )
      COMMON /IRRIG/IDAY,NOIRR(366), balone(50),begsum, dirr(366),
     &              chtone(50)
      COMMON /IRR/ BASEI(366),TOPI(366),bsi,tpi
      COMMON /BOTH/ ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1              R(366),ALONE,REFF,TMEAN(366), potlai(366),
     1              icindx(366),sumlai,acclai,aideal,sfn,
     1              iccrd(366),ioldcp,cdelta(366),chone,wind(366)
      COMMON /PNUT/ DF(366),FP(20),FN(20),DEMERG,DHRVST,YP(90),DMY(90),
     &              NF,FNH(20),C1(90),C2(90),LEG(90),CNR(90),RNP(90),
     &              pernnl(90), ibegro(366), iendro(366)
      COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &              LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &              LUN15,LUN16
      common /rotate/ ibyr, ieyr, irot
      integer df, pernnl, demerg, dhrvst
      save
      if (irot .ne. 1) then
         if (irotyr .gt. irot) then
            irotyr = 1
            rewind( lun11 )
         endif
         read(lun11, 4000) (dlai(i),i=1,366)
         read(lun11, 4101) (potlai(i),i=1,366)
         read(lun11, 4001) (cdelta(i),i=1,366)
         read(lun11, 2000) (icindx(i),i=1,366)
         read(lun11, 4003) (basei(i),i=1,366)
         read(lun11, 4003) (topi(i),i=1,366)
         read(lun11, 4002) (noirr(i),i=1,366)
         read(lun11, 4001) (dirr(i),i=1,366)
         read(lun11, 4002) (iccrd(i),i=1,366)
         read(lun11, 4002) (ibegro(i),i=1,366)
         read(lun11, 4002) (iendro(i),i=1,366)
         alone = balone(irotyr)
         chone = chtone(irotyr)
      else
         irotyr = 1
      endif
      RETURN
2000  FORMAT(10I8)
4000  FORMAT(10f10.7)
4001  FORMAT(10f8.3)
4002  FORMAT(10I3)
4003  FORMAT(10f6.4)
4101  FORMAT(10f12.7)
      END

      SUBROUTINE SETONE
      COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &               VERMNT,BCKEND,flgpen
      COMMON /ONEVAR/A0(2),A1(2),A2(2),B0,B1,B2,wind1,wind2,wind3,
     &               dew1,dew2,dew3
      COMMON /HYDVAR/ ADD,SUM,TOT,POTET(366),EPP(366),PWU,SPG
      COMMON /BOTH/ ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1              R(366),ALONE,REFF,TMEAN(366), potlai(366),
     1              icindx(366),sumlai,acclai,aideal,sfn,
     1              iccrd(366),ioldcp,cdelta(366),chone,wind(366)
      COMMON /FREEZE/ IFZBEG,IFZEND,NFRZ,NFZDAY
      common /solt/ tbg(5),itbg,tbgsum,tswc,tma,dbd,aln,scaled,zl(12),
     &              wft(12), tsc(12), tk4(12)
      COMMON /etest/ etvar
      COMMON /BLK1/ EOS,SW1,RAIN,TUL,TU,CONA,ES,EP,MO,IDA,IYR,
     &              NT,UW,jjJE,jjJ,elev,rlat
      INTEGER FLGGEN,HBDATE,HYDOUT,FLGNUT,FLGPST,FLGMET,VERMNT,BCKEND
      INTEGER FLGpen
      REAL TCC(366,2),dew(366)
      save
      DATA GMA,ALB,CST/0.68,0.23,0.017167/
      PWU  =0.0
      lat  =33.
      SUM  =0.0
      TOT  =0.0
      ADD  =0.0
      SPG  =0.0
      ALAI =ALONE
      if (flgpen .gt. 0) then
c        pressr = atmospheric pressure at mean sea level
c        elev   = mean sea level elevation of site in meters
c
         pressr = 101.3 * ((288. - .0065 * elev) / 288.) ** 5.257
         zw     = 304.8
         zp     = 152.4
         chight = chone
         if (rlat .ge. 0.0) then
            cp   = 2.961
            xlat = rlat
         else
            cp   = 6.111
            xlat = -rlat
         endif
         ap  = 31.54 - .273 * xlat + .00078 * elev
c         ap  = 31.54 - .73 * xlat + .00078 * elev
         bp  = -.30  + .268 * xlat + .00041 * elev
      endif
C     IF (FLGGEN .NE. 2 .AND. VERMNT .NE. 1) THEN
      DO 5  I=1,366
         XI      = FLOAT(I)*CST
         CX      = COS(XI)
         SX      = SIN(XI)
         TC(I,1) = (A0(1)+A1(1)*CX+A2(1)*SX)
         TC(I,2) = (A0(2)+A1(2)*CX+A2(2)*SX)
         if (vermnt .eq. 0) then
            tmean(i) = (tc(i,1) + tc(i,2)) / 2.0
         endif
  5   CONTINUE
C     END IF

      DO 40 I=1,366
         XI = FLOAT(I) * CST
         CX = COS(XI)
         SX = SIN(XI)
         if (flgpen .gt. 0) then
c           wind = kilometers per day
c           dew  = celcius
            wind(i) = wind1 + wind2*cx + wind3*sx
            if (wind(i) .lt. 1.0) wind(i) = 1.0
            dew(i)  = dew1  + dew2*cx  + dew3*sx
         endif
         IF (VERMNT .EQ. 0) THEN
            TT = (TC(I,1)+TC(I,2))/2.0+273.0
         ELSE IF (VERMNT .EQ. 1) THEN
            TT = TMEAN(I)+273.0
         ENDIF
         RAD(I) = B0+B1*CX+B2*SX
         IF (RAD(I).LT.1.0) RAD(I) = 1.0
         HO = (1.0-ALB)*RAD(I)/58.3
         if (flgpen .gt. 0) then
            ttc = (tc(i,1) + tc(i,2)) / 2.0
            rs  = rad(i) * .04184
            rso = ap + bp * cos( (2. * 3.141593 * i) / 365. - cp )
            rbo = (-.02 + .261 * exp( -7.77e-4 * ttc**2.0 )) *
     &            4.903e-9 * (ttc + 273.)**4.
            rb  = (.9 * (rs / rso) + .1) * rbo
            ho  = (1.0-alb) * rs - rb
            chgtcm = chight * 100.
            if (chgtcm .lt. 0.) chgtcm = 0.0
            d   = 2./3. * chgtcm
            if (chgtcm .lt. 3.) then
               penlai = chgtcm * .08333
            else
               penlai = 1.5 * alog( chgtcm ) - 1.4
               if (penlai .gt. alai) penlai = alai
               if (penlai .le. 0.0)  penlai = .1                         fmd
            endif
            zom = .123 * (d + 1.0)
            zov = .1 * zom
c            slope = .2 * (.00738 * ttc + .8072) ** 7. - .000116
            slope = (4098. * vaporp( ttc )) / (ttc + 237.3)**2.
            heatv = 2.501 - .002361 * ttc
c            coefk1 = 19.8 - .08 * ttc
            coefk1 = 1710.0 - 6.85 * ttc
            if (i .eq. 1) then
               tt1 = (tc(366,1) + tc(366,2)) / 2.0
               tt2 = (tc(2,1)   + tc(2,2))   / 2.0
            else if (i .eq. 366) then
               tt1 = (tc(365,1) + tc(365,2)) / 2.0
               tt2 = (tc(1,1)   + tc(1,2))   / 2.0
            else
               tt1 = (tc(i-1,1) + tc(i-1,2)) / 2.0
               tt2 = (tc(i+1,1) + tc(i+1,2)) / 2.0
            endif
            gh  = 2.1 * (tt2 - tt1)

            if (penlai .le. 0.0) then
               rcc = 0.0
            else
               rcc = 200. / penlai
            endif
c            uz     = wind(i) / 86.4 * ((chight*100.0+200.) / 304.8)**.2
            uz     = wind(i) / 86.4
            if (zw - d .le. 0.0) then
               aa = 1.0
            else
               aa = alog( (zw - d) / zom )
            endif
            if (zp - d .le. 0.0) then
               aaa = 1.0
            else
               aaa = alog( (zp - d) / zov )
            endif
            ra     = (aa * aaa) / (.41 ** 2. * uz)
            psycho = (.001629 * pressr) / heatv
            psych1 = psycho * (1. + rcc / ra)
            ez0    = (vaporp( tc(i,1) ) + vaporp( tc(i,2) )) / 2.
            ez     = vaporp( dew(i) )
            priest = (slope  / (slope + psych1)) * (ho - gh)
            penman = (psycho / (slope + psych1)) * coefk1 *
     &               (1. / ra) * (ez0 - ez)
            etr    = priest + penman
            potet(i) = etr / heatv
         else
            D  = EXP(21.255-5304.0/TT)*5304.0/(TT*TT)
c            POTET(I) = 1.28*D*HO/(D+GMA)
            POTET(I) = etvar*D*HO/(D+GMA)
         endif
c        ALAI = ALAI+DLAI(I)                                            lai
         IF (ALAI.GT.0.0) GO TO 10
         EPP(I)   =0.0
         GO TO 30
  10     CONTINUE
C        IF (ALAI.GT.3.0) GO TO 20
C        EPP(I)  = ALAI*POTET(I)/3.0
C        GO TO 30
C 20     CONTINUE
C        EPP(I) = POTET(I)
         XXEAJ  = 1.0-(EXP(-0.6*ALAI))                                   FOREST
         EPP(I) = XXEAJ*POTET(I)                                         FOREST
  30     CONTINUE
         PWU = PWU+EPP(I)
         IF (VERMNT .EQ. 0) THEN
            SUM = SUM+(TC(I,1)+TC(I,2))/2.0
         ELSE IF (VERMNT .EQ. 1) THEN
            SUM = SUM+TMEAN(I)
         ENDIF
         TOT  = TOT+RAD(I)
         ADD  = ADD+POTET(I)
         ALAI = ALAI+DLAI(I)                                            lai
         if (alai .lt. 0.0001) alai=0.0                                 lai
         IF (I.GT.KE) SPG=SPG+EPP(I)
         chight = chight + cdelta(i)
         if (chight .lt. 0.0) chight = 0.0
  40  CONTINUE
      SU1 = SUM/366.0
      TO1 = TOT/366.0
      AD1 = ADD/25.4
c      SPG = SPG/PWU
      IF (NFRZ .GE. 1) THEN
         DO 60 I=1,366
            IF (I .EQ. 1) THEN
               J = 366
            ELSE
               J = I - 1
            ENDIF
C * * * WHEN DOES FREEZE BEGIN?
            IF ((TC(I,2)+TC(I,1))/2.0 .LT. 0.0 .AND.
     &                        (TC(J,2)+TC(J,1))/2.0 .GE. 0.0) THEN
               IFZBEG=I
C * * * WHEN DOES FREEZE END?
            ELSE IF ((TC(I,2)+TC(I,1))/2.0 .GE. 0.0 .AND.
     &                        (TC(J,2)+TC(J,1))/2.0 .LT. 0.0) THEN
               IFZEND=I+NFZDAY
            ENDIF
60       CONTINUE
      ENDIF
      RETURN
1000  FORMAT(10X,10F5.1)
      END

      FUNCTION vaporp( temp )
      vaporp = exp( (16.78 * temp - 116.9) / (temp + 237.3) )
      RETURN
      END

       SUBROUTINE SUMTAB(IYER,NBMO,NBY1)
       CHARACTER *3 CAL (12)
       CHARACTER *80 TITLE(3)
       COMMON /HEAD1/ TITLE
       COMMON /SUMT/ PRE(600),RUN(600),USE(600),PRC(600),ASW(600)
     1               ,TIRR(600),ISNOW
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &                VERMNT,BCKEND,flgpen
      COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
       REAL INTCEP,INTM,INTY,INTET,INTETM,INTETY
       INTEGER HBDATE,HYDOUT,FLGNUT,FLGPST,FLGGEN,FLGMET,VERMNT,
     1         FOREST, BEGGRO, ENDGRO,BCKEND,flgpen
      save
      IF (FLGMET .EQ. 0) THEN
         CONV = 1.0
      ELSE
         CONV = 2.54
      ENDIF
      CAL(1)   = 'JAN'
      CAL(2)   = 'FEB'
      CAL(3)   = 'MAR'
      CAL(4)   = 'APR'
      CAL(5)   = 'MAY'
      CAL(6)   = 'JUN'
      CAL(7)   = 'JUL'
      CAL(8)   = 'AUG'
      CAL(9)   = 'SEP'
      CAL(10)  = 'OCT'
      CAL(11)  = 'NOV'
      CAL(12)  = 'DEC'
       NBYR     =NBY1
       NBMO     =NBMO-1
       WRITE(LUN07,3000)  (TITLE(J),J=1,3)
       XN       =FLOAT(NBYR)
       K        =0
       N        =1
       M        =12
       IYR      =IYER
       DO 20 J=1,NBYR
           YIRR     =0.
           PYR      =0.0
           PGYR     =0.0                                                FOREST
           QYP      =0.0
           YWU      =0.0
           YPC      =0.0
           YSW      =0.0
           WRITE(LUN07,3004) IYR
           WRITE(LUN07,3009)                                            FOREST
           WRITE(LUN07,3001)
           IF (FLGMET .EQ. 0) THEN
              WRITE(LUN07,3006)
           ELSE
              WRITE(LUN07,3007)
           ENDIF
           DO 10 I=1,12
               K        =K+1
               P        =PRE(K)*CONV
               PYR      =PYR+P
               PGYR     =PGYR+PMOG(K)                                   FOREST
               Q        =RUN(K)*CONV
               QYP      =QYP+Q
               WU       =USE(K)*CONV
               YWU      =YWU+WU
               PC       =PRC(K)*CONV
               YPC      =YPC+PC
               SW       =ASW(K)*CONV
               YSW      =YSW+ SW
               SP       =TIRR(K)*CONV
               YIRR     =YIRR+SP
               WRITE(LUN07,3002) CAL(I),PMOG(K),P,Q,WU,PC,SW,SP         FOREST
  10       CONTINUE
           YSW      =YSW/12.0
           WRITE(LUN07,3003) PGYR,PYR,QYP,YWU,YPC,YSW,YIRR              FOREST
           IYR      =IYR+1
           N        =N+12
           M        =M+12
  20   CONTINUE
       AR       =0.0
       ARG      =0.0                                                    FOREST
       AQ       =0.0
       AU       =0.0
       AP       =0.0
       AS       =0.0
       AI       =0.0
       DO 40 I=1,12
           TOT      =0.0
           TOTG     =0.0                                                FOREST
           SUM      =0.0
           WUS      =0.0
           TPC      =0.0
           TSW      =0.0
           TTIRR    =0.
           DO 30 J=I,NBMO,12
               TTIRR    =TTIRR+TIRR(J)*CONV
               TOT      =TOT+PRE(J)*CONV
               TOTG     =TOTG+PMOG(J)                                   FOREST
               SUM      =SUM+RUN(J)*CONV
               WUS      =WUS+USE(J)*CONV
               TPC      =TPC+PRC(J)*CONV
               TSW      =TSW+ASW(J)*CONV
  30       CONTINUE
           PRE(I)   =TOT/XN
           PMOG(I)  =TOTG/XN                                            FOREST
           RUN(I)   =SUM/XN
           USE(I)   =WUS/XN
           PRC(I)   =TPC/XN
           ASW(I)   =TSW/XN
           TIRR(I)  =TTIRR/XN
           AR       =AR+TOT
           ARG      =ARG+TOTG                                           FOREST
           AQ       =AQ+SUM
           AU       =AU+WUS
           AP       =AP+TPC
           AS       =AS+TSW
           AI       =AI+TTIRR
  40   CONTINUE
       AR       =AR/XN
       ARG      =ARG/XN                                                 FOREST
       AQ       =AQ/XN
       AU       =AU/XN
       AP       =AP/XN
       AS       =AS/XN/12.0
       AI       =AI/XN
       WRITE(LUN07,3005)
       WRITE(LUN07,3009)
       WRITE(LUN07,3001)
       DO 50 I=1,12
           WRITE(LUN07,3002) CAL(I),PMOG(I),PRE(I),RUN(I),USE(I),PRC(I),FOREST
     1                       ASW(I),TIRR(I)
  50   CONTINUE
       WRITE (LUN07,3003) ARG,AR,AQ,AU,AP,AS,AI                         FOREST
       IF (ISNOW .NE. 0) WRITE(LUN07,3999)
       RETURN
3000   FORMAT(///,25X,'G L E A M S  HYDROLOGY SUMMARY',//,
     1            28X,'VERSION 3.0, MAY 1, 1999   TIFTON GA',//,
     1          (/,1X,A80))
3001   FORMAT(8X,'MONTH      RAIN       RAIN       RUNOFF        '      FOREST
     1              ,'ET         PERC       AVG SW     IRRIGAT',/,
     1           8X, '-----     ------     ------      ------      ',   FOREST
     1              '------     ------      ------     -------')
3002   FORMAT(9X,A3,7F12.3)
3003   FORMAT(/,9X,'TOT',7F12.3,/)
c3004   FORMAT(/,39X,'19',I2,/,39X,'----')                               y2k
3004   FORMAT(/,39X,     I4,/,39X,'----')                               y2k
3005   FORMAT(////,33X,'ANNUAL AVERAGES',/,33X,'---------------')
3006   FORMAT(20X,'IN          IN          IN          IN          IN', KH  FOR
     1              '          IN          IN')                         KH
3007   FORMAT(20X,'CM          CM          CM          CM          CM', KH  FOR
     1               '         CM          CM')                         KH
3009   FORMAT(9X,'          TOTAL       NET')                           FOREST
3999   FORMAT(//15X,'******************************',/,
     1          15X,'       SNOW NOTICE',/,
     2          15X,'******************************',/,5X,
     3 'DUE TO BELOW FREEZING TEMPERATURES, THIS RUN INCLUDED SNOW.' ,
     4 /,5X,' THE RAINFALL REGIMEN WAS CHANGED DUE TO PACK AND THAW.' )
       END
       SUBROUTINE ANNBUD(YEAR,PASS8B,PAS10B)
       COMMON /ANBUDG/ RAIN,RUN,PERC,ET,OLDSW,NEWSW,AIRR
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &                VERMNT,BCKEND,flgpen
      COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
       REAL INTCEP,INTM,INTY,INTET,INTETM,INTETY                        FOREST
       INTEGER HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,VERMNT,
     1                FOREST, BEGGRO, ENDGRO,BCKEND,flgpen
       REAL NEWSW,NEWSWm
       INTEGER YEAR
       save
C      BAL      =RAIN-RUN-PERC-ET-NEWSW+OLDSW+AIRR
       BAL      =SYRG-TINT-RUN-PERC-ET-NEWSW+OLDSW+AIRR                 FOREST
       IF (ABS(BAL).LT.0.001) BAL=0.0
       IF (FLGMET .EQ. 0) THEN
C         WRITE(LUN07,3000) YEAR,RAIN,RUN,PERC,ET,OLDSW,NEWSW,AIRR,BAL
          WRITE(LUN07,3000)YEAR,SYRG,RAIN,RUN,PERC,PASS8B,PAS10B,ET,    FOREST
     1                      TINT,TINTET,OLDSW,NEWSW,AIRR,BAL            FOREST
       ELSE
          SYRGM =SYRG*2.54                                              FOREST
          RAINm =RAIN*2.54
          RUNm  =RUN*2.54
          PERCm =PERC*2.54
          PASS8m=PASS8B*2.54
          PAS10m=PAS10B*2.54
          ETm   =ET*2.54
          TINTm =TINT*2.54                                              FOREST
          TINTEm=TINTET*2.54                                            FOREST
          OLDSWm=OLDSW*2.54
          NEWSWm=NEWSW*2.54
          AIRRm =AIRR*2.54
          BALm  =BAL*2.54
          WRITE(LUN07,4000) YEAR,SYRGM,RAINm,RUNm,PERCm,PASS8m,PAS10m,
     1                      ETm,TINTm,TINTEm,OLDSWm,NEWSWm,AIRRm,BALm   FOREST
       ENDIF
       RETURN
c3000   FORMAT(////,  30X,'ANNUAL TOTALS FOR 19',I2,/,                   y2k
3000   FORMAT(////,  30X,'ANNUAL TOTALS FOR '  ,I4,/,                   y2k
     1            27X,'PRECIP., TOTAL    =',F8.3,' IN'/,                FOREST
     1            27X,'PRECIP., NET      =',F8.3,' IN'/,                FOREST
     1            27X,'PREDICTED RUNOFF  =',F8.3,' IN'/,
     1            27X,'DEEP PERCOLATION  =',F8.3,' IN'/,
     1            27X,'ACTUAL PLANT EVAP =',F8.3,' IN'/,                FOREST
     1            27X,'ACTUAL SOIL EVAP  =',F8.3,' IN'/,                FOREST
     1            27X,'TOTAL ET          =',F8.3,' IN'/,
     1            27X,'TOTAL INTERCEPTION=',F8.3,' IN'/,                FOREST
     1            27X,'TOTAL INT PLUS ET =',F8.3,' IN'/,                FOREST
     1            27X,'BEGIN SOIL WATER  =',F8.3,' IN'/,
     1            27X,'FINAL SOIL WATER  =',F8.3,' IN'/,
     1            27X,'IRRIGATION APPLIED=',F8.3,' IN'/,
     1            27X,'WATER BUDGET BAL. =',F8.3,' IN'/)
c4000   FORMAT(////,  30X,'ANNUAL TOTALS FOR 19',I2,/,                   y2k
4000   FORMAT(////,  30X,'ANNUAL TOTALS FOR '  ,I4,/,                   y2k
     1            27X,'PRECIP., TOTAL    =',F8.3,' CM'/,                FOREST
     1            27X,'PRECIP., NET      =',F8.3,' CM'/,                FOREST
     1            27X,'PREDICTED RUNOFF  =',F8.3,' CM'/,
     1            27X,'DEEP PERCOLATION  =',F8.3,' CM'/,
     1            27X,'ACTUAL PLANT EVAP =',F8.3,' CM'/,                FOREST
     1            27X,'ACTUAL SOIL EVAP  =',F8.3,' CM'/,                FOREST
     1            27X,'TOTAL ET          =',F8.3,' CM'/,
     1            27X,'TOTAL INTERCEPTION=',F8.3,' CM'/,                FOREST
     1            27X,'TOTAL INT PLUS ET =',F8.3,' CM'/,                FOREST
     1            27X,'BEGIN SOIL WATER  =',F8.3,' CM'/,
     1            27X,'FINAL SOIL WATER  =',F8.3,' CM'/,
     1            27X,'IRRIGATION APPLIED=',F8.3,' CM'/,
     1            27X,'WATER BUDGET BAL. =',F8.3,' CM'/)
       END
       SUBROUTINE EVAP(POTE1,ALAI,ATRN,PTRN,PIRR,IRFLG,IROPT,ftemp)
       REAL POTE1(366)
       COMMON /BOTH/ ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1               R(366),ALONE,REFF,TMEAN(366), potlai(366),
     1               icindx(366),sumlai,acclai,aideal,sfn,
     1               iccrd(366),ioldcp,cdelta(366),chone,wind(366)
       COMMON /BLK1/ EOS,SW1,PIN,UL,U,CONA,ES,EP,MO,J,IYR,NT,ET,JC,JE,
     1               elev,rlat
c      COMMON/IRRIG/IDAY,NOIRR(366)
       COMMON /IRRIG/IDAY,NOIRR(366), balone(50),begsum,dirr(366),
     &              chtone(50)
       COMMON /IRR/ BASEI(366),TOPI(366),bsi,tpi
       common /optmir/cul(12), csw(12), nul                             optimal
      COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
      COMMON /PNUT/ DF(366),FP(20),FN(20),DEMERG,DHRVST,YP(90),DMY(90),
     &              NF,FNH(20),C1(90),C2(90),LEG(90),CNR(90),RNP(90),
     &              pernnl(90),ibegro(366),iendro(366)
       REAL INTCEP,INTM,INTY,INTET,INTETM,INTETY                        FOREST
       INTEGER FOREST, BEGGRO, ENDGRO, pernnl                           FOREST
       integer df, demerg, dhrvst
       save
       IRFLG    =0
       PIRR     =0.
       POTET    =POTE1(J)
       PP       =PIN
       EO       =POTET
       if (ftemp .gt. 0.) then                                          potEo
          fzfac = 1.0                                                   potEo
       else if (ftemp .le. -10.) then                                   potEo
          fzfac = 0.03                                                  potEo
       else if (ftemp .le. -4.) then                                    potEo
          fzfac = 0.00854 * exp (0.2168 * (ftemp + 16.0) )              potEo
       else if (ftemp .le. 0.) then                                     potEo
          fzfac = 0.000216 * exp (0.5213 * (ftemp + 16.0) )             potEo
       endif                                                            potEo
       eo = eo * fzfac                                                  potEo
       CALL RICHET(GR,T,U,EO,EP,ET,ES,ES1,ES2,ESX,EOS,PIN,CONA,ALAI,
     1             FOREST)
       if (forest .eq. 4) then
          if (j .lt. beggro  .or.  j .gt. endgro) then
             ep = 0.0
          endif
       else if (forest .eq. 0) then
          icrop = icindx(j)
          if (icrop .ne. 0) then
             if (icrop .gt. 2000) icrop = icrop - 2000
             if (pernnl(icrop) .gt. 0) then
                if (beggro .gt. 0 .and. endgro .gt. 0) then
                   if (j .lt. beggro  .or.  j .gt. endgro) then
                      ep = 0.0
                      et = es
                   endif
                endif
             endif
          endif
       endif
       ncrd = iccrd(j)
       PTRN = EP/25.4
       uu5  = basei(j) * cul(nul)
       U5   = 0.25 * cul(ncrd)
       SW1  = SW1+PP

c * * *  forest et algorithm.  if interception - energy goes to
c * * *    evap   1) interception, 2) soil, then 3) plant.
       if (forest .gt. 0  .and.  forest .le. 3) then
c * * *  interception uses soil energy first
          if (avlint .gt. 0. .and. es .gt. 0.) then
             if (avlint*25.4 .gt. es) then
                avlint = avlint - es / 25.4
                es = 0.
             else
                es = es - avlint * 25.4
                avlint = 0.
             endif
          endif
c * * *  interception uses plant energy last
          if (avlint .gt. 0. .and. ep .gt. 0.) then
             if (avlint*25.4 .gt. ep) then
                avlint = avlint - ep / 25.4
                ep = 0.
             else
                ep = ep - avlint * 25.4
                avlint = 0.
             endif
          endif
          et = ep + es
       endif

c csw(nul) = cumulative soil water at layer nul - no. of uptake layers.
c cul(nul) = cumulative fc - br15 at layer nul

c       IF (SW1 .GT. U5  .and.  noirr(iday) .eq. 0)  GOTO 10
c       IF (SW1 .le. U5  .and.  noirr(iday) .eq. 0)  GOTO 11
       IF (csw(ncrd) .GT. U5  .and.  noirr(iday) .eq. 0)  GOTO 10
       IF (csw(ncrd) .le. U5  .and.  noirr(iday) .eq. 0)  GOTO 11
       if (csw(nul) .ge. uu5  .and.  csw(ncrd) .ge. u5)   goto 10
       if (csw(nul) .ge. uu5  .and.  csw(ncrd) .lt. u5)   goto 11
C  IRRIGATE
       IRFLG = 1
c       PIRR =(UL*TOPI)-SW1
       PIRR =(cul(nul) * TOPI(j)) - csw(nul)                            optimal
       pirmin = 6.35
       if (pirmin .lt. et) pirmin = et
       if (pirr .lt. pirmin) pirr = pirmin
       SW1 =SW1+PIRR
       GO TO 10
c 11    EP       =EP*SW1/U5
 11    EP       =EP*csw(ncrd)/U5
       ET       =EP+ES
       IF (csw(ncrd).GT.ET) GO TO 10
C  SOIL MOISTURE LIMITING
c       ET       =SW1
c       ES       =SW1
c       SW1       =0.0
       ET       =csw(ncrd)
       ES       =csw(ncrd)
       SW1      =sw1 - et
       IF (ALAI.LE.0.0) GO TO 20
C  IF THERE IS A PLANT, REMAINING SOIL MOISTURE GOES TO PLANT
       ES       =0.0
       EP       =ET
       GO TO 20
C  SOIL MOISTURE NOT LIMITING
  10   CONTINUE
       if (et .gt. sw1) then
          et  = sw1
          sw1 = 0.0
          ep  = (ep/(ep + es)) * et
          es  = et - ep
       else
          SW1       =SW1-ET
       endif
  20   CONTINUE
       ATRN     =EP/25.4
       if (dirr(j) .gt. 0.) then
          IRFLG = 1
          pirr = pirr + dirr(j) * 25.4
          sw1  = sw1 + dirr(j) * 25.4
       endif
       RETURN
       END

       SUBROUTINE EROSB (SOLOSS,ENRICH,FLGMET,TEMPC,BCKEND)
       COMMON /EROS1/BYEAR,EYEAR,CDATE,NDATES,NYEARS,EROOUT,
     &            FLGUPD,FLGSEQ,NPTSO,XPOVR,SPOVR,NPTSC1,XPCHN1,
     &            SPCHN1,NPTSC2,XPCHN2,SPCHN2,DAREA,ELEM,FLGTMP
       COMMON /PASS/ SDATE,RNFALL,RUNOFF,EXRAIN,EI
       COMMON /PART/NPART,DIA(10),SPGR(10),FRAC(10),FALL(10),EQSAND(10),
     1               SOLCLY,SOLSLT,SOLSND,SOLORG,SSCLY,SSSLT,SSSND,
     1               SSORG,SSSOIL,FRCLY(10),FRSLT(10),FRSND(10),
     1               FRORG(10),DCL(11),DDCL(10)                         out
       COMMON /ROUT/ NXK,XSOIL(4),KSOIL(4),NXF,XFACT(4),CFACT(4,40),
     1               PFACT(4,40),NFACT(4,40),DAOVR,SLNGTH,
     1               NXC1,XCHN1(4),NCHN1(4,40),CCHN1(4,40),SCHN1(4,40),
     1               DCHN1(4,40),WCHN1(4,40),FLAGC1,FLAGS1,CTLO1,
     1               CTLZ1,CTLN1,CTLSL1,RA1,RN1,YBASE1,DACHU1,
     1               DACHL1,Z1,LNGTH1,LEFF1,
     1               NXC2,XCHN2(4),NCHN2(4,40),CCHN2(4,40),SCHN2(4,40),
     1               DCHN2(4,40),WCHN2(4,40),FLAGC2,FLAGS2,CTLO2,
     1               CTLZ2,CTLN2,CTLSL2,RA2,RN2,YBASE2,DACHU2,
     1               DACHL2,Z2,LNGTH2,LEFF2                             out
       COMMON /CHAN/ XSTAR(2,40),DEPA(2,40),DEPB(2,40),WIDA(2,40),
     1               WIDB(2,40),WERA(2,40),WERB(2,40)
       COMMON /POND/ CTL,PAC,DAPND,INTAKE,FRONT,DRAW,SIDE,FS,B,DIAO,C
       COMMON /BCKERO/ ELMLOS(4), ELMMON(4), ELMANN(4), ELMENR(4),      BE
     &                 ENRMON(4), ENRANN(4)                             BE
       COMMON /EROEND/ NRAINT, NRUNOT, TRAINT, TRUNOT, TGST(4,10)       DATE
       COMMON /GDATES/ NMONTH, NYEAR, IEOMY                             DATE
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       common /cover/slr
       REAL REB(9),CDRB(9),CDDB(9),XPOVR(40),SPOVR(40),XPCHN1(40),
     1      SPCHN1(40),XPCHN2(40),SPCHN2(40),TGSY(4,10),                DATE
     1      TGSM(4,10),GS(10),CONC(10),DAREA(4),LNGTH1,LEFF1,LNGTH2,
     1      LEFF2,KSOIL,NFACT,NCHN1,NCHN2,INTAKE
       INTEGER BYEAR,EYEAR,SDATE,CDATE(41),DNYEAR(40),EROOUT,
     1     FLGUPD,FLGSEQ,WCHMON,DP,ELEM,FLGTMP,FLGMET,       BCKEND,    BE  out
     1     FLAGC1,FLAGS1,CTLO1,FLAGC2,FLAGS2,CTLO2,CTL,PAC,jan(6)       out                                             jan
       save
       data indxy,lyear,jan,init /2*0,1,4,2,3,4,4,0/                    jan
       DO 10 I=1, 4                                                     BE
          ELMLOS(I) = 0.                                                BE
          ELMENR(I) = 0.                                                BE
10     CONTINUE                                                         BE
       RUNOFF = RUNOFF / 12.0
       EXRAIN = EXRAIN / 43200.
       if (init .eq. 0) then                                            temple
          INDXY  = INDXY-NYEARS                                         temple
          INDXD  = NDATES                                               temple
          INDXND = 1                                                    temple
          init = 1                                                      temple
       endif                                                            temple
       IF (LYEAR .EQ. NYEAR) GOTO 70                                    DATE
       INDXY  = INDXY+(NYEAR-LYEAR)                                     DATE
       LYEAR  = NYEAR                                                   DATE
       IF (INDXY.LE.NYEARS) GO TO 70                                    DATE
       INDXY  = INDXY-NYEARS                                            DATE
       INDXD  = NDATES                                                  DATE
       INDXND = 1                                                       DATE
       IF (FLGUPD.LT.1) GO TO 60                                        DATE
       LINDXD = 0                                                       DATE
       INDXD  = 1                                                       DATE
       INDXND = 2                                                       DATE
       CALL UPDPAR(1,FLGSEQ,NDATES,CDATE,NYEARS,DNYEAR,NPTSO,XPOVR,     DATE
     1             SPOVR,NPTSC1,XPCHN1,SPCHN1,NPTSC2,XPCHN2,SPCHN2,     DATE
     1             FLGMET)                                              DATE
       IF (FLGTMP.EQ.0) GO TO 60                                        DATE
       CALL OUTOV2(NDATES,CDATE,NYEARS,DNYEAR,FLGMET)                   DATE
       IF (FLGSEQ.LE.2) GO TO 60                                        DATE
       CALL OUTCH2(1,NDATES,CDATE,NYEARS,DNYEAR,FLGMET)                 DATE
       IF (FLGSEQ.EQ.3.OR.FLGSEQ.EQ.5) GO TO 60                         DATE
       CALL OUTCH2(2,NDATES,CDATE,NYEARS,DNYEAR,FLGMET)                 DATE
  60   CONTINUE                                                         DATE
       IF (INDXY.GT.NYEARS) INDXY = MOD(INDXY,NYEARS)                   DATE
       IF (INDXY.EQ.0) INDXY = NYEARS                                   DATE
  70   CONTINUE                                                         DATE
C
C      NDATE IS USED TO COMPARE AGAINST THE NEXT VALUE OF CDATE
C      FOR DECIDING WHETHER OR NOT TO UPDATE INDXD.  INDXND IS THE
C      INDEX FOR THE NEXT VALUES OF CDATE.
C
       IF (NDATES.LE.1) GO TO 100
       NDATE = MOD(SDATE,1000)+1000*INDXY
  90   CONTINUE
       IF (NDATE.LE.CDATE(INDXND)) GO TO 100
       INDXD  = INDXND
       INDXND = INDXND+1
       GO TO 90
 100   CONTINUE
C
C      INCREMENT THE COUNTERS FOR THE NUMBER OF RAINFALL EVENTS AND
C      THE RAINFALL TOTALS FOR FINAL ANNUAL AND MONTHLY SUMMARIES.
C      PASOUT PRINT A SUMMARY OUTPUT FOR THE STORM.
C
       IF (EROOUT.GT.3) CALL PASOUT(FLGMET)
             IF (RNFALL .GT. 0.0) THEN
                NRAINT = NRAINT+1
                NRAINY = NRAINY+1
                NRAINM = NRAINM+1
                TRAINT = TRAINT+RNFALL
                TRAINY = TRAINY+RNFALL
                TRAINM = TRAINM+RNFALL
             ENDIF
C
C      CHECK TO SEE WHETHER OR NOT ANY RUNOFF OCCURED AND INCREMENT THE
C      COUNTERS FOR THE NUMBER OF RUNOFF EVENTS AND THE RUNOFF TOTALS
C      BEFORE STARTING THE ROUTING CALCULATIONS
C
       IF (RUNOFF.LE.0.0.OR.EXRAIN.LE.0.0) GO TO 220
       NRUNOT = NRUNOT+1
       NRUNOY = NRUNOY+1
       NRUNOM = NRUNOM+1
       TRUNOT = TRUNOT+RUNOFF
       TRUNOY = TRUNOY+RUNOFF
       TRUNOM = TRUNOM+RUNOFF
CC
CC     CALL THE SUBROUTINE TO CALCULATE THE PARTICLE FALL VELOCITY FOR
CC     THE MEAN DAILY TEMPERATURE
       CALL EQVDIA(TEMPC)
C
C      CALL THE ROUTING PROCEDURE FOR THE OVERLAND FLOW SECTION
C      BEING MODELED.
C
c       IF (SDATE .EQ. FLGDAY) WRITE (LUN08,8000) FLGDAY                out
       ELEM   = 1
       slr = 0.0
       do 105 k=1,nxf
          if (slr .lt. cfact(k,indxd)) slr = cfact(k,indxd)
105    continue
       CALL ROUTE(EROOUT,INDXD,NPTSO,ELEM,XPOVR,SPOVR,GS,CONC,SOLOSS,
     1            FLGMET)
       CALL STROUT(ELEM,EROOUT,NPART,GS,CONC,DAOVR,ENRICH,FLGMET)
       IF (SOLOSS.LE.0.0) GO TO 120
       DO 110 K=1,NPART
           TGST(ELEM,K) = TGST(ELEM,K)+GS(K)
           TGSY(ELEM,K) = TGSY(ELEM,K)+GS(K)
           TGSM(ELEM,K) = TGSM(ELEM,K)+GS(K)
 110   CONTINUE
 120   CONTINUE
       IF (FLGSEQ.EQ.1) GO TO 210
       IF (FLGSEQ.EQ.2) GO TO 190
C
C      IF INDXD HAS CHANGED THEN THE DEPTH AND WIDTH PARAMETERS MUST
C      BE REASSIGNED WITH SPREAD.
C
       IF (INDXD.EQ.LINDXD) GO TO 130
       CALL SPREAD(1,1,INDXD,1,NXC1,XCHN1,DCHN1,NPTSC1,XPCHN1,DEPA)
       CALL SPREAD(1,2,INDXD,1,NXC1,XCHN1,DCHN1,NPTSC1,XPCHN1,DEPB)
       CALL SPREAD(1,1,INDXD,1,NXC1,XCHN1,WCHN1,NPTSC1,XPCHN1,WIDA)
       CALL SPREAD(1,2,INDXD,1,NXC1,XCHN1,WCHN1,NPTSC1,XPCHN1,WIDB)
 130   CONTINUE
C
C      CALL THE ROUTING PROCEDURE FOR THE FIRST CHANNEL BEING MODELED
C
       ELEM   = 2
       CALL ROUTE(EROOUT,INDXD,NPTSC1,ELEM,XPCHN1,SPCHN1,GS,CONC,SOLOSS,
     1            FLGMET)
       CALL STROUT(ELEM,EROOUT,NPART,GS,CONC,DACHL1,ENRICH,FLGMET)
       IF (SOLOSS.LE.0.0) GO TO 150
       DO 140 K=1,NPART
           TGST(ELEM,K) = TGST(ELEM,K)+GS(K)
           TGSY(ELEM,K) = TGSY(ELEM,K)+GS(K)
           TGSM(ELEM,K) = TGSM(ELEM,K)+GS(K)
 140   CONTINUE
 150   CONTINUE
       IF (FLGSEQ.EQ.3) GO TO 210
       IF (FLGSEQ.EQ.5) GO TO 190
C
C      IF INDXD HAS CHANGED THEN THE DEPTH AND WIDTH PARAMETERS MUST
C      BE REASSIGNED WITH SPREAD.
C
       IF (INDXD.EQ.LINDXD) GO TO 160
       CALL SPREAD(1,1,INDXD,2,NXC2,XCHN2,DCHN2,NPTSC2,XPCHN2,DEPA)
       CALL SPREAD(1,2,INDXD,2,NXC2,XCHN2,DCHN2,NPTSC2,XPCHN2,DEPB)
       CALL SPREAD(1,1,INDXD,2,NXC2,XCHN2,WCHN2,NPTSC2,XPCHN2,WIDA)
       CALL SPREAD(1,2,INDXD,2,NXC2,XCHN2,WCHN2,NPTSC2,XPCHN2,WIDB)
 160   CONTINUE
C
C      CALL THE ROUTING PROCEDURE FOR THE SECOND CHANNEL BEING MODELED
C
       ELEM   = 3
       CALL ROUTE(EROOUT,INDXD,NPTSC2,ELEM,XPCHN2,SPCHN2,GS,CONC,SOLOSS,
     1            FLGMET)
       CALL STROUT(ELEM,EROOUT,NPART,GS,CONC,DACHL2,ENRICH,FLGMET)
       IF (SOLOSS.LE.0.0) GO TO 180
       DO 170 K=1,NPART
           TGST(ELEM,K) = TGST(ELEM,K)+GS(K)
           TGSY(ELEM,K) = TGSY(ELEM,K)+GS(K)
           TGSM(ELEM,K) = TGSM(ELEM,K)+GS(K)
 170   CONTINUE
 180   CONTINUE
       IF (FLGSEQ.LT.6) GO TO 210
 190   CONTINUE
C
C      CALL THE IMPOUNDMENT ROUTING PROCEDURE IF AN IMPOUNDMENT IS
C      BEING MODELED.
C
       ELEM   = 4
       CALL IMPOND(GS,CONC,SOLOSS)
       CALL STROUT(ELEM,EROOUT,NPART,GS,CONC,DAPND,ENRICH,FLGMET)
       IF (SOLOSS.LE.0.0) GO TO 220
       DO 200 K=1,NPART
           TGST(ELEM,K) = TGST(ELEM,K)+GS(K)
           TGSY(ELEM,K) = TGSY(ELEM,K)+GS(K)
           TGSM(ELEM,K) = TGSM(ELEM,K)+GS(K)
 200   CONTINUE
       GO TO 230
 210   CONTINUE
C
C      CHECK FOR SOIL LOSS AND IF NONE OCCURED SET THE SEDIMENT
C      ENRICHMENT RATIO TO ZERO.
C
       IF (SOLOSS.GT.0.0) GO TO 230
 220   CONTINUE
       SOLOSS = 0.0
       ENRICH = 0.0
 230   CONTINUE
C
       LINDXD = INDXD
       ELEM   = jan(flgseq)                                             jan
c       IF (IEOMY .GE. 2 .AND. EROOUT .GE. 2) THEN                       DATE
       IF (IEOMY .GE. 2) THEN                                           DATE
          CALL MONOUT(ELEM,FLGSEQ,EROOUT,NPART,NMONTH,NYEAR,NRAINM,     DATE
     1        NRUNOM,TRAINM,TRUNOM,TGSM,DAREA,FLGMET,BCKEND)            DATE
       ENDIF                                                            DATE
       IF (IEOMY .GE. 3) THEN                                           DATE
          CALL ANNOUT(ELEM,FLGSEQ,EROOUT,NPART,NYEAR,NRAINY,NRUNOY,     DATE
     1          TRAINY,TRUNOY,TGSY,DAREA,FLGMET)                        DATE
       ENDIF                                                            DATE
       RETURN
8000   FORMAT(///,17X,'SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS',
     &              /,            33X,'FLGDAY OUTPUT',/,
     &            17X,'SEGMENT BY SEGMENT OUTPUT FOR THE STORM ',I5,/,
     &            17X,'SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS'
     &     ,/)
       END
       SUBROUTINE PASOUT(METFLG)
       COMMON /PASS/ SDATE,RNFALL,RUNOFF,EXRAIN,EI
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       INTEGER SDATE
       save
       IF (RNFALL .LE. 0.0 ) RETURN
       RUNTMP = 12. * RUNOFF
       EXRTMP = 43200.0*EXRAIN
       IF (METFLG .EQ. 0) THEN
          WRITE(LUN08,4000) SDATE,RNFALL,RUNTMP,EXRTMP,EI
       ELSE
          P=RNFALL*2.54
          Q=RUNTMP*2.54
          QP=EXRTMP*2.54
          EIM=EI*17.02
          WRITE (LUN08,5000) SDATE,P,Q,QP,EIM
       ENDIF
       IF (RUNOFF.LE.0.0) WRITE(LUN08,4001)
       RETURN
4000   FORMAT(//,11X,60('S'),//,
     1            35X,'STORM INPUTS',/,
     1            35X,'------------',//,
     1            23X,'DATE',10X,I7,3X,'JULIAN DATE',/,
     1            23X,'RAINFALL',7X,F6.2,3X,'INCHES',/,
     1            23X,'RUNOFF VOLUME',2X,F6.2,3X,'INCHES',/,
     1            23X,'EXCESS RAINFALL',F6.2,3X,'INCHES/HR',/,
     1            23X,'EI',13X,F6.2,3X,'WISCHMEIER ENGL. UNITS',/)
4001   FORMAT(/,24X,'***  NO RUNOFF - NO SOIL LOSS  ***')
5000   FORMAT(//,11X,60('S'),//,
     1            35X,'STORM INPUTS',/,
     1            35X,'------------',//,
     1            23X,'DATE',10X,I7,3X,'JULIAN DATE',/,
     1            23X,'RAINFALL',7X,F6.2,3X,'CM',/,
     1            23X,'RUNOFF VOLUME',2X,F6.2,3X,'CM',/,
     1            23X,'EXCESS RAINFALL',F6.2,3X,'CM/HR',/,
     1            23X,'EI',13X,F6.2,3X,'MJ-MM/HA-HR',/)
       END
       SUBROUTINE ADDPTS(NIN,XIN,NOUT,XOUT,YOUT)
       REAL INTRPL,XIN(NIN),XOUT(40),YOUT(40)
       save
       IIN  = 1
       IOUT = 1
  10   CONTINUE
           DIF  = (XOUT(IOUT)-XIN(IIN)) /XIN(NIN)
           IF (ABS(DIF).LT.0.001)GO TO 30
           IF (XOUT(IOUT).LT.XIN(IIN)) GO TO 40
           NOUT = NOUT+1
           IDWN = NOUT
  20       CONTINUE
               XOUT(IDWN) = XOUT(IDWN-1)
               YOUT(IDWN) = YOUT(IDWN-1)
               IDWN       = IDWN-1
               IF (IDWN.GT.IOUT) GO TO 20
           YOUT(IOUT) = INTRPL(XOUT(IOUT-1),YOUT(IOUT-1),XOUT(IOUT+1),
     1                  YOUT(IOUT+1),XIN(IIN))
  30       CONTINUE
           XOUT(IOUT)=XIN(IIN)
           IIN  = IIN+1
           IF (IIN.GT.NIN) RETURN
  40       CONTINUE
           IOUT = IOUT+1
           IF (IOUT.LE.NOUT) GO TO 10
       RETURN
       END
       SUBROUTINE ANNOUT(ELEM,FLGSEQ,EROOUT,NPART,LYEAR,NRAINY,NRUNOY,
     1                   TRAINY,TRUNOY,TGSY,DAREA,METFLG)
       COMMON /CONS/ AGRAV,MSDH2O,WTDH2O,WTDSOI,KINVIS,KCH,YALCON,BETA,
     1               NBAROV,NBARCH
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       COMMON /BCKERO/ ELMLOS(4), ELMMON(4), ELMANN(4), ELMENR(4),      BE
     &                 ENRMON(4), ENRANN(4)                             BE
       REAL CONC(10),TGSY(4,10),DAREA(4),MSDH2O,KINVIS,KCH,NBAROV,NBARCH
       INTEGER ELEM,FLGSEQ,EROOUT,FLGTMP
       save
C       IF (NRAINY.EQ.0) GO TO 60                                        DATE
       RUNVOL = TRUNOY*DAREA(ELEM)
       TRUNOY = 12.0*TRUNOY
       IF (METFLG .EQ. 0) THEN
          WRITE (LUN08,4000) LYEAR,NRAINY,TRAINY,NRUNOY,TRUNOY
       ELSE
          P=TRAINY*2.54
          Q=TRUNOY*2.54
          WRITE (LUN08,5000) LYEAR,NRAINY,P,NRUNOY,Q
       ENDIF
       IF (NRUNOY.EQ.0) GO TO 60
       FLGTMP = MOD(EROOUT,2)
       IF (EROOUT.EQ.6) FLGTMP = 1
       DO 50 J=1,ELEM
           IF (J.EQ.2.AND.FLGSEQ.EQ.2) GO TO 50
           IF (J.EQ.3.AND.FLGSEQ.EQ.2) GO TO 50
           IF (J.EQ.3.AND.FLGSEQ.EQ.5) GO TO 50
           IF (J.EQ.1) WRITE (LUN08,4004)
           IF (J.EQ.2) WRITE (LUN08,4005)
           IF (J.EQ.3) WRITE (LUN08,4006)
           IF (J.EQ.4) WRITE (LUN08,4007)
           TGS    = 0.0
           DO 10 K=1,NPART
               TGS     = TGS+TGSY(J,K)
  10       CONTINUE
           IF (TGS.LE.0.0) GO TO 40
           IF (METFLG .EQ. 0) THEN
              IF (FLGTMP.EQ.1) WRITE (LUN08,4001)
           ELSE
              IF (FLGTMP.EQ.1) WRITE (LUN08,5001)
           ENDIF
           TCONC  = 0.0
           TCNCPC = 0.0
           TPPM   = 0.0
           DO 20 K=1,NPART
               CONC(K) = TGSY(J,K)/RUNVOL
               CONCPC  = CONC(K)/WTDH2O
               PPM     = CONCPC*1.0E+06
               FRAC    = TGSY(J,K)/TGS
               IF (FLGTMP.EQ.1) THEN
                  IF (METFLG.EQ.0) THEN
                     WRITE (LUN08,4002) K,FRAC,
     1                 TGSY(J,K),CONC(K),CONCPC,PPM
                  ELSE
                     CONCM=CONC(K)*16.01
                     TGSYM=TGSY(J,K)/2.205
                     WRITE (LUN08,4002) K,FRAC,TGSYM,CONCM,CONCPC,PPM
                  ENDIF
               ENDIF
               TCONC   = TCONC+CONC(K)
               TCNCPC  = TCNCPC+CONCPC
               TPPM    = TPPM+PPM
  20       CONTINUE
           DACRE  = DAREA(J)/43560.0
           SOLOSS = TGS/(2000.0*DACRE)
           IF (FLGTMP.EQ.0) GO TO 30
           IF (METFLG .EQ. 0) THEN
              WRITE (LUN08,4003) TGS,TCONC,TCNCPC,TPPM,SOLOSS,DACRE
              ELMANN(J) = SOLOSS                                        BE
           ELSE
              DHECT=DACRE/2.471
              TPH=SOLOSS*2.242
              TGSM=TGS/2.205
              WRITE (LUN08,5003)TGSM,TCONC,TCNCPC,TPPM,TPH,DHECT
              ELMANN(J) = tph                                           BE fmd
           ENDIF
           CALL ENRCMP(2,CONC,ENRICH)
           WRITE (LUN08,4009)
           ENRANN(J) = ENRICH                                           BE
           GO TO 50
  30       CONTINUE
           CALL ENRCMP(1,CONC,ENRICH)
           ENRANN(J) = ENRICH                                           BE
           IF (METFLG .EQ. 0) THEN
              WRITE (LUN08,4008) SOLOSS,ENRICH
              ELMANN(J) = SOLOSS                                        BE
           ELSE
              TPH=SOLOSS*2.242                                          fmd
              WRITE (LUN08,5008) TPH,ENRICH
              ELMANN(J) = TPH                                           BE
           ENDIF
           GO TO 50
  40       CONTINUE
           WRITE (LUN08,4010)
  50   CONTINUE
  60   CONTINUE
       NRAINY = 0
       NRUNOY = 0
       TRAINY = 0.0
       TRUNOY = 0.0
       DO 80 J=1,ELEM
           DO 70 K=1,NPART
               TGSY(J,K) = 0.0
  70       CONTINUE
  80   CONTINUE
       RETURN
4000   FORMAT(//,11X,60('Y'),//,
     1            29X,'ANNUAL SUMMARY FOR '  ,I4,/,                     y2k
     1            29X,'-----------------------',//,
     1            18X,I4,' STORMS PRODUCED ',F8.2,' IN. OF RAINFALL',/,
     1            18X,I4,' STORMS PRODUCED ',F8.2,' IN. OF RUNOFF',/)
4001   FORMAT(/,21X,'THE QUANTITY OF ERODED SEDIMENT IN RUNOFF',//,
     1            6X,'PART.   FRAC. IN   SOIL LOSS  ',
     1               '       CONCENTRATIONS (SOIL/WATER)    ',/,
     1            6X,'TYPE   SED. LOAD      LBS.    ',
     1               '  LBSF/FT**3    LBSF/LBSF     PPM (WT)',/,
     1            6X,'----     -----      -------   ',
     1               '    ------        -----       --------')
4002   FORMAT(7X,I2,6X,F5.2,4X,F9.0,4X,F9.4,4X,F9.4,4X,F10.0)
4003   FORMAT(/,10X,'TOTAL',9X,F9.0,4X,F9.4,4X,F9.4,4X,F10.0,//,
     1            19X,'ANNUAL SOIL LOSS FOR AREA ',F6.2,
     1                ' TONS/ACRE',/,
     1            29X,'(AREA = ',F8.4,' ACRES)')
4004   FORMAT(/,28X,'VALUES FROM OVERLAND FLOW',/,
     1          28X,'-------------------------')
4005   FORMAT(/,29X,'VALUES FROM CHANNEL ONE',/,
     1          29X,'-----------------------')
4006   FORMAT(/,29X,'VALUES FROM CHANNEL TWO',/,
     1          29X,'-----------------------')
4007   FORMAT(/,29X,'VALUES FROM IMPOUNDMENT',/,
     1          29X,'-----------------------')
4008   FORMAT(24X,'ANNUAL SOIL LOSS  ',F6.2,' TONS/ACRE',/,
     1        24X,'ENRICHMENT RATIO  ',F7.3)
4009   FORMAT(//)
4010   FORMAT(/,31X,'*** NO SOIL LOSS ***')
5000   FORMAT(//,11X,60('Y'),//,
     1            29X,'ANNUAL SUMMARY FOR '  ,I4,/,                     y2k
     1            29X,'-----------------------',//,
     1            18X,I4,' STORMS PRODUCED ',F8.2,' CM OF RAINFALL',/,
     1            18X,I4,' STORMS PRODUCED ',F8.2,' CM OF RUNOFF',/)
5001   FORMAT(/,21X,'THE QUANTITY OF ERODED SEDIMENT IN RUNOFF',//,
     1            6X,'PART.   FRAC. IN   SOIL LOSS  ',
     1               '       CONCENTRATIONS (SOIL/WATER)    ',/,
     1            6X,'TYPE   SED. LOAD       KG     ',
     1               '   KG/M**3        KG/KG       PPM (WT)',/,
     1            6X,'----     -----      -------   ',
     1               '    ------        -----       --------')
5003   FORMAT(/,10X,'TOTAL',9X,F9.0,4X,F9.4,4X,F9.4,4X,F10.0,//,
     1            19X,'ANNUAL SOIL LOSS FOR AREA ',F6.2,
     1                ' TONNES/HECTARE',/,
     1            29X,'(AREA = ',F8.4,' HECTARES)')
5008   FORMAT(24X,'ANNUAL SOIL LOSS  ',F6.2,' TONNES/HECTARE',/,
     1        24X,'ENRICHMENT RATIO  ',F7.3)
       END
       REAL FUNCTION CRIT(Z,Q)
       COMMON /CONS/ AGRAV,MSDH2O,WTDH2O,WTDSOI,KINVIS,KCH,YALCON,BETA,
     1               NBAROV,NBARCH
       REAL MSDH2O,KINVIS,KCH,NBAROV,NBARCH
       save
       CRIT = (2.0*BETA*Q**2/(AGRAV*Z**2))**0.2
       RETURN
       END
       SUBROUTINE CURFIT(XU,YU,SU,XL,YL,SL,NPT,XC,YC,SC)
       REAL XC(NPT),YC(NPT),SC(NPT)
       save
       SA = (SU+SL)/2.0
       A1 = -SU/SA
       A2 = ((-SL/SA)-A1)/2.0
       DO 10 I=1,NPT
           XS    = FLOAT(I)/FLOAT(NPT+1)
           XC(I) = XU+XS*(XL-XU)
           YS    = 1.0+A1*XS+A2*XS**2
           YC(I) = YL+YS*(YU-YL)
           SS    = A1+2*A2*XS
           SC(I) = ABS(SA*SS)
  10   CONTINUE
       RETURN
       END
       SUBROUTINE DCAP(FLAGM,FLAGT,Q,SF,C1,Z,EFFSH,DEPSID,DEPMID,WEROD,
     1                 WFLOW,N,CRSH,COVSH,MAXE,EXCESS,TB,DF)
       COMMON /PASS/ SDATE,RNFALL,RUNOFF,EXRAIN,EI
       COMMON /CONS/ AGRAV,MSDH2O,WTDH2O,WTDSOI,KINVIS,KCH,YALCON,BETA,
     1               NBAROV,NBARCH
       COMMON /PART/NPART,DIA(10),SPGR(10),FRAC(10),FALL(10),EQSAND(10),
     1               SOLCLY,SOLSLT,SOLSND,SOLORG,SSCLY,SSSLT,SSSND,
     1               SSORG,SSSOIL,FRCLY(10),FRSLT(10),FRSND(10),
     1               FRORG(10),DCL(11),DDCL(10)
       REAL N,NBARCH,KCH,DF(10),LEFF,MAXE,NBAROV,XXCF(17),FFXCF(17),
     1      XXB(27),FHXB(27),MSDH2O,KINVIS
       INTEGER FLAGT,FLAGM,SDATE                                        out
       save
       DATA XXCF /0.0,0.02,0.04,0.06,0.08,0.10,0.12,0.14,0.16,
     1            0.18,0.20,0.22,0.24,0.26,0.28,0.30,0.32/
       DATA FFXCF/1000.0,33.872,12.571,7.3030,5.1102,
     1            3.9575,3.2659,2.8419,2.5040,2.2818,
     1            2.1194,1.9997,1.9118,1.8489,1.8068,
     1            1.7829,1.7758/
       DATA XXB  /0.0,0.01,0.02,0.04,0.06,0.08,0.1,
     1            0.12,0.14,0.16,0.18,0.2,0.22,0.24,0.26,
     1            0.28,0.3,0.32,0.34,0.36,0.38,0.4,0.42,
     1            0.44,0.46,0.48,0.5/
       DATA FHXB /0.0,0.000474,0.00154,0.00509,0.0104,0.0177,
     1            0.0269,0.0384,0.0524,0.0693,0.0897,0.114,0.1432,
     1            0.1782,0.2207,0.2724,0.3361,0.4159,0.5176,0.6506,
     1            0.8307,1.0858,1.4722,2.1212,3.4264,7.3566,10000.0/
       TIMPOT = 0.0
       ADJSH  = 1.35*EFFSH
       IF (ADJSH.GT.CRSH) GO TO 30
  10   CONTINUE
       DO 20 K=1,NPART
           DF(K) = 0.0
  20   CONTINUE
       DCT    = 0.0
       RETURN
  30   CONTINUE
       TIMSH  = TB*(1.0-(CRSH/(1.35*EFFSH)))
       IF (DEPMID.EQ.0.0) GO TO 90
       IF (FLAGT.EQ.3) GO TO 40
       CALL HYDCHN(4,Q,SF,C1,Z,WFLOW,WEROD,N,CRSH,COVSH,EFFSH)
       GO TO 50
  40   CONTINUE
       WEROD  = WFLOW
  50   CONTINUE
       DIFSH  = 1.35*EFFSH-CRSH
       IF (DIFSH.LE.0.0) GO TO 10
       DI     = EXCESS*(KCH*((1.35*EFFSH-CRSH)**1.05))
       TIMPOT = DEPMID*WTDSOI/DI
       IF (TIMPOT.LT.TIMSH) GO TO 90
  60   CONTINUE
       DCT    = DI*TIMSH*WEROD/(TB*WFLOW)
       IF (FLAGM.EQ.1) GO TO 70
       IF (DCT.LT.MAXE) GO TO 70
       DI     = DI*MAXE/DCT
       DCT    = MAXE
  70   CONTINUE
       DO 80 K=1,NPART
           DF(K) = DCT*FRAC(K)
  80   CONTINUE
       DEPMID = DEPMID-DI*TIMSH/WTDSOI
       IF (DEPMID.LT.0.005) DEPMID= 0.0
       RETURN
  90   CONTINUE
       TIMEX  = TIMSH-TIMPOT
       AB     = (Q*NBARCH/(1.49*SQRT(SF)))
       IF (WEROD.EQ.0.0) CALL HYDCHN(4,Q,SF,C1,Z,WFLOW,WEROD,N,CRSH,
     1                              COVSH,EFFSH)
       HXB    = AB/(WEROD**(8.0/3.0))
       CALL TABLE(4,27,XXB,FHXB,HXB,XB)
       DIFSH  = EFFSH*SHDIST(XB)-CRSH
       IF (DIFSH.GT.0.0) GO TO 100
       IF (DEPMID.LE.0.0) GO TO 10
       TIMSH  = TIMPOT
       GO TO 60
 100   CONTINUE
       DWDTI  = EXCESS*2.0*KCH*(DIFSH**1.05)/WTDSOI
       AD     = (AB**0.375)*WTDH2O*SF/CRSH
       IF (AD.LE.1.7758)GO TO 10
       CALL TABLE(3,17,XXCF,FFXCF,AD,XCF)
       WFIN   = (AB**0.375)*((XCF*(1.0-2.0*XCF)/XCF**(8.0/3.0))**0.375)
       IF (WFIN.LE.WEROD) GO TO 10
       TSTAR  = TIMEX*DWDTI/(WFIN-WEROD)
       WSTAR  = (1.0-EXP(-1.0176*TSTAR))/1.0176
       WE     = WSTAR*(WFIN-WEROD)+WEROD
       EROS   = (WE-WEROD)*DEPSID+DEPMID*WEROD
       DCT    = EROS*WTDSOI/(TB*WFLOW)
       IF (FLAGM.EQ.1) GO TO 110
       IF (DCT.LT.MAXE) GO TO 110
       DCT    = MAXE
       EROS   = DCT*TB*WFLOW/WTDSOI
 110   CONTINUE
       DO 120 K=1,NPART
           DF(K) = DCT*FRAC(K)
 120   CONTINUE
       IF (EROS.LT.DEPMID*WEROD) GO TO 130
       EROSL  = EROS-DEPMID*WEROD
       WEROD  = EROSL/DEPSID+WEROD
       DEPMID = 0.0
       RETURN
 130   CONTINUE
       DEPMID = DEPMID-EROS/WEROD
       RETURN
       END
       SUBROUTINE ENDOUT( METFLG )                                      DATE
       COMMON /HEAD2/ TITLE2
       COMMON /CONS/ AGRAV,MSDH2O,WTDH2O,WTDSOI,KINVIS,KCH,YALCON,BETA,
     1               NBAROV,NBARCH
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       COMMON /PASS/ SDATE,RNFALL,RUNOFF,EXRAIN,EI                      DATE
       COMMON /PART/NPART,DIA(10),SPGR(10),FRAC(10),FALL(10),EQSAND(10),DATE
     1               SOLCLY,SOLSLT,SOLSND,SOLORG,SSCLY,SSSLT,SSSND,     DATE
     1               SSORG,SSSOIL,FRCLY(10),FRSLT(10),FRSND(10),        DATE
     1               FRORG(10),DCL(11),DDCL(10)                         DATE out
       COMMON /EROEND/ NRAINT, NRUNOT, TRAINT, TRUNOT, TGST(4,10)       DATE
       COMMON /EROS1/BYEAR,EYEAR,CDATE,NDATES,NYEARS,EROOUT,            DATE
     &            FLGUPD,FLGSEQ,NPTSO,XPOVR,SPOVR,NPTSC1,XPCHN1,        DATE
     &            SPCHN1,NPTSC2,XPCHN2,SPCHN2,DAREA,ELEM,FLGTMP         DATE
       REAL CONC(10),XPOVR(40),SPOVR(40),XPCHN1(40),SPCHN1(40),         DATE
     &      XPCHN2(40),SPCHN2(40),DAREA(4),MSDH2O,KINVIS,KCH,NBAROV,    DATE
     1      NBARCH
       INTEGER BYEAR,EYEAR,SDATE,CDATE(41),DNYEAR(40),EROOUT,           DATE out
     1          FLGUPD,FLGSEQ,WCHMON,DP,ELEM,FLGTMP,FLGMET              DATE out
       CHARACTER *80 TITLE2 (3)
       save
       IF (NRAINT.EQ.0) GO TO 50
       RUNVOL = TRUNOT*DAREA(ELEM)
       TRUNOT = 12.0*TRUNOT
       P=TRAINT*2.54
       Q=TRUNOT*2.54
       IF (METFLG .EQ. 0) THEN
          WRITE (LUN08,4000)  (TITLE2(J),J=1,3),NRAINT,TRAINT,
     1               NRUNOT,TRUNOT
       ELSE
          WRITE (LUN08,5000)  (TITLE2(J),J=1,3),NRAINT,P,NRUNOT,Q
       ENDIF
       IF (NRUNOT.EQ.0) GO TO 50
       DO 40 J=1,ELEM
          IF (J.EQ.2.AND.FLGSEQ.EQ.2) GO TO 40
          IF (J.EQ.3.AND.FLGSEQ.EQ.2) GO TO 40
          IF (J.EQ.3.AND.FLGSEQ.EQ.5) GO TO 40
          IF (J.EQ.1) WRITE (LUN08,4004)
          IF (J.EQ.2) WRITE (LUN08,4005)
          IF (J.EQ.3) WRITE (LUN08,4006)
          IF (J.EQ.4) WRITE (LUN08,4007)
          TGS    = 0.0
          DO 10 K=1,NPART
              TGS     = TGS+TGST(J,K)
  10      CONTINUE
          IF (TGS.LE.0.0) GO TO 30
          IF (METFLG .EQ. 0) THEN
             WRITE (LUN08,4001)
          ELSE
             WRITE (LUN08,5001)
          ENDIF
          TCONC  = 0.0
          TCNCPC = 0.0
          TPPM   = 0.0
          DO 20 K=1,NPART
             CONC(K) = TGST(J,K)/RUNVOL
             CONCPC  = CONC(K)/WTDH2O
             PPM     = CONCPC*1.0E+06
             FFRAC    = TGST(J,K)/TGS                                   DATE
             IF (METFLG.EQ.0) THEN
                WRITE (LUN08,4002) K,FFRAC,TGST(J,K),CONC(K),CONCPC,PPM DATE
             ELSE
                CONCM=CONC(K)*16.01
                TGSTM=TGST(J,K)/2.205
                WRITE (LUN08,4002) K,FFRAC,TGSTM,CONCM,CONCPC,PPM       DATE
             ENDIF
             TCONC   = TCONC+CONC(K)
             TCNCPC  = TCNCPC+CONCPC
             TPPM    = TPPM+PPM
  20      CONTINUE
          DACRE  = DAREA(J)/43560.0
          SOLOSS = TGS/(2000.0*DACRE)
          IF (METFLG .EQ. 0) THEN
             WRITE (LUN08,4003) TGS,TCONC,TCNCPC,TPPM,SOLOSS,DACRE
          ELSE
             DHECT=DACRE/2.471
             TPH=SOLOSS*2.242
             TGSM=TGS/2.205
             WRITE (LUN08,5003)TGSM,TCONC,TCNCPC,TPPM,TPH,DHECT
          ENDIF
          CALL ENRCMP(2,CONC,ENRICH)
          GO TO 40
  30      CONTINUE
          WRITE (LUN08,4008)
  40   CONTINUE
  50   CONTINUE
       RETURN
4000   FORMAT(///, 6X,'G L E A M S  NONPOINT SOURCE POLLUTION MODEL',
     1                ' (EROSION/SEDIMENT YIELD)',//,
     1            23X,'VERSION 3.0, MAY 1, 1999   TIFTON GA',//,
     1             3(1X,A80,/),/,
     1            34X,'STORM SUMMARY',/,
     1            34X,'-------------',//,
     1            18X,I4,' STORMS PRODUCED ',F8.2,' IN. OF RAINFALL',/,
     1            18X,I4,' STORMS PRODUCED ',F8.2,' IN. OF RUNOFF')
4001   FORMAT(/,21X,'THE QUANTITY OF ERODED SEDIMENT IN RUNOFF',//,
     1            6X,'PART.   FRAC. IN   SOIL LOSS  ',
     1               '       CONCENTRATIONS (SOIL/WATER)',/,
     1            6X,'TYPE   SED. LOAD      LBS.    ',
     1               '  LBSF/FT**3    LBSF/LBSF     PPM (WT)',/,
     1            6X,'----     -----      -------   ',
     1               '    ------        -----       --------')
4002   FORMAT(7X,I2,6X,F5.2,4X,F9.0,4X,F9.4,4X,F9.4,4X,F10.0)
4003   FORMAT(/,10X,'TOTAL',9X,F9.0,4X,F9.4,4X,F9.4,4X,F10.0,//,
     1            20X,'TOTAL SOIL LOSS FOR AREA ',F7.2,
     1                ' TONS/ACRE',/,
     1            29X,'(AREA = ',F8.4,' ACRES)')
4004   FORMAT(///,28X,'VALUES FROM OVERLAND FLOW',/,
     1            28X,'-------------------------')
4005   FORMAT(///,29X,'VALUES FROM CHANNEL ONE',/,
     1            29X,'-----------------------')
4006   FORMAT(///,29X,'VALUES FROM CHANNEL TWO',/,
     1            29X,'-----------------------')
4007   FORMAT(///,29X,'VALUES FROM IMPOUNDMENT',/,
     1            29X,'-----------------------')
4008   FORMAT(/,31X,'*** NO SOIL LOSS ***')
5000   FORMAT(7X,'G L E A M S  NONPOINT SOURCE POLLUTION MODEL',
     1                ' (EROSION/SEDIMENT YIELD)',//,
     1            23X,'VERSION 3.0, MAY 1, 1999   TIFTON GA',//,
     1             3(1X,A80,/),/,
     1            34X,'STORM SUMMARY',/,
     1            34X,'-------------',//,
     1            18X,I4,' STORMS PRODUCED ',F8.2,' CM OF RAINFALL',/,
     1            18X,I4,' STORMS PRODUCED ',F8.2,' CM OF RUNOFF')
5001   FORMAT(/,21X,'THE QUANTITY OF ERODED SEDIMENT IN RUNOFF',//,
     1            6X,'PART.   FRAC. IN   SOIL LOSS  ',
     1               '       CONCENTRATIONS (SOIL/WATER)    ',/,
     1            6X,'TYPE   SED. LOAD       KG     ',
     1               '   KG/M**3        KG/KG       PPM (WT)',/,
     1            6X,'----     -----      -------   ',
     1               '    ------        -----       --------')
5003   FORMAT(/,10X,'TOTAL',9X,F9.0,4X,F9.4,4X,F9.4,4X,F10.0,//,
     1            19X,'TOTAL SOIL LOSS FOR AREA ',F6.2,
     1                ' TONNES/HECTARE',/,
     1            29X,'(AREA = ',F8.4,' HECTARES)')
5008   FORMAT(24X,'TOTAL SOIL LOSS  ',F6.2,' TONES/HECTARE',/,
     1        24X,'ENRICHMENT RATIO  ',F7.3)
       END
