c$DEBUG
       SUBROUTINE OUTCH2(INDXC,NDATES,CDATE,NYEARS,DNYEAR,METFLG)
       COMMON /ROUT/ NXK,XSOIL(4),KSOIL(4),NXF,XFACT(4),CFACT(4,40),
     1               PFACT(4,40),NFACT(4,40),DAOVR,SLNGTH,
     1               NXC1,XCHN1(4),NCHN1(4,40),CCHN1(4,40),SCHN1(4,40),
     1               DCHN1(4,40),WCHN1(4,40),FLAGC1,FLAGS1,CTLO1,
     1               CTLZ1,CTLN1,CTLSL1,RA1,RN1,YBASE1,DACHU1,
     1               DACHL1,Z1,LNGTH1,LEFF1,
     1               NXC2,XCHN2(4),NCHN2(4,40),CCHN2(4,40),SCHN2(4,40),
     1               DCHN2(4,40),WCHN2(4,40),FLAGC2,FLAGS2,CTLO2,
     1               CTLZ2,CTLN2,CTLSL2,RA2,RN2,YBASE2,DACHU2,
     1               DACHL2,Z2,LNGTH2,LEFF2                             out
       COMMON /CHAN/ XSTAR(2,40),DEPA(2,40),DEPB(2,40),WIDA(2,40),
     1               WIDB(2,40),WERA(2,40),WERB(2,40)
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       DIMENSION DISTM1(4),TCHN1(4,40),SIDE1(4,40),CENT1(4,40)
       DIMENSION WIDT1(4,40),DISTM2(4)
       DIMENSION TCHN2(4,40),SIDE2(4,40),CENT2(4,40),WIDT2(4,40)
       REAL KSOIL,NFACT,NCHN1,NCHN2,LNGTH1,LEFF1,LNGTH2,LEFF2
       INTEGER CDATE(NDATES),DNYEAR(NYEARS),DATBEG,DATEND,              out
     1         FLAGC1,FLAGS1,CTLO1,FLAGC2,FLAGS2,CTLO2
       save
       WRITE (LUN08,4000) INDXC,NYEARS
       DATBEG = 1
       DO 50 NYEAR=1,NYEARS
           DATEND = DATBEG+DNYEAR(NYEAR)-1
           WRITE (LUN08,4001) NYEAR,(CDATE(IDATE),IDATE=DATBEG,DATEND)
           IF(INDXC.EQ.2) GO TO 21
           IF(METFLG .EQ. 0) THEN
           DO 10 I=1,NXC1
               WRITE (LUN08,4002) XCHN1(I)
               WRITE (LUN08,4003) (NCHN1(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4004) (CCHN1(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4005) (SCHN1(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4006) (DCHN1(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4007) (WCHN1(I,IDATE),IDATE=DATBEG,DATEND)
  10       CONTINUE
           ELSE
               DO 13 J=1,NXC1
                  DO 12 K=DATBEG,DATEND
                     TCHN1(J,K)=CCHN1(J,K)*0.4882
                     SIDE1(J,K)=SCHN1(J,K)/3.281
                     CENT1(J,K)=DCHN1(J,K)/3.281
                     WIDT1(J,K)=WCHN1(J,K)/3.281
  12              CONTINUE
                  DISTM1(J)=XCHN1(J)/3.281
                  WRITE (LUN08,5002) DISTM1(J)
                  WRITE (LUN08,4003) (NCHN1(J,M),M=DATBEG,DATEND)
                  WRITE (LUN08,5004) (TCHN1(J,M),M=DATBEG,DATEND)
                  WRITE (LUN08,5005) (SIDE1(J,M),M=DATBEG,DATEND)
                  WRITE (LUN08,5006) (CENT1(J,M),M=DATBEG,DATEND)
                  WRITE (LUN08,5007) (WIDT1(J,M),M=DATBEG,DATEND)
  13           CONTINUE
           ENDIF
           GO TO 40
  20       CONTINUE
  21       CONTINUE
           IF(METFLG .EQ. 0) THEN
           DO 30 I=1,NXC2
               WRITE (LUN08,4002) XCHN2(I)
               WRITE (LUN08,4003) (NCHN2(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4004) (CCHN2(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4005) (SCHN2(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4006) (DCHN2(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4007) (WCHN2(I,IDATE),IDATE=DATBEG,DATEND)
  30       CONTINUE
           ELSE
               DO 33 J=1,NXC2
                  DISTM2(J)=XCHN2(J)/3.281
                  DO 32 K=DATBEG,DATEND
                     TCHN2(J,K)=CCHN2(J,K)*0.4882
                     SIDE2(J,K)=SCHN2(J,K)/3.281
                     CENT2(J,K)=DCHN2(J,K)/3.281
                     WIDT2(J,K)=WCHN2(J,K)/3.281
  32              CONTINUE
                  WRITE (LUN08,5002) DISTM2(J)
                  WRITE (LUN08,4003) (NCHN2(J,M),M=DATBEG,DATEND)
                  WRITE (LUN08,5004) (TCHN2(J,M),M=DATBEG,DATEND)
                  WRITE (LUN08,5005) (SIDE2(J,M),M=DATBEG,DATEND)
                  WRITE (LUN08,5006) (CENT2(J,M),M=DATBEG,DATEND)
                  WRITE (LUN08,5007) (WIDT2(J,M),M=DATBEG,DATEND)
  33           CONTINUE
           ENDIF
  40       CONTINUE
           DATBEG = DATBEG+DNYEAR(NYEAR)
  50   CONTINUE
       RETURN
4000   FORMAT(' ',//,20X,'CHANNEL ',I1,' COVER AND MANAGEMENT',
     1                   ' PARAMETERS',/,
     1               20X,41('-'),//,
     1               16X,'(ONE TABLE FOR EACH YEAR OF THE ',I2,
     1                   ' YEAR ROTATION)')
4001   FORMAT(' ',//,36X,'YEAR ',I2,//,1X,'DATES:',12X,10I8)
4002   FORMAT(' ',/,1X,'X = ',F6.1,' FT')
4003   FORMAT(' ','MANNINGS N         ',10(F8.3))
4004   FORMAT(' ','CR SHEAR (LB/FT**2)',10(F8.3))
4005   FORMAT(' ','DEPTH SIDE (FT)    ',10(F7.2,1X))
4006   FORMAT(' ','DEPTH MIDDLE (FT)  ',10(F7.2,1X))
4007   FORMAT(' ','WIDTH (FT)         ',10(F5.0,3X))
5002   FORMAT(' ',/,1X,'X = ',F6.1,' M')
5004   FORMAT(' ','CR SHEAR (G/CM**2) ',10(F8.3))
5005   FORMAT(' ','DEPTH SIDE (M)     ',10(F7.2,1X))
5006   FORMAT(' ','DEPTH MIDDLE (M)   ',10(F7.2,1X))
5007   FORMAT(' ','WIDTH (M)          ',10(F5.0,3X))
       END
       SUBROUTINE OUTOV1(FLAGOV,AVGSLP,NPTSO,XPOVR,SPOVR,METFLG,NSEG)
       COMMON /ROUT/ NXK,XSOIL(4),KSOIL(4),NXF,XFACT(4),CFACT(4,40),
     1               PFACT(4,40),NFACT(4,40),DAOVR,SLNGTH,
     1               NXC1,XCHN1(4),NCHN1(4,40),CCHN1(4,40),SCHN1(4,40),
     1               DCHN1(4,40),WCHN1(4,40),FLAGC1,FLAGS1,CTLO1,
     1               CTLZ1,CTLN1,CTLSL1,RA1,RN1,YBASE1,DACHU1,
     1               DACHL1,Z1,LNGTH1,LEFF1,
     1               NXC2,XCHN2(4),NCHN2(4,40),CCHN2(4,40),SCHN2(4,40),
     1               DCHN2(4,40),WCHN2(4,40),FLAGC2,FLAGS2,CTLO2,
     1               CTLZ2,CTLN2,CTLSL2,RA2,RN2,YBASE2,DACHU2,
     1               DACHL2,Z2,LNGTH2,LEFF2                             out
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       REAL XPOVR(40),SPOVR(40),KSOIL,NFACT,NCHN1,NCHN2,LNGTH1,LEFF1,
     1      LNGTH2,LEFF2
       INTEGER FLAGOV(10),       FLAGC1,FLAGS1,CTLO1,FLAGC2,FLAGS2,CTLO2 out
       save
       DACRES = DAOVR/43560.0
       IF(METFLG .EQ. 0) THEN
          WRITE (LUN08,8000) DACRES,SLNGTH,AVGSLP
       ELSE
          AREA=DACRES/2.471
          SLN=SLNGTH/3.281
          WRITE (LUN08,9000) AREA,SLN,AVGSLP
       ENDIF
       WRITE(LUN08,8001)
       IF(NSEG.EQ.1)THEN
          IF(FLAGOV(1).EQ.1)WRITE(LUN08,8002)
             IF(FLAGOV(1).EQ.0)WRITE(LUN08,8003)
                IF(FLAGOV(1).EQ.-1)WRITE(LUN08,8004)
       ELSE
          DO 10 I=1,NSEG
             IF(FLAGOV(I).EQ.2)WRITE(LUN08,8005) I
             IF(FLAGOV(I).EQ.1)WRITE(LUN08,8006) I
             IF(FLAGOV(I).EQ.0) WRITE(LUN08,8007) I
             IF(FLAGOV(I).EQ.-1) WRITE(LUN08,8008) I
             IF(FLAGOV(I).EQ.-2)WRITE(LUN08,8009) I
  10      CONTINUE
      ENDIF
      IF(METFLG .EQ. 0) THEN
         WRITE(LUN08,8010)
          DO 20 I=1,NPTSO
             XSTAR = XPOVR(I)/SLNGTH
             WRITE(LUN08,8012) XPOVR(I),XSTAR,SPOVR(I)
  20      CONTINUE
       ELSE
         WRITE(LUN08,9010)
          DO 22 I=1,NPTSO
             DIST   =XPOVR(I)/3.281
             XSTAR = XPOVR(I)/SLNGTH
             WRITE(LUN08,8012) DIST,XSTAR,SPOVR(I)
  22      CONTINUE
       ENDIF
       IF(METFLG .EQ. 0) THEN
          WRITE(LUN08,8011)
             DO 30 I=1,NXK
                XSTAR=XSOIL(I)/SLNGTH
                WRITE(LUN08,8012) XSOIL(I),XSTAR,KSOIL(I)
  30         CONTINUE
       ELSE
          WRITE(LUN08,9011)
             DO 32 I=1,NXK
                XDST = XSOIL(I)/3.281
                XSTAR=XSOIL(I)/SLNGTH
                WRITE(LUN08,8012) XDST,XSTAR,KSOIL(I)
  32         CONTINUE
       ENDIF
       RETURN
8000   FORMAT(' ',/////,
     1            30X,'OVERLAND FLOW INPUTS',///,
     1            28X,'OVERLAND FLOW TOPOGRAPHY',/,
     1            28X,'------------------------',//,
     1            24X,'OVERLAND AREA       ',F10.4,' ACRES',/,
     1            24X,'SLOPE LENGTH        ',F8.2,'   FT',/,
     1            24X,'AVERAGE SLOPE       ',F10.4)
8001   FORMAT(' ',///,17X,'SEGMENT TYPES DEFINING THE OVERLAND',
     1                    ' FLOW PROFILE ',/,
     1                17X,48('-'),/)
8002   FORMAT(' ',27X,'THE PROFILE IS SIMPLE CONVEX')
8003   FORMAT(' ',27X,'THE PROFILE IS UNIFORM')
8004   FORMAT(' ',27X,'THE PROFILE IS SIMPLE CONCAVE')
8005   FORMAT(' ',27X,'SEGMENT',I2, ' IS A SHARP CONVEX SLOPE BREAK')
8006   FORMAT(' ',27X,'SEGMENT',I2, ' IS CONVEX')
8007   FORMAT(' ',27X,'SEGMENT',I2, ' IS UNIFORM')
8008   FORMAT(' ',27X,'SEGMENT',I2, ' IS CONCAVE')
8009   FORMAT(' ',27X,'SEGMENT',I2, ' IS A SHARP CONCAVE SLOPE BREAK')
8010   FORMAT(' ',///,17X,'SLOPE STEEPNESS ALONG THE',
     1                    ' OVERLAND FLOW PROFILE',/,
     1            17X,47('-'),//,
     1            25X,'DISTANCE    DISTANCE      SLOPE',/,
     1            25X,'  FEET       NONDIM.',/,
     1            25X,'--------    --------    --------')
8011   FORMAT(' ',//,17X,'SOIL ERODIBILITY ALONG THE',
     1                   ' OVERLAND FLOW PROFILE',/,
     1            17X,48('-'),//,
     1            25X,'DISTANCE    DISTANCE      SOIL',/,
     1            25X,'  FEET       NONDIM.      EROD',/,
     1            25X,'--------    --------    --------')
8012   FORMAT(' ', 24X,F7.1,2(4X,F8.3))
9000   FORMAT(' ',/////,
     1            30X,'OVERLAND FLOW INPUTS',///,
     1            28X,'OVERLAND FLOW TOPOGRAPHY',/,
     1            28X,'------------------------',//,
     1            24X,'OVERLAND AREA       ',F10.4,' HECTARES',/,
     1            24X,'SLOPE LENGTH        ',F8.2,'    M',/,
     1            24X,'AVERAGE SLOPE       ',F10.4)
9010   FORMAT(' ',///,17X,'SLOPE STEEPNESS ALONG THE',
     1                    ' OVERLAND FLOW PROFILE',/,
     1            17X,47('-'),//,
     1            25X,'DISTANCE    DISTANCE      SLOPE',/,
     1            25X,' METERS      NONDIM.',/,
     1            25X,'--------    --------    --------')
9011   FORMAT(' ',//,17X,'SOIL ERODIBILITY ALONG THE',
     1                   ' OVERLAND FLOW PROFILE',/,
     1            17X,48('-'),//,
     1            25X,'DISTANCE    DISTANCE      SOIL',/,
     1            25X,' METERS      NONDIM.      EROD',/,
     1            25X,'--------    --------    --------')
       END
       SUBROUTINE OUTOV2(NDATES,CDATE,NYEARS,DNYEAR,METFLG)
       COMMON /ROUT/ NXK,XSOIL(4),KSOIL(4),NXF,XFACT(4),CFACT(4,40),
     1               PFACT(4,40),NFACT(4,40),DAOVR,SLNGTH,
     1               NXC1,XCHN1(4),NCHN1(4,40),CCHN1(4,40),SCHN1(4,40),
     1               DCHN1(4,40),WCHN1(4,40),FLAGC1,FLAGS1,CTLO1,
     1               CTLZ1,CTLN1,CTLSL1,RA1,RN1,YBASE1,DACHU1,
     1               DACHL1,Z1,LNGTH1,LEFF1,
     1               NXC2,XCHN2(4),NCHN2(4,40),CCHN2(4,40),SCHN2(4,40),
     1               DCHN2(4,40),WCHN2(4,40),FLAGC2,FLAGS2,CTLO2,
     1               CTLZ2,CTLN2,CTLSL2,RA2,RN2,YBASE2,DACHU2,
     1               DACHL2,Z2,LNGTH2,LEFF2                             out
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       REAL KSOIL,NFACT,NCHN1,NCHN2,LNGTH1,LEFF1,LNGTH2,LEFF2
       INTEGER DATBEG,DATEND,CDATE(NDATES),DNYEAR(NYEARS),              out
     1         FLAGC1,FLAGS1,CTLO1,FLAGC2,FLAGS2,CTLO2
       save
       WRITE (LUN08,4000) NYEARS
       DATBEG = 1
       DO 20 NYEAR=1,NYEARS
           DATEND = DATBEG+DNYEAR(NYEAR)-1
           WRITE (LUN08,4001) NYEAR,(CDATE(IDATE),IDATE=DATBEG,DATEND)
           DO 10 I=1,NXF
               IF(METFLG .EQ. 0) THEN
                  WRITE (LUN08,4002) XFACT(I)
               ELSE
                  XF=XFACT(I)/3.281
                  WRITE (LUN08,5002) XF
               ENDIF
               WRITE (LUN08,4003) (CFACT(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4004) (PFACT(I,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4005) (NFACT(I,IDATE),IDATE=DATBEG,DATEND)
  10       CONTINUE
           DATBEG = DATBEG+DNYEAR(NYEAR)
  20   CONTINUE
       RETURN
4000   FORMAT(' ',//,18X,'OVERLAND FLOW COVER AND MANAGEMENT',
     1                   ' PARAMETERS',/,
     1               18X,45('-'),//,
     1               16X,'(ONE TABLE FOR EACH YEAR OF THE ',I2,
     1                   ' YEAR ROTATION)')
4001   FORMAT(' ',//,36X,'YEAR ',I2,//,1X,'DATES:',12X,10I8)
4002   FORMAT(' ',/,1X,'X = ',F6.1,' FT')
4003   FORMAT(' ','SOIL LOSS RATIO    ',10(F8.3))
4004   FORMAT(' ','CONTOURING FACTOR  ',10(F7.2,1X))
4005   FORMAT(' ','MANNINGS N         ',10(F8.3))
5002   FORMAT(' ',/,1X,'X = ',F6.1,' M ')
       END
       SUBROUTINE OUTPND(METFLG)
       COMMON /POND/ CTL,PAC,DAPND,INTAKE,FRONT,DRAW,SIDE,FS,B,DIAO,C
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       REAL INTAKE,INTAKI
       INTEGER CTL,PAC
       save
       DACRE  = DAPND/43560.0
       INTAKI = INTAKE*43200.0
       IF(METFLG .EQ. 0) THEN
          WRITE (LUN08,4000) DACRE,INTAKI,FS,B
       ELSE
          AREA=DACRE/2.471
          SEEP=INTAKI*2.54
          WRITE (LUN08,5000) AREA,SEEP,FS,B
       ENDIF
       IF(PAC.GT.1) GO TO 10
       WRITE (LUN08,4001) FRONT,DRAW,SIDE
       GO TO 20
  10   CONTINUE
       WRITE (LUN08,4002)
  20   CONTINUE
       WRITE (LUN08,4003)
       IF(CTL.GT.1) GO TO 30
       IF(METFLG .EQ. 0) THEN
          WRITE (LUN08,4004) DIAO,C
       ELSE
          DIAM=DIAO/3.281
          WRITE (LUN08,5004) DIAM,C
       ENDIF
       RETURN
  30   CONTINUE
       WRITE (LUN08,4005) C
       RETURN
4000   FORMAT(' ',////,32X,'IMPOUNDMENT INPUTS',/,
     1            32X,18('-'),//,
     1            26X,'DRAINAGE AREA ',F10.4,' ACRES',/,
     1            26X,'INTAKE RATE   ',F8.2,'   IN/HR',//,
     1            31X,'IMPOUNDMENT GEOMETRY',/,
     1            26X,'(SURFACE AREA = FS * DEPTH**B)',/,
     1            34X,'FS = ',F9.1,/,
     1            34X,'B  = ',F10.2)
4001   FORMAT(' ',/,31X,'COMPUTED FROM SLOPES:',/,
     1            35X,'FRONT = ',F5.3,/,
     1            35X,'DRAW  = ',F5.3,/,
     1            35X,'SIDE  = ',F5.3)
4002   FORMAT(' ',/,33X,'SUPPLIED BY USER')
4003   FORMAT(' ',/,33X,'IMPOUNDMENT EXIT',/,
     1            31X,'(Q = C * SQRT(DEPTH))')
4004   FORMAT(' ',23X,'WATER EXITS THROUGH A PIPE OUTLET',/,
     1            24X,'ORIFICE DIAMETER   = ',F9.2,' FT',/,
     1            24X,'ORIFICE COEFICIENT = ',F8.1)
4005   FORMAT(' ',27X,'ORIFICE COEFICIENT READ IN',/,35X,'C = ',F8.1)
5000   FORMAT(' ',////,32X,'IMPOUNDMENT INPUTS',/,
     1            32X,18('-'),//,
     1            26X,'DRAINAGE AREA ',F10.4,' HECTARES',/,
     1            26X,'INTAKE RATE   ',F8.2,'   CM/HR',//,
     1            31X,'IMPOUNDMENT GEOMETRY',/,
     1            26X,'(SURFACE AREA = FS * DEPTH**B)',/,
     1            34X,'FS = ',F9.1,/,
     1            34X,'B  = ',F10.2)
5004   FORMAT(' ',23X,'WATER EXITS THROUGH A PIPE OUTLET',/,
     1            24X,'ORIFICE DIAMETER   = ',F9.4,' M ',/,
     1            24X,'ORIFICE COEFICIENT = ',F8.1)
       END
      SUBROUTINE PROFIL(XTEMP,SLTEMP,XPT,SPT,NPTSO,AVGSLP,SLNGTH,
     1                 FLAGO,NSEG)
C
      COMMON /ARRAY/ X1(40),S1(40),X2(40),S2(40)
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
C
      REAL XTEMP(40),SLTEMP(40),XPT(40),SPT(40)
      INTEGER FLAGO(10)
      save
C
      NEWPTS=1
      NSEG=1
      ILAST=1
      INOW=ILAST
C
      IF((NPTSO.GT.10).OR.(NPTSO.LE.0))THEN
         WRITE(*,1000) NPTSO
         WRITE(LUN08,1000) NPTSO
         STOP
      ENDIF
C
       IF(XTEMP(NPTSO).EQ.0.0)THEN
         WRITE(*,2000)
         WRITE(LUN08,2000)
         STOP
      ENDIF
C
      np = 0
      IF(NPTSO.EQ.1)THEN
         XPT(1)=0.0
         SPT(1)=SLTEMP(1)
         XPT(2)=XTEMP(1)
         SPT(2)=SPT(1)
         AVGSLP=SPT(2)
         SLNGTH=XPT(2)
         FLAGO(1)=0
         NPTSO=2
         np = 1
      ENDIF
C
      IF((XTEMP(1).EQ.0.0.AND.XTEMP(2).EQ.0.0).OR.(XTEMP(NPTSO-1).EQ.
     1XTEMP(NPTSO))) THEN
         WRITE(*,3000) XTEMP(1),XTEMP(2),XTEMP(NPTSO-1),XTEMP(NPTSO)
         WRITE(LUN08,3000) XTEMP(1),XTEMP(2),XTEMP(NPTSO-1),XTEMP(NPTSO)
         STOP
      ENDIF
C
      if (np .eq. 1) return
C
      SLNGTH=XTEMP(NPTSO)
      AVGSLP=0.0
C
      IF(NPTSO.EQ.2)THEN
         IF(XTEMP(1).NE.0.0)GO TO 30
            IF(SLTEMP(1).EQ.SLTEMP(2))THEN
               XPT(1)=0.0
               SPT(1)=SLTEMP(1)
               XPT(2)=SLNGTH
               SPT(2)=SPT(1)
               AVGSLP=SPT(2)
               FLAGO(1)=0
               RETURN
            ELSE
               XTEMP(1)=0.0
               DLENG=SLNGTH/5.0
               DO 10 J=1,6
                  XPT(J)=FLOAT(J-1)*DLENG
                  CALL TABLE(2,2,XTEMP,SLTEMP,XPT(J),SLOPE)
                  SPT(J)=SLOPE
 10            CONTINUE
               DO 20 J=2,6
                  DELX=XPT(J)-XPT(J-1)
                  DELS=(SPT(J)+SPT(J-1))/2.0
                  AVGSLP=AVGSLP+((DELX*DELS)/SLNGTH)
 20            CONTINUE
               IF(SLTEMP(2).GT.SLTEMP(1))THEN
                  FLAGO(1)=1
               ELSE
                  FLAGO(1)=-1
               ENDIF
               NPTSO=6
               RETURN
            ENDIF
      ENDIF
C
 30   IF(XTEMP(1).NE.0.0)THEN
         X1(1)=0.0
         S1(1)=SLTEMP(1)
         NPTSO=NPTSO+1
         DO 40 I=2,NPTSO
            X1(I)=XTEMP(I-1)
            S1(I)=SLTEMP(I-1)
 40      CONTINUE
      ELSE
         DO 50 I=1,NPTSO
            X1(I)=XTEMP(I)
            S1(I)=SLTEMP(I)
 50      CONTINUE
      ENDIF
C
      X2(1)=X1(1)
      S2(1)=S1(1)
C
      IF(S1(2).GT.S1(1))IFLAG=1
      IF(S1(2).EQ.S1(1))IFLAG=0
      IF(S1(2).LT.S1(1))IFLAG=-1
C
      FLAGO(NSEG)=IFLAG
      NSEG=NSEG+1
C
      DO 60 I=2,NPTSO
C
         IF((X1(I).LT.X1(I-1)).OR.(S1(I).LT.0.0))THEN
            WRITE(*,4000) X1(I),S1(I)
            WRITE(LUN08,4000) X1(I),S1(I)
            STOP
         ENDIF
C
         IF(S1(I).GT.S1(I-1))THEN
            IF(X1(I).EQ.X1(I-1))THEN
               INOW=I-1
               CALL NEWPT1(I,IFLAG,ILAST,INOW,NPTSO,NEWPTS,SLNGTH)
               IFLAG=1
               FLAGO(NSEG)=2
               NSEG=NSEG+1
            ELSE
               IF(IFLAG.NE.1)THEN
                  IF(IFLAG.EQ.0)THEN
                     INOW=I-1
                     IFLAG=1
                     FLAGO(NSEG)=IFLAG
                     NSEG=NSEG+1
                     NEWPTS=NEWPTS+1
                     X2(NEWPTS)=X1(INOW)
                     S2(NEWPTS)=S1(INOW)
                     ILAST=INOW
                  ELSE
                     INOW=I-1
                     IFLAG=1
                     FLAGO(NSEG)=IFLAG
                     NSEG=NSEG+1
                     IF(INOW.NE.ILAST)
     1               CALL NEWPT2(ILAST,INOW,NPTSO,NEWPTS)
                  ENDIF
               ENDIF
            ENDIF
         ELSE IF(S1(I).EQ.S1(I-1))THEN
            IF(IFLAG.NE.0)THEN
               INOW=I-1
               IFLAG=0
               FLAGO(NSEG)=IFLAG
               NSEG=NSEG+1
               IF(INOW.NE.ILAST)
     1         CALL NEWPT2(ILAST,INOW,NPTSO,NEWPTS)
            ENDIF
         ELSE IF(S1(I).LT.S1(I-1))THEN
            IF(X1(I).EQ.X1(I-1))THEN
               INOW=I-1
               CALL NEWPT1(I,IFLAG,ILAST,INOW,NPTSO,NEWPTS,SLNGTH)
               IFLAG=-1
               FLAGO(NSEG)=-2
               NSEG=NSEG+1
            ELSE
               IF(IFLAG.NE.-1)THEN
                  IF(IFLAG.EQ.0)THEN
                     INOW=I-1
                     IFLAG=-1
                     FLAGO(NSEG)=IFLAG
                     NSEG=NSEG+1
                     NEWPTS=NEWPTS+1
                     X2(NEWPTS)=X1(INOW)
                     S2(NEWPTS)=S1(INOW)
                     ILAST=INOW
                  ELSE
                     INOW=I-1
                     IFLAG=-1
                     FLAGO(NSEG)=IFLAG
                     NSEG=NSEG+1
                     IF(INOW.NE.ILAST)
     1               CALL NEWPT2(ILAST,INOW,NPTSO,NEWPTS)
                  ENDIF
               ENDIF
            ENDIF
         ELSE
         ENDIF
C
         IF(I.EQ.NPTSO)THEN
            INOW=NPTSO
            NSEG=NSEG-1
            IF(S1(I).EQ.S1(I-1))THEN
               NEWPTS=NEWPTS+1
               X2(NEWPTS)=X1(INOW)
               S2(NEWPTS)=S1(INOW)
            ELSE
               CALL NEWPT2(ILAST,INOW,NPTSO,NEWPTS)
            ENDIF
         ENDIF
C
         IF(NEWPTS.GT.26)THEN
            WRITE(*,5000)NEWPTS
            WRITE(LUN08,5000)NEWPTS
            STOP
         ENDIF
C
 60   CONTINUE
C
      NPTSO=NEWPTS
C
      DO 70 J=1,NPTSO
         XPT(J)=X2(J)
         SPT(J)=S2(J)
 70   CONTINUE
C
      DO 80 J=2,NPTSO
         DELX=XPT(J)-XPT(J-1)
         DELS=(SPT(J)+SPT(J-1))/2.0
         AVGSLP=AVGSLP+((DELX*DELS)/SLNGTH)
 80   CONTINUE
C
 1000 FORMAT(' ',///,10X,'RUN STOPPED : INPUT ERROR',/,
     1               10X,25('-'),//,
     1               10X,'THE NUMBER OF POINTS READ IN MUST BE',/,
     1               10X,'GREATER THAN ZERO OR LESS THAN OR',/,
     1               10X,'EQUAL TO TEN',//,
     1               10X,'NPTSO=',I3)
 2000 FORMAT(' ',///,10X,'RUN STOPPED : INPUT ERROR',/,
     1               10X,25('-'),//,
     1               10X,'EITHER THE LAST DISTANCE POINT',/,
     1               10X,'WAS READ IN AS ZERO',/,
     1               10X,'              OR                       ',/,
     1               10X,'THE NUMBER OF DISTANCE AND SLOPE POINTS',/,
     1               10X,'READ IN WAS LESS THAN NPTSO ',/,
     1               10X,'              OR                    ',/,
     1               10X,'ONLY ONE POINT WAS READ IN AND THE',/,
     1               10X,'DISTANCE WAS ZERO')
 3000 FORMAT(' ',///,10X,'RUN STOPPED : INPUT ERROR',/,
     1               10X,25('-'),//,
     1               10X,'FIRST TWO DISTANCE POINTS CAN NOT BE ZERO',/,
     1               10X,'LAST TWO DISTANCE POINTS CAN NOT BE EQUAL',//,
     1               10X,'XTEMP(1)=',F8.2,', XTEMP(2)=',F8.2,/,
     1               10X,'XTEMP(NPTSO-1)=',F8.2,', XTEMP(NPTSO)=',F8.2)
 4000 FORMAT(' ',///,10X,'RUN STOPPED : INPUT ERROR',/,
     1               10X,25('-'),//,
     1               10X,'DISTANCE POINTS MUST ALWAYS INCREASE',/,
     1               10X,'SLOPE CAN NOT BE NEGATIVE',//,
     1               10X,'XTEMP =',F8.2,' , SLTEMP =',F8.2)
 5000 FORMAT(' ',///,10X,'RUN STOPPED : INPUT ERROR',/,
     1               10X,25('-'),//,
     1               10X,'THERE ARE TOO MANY CURVED SLOPED SEGMENTS',//,
     1               10X,'MAXIMUM NUMBER OF SEGMENTS ALLOWED : ',//,
     1               10X,'1) TWO CONCAVE AND TWO CONVEX WITH EACH ',/,
     1               10X,'   BEING SEPARATED BY A UNIFORM SEGMENT',/,
     1               10X,'               OR                ',/,
     1               10X,'2) TWO CONCAVE AND THREE CONVEX OR THREE',/,
     1               10X,'   CONCAVE AND TWO CONVEX IN DIFFERENT',/,
     1               10X,'   COMBINATIONS (FIVE CURVED - NO UNIFORM)'//,
     1               10X,'THE SUBROUTINE ADDS POINTS TO CURVED',/,
     1               10X,'SEGMENTS - THE TOTAL NUMBER OF POINTS',/,
     1               10X,'SHOULD BE LESS THAN OR EQUAL TO 26',//,
     1               10X,'TOTAL NUMBER OF POINTS RETURNED',/,
     1               10X,'BEFORE EXITING MAIN LOOP =',I3)
      RETURN
      END
       SUBROUTINE PRTCMP
C       FOSTER & NEIBLING PARTICLE SIZES FOR LARGE AND SMALL AGGREGATES.
       COMMON /PART/NPART,DIA(10),SPGR(10),FRAC(10),FALL(10),EQSAND(10),
     1               SOLCLY,SOLSLT,SOLSND,SOLORG,SSCLY,SSSLT,SSSND,
     1               SSORG,SSSOIL,FRCLY(10),FRSLT(10),FRSND(10),
     1               FRORG(10),DCL(11),DDCL(10)                         out
c      INTEGER FLGPRT                                                   out
       save
       DIA(1)   = 0.002
       DIA(2)   = 0.010
       DIA(4)   = 0.300
        IF(SOLCLY .GT. 0.15) DIA(4)   =2.0*SOLCLY
       DIA(5)   = 0.200
       SPGR(1)   = 2.60
       SPGR(2)   = 2.65
       SPGR(3)   = 1.80
       SPGR(4)   = 1.60
       SPGR(5)   = 2.65
       FRAC(1)  = 0.26*SOLCLY
       FRAC(5)  = SOLSND*(1.0-SOLCLY)**5.
       IF(SOLCLY.GT.0.25) GO TO 10
       DIA(3)   = 0.030
       FRAC(3)  = 1.8*SOLCLY
       GO TO 40
  10   CONTINUE
       IF(SOLCLY.GE.0.60) GO TO 20
       DIA(3)   = 0.20*(SOLCLY-0.25)+0.030
       IF(SOLCLY.GE.0.50) GO TO 30
       FRAC(3)  = 0.45-0.6*(SOLCLY - 0.25)
       GO TO 40
  20   CONTINUE
       DIA(3)   = 0.1
  30   CONTINUE
       FRAC(3)  = 0.60 * SOLCLY
  40   CONTINUE
       FRAC(2)  = SOLSLT - FRAC(3)
        IF (FRAC(2) .GT. 0.0 ) GO TO 45
        FRAC(2) = 0.0001
        FRAC(3) = SOLSLT - FRAC(2)
  45   CONTINUE
       FRAC(4)  = 1.0-FRAC(1)-FRAC(2)-FRAC(3)-FRAC(5)
       IF(FRAC(4).GT.0.0) GO TO 60
       CRCT     = 1.0/(1.0+ABS(FRAC(4))+0.0001)
        FRAC(4) = 0.0001
       DO 50 K=1,NPART
           FRAC(K) = FRAC(K)*CRCT
  50   CONTINUE
  60   CONTINUE
       RATIOM   = SOLORG/SOLCLY
       FRCLY(1) = 1.0
       FRSLT(1) = 0.0
       FRSND(1) = 0.0
       FRORG(1) = FRCLY(1)*RATIOM
       FRCLY(2) = 0.0
       FRSLT(2) = 1.0
       FRSND(2) = 0.0
       FRORG(2) = FRCLY(2)*RATIOM
       FRCLY(3) = SOLCLY/(SOLCLY+SOLSLT)
       FRSLT(3) = SOLSLT/(SOLCLY+SOLSLT)
       FRSND(3) = 0.0
       FRORG(3) = FRCLY(3)*RATIOM
       FRCLY(4) = (SOLCLY-FRAC(1)-(FRCLY(3)*FRAC(3)))/FRAC(4)
       FRSLT(4) = (SOLSLT-FRAC(2)-(FRSLT(3)*FRAC(3)))/FRAC(4)
       FRSND(4) = (SOLSND-FRAC(5))/FRAC(4)
       FRORG(4) = FRCLY(4)*RATIOM
       FRCLY(5) = 0.0
       FRSLT(5) = 0.0
       FRSND(5) = 1.0
       FRORG(5) = FRCLY(5)*RATIOM
       FRCLYT   = 0.5*SOLCLY
       FRCLY1   = 0.95*FRCLYT
       IF(FRCLY(4).GE.FRCLY1) RETURN
       F1F2F5   = FRAC(1)+FRAC(2)+FRAC(5)
       FRCLY(4) = FRCLYT
       FRAC(3)  = (SOLCLY-FRCLY(4)-FRAC(1)+FRCLY(4)*F1F2F5)/
     1            (FRCLY(3)-FRCLY(4))
       GO TO 40
       END
       SUBROUTINE RILL(X,SLOPE,KEROD,CROP,PRACT,MAXE,EXCESS,DF)
       COMMON /PASS/ SDATE,RNFALL,RUNOFF,EXRAIN,EI
       COMMON /PART/NPART,DIA(10),SPGR(10),FRAC(10),FALL(10),EQSAND(10),
     1               SOLCLY,SOLSLT,SOLSND,SOLORG,SSCLY,SSSLT,SSSND,
     1               SSORG,SSSOIL,FRCLY(10),FRSLT(10),FRSND(10),
     1               FRORG(10),DCL(11),DDCL(10)                         out
       REAL KEROD,MAXE,DF(10)
       INTEGER SDATE                                                    out
       save
       EXPO   = 2.0
       IF(X.GT.75.0) EXPO = 1.0+1.0245*EXP(-0.0002595*X)
       DETRIL = (0.04597*EXPO/6.574)*(12632.0*RUNOFF*EXRAIN**(1.0/3.0))*
     1          (430.0*SLOPE**2)*((X/72.6)**(EXPO-1.0))*EXRAIN*KEROD*
     1          CROP*PRACT/RUNOFF
       IF(DETRIL.GT.MAXE) DETRIL = MAXE
       DETRIL = EXCESS*DETRIL
       DO 10 K=1,NPART
           DF(K) = DETRIL*FRAC(K)
  10   CONTINUE
       RETURN
       END
C      THIS SUBROUTINE IS USED TO ROUTE SEDIMENT THROUGH THE OVERLAND
C      FLOW AND CHANNEL SECTION OF THE MODEL
C
       SUBROUTINE ROUTE(EROOUT,DATE,NPTS,ELEM,X,SLOPE,GS,CONC,SOLOSS,
     1                  METFLG)
       COMMON /PASS/ SDATE,RNFALL,RUNOFF,EXRAIN,EI
       COMMON /CONS/ AGRAV,MSDH2O,WTDH2O,WTDSOI,KINVIS,KCH,YALCON,BETA,
     1               NBAROV,NBARCH
       COMMON /PART/ NPART,DIA(10),SPG(10),FRAC(10),FALL(10),EQSAND(10),
     1               SOLCLY,SOLSLT,SOLSND,SOLORG,SSCLY,SSSLT,SSSND,
     1               SSORG,SSSOIL,FRCLY(10),FRSLT(10),FRSND(10),
     1               FRORG(10),DCL(11),DDCL(10)                         out
       COMMON /ROUT/ NXK,XSOIL(4),KSOIL(4),NXF,XFACT(4),CFACT(4,40),
     1               PFACT(4,40),NFACT(4,40),DAOVR,SLNGTH,
     1               NXC1,XCHN1(4),NCHN1(4,40),CCHN1(4,40),SCHN1(4,40),
     1               DCHN1(4,40),WCHN1(4,40),FLAGC1,FLAGS1,CTLO1,
     1               CTLZ1,CTLN1,CTLSL1,RA1,RN1,YBASE1,DACHU1,
     1               DACHL1,Z1,LNGTH1,LEFF1,
     1               NXC2,XCHN2(4),NCHN2(4,40),CCHN2(4,40),SCHN2(4,40),
     1               DCHN2(4,40),WCHN2(4,40),FLAGC2,FLAGS2,CTLO2,
     1               CTLZ2,CTLN2,CTLSL2,RA2,RN2,YBASE2,DACHU2,
     1               DACHL2,Z2,LNGTH2,LEFF2                             out
       COMMON /CHAN/ XSTAR(2,40),DEPA(2,40),DEPB(2,40),WIDA(2,40),
     1               WIDB(2,40),WERA(2,40),WERB(2,40)
       COMMON /FLOW/ FLAGS,QB,QE,YCR,YNOR,YE,SFE,RUNPND
       COMMON /R000/ CHECKU,COEFF,CROP,CRSH,CTLN,CTLSL,CTLZ,C1,C3,DAL,
     &               DAU,DEPSID,DX,EATA,EFFSHL,EFFSHU,ENDMAN,EXCESS,
     &               EXCOLD,EXPON,I,ICHAN,IFACT,INDXC,ISOIL,K,NDEP,
     &               NEWP,NEXCES,NK,NT,NT2,NZ,PRACT,QLAT,QLE,QU,RA,
     &               RATEX,RN,SFA,SFL,SFU,SSFB,SSFE,SUMDF,SUMEXD,
     &               SUMPL,SUMPLD,SUMTC,SUMTCL,TEMDEP,TEMWER,WFA,WFL,
     &               WFU,XBEG,XDBIG,XDBMIN,SDEMAX,XDSMAL,YBASE,Z
       REAL X(40),SLOPE(40),GS(10),CONC(10),
     1      DLAT(10),PHI(10),POTLD(10),DTCDX(10),XDE(10),
     1      DDE(10),GSDE(10),GSTDE(10),EXDET(10),XDBEG(10),GSTDB(10),
     1      TCM(10),DU(10),TCU(10),GSU(10),GSTU(10),DL(10),TCL(10),
     1      GSL(10),GSTL(10),DF(10),LEFF,LEFF1,LEFF2,KEROD,NMANOV,
     1      NMANCH,MAXE,KSOIL,NFACT,NCHN1,NCHN2,INTRPL,LNGTH1,LNGTH2,
     1      MSDH2O,KINVIS,KCH,NBAROV,NBARCH
       INTEGER EROOUT,DATE,ELEM,FLAG1,FLAGC,FLAGS,CTLO,SDATE,           out
     1         FLAGC1,FLAGS1,CTLO1,FLAGC2,FLAGS2,CTLO2,FLAGCT           out
       save
       DATA COVSH /1000.0/
       IF(ELEM.EQ.2) GO TO 10
       IF(ELEM.EQ.3) GO TO 20
       DAL    = DAOVR
       LEFF   = SLNGTH
       ISOIL  = 1
       KEROD  = KSOIL(ISOIL)
       IFACT  = 1
       CROP   = CFACT(IFACT,DATE)
       PRACT  = PFACT(IFACT,DATE)
       NMANOV = NFACT(IFACT,DATE)
       EATA   = 0.5
       GO TO 30
  10   CONTINUE
       FLAGCT = FLAGC1
       FLAGS  = FLAGS1
       CTLO   = CTLO1
       CTLZ   = CTLZ1
       CTLN   = CTLN1
       CTLSL  = CTLSL1
       RA     = RA1
       RN     = RN1
       YBASE  = YBASE1
       DAU    = DACHU1
       DAL    = DACHL1
       Z      = Z1
       LEFF   = LEFF1
       ENDMAN = NCHN1(NXC1,DATE)
       ICHAN  = 1
       CRSH   = CCHN1(ICHAN,DATE)
       DEPSID = SCHN1(ICHAN,DATE)
       NMANCH = NCHN1(ICHAN,DATE)
       EATA   = 1.0
       INDXC  = 1
       GO TO 30
  20   CONTINUE
       FLAGCT = FLAGC2
       FLAGS  = FLAGS2
       CTLO   = CTLO2
       CTLZ   = CTLZ2
       CTLN   = CTLN2
       CTLSL  = CTLSL2
       RA     = RA2
       RN     = RN2
       YBASE  = YBASE2
       DAU    = DACHU2
       DAL    = DACHL2
       Z      = Z2
       LEFF   = LEFF2
       ENDMAN = NCHN2(NXC2,DATE)
       ICHAN  = 1
       CRSH   = CCHN2(ICHAN,DATE)
       DEPSID = SCHN2(ICHAN,DATE)
       NMANCH = NCHN2(ICHAN,DATE)
       EATA   = 1.0
       INDXC  = 2
  30   CONTINUE
       SFE    = SLOPE(NPTS)
       DO 740 I=2,NPTS
           IF(I.GT.2) GO TO 90
C
C          INITIALIZE VARIABLES FOR TOP SEGMENT
C
           NEWP   = 1
           IF(ELEM.GT.1) GO TO 50
C
C          INITIALIZE OVERLAND FLOW VARIABLES FOR TOP SEGMENT
C
           EFFSHU = 0.0
           WFU    = 1.0
           SFU    = SLOPE(1)
           QU     = 0.0
           QE     = EXRAIN*LEFF
           QLAT   = EXRAIN
           DO 40 K=1,NPART
               DU(K)   = 0.0
               TCU(K)  = 0.0
               GSU(K)  = 0.0
               GSTU(K) = 0.0
  40       CONTINUE
           GO TO 110
C
C          INITIALIZE CHANNEL VARIABLES FOR TOP SEGMENT
C
  50       CONTINUE
           QB     = EXRAIN*DAU
           QE     = EXRAIN*DAL
           QU     = EXRAIN*DAU
           QLAT   = QE/LEFF
           DO 60 K=1,NPART
               GSTU(K) = QU*CONC(K)
               DLAT(K) = QLAT*CONC(K)
  60       CONTINUE
           CALL FSLPAR(CTLO,CTLZ,CTLN,CTLSL,RA,RN,
     1                 YBASE,Z,ENDMAN,LEFF,IBEG,
     1                 FLAG1,C1,C3,SLOPE(NPTS),SSFE)
           TB     = 2.0*RUNOFF*DAL/QE
           IF(QU.GT.0.0) GO TO 80
           WFU    = 0.0
           FLAGC  = FLAGCT
           IF(FLAGC.EQ.2) WFU = WIDB(INDXC,1)
           EFFSHU = 0.0
           SFU    = 0.0
           DO 70 K=1,NPART
               DU(K)   = 0.0
               TCU(K)  = 0.0
               GSU(K)  = 0.0
               GSTU(K) = 0.0
  70       CONTINUE
           GO TO 110
  80       CONTINUE
           XBEG = XSTAR(INDXC,1)
           IF(FLAGS.EQ.1) CALL FRICHN(QU,NMANCH,Z,C1,C3,
     1                                1,FLAG1,SLOPE(1),XSTAR(INDXC,1),
     1                                LEFF,YE,XBEG,IBEG,SSFB,SSFE,SFU)
           IF(FLAGS.EQ.2) SFU = SLOPE(1)
           IF(SFU.LE.0.0) SFU = 0.000001
           GO TO 110
  90       CONTINUE
           NEWP   = 0
           SFU    = SFL
           QU     = QLE
           WFU    = WFL
           EFFSHU = EFFSHL
           DO 100 K=1,NPART
               DU(K)   = DL(K)
               TCU(K)  = TCL(K)
               GSU(K)  = GSL(K)
               GSTU(K) = GSTL(K)
 100       CONTINUE
 110       CONTINUE
           QLE     = QE*X(I)/LEFF
           DX     = X(I)-X(I-1)
           IF(ELEM.EQ.2) GO TO 140
           IF(ELEM.EQ.3) GO TO 150
           SFL    = SLOPE(I)
           SFA    = (SFL+SFU)/2
           WFL    = 1.0
C
C          TEST WHETHER THE X DEPENDANT VARIABLES NEED TO BE UPDATED
C
           IF(X(I).LE.XSOIL(ISOIL)) GO TO 120
           NEWP   = 1
           ISOIL  = ISOIL+1
           KEROD  = KSOIL(ISOIL)
 120       CONTINUE
           IF(X(I).LE.XFACT(IFACT)) GO TO 130
           NEWP   = 1
           IFACT  = IFACT+1
           CROP   = CFACT(IFACT,DATE)
           PRACT  = PFACT(IFACT,DATE)
           NMANOV = NFACT(IFACT,DATE)
 130       CONTINUE
           CALL INRILL(SFA,KEROD,CROP,PRACT,DLAT)
           IF(NEWP.EQ.1) CALL SHOVR(QU,SFU,NMANOV,EFFSHU)
           CALL SHOVR(QLE,SFL,NMANOV,EFFSHL)
           GO TO 190
 140       CONTINUE
           IF(X(I).LE.XCHN1(ICHAN)) GO TO 160
           NEWP   = 1
           ICHAN  = ICHAN+1
           CRSH   = CCHN1(ICHAN,DATE)
           DEPSID = SCHN1(ICHAN,DATE)
           NMANCH = NCHN1(ICHAN,DATE)
           GO TO 160
 150       CONTINUE
           IF(X(I).LE.XCHN2(ICHAN)) GO TO 160
           NEWP   = 1
           ICHAN  = ICHAN+1
           CRSH   = CCHN2(ICHAN,DATE)
           DEPSID = SCHN2(ICHAN,DATE)
           NMANCH = NCHN2(ICHAN,DATE)
 160       CONTINUE
           XBEG = XSTAR(INDXC,IBEG)
           IF(FLAGS.EQ.1.AND.I.LT.NPTS) CALL FRICHN(QLE,NMANCH,Z,
     1                                              C1,C3,I,FLAG1,
     1                                              SLOPE(I),
     1                                              XSTAR(INDXC,I),
     1                                              LEFF,YE,XBEG,IBEG,
     1                                              SSFB,SSFE,SFL)
           IF(FLAGS.EQ.2.AND.I.LT.NPTS) SFL = SLOPE(I)
           IF(I.EQ.NPTS) SFL = SFE
           IF(SFL.LE.0.0) SFL = 0.000001
           IF(NEWP.EQ.0.OR.QU.EQ.0.0) GO TO 180
           FLAGC  = FLAGCT
           IF(FLAGC.EQ.3.AND.DEPB(INDXC,I-1).EQ.0.0) FLAGC = 2
           CALL HYDCHN(FLAGC,QU,SFU,C1,Z,WIDB(INDXC,I-1),WFU,NMANCH,
     1                CRSH,COVSH,EFFSHU)
           DO 170 K=1,NPART
               GSU(K) = GSTU(K)/WFU
 170       CONTINUE
 180       CONTINUE
           FLAGC  = FLAGCT
           IF(FLAGC.EQ.3.AND.DEPA(INDXC,I).EQ.0.0) FLAGC = 2
           CALL HYDCHN(FLAGC,QLE,SFL,C1,Z,WIDA(INDXC,I),WFL,NMANCH,
     1                 CRSH,COVSH,EFFSHL)
 190       CONTINUE
           WFA    = (WFL+WFU)/2.0
           DO 200 K=1,NPART
               PHI(K)   = EATA*FALL(K)*WFA/QLAT
 200       CONTINUE
           IF(NEWP.EQ.0.OR.QU.EQ.0.0) GO TO 280
           CALL TRNCAP(EFFSHU,TCU,GSU)
           EXCESS = 1.0
           DO 210 K=1,NPART
               IF(TCU(K).EQ.0.0) GO TO 220
               EXCESS   = AMIN1(EXCESS,(1.0-GSU(K)/TCU(K)))
 210       CONTINUE
           IF(EXCESS.GT.0.0) GO TO 240
 220       CONTINUE
           DO 230 K=1,NPART
               DU(K)    = (PHI(K)/X(I-1))*(TCU(K)*WFU-GSTU(K))
               IF(DU(K).GT.0.0) DU(K) = 0.0
 230       CONTINUE
           EXCESS = 1.0
           GO TO 280
 240       CONTINUE
           MAXE   = 1000.0
           IF(ELEM.GT.1) GO TO 250
           CALL RILL(X(I-1),SLOPE(I-1),KEROD,CROP,PRACT,MAXE,EXCESS,DF)
           GO TO 260
 250       CONTINUE
           FLAGC  = FLAGCT
           IF(FLAGC.EQ.3.AND.DEPB(INDXC,I-1).EQ.0.0) FLAGC = 2
           CALL DCAP(1,FLAGC,QU,SFU,C1,Z,EFFSHU,DEPSID,DEPB(INDXC,I-1),
     1               WERB(INDXC,I-1),WFU,NMANCH,CRSH,COVSH,MAXE,
     1               EXCESS,TB,DF)
           IF(FLAGC.EQ.2.AND.WERB(INDXC,I-1).GT.WFU)
     1       WIDB(INDXC,I-1) = WERB(INDXC,I-1)
 260       CONTINUE
           DO 270 K=1,NPART
               DU(K)    = DF(K)*WFU
 270       CONTINUE
           EXCESS = 1.0
 280       CONTINUE
           DO 290 K=1,NPART
               POTLD(K) = (GSTU(K)+DLAT(K)*DX)/WFL
 290       CONTINUE
           CALL TRNCAP(EFFSHL,TCL,POTLD)
           NT     = 0
           NK     = 0
           DO 300 K=1,NPART
               DTCDX(K) = (TCL(K)*WFL-TCU(K)*WFU)/DX
               IF(I.EQ.2.AND.X(1).EQ.0.0.AND.DTCDX(K).LT.DLAT(K))
     1           DU(K)  = (PHI(K)/(1.0+PHI(K)))*(DTCDX(K)-DLAT(K))
               IF(DU(K).GT.0.0) NT = NT+1
               CHECKU   = TCU(K)*WFU
               IF(CHECKU.GT.GSTU(K)) NK = NK+1
 300       CONTINUE
           IF(NK.EQ.NPART) GO TO 540
           IF(NT.EQ.NPART) GO TO 540
           NZ     = 0
           DO 330 K=1,NPART
               COEFF    = 1.0
               XRAT     = X(I-1)/X(I)
               EXPON    = PHI(K)+1.0
               CALL UNDFLO(COEFF,XRAT,EXPON)
               DL(K)    = (PHI(K)/(1.0+PHI(K)))*(DTCDX(K)-DLAT(K))*
     1                    (1.0-XRAT**EXPON)
               COEFF    = ABS(DU(K))
               CALL UNDFLO(COEFF,XRAT,EXPON)
               DL(K)    = DL(K)+(DU(K)*XRAT**EXPON)
               IF(DL(K).GT.0.0) GO TO 310
               NZ       = NZ+1
               XDE(K)   = X(I)
               DDE(K)   = DL(K)
               GSDE(K)  = TCL(K)-(DL(K)*X(I)/PHI(K))/WFL
               GSTDE(K) = GSDE(K)*WFL
               GSL(K)   = GSDE(K)
               GO TO 330
 310           CONTINUE
               IF(DU(K).EQ.0.0) GO TO 320
               XDE(K)   = X(I-1)*(1.0-((1.0+PHI(K))/PHI(K))*
     1                    (DU(K)/(DTCDX(K)-DLAT(K))))**
     1                    (1.0/(1.0+PHI(K)))
               GSTDE(K) = DTCDX(K)*(XDE(K)-X(I-1))+TCU(K)*WFU
               DDE(K)   = 0.0
               GO TO 330
 320           CONTINUE
               XDE(K)   = X(I-1)
               GSDE(K)  = GSU(K)
               GSTDE(K) = GSDE(K)*WFU
               DDE(K)   = 0.0
 330       CONTINUE
           IF(NZ.EQ.NPART) GO TO 720
           XDEMAX = X(I-1)
           DO 340 K=1,NPART
             XDEMAX   = AMAX1(XDEMAX,XDE(K))
 340       CONTINUE
           IF(XDEMAX.LT.X(I)) GO TO 360
           DO 350 K=1,NPART
               IF(XDE(K).EQ.X(I)) GO TO 350
               DL(K)    = 0.0
               GSL(K)   = (GSTDE(K)+DLAT(K)*(X(I)-XDE(K)))/WFL
 350       CONTINUE
           GO TO 720
 360       CONTINUE
           DO 370 K=1,NPART
               DDE(K)   = 0.0
               GSTDE(K) = GSTDE(K)+DLAT(K)*(XDEMAX-XDE(K))
 370       CONTINUE
 380       CONTINUE
           MAXE   = 1000.0
           EXCESS = 1.0
           IF(ELEM.GT.1) GO TO 390
           CALL RILL(X(I),SLOPE(I),KEROD,CROP,PRACT,MAXE,EXCESS,DF)
           GO TO 400
 390       CONTINUE
           TEMDEP = DEPA(INDXC,I)
           TEMWER = WERA(INDXC,I)
           FLAGC  = FLAGCT
           IF(FLAGC.EQ.3.AND.DEPA(INDXC,I).EQ.0.0) FLAGC = 2
           CALL DCAP(1,FLAGC,QLE,SFL,C1,Z,EFFSHL,DEPSID,TEMDEP,TEMWER,
     1               WFL,NMANCH,CRSH,COVSH,MAXE,EXCESS,TB,DF)
 400       CONTINUE
           DO 410 K=1,NPART
               DL(K)    = DF(K)*WFL
               POTLD(K) = (GSTDE(K)+DLAT(K)*(X(I)-XDEMAX)+
     1                    ((DL(K)+DDE(K))*(X(I)-XDEMAX)/2.0))/WFL
 410       CONTINUE
           CALL TRNCAP(EFFSHL,TCL,POTLD)
           NT2    = 0
           DO 420 K=1,NPART
               IF(TCL(K).GE.POTLD(K)) NT2 = NT2+1
 420       CONTINUE
           IF(NT2.EQ.NPART) GO TO 500
           SUMTCL = 0.0
           SUMPLD = 0.0
           DO 430 K=1,NPART
               SUMTCL = SUMTCL + TCL(K)
               SUMPLD = SUMPLD + POTLD(K)
 430       CONTINUE
           DO 440 K=1,NPART
               EXDET(K) = ((TCL(K)*WFL-GSTDE(K)-DLAT(K)*(X(I)-XDEMAX))*
     1                    (2.0/(X(I)-XDEMAX))-DDE(K))/WFL
 440       CONTINUE
      SUMDF=0.0
      SUMEXD=0.0
      DO 442 K=1,NPART
      SUMDF=SUMDF+DF(K)
      SUMEXD=SUMEXD+EXDET(K)
 442  CONTINUE
           MAXE   = 1000.0
           EXCESS = SUMTCL/SUMPLD
      EXCOLD=EXCESS
      NEXCES=0
 452  CONTINUE
      NEXCES=NEXCES+1
      IF(NEXCES.GT.20)GO TO 494
 453  CONTINUE
           IF(EXCESS.LT.0.0) EXCESS = 0.0
           IF(ELEM.GT.1) GO TO 460
           CALL RILL(X(I),SLOPE(I),KEROD,CROP,PRACT,MAXE,EXCESS,DF)
           GO TO 470
 460       CONTINUE
           TEMDEP = DEPA(INDXC,I)
           TEMWER = WERA(INDXC,I)
           CALL DCAP(2,FLAGC,QLE,SFL,C1,Z,EFFSHL,DEPSID,TEMDEP,
     1               TEMWER,WFL,NMANCH,CRSH,COVSH,MAXE,
     1               EXCESS,TB,DF)
 470       CONTINUE
           EXCESS = 1.0
           MAXE   = 1000.0
           DO 480 K=1,NPART
               DL(K)    = DF(K)*WFL
               GSL(K)   = (GSTDE(K)+DLAT(K)*(X(I)-XDEMAX)+((DL(K)+
     1                    DDE(K))*(X(I)-XDEMAX)/2.0))/WFL
               POTLD(K) = GSL(K)
 480       CONTINUE
           CALL TRNCAP(EFFSHL,TCL,POTLD)
      SUMTCL=0.0
      SUMPLD=0.0
      SUMDF=0.0
      SUMEXD=0.0
           DO 490 K=1,NPART
      SUMTCL=SUMTCL+TCL(K)
      SUMPLD=SUMPLD+POTLD(K)
               EXDET(K) = ((TCL(K)*WFL-GSTDE(K)-DLAT(K)*(X(I)-XDEMAX))*
     1                    (2.0/(X(I)-XDEMAX))-DDE(K))/WFL
      SUMEXD=SUMEXD+EXDET(K)
      SUMDF=SUMDF+DF(K)
 490       CONTINUE
      IF(ABS(SUMTCL-SUMPLD)/SUMTCL.LT.0.01)GO TO 494
      RATEX=SUMEXD/SUMDF
      IF(RATEX.LE.0.0)RATEX=SUMTCL/SUMPLD
      EXCESS=EXCOLD*RATEX
      EXCOLD=EXCESS
      GO TO 452
 494  CONTINUE
      DO 495 K=1,NPART
                GSL(K) = TCL(K)
 495  CONTINUE
           GO TO 530
 500       CONTINUE
           DO 520 K=1,NPART
               GSL(K)   = POTLD(K)
 520       CONTINUE
 530       CONTINUE
           IF(ELEM.EQ.1) GO TO 720
           DEPA(INDXC,I) = TEMDEP
           WERA(INDXC,I) = TEMWER
           FLAGC  = FLAGCT
           IF(FLAGC.EQ.3.AND.DEPA(INDXC,I).EQ.0.0) FLAGC = 2
           IF(FLAGC.EQ.2.AND.WERA(INDXC,I).GT.WFL)
     1       WIDA(INDXC,I) = WERA(INDXC,I)
           GO TO 720
 540       CONTINUE
      NT=0
      DO 542 K=1,NPART
      IF(TCL(K).LE.POTLD(K))NT=NT+1
 542  CONTINUE
      IF(NT.EQ.NPART)GO TO 630
           DO 550 K=1,NPART
               POTLD(K) = (GSTU(K)+DLAT(K)*DX+DU(K)*DX/2.0)/WFL
 550       CONTINUE
           CALL TRNCAP(EFFSHL,TCL,POTLD)
           NT     = 0
           DO 560 K=1,NPART
               DTCDX(K) = (TCL(K)*WFL-TCU(K)*WFU)/DX
      IF(TCL(K).LE.POTLD(K))NT=NT+1
 560       CONTINUE
           IF(NT.EQ.NPART) GO TO 590
 570       CONTINUE
           DO 580 K=1,NPART
               DDE(K)   = DU(K)
               XDEMAX   = X(I-1)
               GSDE(K)  = GSU(K)
               GSTDE(K) = GSDE(K)*WFU
 580       CONTINUE
           GO TO 380
 590       CONTINUE
      XDSMAL=X(I-1)
      XDBIG=X(I)
      NDEP=0
 599  CONTINUE
           DO 610 K=1,NPART
               IF(POTLD(K).LE.TCL(K)) GO TO 600
      XDBEG(K)=(2.0*(TCL(K)*WFL-GSTU(K)-DLAT(K)*DX)/DU(K))+X(I-1)
               GO TO 610
 600           CONTINUE
               XDBEG(K) = X(I)
 610       CONTINUE
           XDBMIN = X(I)
           DO 620 K=1,NPART
               XDBMIN   = AMIN1(XDBMIN,XDBEG(K))
 620       CONTINUE
      IF(XDBMIN.LE.XDSMAL)XDBMIN=XDSMAL
 624  CONTINUE
      DO 625 K=1,NPART
      POTLD(K)=(GSTU(K)+DLAT(K)*DX+DU(K)*(XDBMIN-X(I-1))/2.0)/WFL
 625  CONTINUE
      CALL TRNCAP(EFFSHL,TCL,POTLD)
      NT=0
      SUMTC=0.0
      SUMPL=0.0
      NDEP=NDEP+1
      IF(NDEP.EQ.4)GO TO 6291
      DO 627 K=1,NPART
      SUMTC=SUMTC+TCL(K)
      SUMPL=SUMPL+POTLD(K)
      IF(TCL(K).LE.POTLD(K))NT=NT+1
 627  CONTINUE
      IF(ABS((SUMTC-SUMPL)/SUMTC).LT.0.01)GO TO 629
      IF(NT.EQ.NPART)GO TO 628
      XDSMAL=XDBMIN
      XDBMIN=(XDSMAL+XDBIG)/2.0
      GO TO 624
 628  CONTINUE
      XDBIG=XDBMIN
      GO TO 599
 629  CONTINUE
6292  CONTINUE
      DO 6290 K=1,NPART
      DL(K)=0.0
      GSL(K)=TCL(K)
6290  CONTINUE
      GO TO 720
6291  CONTINUE
      GO TO 6292
 630  CONTINUE
      NZ=0
      NK=0
      DO 632 K=1,NPART
      IF(DU(K).GT.0.0)NZ=NZ+1
      IF(GSU(K).EQ.TCU(K))NK=NK+1
 632  CONTINUE
      IF(NZ.EQ.NPART.AND.NK.EQ.NPART)GO TO 640
      DO 635 K=1,NPART
      IF(TCL(K).GE.POTLD(K))GO TO 635
      XDBEG(K)=((TCU(K)*WFU-GSTU(K))/(DU(K)/2.0+DLAT(K)-DTCDX(K)))+
     2   X(I-1)
 635  CONTINUE
      GO TO 690
 640  CONTINUE
      DO 645 K=1,NPART
      IF(TCL(K).GE.POTLD(K))GO TO 645
      XDBEG(K)=DX*DU(K)/(2.0*DLAT(K)+DU(K))+X(I-1)
 645  CONTINUE
 690       CONTINUE
           DO 710 K=1,NPART
               IF(POTLD(K).LE.TCL(K)) GO TO 700
               COEFF    = 1.0
               XRAT     = XDBEG(K)/X(I)
               EXPON    = PHI(K)+1.0
               CALL UNDFLO(COEFF,XRAT,EXPON)
               DL(K)    = (PHI(K)/(1.0+PHI(K)))*(DTCDX(K)-DLAT(K))*
     1                    (1.0-XRAT**EXPON)
               GSL(K)   = TCL(K)-DL(K)*X(I)/(PHI(K)*WFL)
               GO TO 710
 700           CONTINUE
               GSL(K)   = POTLD(K)
               DL(K)    = 0.0
 710       CONTINUE
 720       CONTINUE
           DO 730 K=1,NPART
               GSTL(K)  = GSL(K)*WFL
 730       CONTINUE
c          IF(EROOUT.EQ.6 .AND. FLGDAY .EQ. SDATE) CALL SEGOUT(ELEM,
c          IF(FLGDAY .EQ. SDATE) CALL SEGOUT(ELEM,                      out
c    &        NPART,GSTU,GSTL,X(I),DX,DLAT,METFLG)                      out
 740   CONTINUE
       SOLOSS = 0.0
       DO 750 K=1,NPART
           CONC(K) = GSTL(K)/QE
           GS(K)   = RUNOFF*DAL*CONC(K)
           SOLOSS  = SOLOSS+GS(K)/DAL
 750   CONTINUE
       RETURN
       END
