#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "screen.h"
#include "extkeys.h"
#include "nutfunct.h"
#include "n4h.h"

extern struct vcfg cfg;

static SMALL_WINDOW *w_ptr;

/*
 *  master help routine that sets up and dispatches the help screens.
 */
void get_nut_help( NUTRIENT *tmp, WINDOW_CONTROL *wc, char *t, int *ch )
{
HELP_WINDOW hw;

   w_ptr = NULL;
   hw.v_row = 0;        /*  virtual row in a window */
   hw.select = 0;       /*  current position in help arrays */
   switch (tmp->type) {
      case 4 :
         switch (wc->field) {
            case 2 :
               hw.dply_col = 2;         /* column to start display in win */
               hw.dply_row = 3;         /* row to start display in window */
               hw.line_length = 43;     /* maximum length of help line    */
               hw.avail_lines = 4;      /* num of lines avail for display */
               hw.num_entries = 4;      /* num of help choices in array   */
               hw.ulft_col = 10;        /* upper left col to begin box    */
               hw.ulft_row = 5;         /* upper left row to begin box    */
               hw.total_col = 47;       /* total num of columns in box    */
               hw.total_row = 8;        /* total num of lines in help box */
               master_help( &hw, nutout_tbl, nutout_head, t, ch );
               break;
            case 5 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 31;
               hw.avail_lines = 3;
               hw.num_entries = 3;
               hw.ulft_col = 20;
               hw.ulft_row = 5;
               hw.total_col = 35;
               hw.total_row = 7;
               master_help( &hw, isoil_tbl, isoil_head, t, ch );
               break;
         }
         break;
      case 15 :
         switch (wc->field) {
            case 0 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 28;
               hw.avail_lines = 7;
               hw.num_entries = 78;
               hw.ulft_col = 22;
               hw.ulft_row = 5;
               hw.total_col = 32;
               hw.total_row = 11;
               master_help( &hw, icrop_tbl, icrop_head, t, ch );
               break;
         }
         break;
      case 16 :
         switch (wc->field) {
            case 2 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 28;
               hw.avail_lines = 3;
               hw.num_entries = 5;
               hw.ulft_col = 20;
               hw.ulft_row = 5;
               hw.total_col = 32;
               hw.total_row = 7;
               master_help( &hw, methap_tbl, methap_head, t, ch );
               break;
            case 3 :
               hw.dply_col = 2;
               hw.dply_row = 6;
               hw.line_length = 75;
               hw.avail_lines = 7;
               hw.num_entries = 15;
               hw.ulft_col = 1;
               hw.ulft_row = 5;
               hw.total_col = 79;
               hw.total_row = 14;
               master_help( &hw, mtype_tbl, mtype_head, t, ch );
               if (*ch == RTURN)
                  fill_card18( tmp, wc, hw );
               else
                  *ch = 0;
               break;
         }
         break;
      case 19 :
         switch (wc->field) {
            case 1 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 33;
               hw.avail_lines = 7;
               hw.num_entries = 22;
               hw.ulft_col = 10;
               hw.ulft_row = 5;
               hw.total_col = 37;
               hw.total_row = 11;
               master_help( &hw, ltil_tbl, ltil_head, t, ch );
               break;
         }
         break;
   }
}


/*
 *  user has selected a manure from built in data base.  fill in
 *  card 18 with manure info.
 */
void fill_card18( NUTRIENT *tmp, WINDOW_CONTROL *wc, HELP_WINDOW hw )
{
NUTRIENT *a;
int i;

   a = tmp->n;
   if (a->type == 18 && hw.select < 14 && hw.select >= 0) {
      i = hw.select;
      set_field_value( a, contents[i].total_n, 2, TRUE );
      set_field_value( a, contents[i].organic_n, 3, TRUE );
      set_field_value( a, contents[i].ammonia, 4, TRUE );
      set_field_value( a, contents[i].total_p, 5, TRUE );
      set_field_value( a, contents[i].organic_p, 6, TRUE );
      set_field_value( a, contents[i].organic_matter, 7, TRUE );
      if (i <= 6)
         set_field_value( a, "1", 8, TRUE );
      else if (i <= 9)
         set_field_value( a, "2", 8, TRUE );
      else if (i <= 13)
         set_field_value( a, "3", 8, TRUE );
      refresh_screen( tmp, wc );
   }
}


/*
 *  write help screen heading.
 */
void show_help_list( HELP_WINDOW *hw, TABLE_TYPE *help, int row_spacing )
{
int row, col, i, j, lite_len;

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row;
   lite_len = hw->line_length;
   scroll_window( 0, row, col, row+hw->avail_lines-1, col+lite_len, NORMAL );
   i = hw->v_row;
   j = hw->select;
   for (; i>0 && j>0; i--, j--);
   for (; i < hw->avail_lines && j < hw->num_entries; i+=row_spacing, j++) {
      row = hw->ulft_row + hw->dply_row + i;
      fast_write( col, row, help[j].line, NORMAL );
   }
}


/*
 *  move cursor according to keypad entries.  determine if change color "cc"
 *  or update name "un" need to be done.
 */
void position_cursor( HELP_WINDOW *hw, TABLE_TYPE *help, int *un, int *cc,
                      int *ch )
{
int col, row, y, yy, lite_len, draw_page, i;

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row + hw->v_row * 1;
   y  = hw->ulft_row + hw->dply_row;
   yy = hw->ulft_row + hw->dply_row + hw->avail_lines * 1 - 1;
   *un = FALSE;
   draw_page = FALSE;
   lite_len = hw->line_length;
   switch (*ch) {
      case UP    :
         if (hw->v_row > 0 && hw->select > 0) {
            hlight_line( col, row, lite_len, NORMAL );
            --hw->v_row;
            --hw->select;
            *cc = TRUE;
         } else if (hw->v_row == 0 && hw->select > 0) {
            hlight_line( col, row, lite_len, NORMAL );
            --hw->select;
            scroll_window( -1, y, col, yy+1, col+lite_len, NORMAL );
            *un = TRUE;
            *cc = TRUE;
         }
         break;
      case DOWN :
         if (hw->v_row < hw->avail_lines-1 &&
                                      hw->select < hw->num_entries-1) {
            hlight_line( col, row, lite_len, NORMAL );
            ++hw->v_row;
            ++hw->select;
            *cc = TRUE;
         } else if (hw->v_row == hw->avail_lines-1 &&
                                      hw->select < hw->num_entries-1) {
            hlight_line( col, row, lite_len, NORMAL );
            ++hw->select;
            scroll_window( 1, y, col, yy, col+lite_len, NORMAL );
            *un = TRUE;
            *cc = TRUE;
         } else if (hw->select == hw->num_entries - 1 && hw->v_row > 0) {
            --hw->v_row;
            scroll_window( 1, y, col, yy, col+lite_len, NORMAL );
         }
         break;
      case PGUP :
         if (hw->select > hw->avail_lines-1) {
            hw->select = hw->select - hw->avail_lines;
            if (hw->v_row > hw->select)
               hw->select = hw->v_row;
            draw_page = TRUE;
         } else if (hw->select - hw->v_row > 0) {
            hw->select = hw->v_row;
            draw_page = TRUE;
         }
         break;
      case PGDN :
         if (hw->select + hw->avail_lines < hw->num_entries) {
            hw->select = hw->select + hw->avail_lines;
            draw_page = TRUE;
         } else if (hw->select + hw->avail_lines - hw->v_row <
                                                      hw->num_entries) {
            hw->select = hw->num_entries - 1;
            draw_page = TRUE;
         }
         if ((hw->num_entries - 1) - hw->select <
                                           hw->avail_lines && draw_page) {
            i = row - hw->v_row;
            scroll_window( 0, i, col, i+hw->avail_lines-1,
                           col+hw->line_length, NORMAL );
         }
         break;
   }
   if (draw_page == TRUE) {
      show_help_list( hw, help, 1 );
      *un = TRUE;
      *cc = TRUE;
   }
}


/*
 *  master help routine that 1) saves screen area for help table  2) draws help
 *  screen  3) moves cursor and updates choices as needed  4) restores screen
 */
void master_help( HELP_WINDOW *hw, TABLE_TYPE *help,
                  struct screen help_heading[], char *t, int *ch )
{
int col, row, lite_len;
int update_name, change_color;
char str[100];

   save_and_draw( hw, help_heading, &w_ptr );
   show_help_list( hw, help, 1 );

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row + hw->v_row;
   change_color = TRUE;
   *ch = 0;
   lite_len = hw->line_length;
   while (*ch!=RTURN && *ch!=ESC) {
      strcpy( str, help[hw->select].line );
      position_cursor( hw, help, &update_name, &change_color, ch );
      row = hw->ulft_row + hw->dply_row + hw->v_row;
      if (update_name)
         fast_write( col, row, help[hw->select].line, NORMAL );
      if (change_color)
         hlight_line( col, row, lite_len, cfg.hi_i);
/*   hlight_line( col, row, strlen( help[hw->select].line ), cfg.hi_i); */
      *ch = getkey( );
      change_color = FALSE;
   } /*
   hlight_line(col, row, strlen(help[hw->select].line), cfg.lo_i);
   */
   c_on( );
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   if (*ch == RTURN)
      strcpy( t, help[hw->select].value );
   else
      *ch = 0;
}


/*
 *  save screen area for help table.  draw the help screen border.
 *  write help screen heading.
 */
void save_and_draw( HELP_WINDOW *hw, struct screen help_heading[],
                    SMALL_WINDOW **w_ptr )
{

   c_off( );
   window_control( w_ptr, SAVE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   no_buf_make_window( hw->ulft_col, hw->ulft_row, hw->total_col,
                   hw->total_row, NORMAL );
   write_to_window( help_heading, hw->ulft_col, hw->ulft_row, NORMAL );
}


/*
 *  show info on greatest composer who ever lived
 */
void show_mozart( void )
{
HELP_WINDOW hw;
int i;

   w_ptr = NULL;
   hw.ulft_col = 20;        /* upper left col to begin box    */
   hw.ulft_row = 9;         /* upper left row to begin box    */
   hw.total_col = 44;       /* total num of columns in box    */
   hw.total_row = 4;        /* total num of lines in help box */
   save_and_draw( &hw, mozart_heading, &w_ptr );
   i = 0;
   while (i!=RTURN && i!=ESC) {
      i = getkey( );
   }
   c_on( );
   window_control( &w_ptr, RESTORE, hw.ulft_col, hw.ulft_row,
                   hw.total_col, hw.total_row );
}
