#include <conio.h>
#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#undef toupper

#include "screen.h"
#include "extkeys.h"
#include "nutfunct.h"
#include "nut1.h"


static NUTRIENT *n_list;

struct vcfg cfg;
extern struct c_scheme clr;
struct file_position pos;
char fname[40];

static SMALL_WINDOW *w_ptr;

char *greatest_composer_ever = "W. A. Mozart, 1756-1791";


/*
 *   master routine that calls all major support routines
 */
main( int argc, char *argv[] )
{
int c, stop;
NUTRIENT *first, *last, *tmp;
WINDOW_CONTROL wc;
char *tname = "Temporary file";

   stop = FALSE;
   w_ptr = NULL;
   wc.beg_vrow = 0;
   wc.max_rows = 16;
   wc.d_col    = 5;
   wc.d_row    = 3;
   wc.offset   = 0;
   wc.field    = 0;
   wc.v_row = wc.r_row = 0;
   wc.view     = VLEFT;
   get_vcfg( );
   if (argc > 1) {
      c = init_from_file( &n_list, argv[1] );
      strcpy( fname, argv[1] );
      if (c == FALSE) {
         init_all_cards( &n_list );
         strcpy( fname, tname );
      }
   } else {
      init_all_cards( &n_list );
      strcpy( fname, tname );
   }
   first = n_list;
   for (tmp=n_list; tmp != NULL; tmp=tmp->n)
      last = tmp;
   tmp = first;
   intro( );
   pd( );
   pos.display = TRUE;
   pos.d_row = 24;
   pos.d_col = 72;
   pos.color = cfg.f_bar;
   pos.f_row = wc.r_row + 1;
   pos.f_col = 0;
   work_screen( tmp, wc );
   show_footer( tit_foot, wc );
   write_filename( fname );
   c = 0;
   while (stop != TRUE) {
      switch (tmp->type) {
         case 1 :
         case 2 :
         case 3 :
            wc.field = 0;
            get_title( &first, &tmp, &wc, &c, &stop );
            break;
         case 4  :
         case 5  :
         case 6  :
         case 7  :
         case 8  :
         case 9  :
         case 10 :
         case 11 :
         case 12 :
         case 13 :
         case 14 :
         case 15 :
         case 16 :
         case 17 :
         case 18 :
         case 19 :
         case 20 :
         case 21 :
         case 22 :
         case 23 :
         case 24 :
            get_card4_24( &first, &tmp, &wc, &c, &stop );
            break;
         default :
            c = UP;
            break;
      }
      link_list_editor( &tmp, &wc, c );
      pos.f_row = wc.r_row + 1;
      switch (c) {
/*
         case ALTF  :
         case ALTD  :
         case ALTC  :
         case ALTO  :
         case ALTH  :
            lite_bar_menu( &first, &tmp, &wc, &stop, &c );
            break;
*/
         case ALTS  :
            save( first );
            break;
         case ALTX  :
            quit( first, &stop );
            break;
      }
   }
   cls( );
   set_cur( 0, 0 );
}


/*
 *   if command line arguments have file - try to load it.
 */
int  init_from_file( NUTRIENT **n_list, char *path )
{
NUTRIENT *a, *b;
int  rc;
FILE *infile;
char line[100];
struct card_parse crd;

   crd.eof = FALSE;
   rc = FALSE;
   if ( (infile = fopen( path, "r" )) != NULL) {
      fseek( infile, 0L, SEEK_SET );
      for (crd.c_no=0; fgets( line, 90, infile ) != NULL && crd.eof != TRUE;) {
         if (crd.c_no == 0) {
            crd.c_no = 1;
            *n_list = (NUTRIENT *)malloc( sizeof(NUTRIENT) );
            (*n_list)->n = (*n_list)->p = NULL;
            a = *n_list;
         } else {
            b = (NUTRIENT *)malloc( sizeof(NUTRIENT) );
            a->n = b;
            b->p = a;
            b->n = NULL;
            a = b;
         }
         add_a_line( a, line, &crd );
      }
      fclose( infile );
      rc = TRUE;
   } else
      rc = FALSE;
   return( rc );
}


/*
 *   no command line arguments - set up default card sequence.
 */
void init_all_cards( NUTRIENT **n_list )
{
int i;
NUTRIENT *a, *b;

   for (i=1; i<14; i++) {
      if (i == 1) {
         *n_list = (NUTRIENT *)malloc( sizeof(NUTRIENT) );
         (*n_list)->n = (*n_list)->p = NULL;
         (*n_list)->type = i;
         a = *n_list;
      } else {
         b = (NUTRIENT *)malloc( sizeof(NUTRIENT) );
         a->n = b;
         b->p = a;
         b->n = NULL;
         b->type = i;
         a = b;
      }
      blank_line( a );
      if (i == 13)
         set_field_value( a, "0", 0, TRUE );
   }
}


/*
 *   initialize display contents, numerical values, and entry status.
 */
void blank_line( NUTRIENT *a )
{
int i;

   memset( a->line, ' ', 80 );
   a->line[80] = '\0';
   for (i=0; i<10; i++) {
      a->num[i] = 0.0;
      a->apd[i] = FALSE;
   }
}


/*
 *   show gleams credits
 */
void intro( void )
{
int c;

   c_off( );
   cls( );
   write_to_window( nut_intro, 0, 0, NORMAL );
   c = getkey( );
   c_on( );
   cls( );
}


/*
 *   write editor heading and borders
 */
void work_screen( NUTRIENT *tmp, WINDOW_CONTROL wc )
{
   write_to_window( nut_work, 0, 0, NORMAL );
   show_list( tmp, &wc );
}


/*
 *   write linked list to screen
 */
void show_list( NUTRIENT *tmp, WINDOW_CONTROL *wc )
{
int  r;
char t[82], s[10];

   scroll_window( 0, wc->d_row, 0, wc->d_row+wc->max_rows-1, 79, NORMAL );
   for (r=wc->d_row; tmp!=NULL && r<wc->max_rows+wc->d_row; tmp=tmp->n,r++) {
      if (tmp->type >= 1 && tmp->type <=3)
         fast_write( 0, r, tmp->line, 7 );
      else {
         strncpy( t, tmp->line, 72 );
         t[72] = '\0';
         strcpy( s, itoa( tmp->type, s, 10 ) );
         fast_write( wc->d_col, r, t, NORMAL );
         if (strlen( s ) == 1)
            fast_write( wc->d_col-2, r, s, NORMAL );
         else
            fast_write( wc->d_col-3, r, s, NORMAL );
      }
   }
}


/*
 *   since nutrient heading only contains text, just get text - don't worry
 *   about numeric values, help screens, and footers.
 */
void get_title( NUTRIENT **first, NUTRIENT **tmp, WINDOW_CONTROL *wc, int *c,
                int *stop )
{
int append, cntinue, cell_r, cell_c, rc;
char t[82];
char s[82];

   pos.f_col = 1;
   cell_r = wc->v_row + wc->d_row;
   cell_c = 0;
   if (*c == UP && wc->r_row == 2)
      show_footer( tit_foot, *wc );
   append = (*tmp)->apd[0];
   if (append)
      strcpy( t, (*tmp)->line );
   cntinue = TRUE;
   while ( cntinue) {
      field_editor( t, 'A', 80, cell_r, cell_c, append, c, 7, pos );
      strcpy( (*tmp)->line, t );
      if (*t != '\0')
         (*tmp)->apd[0] = TRUE;
      else
         (*tmp)->apd[0] = FALSE;
      switch (*c) {

         case ALTF  :
         case ALTU  :
         case ALTC  :
         case ALTO  :
         case ALTH  :
            *s = '\0';
            rc = lite_bar_menu( first, tmp, wc, stop, c, t );
            if ((*tmp)->type == 1)
               append = (*tmp)->apd[0];
            if (rc == RTURN) {
               rc = 1;
               *c = 0;
            } else
               rc = 0;
            if (*stop == TRUE)
               cntinue = FALSE;
            break;

         case UP     :
         case DOWN   :
         case RTURN  :
         case PGDN   :
         case PGUP   :
         case ALTS   :
         case ALTX   :
            cntinue = FALSE;
            break;
   }  }
}


/*
 *   master linked list editor.  very damn complicated.  works based on
 *   real row "rr' and virtual row "vr".  go up and down list as long as
 *   there are enough real rows.  update virtual rows (displayed rows) as
 *   needed.
 */
void link_list_editor( NUTRIENT **tmp, WINDOW_CONTROL *wc, int c )
{
NUTRIENT *a, *b;
int i, k, vr, rr;
char t[82], s[10];

   rr = wc->r_row;
   vr = wc->v_row;
   switch (c) {
      case UP :
         if ( (*tmp)->p != NULL) {
            *tmp = (*tmp)->p;
            if (vr > wc->beg_vrow) {
               --vr;
               --rr;
            } else if (vr == wc->beg_vrow) {
               --rr;
               scroll_window( -1, wc->d_row, 0, wc->d_row+wc->max_rows, 79,
                              NORMAL );
               if ((*tmp)->type >= 1 && (*tmp)->type <= 3)
                  fast_write( 0, vr+wc->d_row, (*tmp)->line, NORMAL );
               else {
                  i = 0 + 8 * wc->view;
                  strncpy( t, (*tmp)->line+i, 72 );
                  t[72] = '\0';
                  fast_write( wc->d_col, vr+wc->d_row, t, NORMAL );
                  strcpy( s, itoa( (*tmp)->type, s, 10 ) );
                  if (strlen( s ) == 1)
                     fast_write( wc->d_col-2, vr+wc->d_row, s, NORMAL );
                  else
                     fast_write( wc->d_col-3, vr+wc->d_row, s, NORMAL );
               }
            }
         }
         break;
      case DOWN  :
      case RTURN :
         if (*tmp != NULL && (*tmp)->n != NULL) {
            *tmp = (*tmp)->n;
            if (vr + wc->offset < wc->max_rows-1) {
               ++vr;
               ++rr;
            } else if (vr + wc->offset == wc->max_rows - 1) {
               ++rr;
               scroll_window( 1, wc->d_row, 0, wc->d_row+wc->max_rows-1, 79,
                              NORMAL );
               if ((*tmp)->type >= 1 && (*tmp)->type <= 3)
                  fast_write( 0, vr+wc->d_row, (*tmp)->line, NORMAL );
               else {
                  i = 0 + 8 * wc->view;
                  strncpy( t, (*tmp)->line+i, 72 );
                  t[72] = '\0';
                  fast_write( wc->d_col, vr+wc->d_row, t, NORMAL );
                  strcpy( s, itoa( (*tmp)->type, s, 10 ) );
                  if (strlen( s ) == 1)
                     fast_write( wc->d_col-2, vr+wc->d_row, s, NORMAL );
                  else
                     fast_write( wc->d_col-3, vr+wc->d_row, s, NORMAL );
               }
            }
         } else if ((*tmp)->n == NULL && vr > 0) {
            --vr;
            scroll_window( 1, wc->d_row, 0, wc->d_row+wc->max_rows-1, 79,
                           NORMAL );
         }
         break;
      case PGDN  :
         for (i=0, k=wc->v_row, a=*tmp; a->n != NULL && i < wc->max_rows;
                                                          a=a->n, i++, k++);
         if (k >= wc-> max_rows) {
            b = a;
            for (i=wc->v_row; i>0 && a->p != NULL; i--, a=a->p);
            show_list( a, wc );
            rr = rr + k - vr;
            *tmp = b;
         }
         break;
      case PGUP  :
         if (rr != vr) {
            i = rr - vr;
            if ( i < wc->max_rows) {
               for (a=*tmp; i>0 && a->p!=NULL; i--, a=a->p);
               for (b=a; a->p != NULL; a=a->p);
               rr = vr + wc->max_rows;
            } else {
               for (i=0, a=*tmp; i<wc->max_rows; i++, a=a->p);
               for (b=a, i=vr; i>0 && a->p!=NULL; i--, a=a->p);
            }
            show_list( a, wc );
            rr = rr - wc->max_rows;
            *tmp = b;
         }
         break;
   }
   wc->r_row = rr;
   wc->v_row = vr;
}


/*
 *   clear display string and put in scratch string.
 */
void format_output( char *in, char *out, int field, int wid )
{
   memset( out+field*8, ' ', wid );
   strncpy( out+field*8+(wid-strlen( in )), in, strlen( in ) );
}


/*
 *   make sure ranges are within upper and lower limits.
 */
int  range_not_ok( char *t, double low, double high )
{
int rc;
double num;

   if (*t == '\0')
      rc = 1;
   else {
      num = atof( t );
      if (num < low || num > high)
         rc = 1;
      else
         rc = 0;
   }
   return( rc );
}


/*
 *   display field information at the bottom of the screen.
 */
void show_footer( struct screen *p, WINDOW_CONTROL wc )
{
int row;

   row = wc.d_row + wc.max_rows + 1;
   scroll_window( 0, row, 0, row+3, 79, NORMAL );
   while (p->text != NULL && p->row != 24) {
      fast_write( p->col, p->row, p->text, NORMAL );
      p++;
   }
   if (p->text != NULL)
      fast_write( p->col, p->row, p->text, cfg.f_bar );
}


/*
 *   write file name if any on the screen inbetween linked list and heading.
 */
void write_filename( char *string )
{
char line[82];
int j;

   memset( line, 196, 80 );
   line[80] = '\0';
   fast_write( 0, 2, line, NORMAL );
   strcpy( line, string );
   j = strlen( line );
   insert( line, j, 195 );
   insert( line, 0, 180 );
   j += 2;
   j = 39 - (j >> 1);
   fast_write( j, 2, line, NORMAL );
}


/*
 *   free the linked list and get out with asking if OK.
 */
void quit( NUTRIENT *first, int *stop )
{
NUTRIENT *tmp;

   while (first != NULL) {
      tmp = first;
      first = first->n;
      free( tmp );
   }
   *stop = TRUE;
}


/*
 *   save the linked list to file name displayed inbetween heading and list.
 */
void save( NUTRIENT *first )
{
NUTRIENT *p;
char  *p1, *p2, temp[100], *head="Saving file:";
FILE *outfile;
int col, row, wid, hgt, i, j, k;

   if (strncmp( fname, "Temporary", 9 ) != 0) {
      if ((outfile = fopen( fname, "w" )) != NULL) {
         k = ((i=strlen( head )) > (j=strlen( fname ))) ? i : j;
         wid = k+4;
         col = 40 - wid / 2;
         row = 10;
         hgt = 4;
         window_control( &w_ptr, SAVE, col, row, wid, hgt );
         no_buf_make_window( col, row, wid, hgt, clr.w_outline );
         i = (k - i) / 2;
         fast_write( col+2+i, row+1, head, NORMAL );
         j = (k - j) / 2;
         fast_write( col+2+j, row+2, fname, NORMAL );
         for (i=0; i<hgt-2; i++)
            hlight_line( col+1, row+1+i, wid-2, clr.w_list );
         fseek( outfile, 0L, SEEK_SET );
         for (p=first; p != NULL; p=p->n) {
            strcpy( temp, p->line );
            p1 = p2 = temp;
            for (; *p1 != '\0'; p1++);
            for (--p1; *p1 == ' ' && p1 >= p2; p1--)
               *p1 = '\0';
            fprintf( outfile, "%s\n", temp );
         }
         fclose( outfile );
         window_control( &w_ptr, RESTORE, col, row, wid, hgt );
      }
   }
}
