#include <dos.h>
#include <memory.h>
#include <search.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "screen.h"
#include "getfns.h"
#include "extkeys.h"
#include "hydfunc.h"

extern struct c_scheme clr;
extern struct vcfg cfg;
extern struct file_position pos;


void do_dir( void )
{
int ch, i, gd, nfiles, display;
char path[MAXPATH + 1];
struct OUTBUF *fp, *fq;
struct dir_struct dir;
SMALL_WINDOW *w_ptr;

   display = pos.display;
   pos.display = FALSE;
   w_ptr = NULL;
   dir.col = 12;
   dir.row = 5;
   dir.wid = 60;
   dir.hgt = 15;
   dir.num_cols = 4;
   dir.num_lines = 9;
   dir.flist_col[0] = dir.col + 2;
   for (i=1; i<4; i++)
      dir.flist_col[i] = dir.flist_col[i-1] + 14;
   window_control( &w_ptr, SAVE, dir.col, dir.row, dir.wid, dir.hgt );
   no_buf_make_window( dir.col, dir.row, dir.wid, dir.hgt, clr.w_outline );
   for (i=0; i<dir.hgt-2; i++)
      hlight_line( dir.col+1, dir.row+1+i, dir.wid-2, clr.w_list );
   fast_write( dir.col+28, dir.row+13, "<OK>", clr.w_list );
   fq = fp = (struct OUTBUF *)malloc( N_FILES * sizeof(struct OUTBUF) );
   if (fp == NULL)
     exit( 1 );
   gd = 1; nfiles = 0;
   c_on( );
   fast_write( dir.col+2, dir.row+1, "Enter path name :", clr.w_list );
   field_editor( path, 'A', 30, dir.row+1, dir.col+20, FALSE, &ch, clr.w_list,
                 pos );
   while( path_not_ok( path, dir.col+20, dir.row+1 ) && ch != ESC)
      field_editor( path, 'A', 30, dir.row+1, dir.col+20, FALSE, &ch,
                    clr.w_list, pos );


   if (ch != ESC) {
      gd = get_directory( fp, fq, path, &nfiles );
      fast_write( dir.col+20, dir.row+1, path, NORMAL );

                      /* make sure directory not empty and return code from
                         get directory is good
                      */
      if (nfiles > 0 && gd == 0) {
         fq = fp + 1;
         qsort( fq, nfiles, sizeof(struct OUTBUF), fname_cmp );
         list_files( fq, nfiles, dir );
         c_off( );
         select_file( fq, nfiles, dir, &ch );
         c_on( );
      }
   }
   free( fp );
   window_control( &w_ptr, RESTORE, dir.col, dir.row, dir.wid, dir.hgt );
   pos.display = display;
}


int  path_not_ok( char *path, int col, int row )
{
int rc;
struct find_t buf;

   rc = 0;
   if (*path == '\0') {
      path[0] = (char)('a' + getdrive( ));   /* getdrive returns integer for drive */
      path[1] = ':';
      path[2] = '\\';
      drvpath( path );
   }
   if (path[0] == '\\') {
            /* prepend default drive name */
      memmove( path + 2, path, strlen( path ) + 1 );
      path[0] = (char)('a' + getdrive( ));
      path[1] = ':';
   }  else if (path[1] == ':' && path[2] == '\0') {
      path[2] = '\\';
      drvpath( path );
   }
   if (last_ch( path ) == '\\')
      strcat( path, "*.*" );
   if (_dos_findfirst( path, 0xffff, &buf ) != 0) {
      fast_write( col, row, "File name not found           ", clr.w_list );
      rc = getkey( );
   }
   return( rc );
}


int  get_directory( struct OUTBUF *fp, struct OUTBUF *fq, char *path,
                    int *nfiles )
{
struct find_t buf;

   if (fp == NULL) {
      fatal( "Out of memory", 1 );
      return( 1 );
   }
   *nfiles = 0;


   _dos_findfirst( path, 0xffff, &buf );
   if ((buf.attrib & _A_SUBDIR) == _A_SUBDIR) {
         /*  path is a subdirectory */
      if (last_ch( path ) != '*')
         strcat( path, "\\*.*" );
      _dos_findfirst( path, 0xffff, &buf );
   }

   fq = fp;
   fq->fname = strdup( buf.name );
   fq++;
   do {
      if ( (buf.attrib & _A_SUBDIR) == _A_SUBDIR)
         fq->fname = strdup( strcat( buf.name, "\\" ) );
      else
         fq->fname = strdup( buf.name );
      ++*nfiles;
      ++fq;
  } while (_dos_findnext( &buf ) == 0);
   return( 0 );
}


char last_ch( char *s )
{
register char *cp;

   cp = s;
   if (*cp == '\0')
      return( *cp );
   while (*cp != '\0')
      ++cp;
   --cp;
   return( *cp );
}


int  fatal( char *str, int errlvl )
{
   fputs(str, stderr);
   fputc(' ',stderr);
   return( errlvl );
}


int  getdrive( void )
{
   return( bdos( 0x19, 0, 0 ) ); /* current_disk */
}


void drvpath( char far *path )
{
int drive_num;

   drive_num = drive( path[0] );
   _asm {
        push    ds                      ; save ds
        push    si                      ; save si

        mov     ah, 0x47                ; function 0x47 == get current dir
        mov     dx, WORD PTR drive_num  ; drive code, 0 == default, 1 = a
        mov     si, WORD PTR path       ; load OFFSET of path
        inc     si                      ; skip "c:\"
        inc     si
        inc     si
        mov     bx, WORD PTR path+2     ; load SEGMENT of path
        mov     ds, bx                  ; put it in ds
        int     0x21                    ; DOS interrupt

        pop     si                      ; get back si and ds
        pop     ds
   }
}


int  drive( char dltr )
{
   if (dltr < 'a')
      dltr += 32;
   return( dltr - 'a' + 1 );
}


void list_files( struct OUTBUF *buf, int nelem, struct dir_struct dir )
{
int ncols, nlines;

   nlines = nelem / dir.num_cols;
   if (nelem % dir.num_cols)
      ++nlines;
   if (nlines > dir.num_lines)
      nlines = dir.num_lines;
   ncols = nelem / nlines + (nelem % nlines ? 1 : 0);
   if (ncols > dir.num_cols)
      ncols = dir.num_cols;

   scroll_window( 0, dir.row+3, dir.col+2, dir.row+dir.hgt-3,
                                        dir.col+dir.wid-3, clr.w_list );
   write_list( buf, nelem, nlines, ncols, dir );
}


void write_list( struct OUTBUF *buf, int nelem, int nlines, int ncols,
                 struct dir_struct dir )
{
int i, j, k;
struct OUTBUF *tmp, *base;

   base = buf;
   for (i = 0; i < nlines; ++i) {
      tmp = base;
      for (j = 0; j < ncols; ++j) {
         fast_write( dir.flist_col[j], i+dir.row+3, strlwr(tmp->fname),
                                           clr.w_list );
         tmp += nlines;
         k = tmp - buf;
         if (k >= nelem)
            break;
      }
      ++base;
   }
}


void select_file( struct OUTBUF *base, int nelem, struct dir_struct dir,
                  int *ch )
{
int field, j, good_key;
struct OUTBUF *tmp, *buf;
int r, c, nlines, ncols, nfiles, prow, noffset, offset;

   get_boundaries( nelem, &nlines, &ncols, &nfiles, &prow, &noffset, dir );
   r = 1;
   c = 1;
   offset = 0;

   good_key = FALSE;
   field = r + nlines * (c - 1) - 1;
   buf = base + offset;
   tmp = buf + field;
   hlight_line( (c-1)*14+dir.col+2, r+dir.row+2, 12, cfg.lo_i );
   *ch = getkey( );
   switch (*ch) {
      case UP    :
      case DOWN  :
      case LEFT  :
      case RIGHT :
      case HOME  :
      case END   :
      case PGUP  :
      case PGDN  :
         good_key = TRUE;
         break;
   }
   while (*ch != ESC && *ch != RTURN) {
      if (good_key)
         hlight_line( (c-1)*14+dir.col+2, r+dir.row+2, 12, clr.w_list );
      switch (*ch) {
         case UP :
            if (r > 1)  --r;
            else if (c != ncols) r = nlines;
            else r = prow;
            good_key = TRUE;
            break;
         case DOWN :
            if (r < prow) ++r;
            else if (r < nlines && c != ncols) ++r;
            else r = 1;
            good_key = TRUE;
            break;
         case LEFT :
            if (offset == 0 || c > 1) {
               if (c > 1) --c;
               else if (r <= prow) c = ncols;
               else c = ncols - 1;
            } else if (noffset > 0 && offset > 0 && c == 1) {
               offset -= dir.num_lines;
               buf = base + offset;
               scroll_window( 0, dir.row+3, dir.col+2, dir.row+dir.hgt-3,
                                        dir.col+dir.wid-3, clr.w_list );
               field -= dir.num_lines;
               j = nlines * ncols;
               nfiles = (nelem - offset) > j ? j : (nelem - offset);
               prow = nlines - (j - nfiles);
               write_list( buf, nfiles, nlines, ncols, dir );
            }
            good_key = TRUE;
            break;
         case RIGHT :
            if (offset == noffset * dir.num_lines || c < ncols) {
               if (c < ncols - 1) ++c;
               else if (c < ncols && r <= prow) ++c;
               else c = 1;
            } else if (noffset > 0 && offset < noffset * dir.num_lines &&
                                      c == dir.num_cols) {
               offset += dir.num_lines;
               buf = base + offset;
               scroll_window( 0, dir.row+3, dir.col+2, dir.row+dir.hgt-3,
                                        dir.col+dir.wid-3, clr.w_list );
               field += dir.num_lines;
               j = nlines * ncols;
               nfiles = (nelem - offset) > j ? j : (nelem - offset);
               prow = nlines - (j - nfiles);
               if (r > prow)
                  r = prow;
               write_list( buf, nfiles, nlines, ncols, dir );
            }
            good_key = TRUE;
            break;
         case HOME  :
            r = 1;
            c = 1;
            good_key = TRUE;
            break;
         case END   :
            r = prow;
            c = ncols;
            good_key = TRUE;
            break;
         case PGUP  :
            r = 1;
            good_key = TRUE;
            break;
         case PGDN  :
            if (c == ncols)
               r = prow;
            else
               r = nlines;
            good_key = TRUE;
            break;
      }
      if (good_key) {
         field = r + nlines * (c - 1) - 1;
         tmp = buf + field;
         hlight_line( (c-1)*14+dir.col+2, r+dir.row+2, 12, cfg.lo_i );
         good_key = FALSE;
      }
      *ch = getkey( );
      switch (*ch) {
         case UP    :
         case DOWN  :
         case LEFT  :
         case RIGHT :
         case HOME  :
         case END   :
         case PGUP  :
         case PGDN  :
            good_key = TRUE;
            break;
      }
   }
}


void get_boundaries( int nelem, int *nlines, int *ncols, int *nfiles,
                     int *prow, int *noffset, struct dir_struct dir )
{
int lxc;

      /*  Have room for only so many files on display screen.     */
      /*  In fact, there is only room for LINES * COLS of files.  */
      /*  Let's say we can display only 6 lines and 5 columns of  */
      /*  files - total of 30 files on screen at one time.  Given */
      /*  some number of files, we can compute how many lines and */
      /*  columns are needed to display the file names.           */

   *nlines = nelem / dir.num_cols;  /* divide num of files to get num lines */
   if (nelem % dir.num_cols)       /* only have enough room on screen for  */
      ++*nlines;                /* 5 columns and 6 - 10 lines           */
   *nlines = *nlines > dir.num_lines ? dir.num_lines : *nlines;
   *ncols = nelem / *nlines + (nelem % *nlines ? 1 : 0); /* round up */
   *ncols = *ncols > dir.num_cols ? dir.num_cols : *ncols;  /* figure number of cols */

   lxc = *nlines * *ncols;              /* lines times cols = lxc */
   *nfiles = nelem > lxc ? lxc : nelem; /* can only show nfiles on screen */
   *prow = *nlines - (lxc - *nfiles);   /* right most row will be  */
                                        /* partially filled */
   if (nelem < lxc)
      *noffset = 0;    /* noffset = number of columns that cannot be */
   else                /*           displayed on screen              */
      *noffset = (nelem - lxc) / dir.num_lines + ((nelem - lxc) % dir.num_lines ? 1 : 0);
   lxc = 0;
}


int  fname_cmp( struct OUTBUF *s1, struct OUTBUF *s2 )
{
int result;

   result = strcmp( s1->fname, s2->fname );
   return( result );
}
