#include <conio.h>
#include <dos.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "screen.h"
#include "extkeys.h"
#include "hydfunc.h"
#include "h4h.h"

extern struct file_position pos;
extern struct vcfg cfg;
extern int units;
extern struct limit_type (*limits)[32];


static SMALL_WINDOW *w_ptr;
static int elev_apd = FALSE, flow_apd = FALSE;
static char elev_c[20], flow_c[20];


void get_hyd_help( HYDROLOGY **tmp, WINDOW_CONTROL *wc, char *t, int *ch )
{
HYDROLOGY *a;
HELP_WINDOW hw;
int soil_type;

   w_ptr = NULL;
   hw.v_row = 0;        /*  virtual row in a window */
   hw.select = 0;       /*  current position in help arrays */
   switch ((*tmp)->type) {
      case 4 :
         switch (wc->field) {
            case 5 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 59;
               hw.avail_lines = 4;
               hw.num_entries = 4;
               hw.ulft_col = 10;
               hw.ulft_row = 4;
               hw.total_col = 63;
               hw.total_row = 8;
               master_help( &hw, gen_tbl, gen_head, t, ch );
               break;
            case 9 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 46;
               hw.avail_lines = 4;
               hw.num_entries = 4;
               hw.ulft_col = 10;
               hw.ulft_row = 4;
               hw.total_col = 51;
               hw.total_row = 8;
               master_help( &hw, for_tbl, for_head, t, ch );
            break;
         }
         break;
      case 5 :
         hw.dply_col = 2;
         hw.dply_row = 3;
         hw.line_length = 58;
         hw.avail_lines = 10;
         hw.num_entries = 217;
         hw.ulft_col = 10;
         hw.ulft_row = 4;
         hw.total_col = 62;
         hw.total_row = 14;
         master_help( &hw, bck_tbl, bck_head, t, ch );
         break;
      case 6 :
         switch (wc->field) {
            case 1 :
               hw.dply_col = 2;       /* column to start display in win */
               hw.dply_row = 6;       /* row to start display in window */
               hw.line_length = 28;   /* maximum length of help line    */
               hw.avail_lines = 4;    /* num of lines avail for display */
               hw.num_entries = 4;    /* num of help choices in array   */
               hw.ulft_col = 15;      /* upper left col to begin box    */
               hw.ulft_row = 3;       /* upper left row to begin box    */
               hw.total_col = 30;     /* total num of columns in box    */
               hw.total_row = 11;      /* total num of lines in help box */
               get_rc_help( &hw, ch, t );
               break;
            case 3 :
               hw.dply_col = 2;
               hw.dply_row = 5;
               hw.line_length = 30;
               hw.avail_lines = 7;
               hw.num_entries = 21;
               hw.ulft_col = 10;
               hw.ulft_row = 3;
               hw.total_col = 34;
               hw.total_row = 13;
               for (a=*tmp; a->type != 8; a=a->n);
               hw.select = a->num[5];
               master_help( &hw, cona_tbl, cona_head, t, ch );
               if (*ch == RTURN) {
                  for (a = *tmp; a->type != 8; a=a->n);
                  for (; a->type < 11; a= a->n)
                     a->num[5] = hw.select;
               }
               break;
            case 5 :
               hw.dply_col = 2;
               hw.dply_row = 5;
               hw.line_length = 61;
               hw.avail_lines = 7;
               hw.num_entries = 21;
               hw.ulft_col = 10;
               hw.ulft_row = 4;
               hw.total_col = 65;
               hw.total_row = 13;
               get_chs_help( *tmp, wc, &hw, ch, t );
               break;
            case 6 :
               hw.dply_col = 2;
               hw.dply_row = 5;
               hw.line_length = 61;
               hw.avail_lines = 7;
               hw.num_entries = 21;
               hw.ulft_col = 10;
               hw.ulft_row = 4;
               hw.total_col = 65;
               hw.total_row = 14;
               get_wlw_help( *tmp, wc, &hw, ch, t );
               break;
         }
         break;
      case 7 :
         switch (wc->field) {
            case 0 :
               hw.dply_col = 2;         /* column to start display in win */
               hw.dply_row = 6;         /* row to start display in window */
               hw.line_length = 28;     /* maximum length of help line    */
               hw.avail_lines = 4;      /* num of lines avail for display */
               hw.num_entries = 4;      /* num of help choices in array   */
               hw.ulft_col = 15;        /* upper left col to begin box    */
               hw.ulft_row = 3;         /* upper left row to begin box    */
               hw.total_col = 57;       /* total num of columns in box    */
               hw.total_row = 11;       /* total num of lines in help box */
               get_isoil_help( &hw, ch, t );
               break;
         }
         break;
      case 8  :
      case 9  :
      case 10 :
      case 13 :
      case 14 :
         soil_type = (*tmp)->num[wc->field+5];
         hw.dply_col = 2;
         hw.dply_row = 5;
         hw.line_length = 63;
         hw.avail_lines = 7;
         hw.num_entries = 21;
         hw.ulft_col = 10;
         hw.ulft_row = 5;
         hw.total_col = 67;
         hw.total_row = 13;
         hw.select = soil_type;
         master_help( &hw, soil_tbl, soil_head, t, ch );
         if (*ch == RTURN) {
            set_soil_selection( *tmp, wc, hw );
            fill_card810( *tmp, wc, hw );
            switch ((*tmp)->type) {
               case 8 :
                  soil_type = 0;
                  break;
               case 9 :
                  soil_type = 1;
                  break;
               case 10 :
                  soil_type = 2;
                  break;
               case 13 :
                  soil_type = 3;
                  break;
               case 14 :
                  soil_type = 4;
                  break;
            }
/*            strcpy( t, soil_info[hw.select].val[(*tmp)->type-8] ); */
            strcpy( t, soil_info[hw.select].val[soil_type] );
         }
         break;
      case 11 :
         hw.dply_col = 2;       /* column to start display in win */
         hw.dply_row = 6;       /* row to start display in window */
         hw.line_length = 28;   /* maximum length of help line    */
         hw.avail_lines = 4;    /* num of lines avail for display */
         hw.num_entries = 4;    /* num of help choices in array   */
         hw.ulft_col = 15;      /* upper left col to begin box    */
         hw.ulft_row = 3;       /* upper left row to begin box    */
         hw.total_col = 30;     /* total num of columns in box    */
         hw.total_row = 11;      /* total num of lines in help box */
         get_satk_help( &hw, ch, t );
         break;
      case 29 :
         switch (wc->field) {
            case 0 :
               hw.dply_col = 2;
               hw.dply_row = 5;
               hw.line_length = 30;
               hw.avail_lines = 7;
               hw.num_entries = 78;
               hw.ulft_col = 20;
               hw.ulft_row = 3;
               hw.total_col = 34;
               hw.total_row = 13;
               master_help( &hw, crop_tbl, crop_head, t, ch );
               break;
            case 1 :
            case 2 :
            case 3 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 24;
               hw.avail_lines = 4;
               hw.num_entries = 4;
               hw.ulft_col = 26;
               hw.ulft_row = 4;
               hw.total_col = 28;
               hw.total_row = 14;
               get_date_help( *tmp, wc, &hw, ch, t );
               break;
         }
         break;
      case 30 :
         switch (wc->field) {
            case 0 :
            case 1 :
            case 2 :
               hw.dply_col = 2;
               hw.dply_row = 3;
               hw.line_length = 24;
               hw.avail_lines = 4;
               hw.num_entries = 4;
               hw.ulft_col = 26;
               hw.ulft_row = 4;
               hw.total_col = 28;
               hw.total_row = 14;
               get_date_help( *tmp, wc, &hw, ch, t );
               break;
         }
         break;
   }
}


void get_rc_help( HELP_WINDOW *hw, int *ch, char *t )
{
char tt[10];
int  apd, display;
double lo, hi;

   display = pos.display;
   pos.display = FALSE;
   if (units == ENGLISH) {
      save_and_draw( hw, rc_head_e );
      hi = 0.5;
   } else {
      save_and_draw( hw, rc_head_m );
      hi = 1.3;
   }
   lo = 0.0;
   c_on( );
   memset( tt, '\0', 10 );
   if (*t != '\0') {
      apd = TRUE;
      strcpy( tt, t );
   } else
      apd = FALSE;
   while (*ch != ESC && *ch != RTURN) {
      field_editor( tt, 'R', 4, 12, 37, apd, ch, cfg.hi_i, pos );
      while (tt[0]!='\0' && range_not_ok( tt, lo, hi ))
         field_editor( tt, 'R', 4, 12, 37, FALSE, ch, cfg.hi_i, pos );
      apd = TRUE;
      if ((*ch == RTURN) && tt[0] != '\0')
         strcpy( t, tt );
   }
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row, hw->total_col,
                                               hw->total_row );
   *ch = 0;
   pos.display = display;
}


void get_satk_help( HELP_WINDOW *hw, int *ch, char *t )
{
char tt[10];
int  apd, display;
double lo, hi;

   display = pos.display;
   pos.display = FALSE;
   if (units == ENGLISH) {
      save_and_draw( hw, satk_head_e );
      hi = 6.0;
   } else {
      save_and_draw( hw, satk_head_m );
      hi = 15.0;
   }
   lo = 0.0;
   c_on( );
   memset( tt, '\0', 10 );
   if (*t != '\0') {
      apd = TRUE;
      strcpy( tt, t );
   } else
      apd = FALSE;
   while (*ch != ESC && *ch != RTURN) {
      field_editor( tt, 'R', 4, 12, 37, apd, ch, cfg.hi_i, pos );
      while (tt[0]!='\0' && range_not_ok( tt, lo, hi ))
         field_editor( tt, 'R', 4, 12, 37, FALSE, ch, cfg.hi_i, pos );
      apd = TRUE;
      if ((*ch == RTURN) && tt[0] != '\0')
         strcpy( t, tt );
   }
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row, hw->total_col,
                                               hw->total_row );
   *ch = 0;
   pos.display = display;
}


void get_isoil_help( HELP_WINDOW *hw, int *ch, char *t )
{
char tt[10];
int  apd, display;
double lo, hi;

   display = pos.display;
   pos.display = FALSE;
   save_and_draw( hw, isoil_head );
   lo = 0.0;
   hi = 3.0;
   c_on( );
   memset( tt, '\0', 10 );
   if (*t != '\0') {
      apd = TRUE;
      strcpy( tt, t );
   } else
      apd = FALSE;
   while (*ch != ESC && *ch != RTURN) {
      field_editor( tt, 'W', 4, 12, 43, apd, ch, cfg.hi_i, pos );
      while (tt[0]!='\0' && range_not_ok( tt, lo, hi ))
         field_editor( tt, 'W', 4, 12, 43, FALSE, ch, cfg.hi_i, pos );
      apd = TRUE;
      if ((*ch == RTURN) && tt[0] != '\0')
         strcpy( t, tt );
   }
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row, hw->total_col,
                                               hw->total_row );
   *ch = 0;
   pos.display = display;
}


void get_chs_help( HYDROLOGY *tmp, WINDOW_CONTROL *wc, HELP_WINDOW *hw,
                   int *ch, char *t )
{
char tt[20], dacre_c[20];
int cursor, row, col, display;
float num;

   display = pos.display;
   pos.display = FALSE;
   save_and_draw( hw, chs_head );
   hlight_line( hw->ulft_col+26, hw->ulft_row+11, 4, cfg.lo_i );
   hlight_line( hw->ulft_col+32, hw->ulft_row+11, 8, cfg.lo_i );
   c_on( );
   if (elev_apd == TRUE && flow_apd == TRUE) {
      num = atof( elev_c ) / atof( flow_c );
      ftoa( num, 3, tt );
      fast_write( 12, 13, tt, NORMAL );
   }
   if (flow_apd == TRUE)
      fast_write( 21, 14, flow_c, NORMAL );
   cursor = 0;
   while (*ch != ESC && *ch != RTURN) {
      switch (cursor) {
         case 0 :
            *ch = 0;
            while (*ch != ESC && *ch != RTURN && *ch != TAB &&
                                                 *ch != UP && *ch != DOWN)
               field_editor( elev_c, 'R', 5, 12, 25, elev_apd, ch, cfg.hi_i,
                             pos );
            if (*elev_c == '\0')
               elev_apd = FALSE;
            else
               elev_apd = TRUE;
            break;
         case 1 :
            *ch = 0;
            while (*ch != ESC && *ch != RTURN && *ch != TAB &&
                                                 *ch != UP && *ch != DOWN)
               field_editor( flow_c, 'R', 10, 14, 21, flow_apd, ch, cfg.hi_i,
                             pos );
            if (*flow_c == '\0')
               flow_apd = FALSE;
            else {
               if (atof( flow_c ) == 0.) {
                  *flow_c = '\0';            /* can't divide by zero  */
                  *ch = 0;
               } else
                  flow_apd = TRUE;
            }
            break;
      }
      if ((*ch == TAB || *ch == DOWN) && cursor == 0)
         cursor = 1;
      else if ((*ch == TAB || *ch == UP) && cursor == 1)
         cursor = 0;
      if (elev_apd == TRUE && flow_apd == TRUE) {
         num = atof( elev_c) / atof( flow_c );
         ftoa( num, 3, tt );
         fast_write( 12, 13, tt, NORMAL );
      } else
         fast_write( 12, 13, "    ", NORMAL );
   }
   if (*ch == RTURN && elev_apd == TRUE && flow_apd == TRUE && tt[0] != '\0')
      strcpy( t, tt );
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   if (tmp->apd[0] == TRUE) {
      get_string_field_value( tmp, dacre_c, 0 );
      if (units == ENGLISH)
         num = (atof( flow_c ) * atof( flow_c )) / (atof( dacre_c ) * 43560.);
      else
         num = (atof( flow_c ) * atof( flow_c )) / (atof( dacre_c ) * 10000.);
      ftoa( num, 3, tt );
      col = wc->d_col + 6 * 8 + 8 - 7 - 8 * wc->view;
      row = wc->v_row + wc->d_row;      /* 7 = width of chs on front end */
      fast_write( col, row, "       ", NORMAL );
      fast_write( col+7-strlen(tt), row, tt, NORMAL );
      set_field_value( tmp, tt, 6, TRUE );
   }
   *ch = 0;
   pos.display = display;
}


void get_wlw_help( HYDROLOGY *tmp, WINDOW_CONTROL *wc, HELP_WINDOW *hw,
                   int *ch, char *t )
{
char tt[20], dacre_c[20], blank[10];
int cursor, dacre_apd, row, col, display;
float num;

   display = pos.display;
   pos.display = FALSE;
   memset( blank, ' ', 7 );
   blank[7] = '\0';
   if (units == ENGLISH)
      save_and_draw( hw, wlw_head_e );
   else
      save_and_draw( hw, wlw_head_m );
   hlight_line( hw->ulft_col+26, hw->ulft_row+12, 4, cfg.lo_i );
   hlight_line( hw->ulft_col+32, hw->ulft_row+12, 8, cfg.lo_i );
   c_on( );
   if (tmp->apd[0] == TRUE) {
      get_string_field_value( tmp, dacre_c, 0 );
      dacre_apd = TRUE;
   } else {
      *dacre_c = '\0';
      dacre_apd = FALSE;
   }
   if (flow_apd == TRUE && dacre_apd == TRUE) {
      if (units == ENGLISH)
         num = (atof( flow_c ) * atof( flow_c )) / (atof( dacre_c ) * 43560.);
      else
         num = (atof( flow_c ) * atof( flow_c )) / (atof( dacre_c ) * 10000.);
      ftoa( num, 3, tt );
      fast_write( 12, 13, tt, NORMAL );
   }
   if (dacre_apd == TRUE)
      fast_write( 26, 14, dacre_c, NORMAL );
   cursor = 0;
   while (*ch != ESC && *ch != RTURN) {
      switch (cursor) {
         case 0 :
            *ch = 0;
            while (*ch != ESC && *ch != RTURN && *ch != TAB &&
                                                 *ch != UP && *ch != DOWN)
               field_editor( flow_c, 'R', 8, 12, 26, flow_apd, ch, cfg.hi_i,
                             pos );
            if (*flow_c == '\0')
               flow_apd = FALSE;
            else
               flow_apd = TRUE;
            break;
         case 1 :
            *ch = 0;
            while (*ch != ESC && *ch != RTURN && *ch != TAB &&
                                                 *ch != UP && *ch != DOWN)
               field_editor( dacre_c, 'R', 6, 14, 26, dacre_apd, ch, cfg.hi_i,
                             pos );
            if (*dacre_c == '\0')
               dacre_apd = FALSE;
            else {
               if (atof( dacre_c ) == 0.) {
                  *dacre_c = '\0';            /* can't divide by zero  */
                  *ch = 0;
               } else
                  dacre_apd = TRUE;
            }
            break;
      }
      if ((*ch == TAB || *ch == DOWN) && cursor == 0)
         cursor = 1;
      else if ((*ch == TAB || *ch == UP) && cursor == 1)
         cursor = 0;
      if (flow_apd == TRUE && dacre_apd == TRUE) {
         if (units == ENGLISH)
            num = (atof( flow_c ) * atof( flow_c )) /(atof( dacre_c ) * 43560.);
         else
            num = (atof( flow_c ) * atof( flow_c )) /(atof( dacre_c ) * 10000.);
         ftoa( num, 3, tt );
         fast_write( 12, 13, tt, NORMAL );
      } else
         fast_write( 12, 13, blank, NORMAL );
   }
   if (*ch == RTURN && flow_apd == TRUE && dacre_apd == TRUE && tt[0] != '\0')
      strcpy( t, tt );
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   if (*ch == RTURN && dacre_apd == TRUE) {
      get_string_field_value( tmp, tt, 0 );
      if (atof( tt ) != atof( dacre_c )) {
         if (wc->view == VLEFT) {           /* 7 width for DACRE */
            row = wc->v_row + wc->d_row;
            col = wc->d_col + 8 - 7;
            fast_write( col, row, blank, NORMAL );
            fast_write( col+7-strlen( dacre_c ), row, dacre_c, NORMAL );
         }
         set_field_value( tmp, dacre_c, 0, TRUE );
      }
   }
   if (*ch == RTURN && flow_apd == TRUE && elev_apd == TRUE) {
      num = atof( elev_c ) / atof( flow_c );
      ftoa( num, 3, tt );                     /* 5 = chs position on card 5 */
      col = wc->d_col + 5 * 8 + 8 - 7 - 8 * wc->view;
      row = wc->v_row + wc->d_row;      /* 7 = width of chs on front end */
      fast_write( col, row, blank, NORMAL );
      fast_write( col+7-strlen( tt ), row, tt, NORMAL );
      set_field_value( tmp, tt, 5, TRUE );
   }
   *ch = 0;
   pos.display = display;
}


void set_soil_selection( HYDROLOGY *tmp, WINDOW_CONTROL *wc, HELP_WINDOW hw )
{
HYDROLOGY *a;

   for (a = tmp; a->type != 8; a=a->p);
   for (; a->type < 11; a= a->n)
      a->num[wc->field+5] = hw.select;
   for (; a->type != 13; a=a->n);
   for (; a->type < 15; a= a->n)
      a->num[wc->field+5] = hw.select;
}


void fill_card810( HYDROLOGY *tmp, WINDOW_CONTROL *wc, HELP_WINDOW hw )
{
HYDROLOGY *a;
int i;

   for (a = tmp; a->type != 8; a=a->p);
   for (i=0; a->type < 11; a= a->n, i++)
      set_field_value( a, soil_info[hw.select].val[i], wc->field, TRUE );
   for (; a->type != 13; a=a->n);
   for (i=3; a->type < 15; a= a->n, i++)
      set_field_value( a, soil_info[hw.select].val[i], wc->field, TRUE );
   for (a=tmp, i=wc->v_row; a->type != 8 && i >= 0; a=a->p)
      i--;
   scroll_and_show( a, wc,  i + wc->d_row );
}


void show_help_list( HELP_WINDOW *hw, TABLE_TYPE *help, int row_spacing )
{
int row, col, i, j;

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row;
/*   i = hw->v_row; */
   i = 0;
   j = hw->select - hw->v_row;
   for (; i < hw->avail_lines && j<hw->num_entries; i+=row_spacing, j++, row++)
      fast_write( col, row, help[j].line, NORMAL );
}


void position_cursor( HELP_WINDOW *hw, char *str, int *un, int *cc, int *ch )
{
int col, row, y, yy;

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row + hw->v_row;
   y  = hw->ulft_row + hw->dply_row;
   yy = hw->ulft_row + hw->dply_row + hw->avail_lines - 1;
   *un = FALSE;
   switch (*ch) {
      case UP    :
         if (hw->v_row > 0 && hw->select > 0) {
            hlight_line( col, row, strlen( str ), NORMAL );
            --hw->v_row;
            --hw->select;
            *cc = TRUE;
         } else if (hw->v_row == 0 && hw->select > 0) {
            hlight_line( col, row, strlen( str ), NORMAL );
            --hw->select;
            scroll_window( -1, y, col, yy+1, col+hw->line_length, NORMAL );
            *un = TRUE;
            *cc = TRUE;
         }
         break;
      case DOWN :
         if (hw->v_row < hw->avail_lines-1 &&
                                      hw->select < hw->num_entries-1) {
            hlight_line( col, row, strlen( str ), NORMAL );
            ++hw->v_row;
            ++hw->select;
            *cc = TRUE;
         } else if (hw->v_row == hw->avail_lines-1 &&
                                      hw->select < hw->num_entries-1) {
            hlight_line( col, row, strlen( str ), NORMAL );
            ++hw->select;
            scroll_window( 1, y, col, yy, col+hw->line_length, NORMAL );
            *un = TRUE;
            *cc = TRUE;
         } else if (hw->select == hw->num_entries - 1 && hw->v_row > 0) {
            --hw->v_row;
            scroll_window( 1, y, col, yy, col+hw->line_length, NORMAL );
         }
         break;
   }
}


void master_help( HELP_WINDOW *hw, TABLE_TYPE *help,
                  struct screen *help_heading, char *t, int *ch )
{
int col, row, i;
int update_name, change_color, draw_page;
char str[80];

   save_and_draw( hw, help_heading );
   show_help_list( hw, help, 1 );

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row + hw->v_row;
   change_color = TRUE;
   *ch = 0;
   while (*ch!=RTURN && *ch!=ESC) {
      draw_page = FALSE;
      strcpy( str, help[hw->select].line );
      position_cursor( hw, str, &update_name, &change_color, ch );
      switch (*ch) {
         case PGUP :
            if (hw->select > hw->avail_lines-1) {
               hw->select = hw->select - hw->avail_lines;
               if (hw->v_row > hw->select)
                  hw->select = hw->v_row;
               draw_page = TRUE;
            } else if (hw->select - hw->v_row > 0) {
               hw->select = hw->v_row;
               draw_page = TRUE;
            }
            break;
         case PGDN :
            if (hw->select + hw->avail_lines < hw->num_entries) {
               hw->select = hw->select + hw->avail_lines;
               draw_page = TRUE;
            } else if (hw->select + hw->avail_lines - hw->v_row <
                                                         hw->num_entries) {
               hw->select = hw->num_entries - 1;
               draw_page = TRUE;
            }
            if ((hw->num_entries - 1) - hw->select <
                                              hw->avail_lines && draw_page) {
               i = row - hw->v_row;
               scroll_window( 0, i, col, i+hw->avail_lines-1,
                              col+hw->line_length, NORMAL );
            }
            break;
      }
      if (draw_page == TRUE) {
         show_help_list( hw, help, 1 );
         update_name = TRUE;
         change_color = TRUE;
      }
      row = hw->ulft_row + hw->dply_row + hw->v_row;
      if (update_name)
         fast_write( col, row, help[hw->select].line, NORMAL );
      if (change_color)
         hlight_line( col, row, strlen( help[hw->select].line ), cfg.hi_i );
      *ch = getkey( );
      change_color = FALSE;
   }
   c_on( );
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   if (*ch == RTURN)
      strcpy( t, help[hw->select].value );
   else
      *ch = 0;
}


void save_and_draw( HELP_WINDOW *hw, struct screen *help_heading )
{
   c_off( );
   window_control( &w_ptr, SAVE, hw->ulft_col, hw->ulft_row,
                   hw->total_col, hw->total_row );
   no_buf_make_window( hw->ulft_col, hw->ulft_row, hw->total_col,
                   hw->total_row, NORMAL );
   write_to_window( help_heading, hw->ulft_col, hw->ulft_row, NORMAL );
}


void get_rot_yr( HELP_WINDOW *hw, DATE_TYPE *date, int *ch, float hi,
                 float lo)
{
int row, col, low, high, day, lo_day;

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row;
   low = floor( lo / 1000. );
   lo_day = ( (long)lo % 1000L );
   high= floor( hi / 1000. );
   day = date->jday;
   write_irot_date( row, col, date, cfg.hi_i );
   *ch = 0;
   while (*ch!=RTURN && *ch!=ESC && *ch!=F2) {
      switch (*ch) {
         case UP   :
            if (date->irot == low)
               date->irot = high;
            else
               --date->irot;
            break;
         case DOWN :
            if (date->irot == high)
               date->irot = low;
            else
               ++date->irot;
            break;
      }
      if (date->irot == low) {
         if (date->jday < lo_day)
            date->jday = lo_day;
         else
            date->jday = day;
      } else
         date->jday = day;
      month_day( date->jday, &date->mo, &date->day );
      if (*ch == UP || *ch == DOWN)
         write_irot_date( row, col, date, cfg.hi_i );
      *ch = getkey( );
   }
   if (*ch != ESC)
      write_irot_date( row, col, date, cfg.lo_i );
}


void get_date( HELP_WINDOW *hw, DATE_TYPE *date, int *ch, float hi, float lo )
{
int i, row, col, low, high, test, lo_year;

   high= ( (long)hi % 1000L );
   lo_year = (long)lo / 1000L;
   if (date->irot == lo_year)
      low = ( (long)lo % 1000L );
   else
      low = 1;
   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row;
   if (date->jday == 0)
      date->jday = 1;
   if (date->jday < low)
      date->jday = low;
   else if (date->jday > high)
      date->jday = high;
   write_date( row, col, date, cfg.hi_i );
   *ch = 0;
   while (*ch!=RTURN && *ch!=ESC && *ch!=F1) {
      switch (*ch) {
         case UP   :
            if (date->jday <= low) {
               date->jday = high;
            } else
               --date->jday;
            break;
         case DOWN :
            if (date->jday >= high || date->jday == 365) {
               date->jday = low;
            } else
               ++date->jday;
            break;
         case PGUP :
            if (date->mo == 0)
               date->mo = 11;
            else
               --date->mo;
            if (date->day > day_tab[date->mo])
               date->day = day_tab[date->mo];
            test = day_of_year( date->mo, date->day );
            if (test < low || test > high) {
               test = day_of_year( 11, date->day );
               for (i=11; test > high && i >= 0; i--) {
                  if (date->day > day_tab[i])
                     date->day = day_tab[i];
                  test = day_of_year( i, date->day );
               }
               date->mo = i;
            }
            date->jday = day_of_year( date->mo, date->day );
            break;
         case PGDN :
            if (date->mo == 11)
               date->mo = 0;
            else
               ++date->mo;
            if (date->day > day_tab[date->mo])
               date->day = day_tab[date->mo];
            test = day_of_year( date->mo, date->day );
            if (test > high || test < low) {
               test = day_of_year( 0, date->day );
               for (date->mo=i=0; test < low && i <= 11; i++) {
                  if (date->day > day_tab[i])
                     date->day = day_tab[i];
                  test = day_of_year( i, date->day );
                  date->mo = i;
               }
            }
            date->jday = day_of_year( date->mo, date->day );
            break;
      }
      month_day( date->jday, &date->mo, &date->day );
      if (*ch == UP || *ch == DOWN || *ch == PGUP || *ch == PGDN)
         write_date( row, col, date, cfg.hi_i );
      *ch = getkey( );
   }
   write_date( row, col, date, cfg.lo_i );
}


void write_date( int row, int col, DATE_TYPE *date, int intensity )
{
char t[20];

   fast_write( col+9, row+4, mos[date->mo], NORMAL );
   fast_write( col+21, row+4, "   ", NORMAL );
   fast_write( col+21, row+4, itoa( date->day, t, 10 ), NORMAL );
   date->jday = day_of_year( date->mo, date->day );
   fast_write( col+18, row+3, "   ", NORMAL );
   fast_write( col+18, row+3, itoa( date->jday, t, 10 ), intensity );
   date->gday = 1000L * date->irot + date->jday;
   fast_write( col+17, row+6, "     ", NORMAL );
   fast_write( col+17, row+6, ltoa( date->gday, t, 10 ), NORMAL );
}


void write_irot_date( int row, int col, DATE_TYPE *date, int intensity )
{
char t[20];

   write_date( row, col, date, cfg.lo_i );
   fast_write( col+21, row+1, "  ", NORMAL );
   fast_write( col+21, row+1, itoa( date->irot, t, 10 ), intensity );
   date->jday = day_of_year( date->mo, date->day );
   date->gday = 1000L * date->irot + date->jday;
   fast_write( col+17, row+6, "     ", NORMAL );
   fast_write( col+17, row+6, ltoa( date->gday, t, 10 ), NORMAL );
}


int  day_of_year( int month, int day )
{
int i;

   for (i=0; i<month; i++)
      day += day_tab[i];
   return( day );
}


void month_day( int jday, int *month, int *day )
{
int i;

   if (jday == 366) {
      *day = 31;
      *month = 11;
   } else {
      for (i=0; jday > day_tab[i]; i++)
         jday -= day_tab[i];
      *day = jday;
      *month = i;
   }
}


void get_date_help( HYDROLOGY *tmp, WINDOW_CONTROL *wc, HELP_WINDOW *hw,
                    int *ch, char *t )
{
char tt[10];
int col, row, display, cell_r, rot, day, field, low;
double lo, hi;
DATE_TYPE date;

   cell_r = tmp->type - 4;
   display = pos.display;
   pos.display = FALSE;
   lo = (*limits)[cell_r].range[wc->field].lo;
   hi = (*limits)[cell_r].range[wc->field].hi;
   low = (long)lo % 1000L;
   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row;
   date.jday = low;
   month_day( date.jday, &date.mo, &date.day );
   date.irot = floor( lo / 1000. );
   save_and_draw( hw, date_head );
   memset( tt, '\0', 10 );
   write_date( row, col, &date, cfg.lo_i );
   *ch = 0;
   field = 0;
   rot = FALSE;
   day = FALSE;
   while (*ch != ESC && *ch != RTURN) {
      switch (field) {
         case 0 :
            get_rot_yr( hw, &date, ch, hi, lo );
            rot = TRUE;
            break;
         case 1 :
            get_date( hw, &date, ch, hi, lo );
            day = TRUE;
            break;
      }
      if (*ch == F1)
         field = 0;
      else if (*ch == F2)
         field = 1;
   }
   if (*ch == RTURN && rot == TRUE && day == TRUE) {
      date.gday = 1000L * date.irot + date.jday;
      ltoa( date.gday, tt, 10 );
      strcpy( t, tt );
   }
   window_control( &w_ptr, RESTORE, hw->ulft_col, hw->ulft_row, hw->total_col,
                                               hw->total_row );
   *ch = 0;
   c_on( );
   pos.display = display;
}
