/*
 * SUMMARY:      ReportError.c - Report error and exit
 * USAGE:        Part of DHSVM
 *
 * AUTHOR:       Bart Nijssen
 * ORG:          University of Washington, Department of Civil Engineering
 * E-MAIL:       nijssen@u.washington.edu
 * ORIG-DATE:    Apr-96
 * LAST-MOD: Wed Jun 11 10:57:44 1997 by Bart Nijssen <nijssen@meter.ce.washington.edu>
 * DESCRIPTION:  Display a context-dependent error message and exit
 * DESCRIP-END.
 * FUNCTIONS:    ReportError()
 *               ReportWarning()
 * COMMENTS:     
 */

#ifndef lint
static char vcid[] = "$Id$";
#endif /* lint */

#include <stdio.h>
#include <stdlib.h>
#include "settings.h"
#include "data.h"
#include "DHSVMerror.h"

static char *ErrorMessage[] = {
  "Cannot allocate enough memory in function:",	/* 1 */
  "Error while reading file:",	/* 2 */
  "Cannot open file:",		/* 3 */
  "File already exists, and should not be overwritten:", /* 4 */
  "Error reading input in file:", /* 5 */
  "No met locations specified in file:", /* 6 */
  "Hourly timestep does not divide 24 in function:", /* 7 */
  "No types defined in file: ",	/* 8 */
  "Incorrect number of scientific datasets in HDF file with info on:", /* 9 */
  "Scientific dataset with incorrect rank in HDF file:", /* 10 */
  "Scientific dataset with incorrect number type in HDF file:",	/* 11 */
  "Scientific dataset with incorrect dimensions in HDF file:", /* 12 */
  "HDF error:",			/* 13 */
  "Unexpected error returned by:", /* 14 */
  "Error in switch():",		/* 15 */
  "Absolute value of number larger than MAX_INT: ", /* 16 */
  "Pixel to be dumped does not lie in the model area:",	/* 17 */
  "Pixel to be dumped does not lie within the modeled basin:", /* 18 */
  "Not a valid ID for variable to be dumped:", /* 19 */
  "Wrong layer number to be dumped:", /* 20 */
  "Invalid resolution specifier in:", /* 21 */
  "Invalid number of single maps to dump specified in:", /* 22 */
  "Invalid date specified in:",	/* 23 */
  "Invalid time interval for map dumps in:", /* 24 */
  "Invalid period for map dumps in:", /* 25 */
  "Invalid variable ID in:",	/* 26 */
  "Invalid heat flux option specifier: ", /* 27 */
  "Date in met file does not correspond to current model time:", /* 28 */
  "Too many vegetation layers: ", /* 29 */
  "Incorrect flag (valid flags: T, F): ", /* 30 */
  "Radar precipitation does not cover entire model area:", /* 31 */
  "Unknown soil type in file:",	/* 32 */
  "Maximum number of iterations exceeded in RootBrent():", /* 33 */
  "Root not bracketed in RootBrent():",	/* 34 */
  "Soil moisture profile is supersaturated: ", /* 35 */
  "Grid NOT square, resulting in problems with flow width calculation:", /* 36 */
  "Radar precipitation file starts later than start of run:", /* 37 */
  "Invalid file format specifier:", /* 38 */
  "Error setting file pointer:", /* 39 */
  "Unknown number type:",	/* 40 */
  "Error writing to file:",	/* 41 */
  "HAVE_HDF undefined, cannot read hdf format:", /* 42 */
  "Invalid radiation type specifier:", /* 43 */
  "Invalid channel/road network specifier:", /* 44 */
  "Invalid flow gradient specifier:", /* 45 */
  "Incorrect travel times in hydrograph file:",	/* 46 */
  "Table index out of bounds: ", /* 47 */
  "Wind profile error:",	/* 48 */
  "Current version does not support more than two vegetation layers:", /* 49 */
  "Section not found:",		/* 50 */
  "Key not found or invalid entry:", /* 51 */
  "Invalid key or required key (no default value):", /* 52 */
  "Invalid station number:"	/* 53 */
};

void ReportError(char *ErrorString, int ErrorCode)
{
  const char *Routine = "ReportError";
  fprintf(stderr, "%s %s\n", ErrorMessage[ErrorCode-1], ErrorString);

  exit(ErrorCode);
}

void ReportWarning(char *ErrorString, int ErrorCode)
{
  const char *Routine = "ReportError";

  fprintf(stderr, "%s %s\n", ErrorMessage[ErrorCode-1], ErrorString);
}

