/* -------------------------------------------------------------
   file: DHSVMChannel.h
   ------------------------------------------------------------- */
/* -------------------------------------------------------------
   Battelle Memorial Institute
   Pacific Northwest Laboratory
   ------------------------------------------------------------- */
/* -------------------------------------------------------------
   Created August 30, 1996 by  William A Perkins
   Last Change: Fri May 30 23:46:25 1997 by  <nijssen@u.washington.edu>
   ------------------------------------------------------------- */

/* $Id: DHSVMChannel.h,v 1.4 1997/04/23 21:29:05 battelle Exp $ */

#ifndef _DHSVMChannel_h_
#define _DHSVMChannel_h_

#include "settings.h"           /* for data.h */
#include "data.h"
#include "channel.h"
#include "channel_grid.h"

/* -------------------------------------------------------------
   struct CHANNEL
   ------------------------------------------------------------- */
typedef struct {
  ChannelClass *stream_class;
  ChannelClass *road_class;
  Channel *streams;
  Channel *roads;
  ChannelMapPtr **stream_map;
  ChannelMapPtr **road_map;
  FILE *streamout;
  FILE *roadout;
} CHANNEL;

/* -------------------------------------------------------------
   available functions
   ------------------------------------------------------------- */
void InitChannel(char *InFileName, MAPSIZE *Map, int deltat, CHANNEL *channel);
void InitChannelDump(CHANNEL *channel, char *DumpPath);
double ChannelCulvertFlow(int y, int x, CHANNEL *ChannelData);
void RouteChannel(CHANNEL *ChannelData, TIMESTRUCT *Time, MAPSIZE *Map, 
                  TOPOPIX **TopoMap, SOILPIX **SoilMapi, AGGREGATED *Total);
void ChannelCut(int y, int x, CHANNEL *ChannelData, ROADSTRUCT *Network);
uchar ChannelFraction(TOPOPIX *topo, ChannelMapRec *rds);

#endif
