! Time of File Save by ERB: 6/15/2006 12:51PM
C     Last change:  SAL   3 Sep 2003    7:37 am
      MODULE SUBARRAYS
      LOGICAL NDF,NNDF,OCFLGS,OCLAY
      DIMENSION ISBOCF(6),ISBOCU(6)
      ALLOCATABLE OCFLGS(:,:)
      ALLOCATABLE OCLAY(:)
      ALLOCATABLE ILSYS(:)
      ALLOCATABLE RNB(:)
      ALLOCATABLE LN(:)
      ALLOCATABLE LDN(:)
      ALLOCATABLE DH(:)
      ALLOCATABLE DHP(:)
      ALLOCATABLE DHC(:)
      ALLOCATABLE NZ(:)
      ALLOCATABLE DZ(:)
      ALLOCATABLE DP(:,:)
      ALLOCATABLE HC(:)
      ALLOCATABLE SCE(:)
      ALLOCATABLE SCV(:)
      ALLOCATABLE DCOM(:)
      ALLOCATABLE DVB(:,:)
      ALLOCATABLE A1(:)
      ALLOCATABLE A2(:)
      ALLOCATABLE BB(:)
      ALLOCATABLE SUB(:)
      ALLOCATABLE NTSSUM(:)
      END MODULE SUBARRAYS
      SUBROUTINE GWF1SUB1ALP(NROW,NCOL,NLAY,ITERP,IIBSCB,ISUBOC,AC1,AC2,
     1    ITMIN,NNDB,NDB,NMZ,NN,NND1,ND1,ND2,IDSAVE,IDREST,ISSFLG,NPER,
     2    NSTP,NSTPT,IN,IOUT,ISIP,LCV,ISEN)
C
C-----VERSION 0000 06JUN2006 GWF1SUB1ALP
C     ******************************************************************
C     ALLOCATE ARRAY STORAGE FOR SUBSIDENCE PACKAGE
C     ******************************************************************
C        Modifications, 06JUN2006:
C                  1. Made check for error condition of ND2<1 active only
C                     when delay beds are present.
C                  2. Corrected the way space is allocated for arrays
c                     OCFLGS, OCLAY, and ILSYS to allow the package to
C                     allocate when delay beds are not present.
C                  3. Changed some READ statements to calls to URDCOM to
C                     allow use of comments at select locations in the
C                     input file.
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS
      CHARACTER*24 ANAME
      CHARACTER*200 LINE
      DIMENSION ISSFLG(NPER),NSTP(NPER)
      DATA ANAME/'NUMBER OF BEDS IN SYSTEM'/
C     ------------------------------------------------------------------
C0------Define SIP LCV array pointer  if SIP is inactive.
      IF(ISIP.LE.0) LCV=1
C
C1------IDENTIFY PACKAGE.
      WRITE(IOUT,1)IN
    1 FORMAT(/,'SUB1 -- SUBSIDENCE PACKAGE, VERSION 1,',
     1     ' 06/21/88',' INPUT READ FROM UNIT',I3)
C
C2------CHECK TO SEE THAT SUBSIDENCE OPTION IS APPROPRIATE
C2------IF INAPPROPRIATE PRINT A MESSAGE & STOP THE SIMULATION.
C2------ALSO, SUM TO GET THE TOTAL NUMBER OF TIME STEPS IN THE
C2------SIMULATION.
C
      NSTPT=0
      DO 12 NS=1,NPER
      NSTPT=NSTPT+NSTP(NS)
      IF(ISSFLG(NS).NE.0.AND.NS.GT.1) THEN
       WRITE(IOUT,10)
   10  FORMAT(1X,'SUBSIDENCE CANNOT BE USED IN SIMULATIONS',
     1  ' IN WHICH STRESS PERIODS OTHER THAN THE ',/,1X,
     2  ' FIRST ARE STEADY-STATE. SIMULATION ABORTED.')
       CALL USTOP(' ')
      ENDIF
 12   CONTINUE
C2b------PRINT A MESSAGE AND STOP THE SIMULATION IF BOTH THE SEN
C2b------ PROCESS IS USED WITH THE SUB PACKAGE ACTIVE.
      IF(ISEN.GT.0) THEN
       WRITE(IOUT,104)
  104  FORMAT(1H0,'***ERROR*** THE SUB PACKAGE CANNOT BE USED ',
     1     'WITH THE ',/,
     2     'SENSITIVITY PROCESS. SIMULATION ABORTED. ')
       CALL USTOP(' ')
      ENDIF
C
C ------ALLOCATE SPACE FOR ARRAY NTSSUM, WHICH WILL CONTAIN THE TOTAL
C ------NUMBER OF TIME STEPS PRIOR TO THE CURRENT TIME STEP.
      IF(ITERP.EQ.1) ALLOCATE(NTSSUM(NPER))
C
C4------READ FLAG FOR STORING CELL-BY-CELL STORAGE CHANGES AND
C4------FLAG FOR PRINTING AND STORING COMPACTION, SUBSIDENCE, AND
C4------CRITICAL HEAD ARRAYS.
      CALL URDCOM(IN,IOUT,LINE)
      LLOC=1
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IIBSCB,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISUBOC,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,NNDB,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,NDB,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,NMZ,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,NN,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,3,I,AC1,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,3,I,AC2,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ITMIN,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IDSAVE,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IDREST,R,IOUT,IN)
C-----
      IF(AC2.EQ.0.0) AC2=1.0
      NDF=.TRUE.
      NNDF=.TRUE.
      IF(NNDB.LT.1) THEN
       NNDF=.FALSE.
       NNDB=0
      ENDIF
      IF(NDB.LT.1) THEN
       NDF=.FALSE.
       NDB=0
       NMZ=0
       NN=0
      ENDIF
      WRITE(IOUT,50) NNDB,NDB,NMZ,NN
   50 FORMAT(/,'         NUMBER OF SYSTEMS OF NO-DELAYED INTERBEDS:',
     1 I3,/,'              NUMBER OF SYSTEMS OF DELAY INTERBEDS:',
     2 I3,/,'                          NUMBER OF MATERIAL ZONES:',
     3 I3,/,'                    NUMBER OF NODES IN EACH STRING:',I3)
      IF(IDSAVE.GT.0) THEN
       WRITE(IOUT,52) IDSAVE
   52 FORMAT(' RESTART INFORMATION WILL BE SAVED ON UNIT ', I5,
     1 ' FOR DELAY INTERBEDS')
      ELSE
       WRITE(IOUT,53)
   53 FORMAT(' RESTART INFORMATION WILL NOT BE SAVED FOR DELAY',
     1 ' INTERBEDS')
      ENDIF
      IF(IDREST.GT.0) THEN
       WRITE(IOUT,54) IDREST
   54 FORMAT(' RESTART INFORMATION WILL BE READ FROM UNIT ', I5,
     1 ' FOR DELAY INTERBEDS')
      ELSE
       WRITE(IOUT,55)
   55 FORMAT(' RESTART INFORMATION WILL NOT BE READ FOR DELAY',
     1 ' INTERBEDS')
      ENDIF
C
C ------ABORT IF NO LAYERS ARE SPECIFIED FOR INTERBED STORAGE
      IF(.NOT.NNDF.AND..NOT.NDF) THEN
       WRITE(IOUT,60)
   60  FORMAT(1X,'NO LAYERS WITH INTERBED STORAGE OF EITHER TYPE ',
     1  'WERE SPECIFIED IN INPUT.',/,1X,'SIMULATION ABORTED.')
       CALL USTOP(' ')
      ENDIF
C ------ABORT IF NO PROPERTY ZONES ARE SPECIFIED
      IF(NDF.AND.NMZ.LT.1) THEN
         WRITE(IOUT,*) ' STOPPING-- At least one property zone must ',
     &                 'be specified for delay beds.'
         CALL USTOP(' ')
      ENDIF
C ------ABORT IF NOT ENOUGH NODES ARE SPECIFIED
      IF(NDF.AND.NN.LT.2) THEN
         WRITE(IOUT,*) ' STOPPING-- Number of nodes in strings for ',
     &                 'delay beds (NN) should be at least 2.'
         CALL USTOP(' ')
      ENDIF
C
C5------IF CELL-BY-CELL TERMS TO BE SAVED THEN PRINT UNIT NUMBER.
   70 IF(IIBSCB.GT.0) WRITE(IOUT,80) IIBSCB
   80 FORMAT(1X,'CELL-BY-CELL FLOW TERMS WILL BE SAVED ON UNIT',I3)
C
C5A-----IF OUTPUT CONTROL FOR PRINTING ARRAYS IS SELECTED PRINT MESSAGE.
      IF(ISUBOC.GT.0) WRITE(IOUT,90) ISUBOC
   90 FORMAT(1X,I4,' OUTPUT CONTROL RECORDS FOR SUB PACKAGE WILL BE ',
     1 'READ.')
C ------READ IN MODEL LAYER NUMBERS FOR EACH SYSTEM OF INTERBEDS,
C ------FOR LAYERS WITHOUT DELAY.
      IF(NNDF) THEN
       IF(ITERP.EQ.1) ALLOCATE(LN(NNDB))
       WRITE(IOUT,100) NNDB
  100  FORMAT(/,' MODEL LAYER ASSIGNMENTS FOR EACH OF',I3,' NO-DELAY',
     1  ' SYSTEMS OF INTERBEDS:')
       CALL URDCOM(IN,IOUT,LINE)
       READ(LINE,*) (LN(N),N=1,NNDB)
       WRITE(IOUT,115) (LN(N),N=1,NNDB)
  115  FORMAT(1X,25I4)
       DO 120 N=1,NNDB
       IF(LN(N).GE.1.AND.LN(N).LE.NLAY) GO TO 120
       WRITE(IOUT,118)
  118  FORMAT(/,' IMPROPER LAYER ASSIGNMENT FOR NO-DELAY SYSTEM OF ',
     1  'INTERBEDS.',/,' ABORTING...')
       CALL USTOP(' ')
  120  CONTINUE
      ENDIF
C ------READ IN MODEL LAYER NUMBERS FOR EACH SYSTEM OF INTERBEDS,
C ------FOR LAYERS WITH DELAY.
      IF(NDF) THEN
       IF(ITERP.EQ.1) ALLOCATE(LDN(NDB))
       WRITE(IOUT,135) NDB
  135  FORMAT(/,' MODEL LAYER ASSIGNMENTS FOR EACH OF',I3,' DELAY',
     1  ' SYSTEMS OF INTERBEDS:')
       CALL URDCOM(IN,IOUT,LINE)
       READ(LINE,*) (LDN(N),N=1,NDB)
       WRITE(IOUT,115) (LDN(N),N=1,NDB)
       DO 140 N=1,NDB
       IF(LDN(N).GE.1.AND.LDN(N).LE.NLAY) GO TO 140
       WRITE(IOUT,138)
  138  FORMAT(/,' IMPROPER LAYER ASSIGNMENT FOR DELAY SYSTEM OF ',
     1  'INTERBEDS.',/,' ABORTING...')
       CALL USTOP(' ')
  140  CONTINUE
      ENDIF
C
C ------
C
C8------ALLOCATE SPACE FOR THE ARRAYS HC, SCE, SCV, AND SUB.
      NCR=NROW*NCOL
      NND1=NCR*NNDB
      ND1=NCR*NDB
      ND2=0
C -----READ IN ARRAY RND TO SEE HOW MANY STRINGS OF NN CELLS ARE NEEDED.
      IF(NDF) THEN
       IF(ITERP.EQ.1) ALLOCATE(RNB(ND1))
       NNSUM=0
       DO 190 KQ=1,NDB
       LOC1 = 1+(KQ-1)*NCR
       LAYNUM=LDN(KQ)
       WRITE(IOUT,144) KQ
 144   FORMAT(/,1X,' SYSTEM',I4,' OF DELAY BEDS:')
       CALL U2DREL(RNB(LOC1),ANAME,NROW,NCOL,LAYNUM,IN,IOUT)
       DO 180 N=1,NCR
       IF(RNB(LOC1+N-1).GE.1.0) NNSUM=NNSUM+1
  180  CONTINUE
  190  CONTINUE
       ND2=NN*NNSUM
      ENDIF
      IF(ND2.LT.1.AND.NDF) THEN
         WRITE(IOUT,*) ' STOPPING-- Delay beds were not found in ',
     &                 ' array specifying numbers of delay beds (RNB).'
         CALL USTOP(' ')
      ENDIF
C
      IF(ITERP.EQ.1) THEN
         ALLOCATE(OCFLGS(13,NSTPT))
         ALLOCATE(OCLAY(NLAY))
      ENDIF
      IF(NNDF.AND. ITERP.EQ.1) THEN
         ALLOCATE(HC(NND1))
         ALLOCATE(SCE(NND1))
         ALLOCATE(SCV(NND1))
         ALLOCATE(SUB(NND1))
         ALLOCATE(ILSYS(NNDB))
      ENDIF
      IF(NDF.AND. ITERP.EQ.1) THEN
         ALLOCATE(NZ(ND1))
         ALLOCATE(DZ(ND1))
         ALLOCATE(DCOM(ND1))
         ALLOCATE(DHP(ND2))
         ALLOCATE(DH(ND2))
         ALLOCATE(DHC(ND2))
         ALLOCATE(DP(NMZ,3))
         ALLOCATE(DVB(NDB,4))
         ALLOCATE(A1(NN))
         ALLOCATE(A2(NN))
         ALLOCATE(BB(NN))
      ENDIF
C ------ALLOCATE SPACE FOR OUTPUT CONTROL FLAGS
C
C10-----RETURN.
      RETURN
      END
      SUBROUTINE GWF1SUB1RPP(DELR,DELC,HNEW,BUFF,NCOL,NROW,NLAY,NODES,
     1   NPER,NSTP,ISUBOC,NND1,ND1,ND2,NDB,NNDB,
     2   NMZ,NN,IDSAVE,IDREST,NSTPT,IN,IOUT)
C
C-----VERSION 0000 03SEP2003 GWF1SUB1RPP
C     ******************************************************************
C     READ SUBSIDENCE PACKAGE DATA
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS ,ONLY: RNB,LN,LDN,DHP,DH,DHC,NZ,DZ,DCOM,DP,DVB,
     1                       HC,SCE,SCV,SUB,NDF,NNDF,OCFLGS,NTSSUM,
     2                       ISBOCF,ISBOCU
      DOUBLE PRECISION HNEW
      DIMENSION IFL(13)
      DIMENSION HNEW(NODES),DELR(NCOL),DELC(NROW),BUFF(NODES),
     1  NSTP(NPER)
      CHARACTER*24 ANAME(9)
      CHARACTER*200 LINE
C
      DATA ANAME(1) /'   PRECONSOLIDATION HEAD'/
      DATA ANAME(2) /'ELASTIC INTERBED STORAGE'/
      DATA ANAME(3) /' VIRGIN INTERBED STORAGE'/
      DATA ANAME(4) /'     STARTING COMPACTION'/
      DATA ANAME(5) /'     DELAY STARTING HEAD'/
      DATA ANAME(6) /'   DELAY PRECOLSOL. HEAD'/
      DATA ANAME(7) /'DELAY INITIAL COMPACTION'/
      DATA ANAME(8) /'DELAY INTERBED THICKNESS'/
      DATA ANAME(9) /'   MATERIAL ZONE INDICES'/
C     ------------------------------------------------------------------
C
      NCR=NROW*NCOL
      ANNI=0.5/(FLOAT(NN)-.5)
C
C  -----READ RESTART RECORDS IF THIS SIMULATION CONTINUES FROM A
C  -----PREVIOUS SIMULATION
      IF(NDF) THEN
       IF(IDREST.GT.0) THEN
        READ(IDREST) NND2
        IF(NND2.EQ.ND2) THEN
         WRITE(IOUT,42)
   42    FORMAT(' HEAD AND PRECONSOLIDATION HEAD FOR DELAY BEDS ARE',
     1   ' BEING READ FROM RESTART RECORDS')
         READ(IDREST) (DH(N),N=1,ND2)
         READ(IDREST) (DHC(N),N=1,ND2)
         DO 50 N2=1,ND2
         DHP(N2)=DH(N2)
  50     CONTINUE
        ELSE
         WRITE(IOUT,52)
   52    FORMAT(' HEAD AND PRECONSOLIDATION HEAD FOR DELAY BEDS ',
     1   'CANNOT BE READ FROM RESTART RECORDS',/,
     2   ' SIMULATION ABORTING')
         CALL USTOP(' ')
        ENDIF
       ENDIF
      ENDIF
C  -----READ IN ARRAYS FOR SYSTEMS OF NO-DELAY INTERBEDS.
      IF(NNDF) THEN
       DO 60 KQ=1,NNDB
       K=LN(KQ)
       LOC1=1+(KQ-1)*NCR
       WRITE(IOUT,56) KQ
  56   FORMAT(/,1X,' SYSTEM',I4,' OF NO-DELAY BEDS:')
       CALL U2DREL(HC(LOC1),ANAME(1),NROW,NCOL,K,IN,IOUT)
       WRITE(IOUT,56) KQ
       CALL U2DREL(SCE(LOC1),ANAME(2),NROW,NCOL,K,IN,IOUT)
       WRITE(IOUT,56) KQ
       CALL U2DREL(SCV(LOC1),ANAME(3),NROW,NCOL,K,IN,IOUT)
       WRITE(IOUT,56) KQ
       CALL U2DREL(SUB(LOC1),ANAME(4),NROW,NCOL,K,IN,IOUT)
   60  CONTINUE
CC
C  -----INITIALIZE ARRAYS FOR SYSTEMS OF NO-DELAY INTERBEDS.
       DO 80 KQ=1,NNDB
       K=LN(KQ)
       NQ=(KQ-1)*NCR
       NK=(K-1)*NCR
       DO 70 IR=1,NROW
       NQR=NQ+(IR-1)*NCOL
       NKR=NK+(IR-1)*NCOL
       DO 70 IC=1,NCOL
       LOC2=NQR+IC
       LOC2H=NKR+IC
CC
C ------MULTIPLY STORAGE BY AREA TO GET STORAGE CAPACITY.
       AREA=DELR(IC)*DELC(IR)
       SCE(LOC2)=SCE(LOC2)*AREA
       SCV(LOC2)=SCV(LOC2)*AREA
CC
C ------MAKE SURE THAT PRECONSOLIDATION HEAD VALUES
C ------ARE CONSISTANT WITH STARTING HEADS.
       IF(HC(LOC2).GT.HNEW(LOC2H)) HC(LOC2)=HNEW(LOC2H)
   70  CONTINUE
   80  CONTINUE
      ENDIF
      IF(NDF) THEN
C  -----READ IN TABLE OF MATERIAL PROPERTIES: K, Sse, Ssv FOR EACH
C  -----OF NMZ ZONES.
       WRITE(IOUT,95)
   95 FORMAT(/,' MATERIAL PROPERTIES OF INTERBEDS WITH DELAY PROPERTIES'
     1 ,//,'   ZONE        HYDRAULIC           ELASTIC            INEL',
     2 'ASTIC       ',/,'  NUMBER      CONDUCTIVITY     SPECIFIC STORA',
     3 'GE    SPECIFIC STORAGE   ',/,' ',69('-'))
       DO 100 N=1,NMZ
       READ(IN,*) (DP(N,NP),NP=1,3)
  100  CONTINUE
       WRITE(IOUT,105) (N,(DP(N,NP),NP=1,3),N=1,NMZ)
  105  FORMAT(I5,4X,G15.5,5X,G15.5,5X,G15.5)
       LOC3=0
       LOC4=0
       DO 180 KQ=1,NDB
       K=LDN(KQ)
       LOC1=1+(KQ-1)*NCR
C  -----READ IN ARRAYS FOR SYSTEMS OF DELAY INTERBEDS.
       IF(IDREST.LE.0) THEN
        WRITE(IOUT,108) KQ
 108    FORMAT(/,1X,' SYSTEM',I4,' OF DELAY BEDS:')
        CALL U2DREL(BUFF,ANAME(5),NROW,NCOL,K,IN,IOUT)
        DO 120 N1=1,NCR
        LOC2=LOC1+N1-1
        IF(RNB(LOC2).LT.1.0) GO TO 120
        DO 115 N2=1,NN
        LOC3=LOC3+1
        DHP(LOC3)=BUFF(N1)
        DH(LOC3)=BUFF(N1)
  115   CONTINUE
  120   CONTINUE
        WRITE(IOUT,108) KQ
        CALL U2DREL(BUFF,ANAME(6),NROW,NCOL,K,IN,IOUT)
        DO 130 N1=1,NCR
        LOC2=LOC1+N1-1
        IF(RNB(LOC2).LT.1.0) GO TO 130
        DO 125 N2=1,NN
        LOC4=LOC4+1
        DHC(LOC4)=BUFF(N1)
        IF(DHC(LOC4).GT.DH(LOC4)) DHC(LOC4)=DH(LOC4)
  125   CONTINUE
  130   CONTINUE
       ENDIF
       WRITE(IOUT,108) KQ
       CALL U2DREL(DCOM(LOC1),ANAME(7),NROW,NCOL,K,IN,IOUT)
       WRITE(IOUT,108) KQ
       CALL U2DREL(DZ(LOC1),ANAME(8),NROW,NCOL,K,IN,IOUT)
       WRITE(IOUT,108) KQ
       CALL U2DINT(NZ(LOC1),ANAME(9),NROW,NCOL,K,IN,IOUT)
C  -----INITIALIZE ARRAYS FOR SYSTEMS OF DELAY INTERBEDS.
       DO 160 NL=1,NCR
       LOC2=LOC1+NL-1
       IF(RNB(LOC2).GE.1.0.AND.DZ(LOC2).LE.0.0) THEN
          WRITE(IOUT,155)
 155      FORMAT(' A VALUE OF ZERO WAS FOUND IN THE DZ ARRAY WHERE ',
     1    'DELAY INTERBEDS OCCUR.',/,' MAKE SURE THAT',
     2    ' DZ IS GREATER THAN 0.0 AT ALL CELLS WHERE RNB ',/,
     3    ' IS 1.0 OR MORE. SIMULATION ABORTING')
          CALL USTOP(' ')
       ENDIF
       DZ(LOC2)=DZ(LOC2)*ANNI
  160  CONTINUE
       DO 170 N=1,4
       DVB(KQ,N)=0.0
  170  CONTINUE
  180  CONTINUE
      ENDIF
C
C ------SET ALL FLAGS FOR OUTPUT CONTROL TO "FALSE".
      DO 360 I=1,NSTPT
      DO 350 N=1,13
      OCFLGS(N,I)=.FALSE.
  350 CONTINUE
  360 CONTINUE
C
C5------READ FORMATS AND UNIT NUMBERS OUTPUT FLAGS.
      IF(ISUBOC.GT.0) THEN
       CALL URDCOM(IN,IOUT,LINE)
       LLOC=1
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCF(1),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCU(1),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCF(2),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCU(2),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCF(3),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCU(3),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCF(4),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCU(4),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCF(5),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCU(5),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCF(6),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISBOCU(6),R,IOUT,IN)
       WRITE(IOUT,310) (ISBOCF(N),ISBOCU(N),N=1,6)
  310  FORMAT(/,'             SUBSIDENCE PRINT FORMAT IS NUMBER',I4/
     &            '                 UNIT FOR SAVING SUBSIDENCE IS',I4/
     &            '    COMPACTION BY LAYER PRINT FORMAT IS NUMBER',I4/
     &            '        UNIT FOR SAVING COMPACTION BY LAYER IS',I4/
     &            '   COMPACTION BY SYSTEM PRINT FORMAT IS NUMBER',I4/
     &            '       UNIT FOR SAVING COMPACTION BY SYSTEM IS',I4/
     &            '  VERTICAL DISPLACEMENT PRINT FORMAT IS NUMBER',I4/
     &            '      UNIT FOR SAVING VERTICAL DISPLACEMENT IS',I4/
     &            ' NO-DELAY CRITICAL HEAD PRINT FORMAT IS NUMBER',I4/
     &            '     UNIT FOR SAVING NO-DELAY CRITICAL HEAD IS',I4/
     &            '    DELAY CRITICAL HEAD PRINT FORMAT IS NUMBER',I4/
     &            '        UNIT FOR SAVING DELAY CRITICAL HEAD IS',I4)
       NTSSUM(1)=0
       IF(NPER.GT.1) THEN
        DO 370 N=2,NPER
        NTSSUM(N)=NTSSUM(N-1)+NSTP(N-1)
  370   CONTINUE
       ENDIF
       DO 450 NOCLIN=1,ISUBOC
      CALL URDCOM(IN,IOUT,LINE)
       LLOC=1
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISP1,R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,ISP2,R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,JTS1,R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,JTS2,R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(1),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(2),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(3),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(4),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(5),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(6),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(7),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(8),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(9),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(10),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(11),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(12),R,IOUT,IN)
       CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFL(13),R,IOUT,IN)
       IF(ISP1.LT.1) ISP1=1
       IF(ISP1.GT.NPER) ISP1=NPER
       IF(ISP2.LT.1) ISP2=1
       IF(ISP2.GT.NPER) ISP2=NPER
       IF(ISP1.GT.ISP2) ISP1=ISP2
       DO 440 I=ISP1,ISP2
       J1=JTS1
       J2=JTS2
       IF(J1.LT.1) J1=1
       IF(J1.GT.NSTP(I)) J1=NSTP(I)
       IF(J2.LT.1) J2=1
       IF(J2.GT.NSTP(I)) J2=NSTP(I)
       IF(J1.GT.J2) J1=J2
       DO 430 J=J1,J2
       ILOC=NTSSUM(I)+J
       DO 420 N=1,13
       IF(IFL(N).GT.0) OCFLGS(N,ILOC)=.TRUE.
       IF(IFL(N).EQ.0) OCFLGS(N,ILOC)=.FALSE.
  420  CONTINUE
  430  CONTINUE
  440  CONTINUE
  450  CONTINUE
      ENDIF
C
C6------RETURN
  500 RETURN
      END
      SUBROUTINE GWF1SUB1ST(HNEW,NNDB,NDB,ISSFLG,NROW,NCOL,NODES,
     1 NPER,KPER,NN)
C
C-----VERSION 0000 03SEP2003 GWF1SUB1ST
C     ******************************************************************
C        SET PRECONSOLIDATION HEAD (HC AND DHC) EQUAL TO THE STEADY-
C        STATE HEAD IF HEAD IS LOWER THAN PRECONSOLIDATION HEAD.
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS ,ONLY: RNB,LN,LDN,HC,DHP,DH,DHC,NZ,DZ,DP,
     1                       A1,A2,BB,NDF,NNDF
      DOUBLE PRECISION HNEW
      DIMENSION HNEW(NODES),ISSFLG(NPER)
C
C     ------------------------------------------------------------------
C
C1------RETURN IF THIS IS NOT THE SECOND STRESS PERIOD OR IF THE FIRST
C1------STRESS PERIOD WAS TRANSIENT.
      IF(KPER.NE.2) RETURN
      IF(ISSFLG(1).EQ.0) RETURN
C2-----MAKE SURE THAT NO-DELAY PRECONSOLIDATION HEAD VALUES ARE CONSISTENT
C2-----WITH STEADY-STATE HEADS.
      NCR=NROW*NCOL
      IF(NNDF) THEN
       DO 20 KQ=1,NNDB
       K=LN(KQ)
       NQ=(KQ-1)*NCR
       NK=(K-1)*NCR
       DO 10 IR=1,NROW
       NQR=NQ+(IR-1)*NCOL
       NKR=NK+(IR-1)*NCOL
       DO 10 IC=1,NCOL
       LOC2=NQR+IC
       LOC2H=NKR+IC
       HTMP=HNEW(LOC2H)
       IF(HC(LOC2).GT.HTMP) HC(LOC2)=HTMP
   10  CONTINUE
   20  CONTINUE
      ENDIF
C3-----MAKE SURE THAT DELAY PRECONSOLIDATION HEAD VALUES ARE CONSISTENT
C3-----WITH STEADY-STATE HEADS. ALSO, SET HEAD (DH) AND HEAD FOR
C3-----PREVIOUS TIME STEP (DHP) EQUAL TO THE AQUIFER HEAD (HNEW).
      IF(NDF) THEN
       LOC3=0
       DO 40 KQ=1,NDB
       K=LDN(KQ)
       NQ=(KQ-1)*NCR
       NK=(K-1)*NCR
       DO 30 N1=1,NCR
       LOC2=NQ+N1
       LOC2H=NK+N1
       HTMP=HNEW(LOC2H)
       IF(RNB(LOC2).LT.1.0) GO TO 30
       DO 18 N2=1,NN
       LOC3=LOC3+1
       IF(DHC(LOC3).GT.HTMP) DHC(LOC3)=HTMP
       DH(LOC3)=HTMP
       DHP(LOC3)=HTMP
   18  CONTINUE
   30  CONTINUE
   40  CONTINUE
      ENDIF
C4-----RETURN.
      RETURN
      END
      SUBROUTINE GWF1SUB1FM(RHS,HCOF,HNEW,HOLD,IBOUND,V,DELR,DELC,NCOL,
     1      NROW,NODES,DELT,AC1,AC2,HCLOSE,ITER,ITMIN,NN,NND1,ND1,ND2,
     2      NDB,NNDB,NMZ,ISSCHK,ISIP)
C
C-----VERSION 0000 03SEP2003 GWF1SUB1FM
C     ******************************************************************
C        ADD INTERBED STORAGE TERMS TO RHS AND HCOF
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS ,ONLY: RNB,LN,LDN,HC,SCE,SCV,DHP,DH,DHC,NZ,DZ,DP,
     1                       A1,A2,BB,NDF,NNDF
      DOUBLE PRECISION HNEW
      LOGICAL ICHK
      DIMENSION RHS(NODES),HCOF(NODES),IBOUND(NODES),DELR(NCOL),
     1  V(NODES),DELC(NROW),HNEW(NODES),HOLD(NODES)
C
      DATA ICHK/.FALSE./
C     ------------------------------------------------------------------
C
C0------SKIP CALCULATIONS IF THIS IS A STEADY-STATE STRESS PERIOD.
      IF(ISSCHK.EQ.1) RETURN
C
C1------INITIALIZE
      TLED=1./DELT
      NCR=NCOL*NROW
C
      IF(NNDF) THEN
C2------FIND LAYERS WITH INTERBED STORAGE
       DO 110 KQ=1,NNDB
       K=LN(KQ)
       LOCT=(KQ-1)*NCR
       LOCTH=(K-1)*NCR
       DO 100 N=1,NCR
       LOC2=LOCT+N
       LOC2H=LOCTH+N
       IF(IBOUND(LOC2H).LE.0) GO TO 100
CC
C3------DETERMINE STORAGE CAPACITIES FOR CELL AT START AND END OF STEP
       RHO1=SCE(LOC2)*TLED
       RHO2=RHO1
       HCTMP=HC(LOC2)
       IF(HNEW(LOC2H).LT.HCTMP) RHO2=SCV(LOC2)*TLED
CC
C4------ADD APPROPRIATE TERMS TO RHS AND HCOF
       RHS(LOC2H)=RHS(LOC2H)-HCTMP*(RHO2-RHO1)-RHO1*HOLD(LOC2H)
       HCOF(LOC2H)=HCOF(LOC2H)-RHO2
  100  CONTINUE
  110  CONTINUE
      ENDIF
      IF(NDF) THEN
       LOC3=1-NN
       DO 420 KQ=1,NDB
       K=LDN(KQ)
       NQ=(KQ-1)*NCR
       NK=(K-1)*NCR
       DO 410 IR=1,NROW
       NQR=NQ+(IR-1)*NCOL
       NKR=NK+(IR-1)*NCOL
       DO 410 IC=1,NCOL
       LOC2=NQR+IC
       LOC2H=NKR+IC
       RNB2=RNB(LOC2)
       IF(RNB2.LT.1.0) GO TO 410
       LOC3=LOC3+NN
       IF(IBOUND(LOC2H).LE.0) GO TO 410
       IF(ISIP.GT.0.AND.ICHK) THEN
        VV=V(LOC2H)
       ELSE
        VV=0.0
        ICHK=.TRUE.
       ENDIF
       NZONE=NZ(LOC2)
       DZZ=DZ(LOC2)
       CI=DP(NZONE,1)/DZZ
       IF(ISIP.GT.0.AND.ITER.GT.ITMIN.AND.ABS(VV).LT.HCLOSE) GO TO 205
CC
C  -----ASSEMBLE COEFFICIENTS FOR DIRECT SOLUTION OF HEAD IN INTERBED
       HAQ=HNEW(LOC2H)+VV*AC1
       SSE=DP(NZONE,2)
       SSV=DP(NZONE,3)
       CALL SGWF1SUB1A(HAQ,TLED,CI,SSE,SSV,DZZ,
     1      DH(LOC3),DHP(LOC3),DHC(LOC3),NN)
CC
C  -----SOLVE FOR HEAD CHANGES IN STRING USING GAUSSIAN ELIMINATION.
C  -----ADD CHANGES TO HEAD VALUES TO GET HEAD AT CURRENT ITERATION.
       CALL SGWF1SUB1S(NN)
       DO 200 N=1,NN
       DH(LOC3+N-1)=DH(LOC3+N-1)+BB(N)*AC2
  200  CONTINUE
CC
C3------CALCULATE STORAGE CHANGE IN INTERBEDS
  205  AREA=DELR(IC)*DELC(IR)
       STRGS=0.0
       L1=LOC3
       L2=LOC3+NN-1
       DO 210 LOC4=L1,L2
       HHOLD=DHP(LOC4)
       HHNEW=DH(LOC4)
       HHC=DHC(LOC4)
C
C  ------GET STORAGE CAPACITIES AT BEGINNING AND END OF TIME STEP.
       SBGN=DP(NZ(LOC2),2)
       SEND=SBGN
       IF(HHNEW.LT.HHC) SEND=DP(NZ(LOC2),3)
C
C  ------CALCULATE VOLUME CHANGE IN INTERBED STORAGE FOR TIME STEP.
       STR1=(HHC*(SEND-SBGN)+SBGN*HHOLD-
     1                 SEND*HHNEW)*DZ(LOC2)*RNB(LOC2)*2.
       IF(LOC4.EQ.L2) STR1=STR1*.5
       STRGS=STRGS+STR1
  210  CONTINUE
       RATES=STRGS*AREA*TLED
CC
C4------ADD APPROPRIATE TERMS TO RHS AND HCOF
       RHS(LOC2H)=RHS(LOC2H)-RATES
  410  CONTINUE
  420  CONTINUE
      ENDIF
C
C5------RETURN
      RETURN
      END
      SUBROUTINE GWF1SUB1BD(IBOUND,HNEW,HOLD,BUFF,DELR,DELC,VBVL,VBNM,
     1      NN,NND1,ND1,ND2,NDB,NNDB,NMZ,NCOL,NROW,NLAY,
     2      NODES,DELT,MSUM,NIUNIT,KSTP,KPER,IIBSCB,ICBCFL,ISSCHK,IOUT)
C-----VERSION 0000 03SEP2003 GWF1SUB1BD
C     ******************************************************************
C     CALCULATE VOLUMETRIC BUDGET FOR INTERBED STORAGE
C     ******************************************************************
C
C     SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS ,ONLY: RNB,LN,LDN,HC,SCE,SCV,SUB,DHP,DH,DHC,
     1                       NZ,DZ,DCOM,DP,DVB,NDF,NNDF
      DOUBLE PRECISION HNEW
      DIMENSION IBOUND(NODES),HNEW(NODES),HOLD(NODES),BUFF(NODES),
     1          DELR(NCOL),DELC(NROW),VBVL(4,NIUNIT)
      CHARACTER*16 TEXT(2),VBNM(NIUNIT)
C
      DATA TEXT(1) /'INST. IB STORAGE'/
      DATA TEXT(2) /'DELAY IB STORAGE'/
C     ------------------------------------------------------------------
C
C1------INITIALIZE CELL-BY-CELL FLOW TERM FLAG (IBD) AND
C1------SET IF CELL-BY-CELL FLOW TERMS ARE NEEDED.
      IBD=0
      IF(ICBCFL.NE.0 .AND. IIBSCB.GT.0 ) IBD=1
      NCR=NCOL*NROW
      TLED=1.  ! Initialize for steady-state case  ERB 5/29/08
C
C  -----RUN THROUGH EVERY CELL IN THE GRID WITH INTERBED STORAGE.
      IF(NNDF) THEN
C
C  ------CELL-BY-CELL FLOW TERMS ARE NEEDED SET IBD AND CLEAR BUFFER.
       IF(IBD.EQ.1) THEN
        DO 90 N=1,NODES
        BUFF(N)=0.
   90   CONTINUE
       ENDIF
       STOIN=0.
       STOUT=0.
C
C ------IF THIS IS A STEADY-STATE STRESS PERIOD, SKIP CALCULATIONS
       IF(ISSCHK.EQ.1) GO TO 111
       TLED=1./DELT
C
C ------CALCULATE NO-DELAY INTERBED STORAGE CHANGE FOR EACH CELL
       DO 110 KQ=1,NNDB
       K=LN(KQ)
       NQ=(KQ-1)*NCR
       NK=(K-1)*NCR
       DO 100 IR=1,NROW
       NQR=NQ+(IR-1)*NCOL
       NKR=NK+(IR-1)*NCOL
       DO 100 IC=1,NCOL
       LOC2=NQR+IC
       LOC2H=NKR+IC
C
C  ------CALCULATE FLOW FROM STORAGE (VARIABLE HEAD CELLS ONLY)
       IF(IBOUND(LOC2H).LE.0) GO TO 100
       HHOLD=HOLD(LOC2H)
       HHNEW=HNEW(LOC2H)
       HHC=HC(LOC2)
C
C  ------GET STORAGE CAPACITIES AT BEGINNING AND END OF TIME STEP.
       SBGN=SCE(LOC2)
       SEND=SBGN
       IF(HHNEW.LT.HHC) SEND=SCV(LOC2)
C
C  ------CALCULATE VOLUME CHANGE IN INTERBED STORAGE FOR TIME STEP.
       STRG=HHC*(SEND-SBGN)+SBGN*HHOLD-SEND*HHNEW
C
C  ------ACCUMULATE SUBSIDENCE ASSOCIATED WITH CHANGE IN STORAGE
       SUB(LOC2)=SUB(LOC2)+STRG/(DELR(IC)*DELC(IR))
C
C  ------IF C-B-C FLOW TERMS ARE TO BE SAVED THEN ADD RATE TO BUFFER.
       IF(IBD.EQ.1) BUFF(LOC2H)=BUFF(LOC2H)+STRG*TLED
C
C  ------SEE IF FLOW IS INTO OR OUT OF STORAGE.
       IF(STRG.LE.0) THEN
        STOUT=STOUT-STRG
       ELSE
        STOIN=STOIN+STRG
       ENDIF
  100  CONTINUE
  110  CONTINUE
C
C  ------IF C-B-C FLOW TERMS WILL BE SAVED CALL UBUDSV TO RECORD THEM.
  111  IF(IBD.EQ.1) CALL UBUDSV(KSTP,KPER,TEXT(1),IIBSCB,BUFF,NCOL,
     1                           NROW,NLAY,IOUT)
C
C  ------MOVE RATES,VOLUMES & LABELS INTO ARRAYS FOR PRINTING.
       VBVL(3,MSUM)=STOIN*TLED
       VBVL(4,MSUM)=STOUT*TLED
       VBVL(1,MSUM)=VBVL(1,MSUM)+STOIN
       VBVL(2,MSUM)=VBVL(2,MSUM)+STOUT
       VBNM(MSUM)=TEXT(1)
C
C  ------INCREMENT BUDGET TERM COUNTER
       MSUM=MSUM+1
C
C  ------UPDATE PRECONSOLIDATION HEAD ARRAY
       DO 310 KQ=1,NNDB
       K=LN(KQ)
       LOCT=(KQ-1)*NCR
       LOCTH=(K-1)*NCR
       DO 300 N=1,NCR
       LOC2=LOCT+N
       LOC2H=LOCTH+N
       IF(IBOUND(LOC2H).LE.0) GO TO 300
       HHNEW=HNEW(LOC2H)
       IF(HHNEW.LT.HC(LOC2)) HC(LOC2)=HHNEW
  300  CONTINUE
  310  CONTINUE
      ENDIF
      IF(NDF) THEN
       IF(IBD.EQ.1) THEN
        DO 390 N=1,NODES
        BUFF(N)=0.
  390   CONTINUE
       ENDIF
       RATIN=0.
       RATOUT=0.
C
C ------IF THIS IS A STEADY-STATE STRESS PERIOD, SKIP CALCULATIONS
       IF(ISSCHK.EQ.1) GO TO 421
C
C ------CALCULATE NO-DELAY INTERBED STORAGE CHANGE FOR EACH CELL
       LOC3=1-NN
       DO 420 KQ=1,NDB
       K=LDN(KQ)
       NQ=(KQ-1)*NCR
       NK=(K-1)*NCR
       STRGT=0.0
       RATBSM=0.0
       DO 410 IR=1,NROW
       NQR=NQ+(IR-1)*NCOL
       NKR=NK+(IR-1)*NCOL
       DO 410 IC=1,NCOL
       AREA=DELR(IC)*DELC(IR)
       LOC2=NQR+IC
       LOC2H=NKR+IC
       RNB2=RNB(LOC2)
       IF(RNB2.LT.1.0) GO TO 410
       LOC3=LOC3+NN
       IF(IBOUND(LOC2H).LE.0) GO TO 410
       HD1=DH(LOC3)
       HHNEW=HNEW(LOC2H)
C
C  ------CALCULATE CONDUCTANCE BETWEEN AQUIFER AND FIRST CELL IN INTERBED
C  ------ACCOUNTING FOR BOTH HALVES OF RNB(LOC2) BEDS IN SYSTEM
       COND=4.*RNB2*DP(NZ(LOC2),1)*AREA/DZ(LOC2)
C
C  ------CALCULATE THE FLOW RATE INTO THE CELL
       RATB=DBLE(COND)*(DBLE(HD1)-HNEW(LOC2H))
       STRGS=0.0
       L1=LOC3
       L2=LOC3+NN-1
       DO 401 LOC4=L1,L2
       HHOLD=DHP(LOC4)
       HHNEW=DH(LOC4)
       HHC=DHC(LOC4)
C
C  ------GET STORAGE CAPACITIES AT BEGINNING AND END OF TIME STEP.
       SBGN=DP(NZ(LOC2),2)
       SEND=SBGN
       IF(HHNEW.LT.HHC) SEND=DP(NZ(LOC2),3)
C
C  ------CALCULATE VOLUME CHANGE IN INTERBED STORAGE FOR TIME STEP.
       STR1=(HHC*(SEND-SBGN)+SBGN*HHOLD-
     1                        SEND*HHNEW)*DZ(LOC2)*RNB(LOC2)*2.
       IF(LOC4.EQ.L2) STR1=STR1*.5
       STRGS=STRGS+STR1
C
C  ------ACCUMULATE SUBSIDENCE ASSOCIATED WITH CHANGE IN STORAGE
       DCOM(LOC2)=DCOM(LOC2)+STR1
  401  CONTINUE
       STRGS=STRGS*AREA
       STRGT=STRGT+STRGS
       RATS=STRGS*TLED
       IF(IBD.EQ.1) BUFF(LOC2H)=BUFF(LOC2H)+RATS
       RATBSM=RATBSM-RATS
       IF(RATS.LE.0.) THEN
        RATOUT=RATOUT-RATS
       ELSE
        RATIN=RATIN+RATS
       ENDIF
  410  CONTINUE
       DVB(KQ,1)=DVB(KQ,1)+STRGT
       DVB(KQ,2)=DVB(KQ,2)+RATBSM*DELT
       DVB(KQ,3)=STRGT*TLED
       DVB(KQ,4)=RATBSM
  420  CONTINUE
C
C  ------IF C-B-C FLOW TERMS WILL BE SAVED CALL UBUDSV TO RECORD THEM.
  421  IF(IBD.EQ.1) CALL UBUDSV(KSTP,KPER,TEXT(2),IIBSCB,BUFF,
     1                           NCOL,NROW,NLAY,IOUT)
C
C  ------MOVE RATES,VOLUMES & LABELS INTO ARRAYS FOR PRINTING.
       VBVL(3,MSUM)=RATIN
       VBVL(4,MSUM)=RATOUT
       VBVL(1,MSUM)=VBVL(1,MSUM)+RATIN*DELT
       VBVL(2,MSUM)=VBVL(2,MSUM)+RATOUT*DELT
       VBNM(MSUM)=TEXT(2)
C
C  ------INCREMENT BUDGET TERM COUNTER
       MSUM=MSUM+1
C
C  ------UPDATE PRECONSOLIDATION HEAD ARRAY, PREVIOUS HEAD ARRAY FOR
C  ------SYSTEMS OF DELAY INTERBEDS.
       DO 500 N=1,ND2
       IF(DH(N).LT.DHC(N)) DHC(N)=DH(N)
       DHP(N)=DH(N)
  500  CONTINUE
      ENDIF
C
C  -----RETURN
      RETURN
      END
      SUBROUTINE GWF1SUB1OT(NCOL,NROW,NLAY,PERTIM,TOTIM,KSTP,KPER,NSTP,
     1     BUFF,NODES,NN,ND1,ND2,NND1,NNDB,NDB,ISSCHK,
     3     IN,IOUT)
C-----VERSION 0000 03SEP2003 GWF1SUB1OT
C     ******************************************************************
C     PRINT AND STORE SUBSIDENCE, COMPACTION AND CRITICAL HEAD.
C     ******************************************************************
C
C     SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS ,ONLY: LN,LDN,SUB,HC,RNB,DCOM,DHC,DVB,NDF,NNDF,
     &                     NTSSUM,OCFLGS,OCLAY,ILSYS,ISBOCF,ISBOCU
      DIMENSION BUFF(NODES)
      CHARACTER*16 TEXT(7)
      LOGICAL IBDPR
      DATA TEXT
     &  /'      SUBSIDENCE',      'LAYER COMPACTION',
     &   'NDSYS COMPACTION',      ' DSYS COMPACTION',
     &   '  Z DISPLACEMENT',      'ND CRITICAL HEAD',
     2   ' D CRITICAL HEAD'/
C     ------------------------------------------------------------------
C
      NCR=NCOL*NROW
C1------INITIALIZE TIME STEP POINTER TO RETRIEVE FLAGS FOR PRINTING AND
C1------SAVING ARRAYS. SET FLAG FOR PRINTING BUDGET FOR DELAY INTERBEDS.
      NNSTP=NTSSUM(KPER)+KSTP
      IBDPR=.FALSE.
      IF(KSTP.EQ.NSTP.OR.OCFLGS(13,NNSTP)) IBDPR=.TRUE.
      IF(ISSCHK.EQ.1) IBDPR=.FALSE.
C
C3------PRINT AND STORE SUBSIDENCE, FIRST, CLEAR OUT BUFF.
      IF(OCFLGS(1,NNSTP).OR.OCFLGS(2,NNSTP)) THEN
       DO 30 N=1,NODES
       BUFF(N)=0.
   30  CONTINUE
C
C4-------SUM COMPACTION IN ALL LAYERS TO GET SUBSIDENCE.
       IF(NNDF) THEN
        DO 50 KQ=1,NNDB
        LOCT=(KQ-1)*NCR
        DO 40 N=1,NCR
        LOC2=LOCT+N
        BUFF(N)=BUFF(N)+SUB(LOC2)
   40   CONTINUE
   50   CONTINUE
       ENDIF
       IF(NDF) THEN
        DO 70 KQ=1,NDB
        LOCT=(KQ-1)*NCR
        DO 60 N=1,NCR
        LOC2=LOCT+N
        BUFF(N)=BUFF(N)+DCOM(LOC2)
   60   CONTINUE
   70   CONTINUE
       ENDIF
C
C5-------PRINT SUBSIDENCE.
       IF(OCFLGS(1,NNSTP)) THEN
        IF(ISBOCF(1).LT.0) CALL ULAPRS(BUFF,TEXT(1),KSTP,KPER,NCOL,
     1            NROW,1,-ISBOCF(1),IOUT)
        IF(ISBOCF(1).GE.0) CALL ULAPRW(BUFF,TEXT(1),KSTP,KPER,NCOL,
     1             NROW,1,ISBOCF(1),IOUT)
       ENDIF
C
C6-------STORE SUBSIDENCE.
       IF(OCFLGS(2,NNSTP)) THEN
        CALL ULASAV(BUFF,TEXT(1),KSTP,KPER,PERTIM,TOTIM,NCOL,NROW,1,
     1              ISBOCU(1))
       ENDIF
      ENDIF
C
C7------PRINT AND STORE COMPACTION FOR EACH SYSTEM OF INTERBEDS,
C7------INCLUDING DELAY AND NO-DELAY INTERBEDS.
      IF(OCFLGS(5,NNSTP).OR.OCFLGS(6,NNSTP)) THEN
       IF(NNDF) THEN
        DO 80 KQ=1,NNDB
        K=LN(KQ)
        LOC2=(KQ-1)*NCR+1
        IF(OCFLGS(5,NNSTP)) THEN
       WRITE(IOUT,76) KQ
  76   FORMAT(/,1X,' SYSTEM',I4,' OF NO-DELAY BEDS:')
        IF(ISBOCF(3).LT.0) CALL ULAPRS(SUB(LOC2),TEXT(3),KSTP,KPER,NCOL,
     1            NROW,K,-ISBOCF(3),IOUT)
        IF(ISBOCF(3).GE.0) CALL ULAPRW(SUB(LOC2),TEXT(3),KSTP,KPER,NCOL,
     1             NROW,K,ISBOCF(3),IOUT)
        ENDIF
        IF(OCFLGS(6,NNSTP)) THEN
         CALL ULASAV(SUB(LOC2),TEXT(3),KSTP,KPER,PERTIM,TOTIM,NCOL,
     1              NROW,KQ,ISBOCU(3))
        ENDIF
   80   CONTINUE
       ENDIF
       IF(NDF) THEN
        DO 90 KQ=1,NDB
        K=LDN(KQ)
        LOC2=(KQ-1)*NCR+1
        IF(OCFLGS(5,NNSTP)) THEN
        WRITE(IOUT,82) KQ
  82   FORMAT(/,1X,' SYSTEM',I4,' OF DELAY BEDS:')
         IF(ISBOCF(3).LT.0) CALL ULAPRS(DCOM(LOC2),TEXT(4),KSTP,KPER,
     1            NCOL,NROW,K,-ISBOCF(3),IOUT)
         IF(ISBOCF(3).GE.0) CALL ULAPRW(DCOM(LOC2),TEXT(4),KSTP,KPER,
     1             NCOL,NROW,K,ISBOCF(3),IOUT)
        ENDIF
        IF(OCFLGS(6,NNSTP)) THEN
         CALL ULASAV(DCOM(LOC2),TEXT(4),KSTP,KPER,PERTIM,TOTIM,NCOL,
     1              NROW,KQ,ISBOCU(3))
        ENDIF
   90   CONTINUE
       ENDIF
      ENDIF
C
C ------SUM COMPACTION IN EACH LAYER IN THE BUFF ARRAY FOR SAVING
C ------OR PRINTING COMPACTION OR VERTICAL DISPLACEMENT BY MODEL
C ------LAYER. FIRST, CLEAR OUT BUFF.
      IF(OCFLGS(3,NNSTP).OR.OCFLGS(4,NNSTP).OR.
     & OCFLGS(7,NNSTP).OR.OCFLGS(8,NNSTP)) THEN
       DO 93 NL=1,NLAY
       OCLAY(NL)=.FALSE.
   93  CONTINUE
       DO 95 N=1,NODES
       BUFF(N)=0.
   95  CONTINUE
C
C -------SUM NO-DELAY COMPACTION IN ALL MODEL LAYERS.
       IF(NNDF) THEN
        DO 105 KQ=1,NNDB
        K=LN(KQ)
        OCLAY(K)=.TRUE.
        LOCT=(KQ-1)*NCR
        LOCT3=(K-1)*NCR
        DO 100 N=1,NCR
        LOC2=LOCT+N
        LOC3=LOCT3+N
        BUFF(LOC3)=BUFF(LOC3)+SUB(LOC2)
  100   CONTINUE
  105   CONTINUE
       ENDIF
C
C -------SUM DELAY COMPACTION IN ALL MODEL LAYERS.
       IF(NDF) THEN
        DO 115 KQ=1,NDB
        K=LDN(KQ)
        OCLAY(K)=.TRUE.
        LOCT=(KQ-1)*NCR
        LOCT3=(K-1)*NCR
        DO 110 N=1,NCR
        LOC2=LOCT+N
        LOC3=LOCT3+N
        BUFF(LOC3)=BUFF(LOC3)+DCOM(LOC2)
  110   CONTINUE
  115   CONTINUE
       ENDIF
      ENDIF
C
C -------PRINT COMPACTION BY LAYER.
      IF(OCFLGS(3,NNSTP)) THEN
       DO 120 KL=1,NLAY
       IF(.NOT.OCLAY(KL)) GO TO 120
       LOC3=(KL-1)*NCR+1
       KKL=KL
       IF(ISBOCF(2).LT.0) CALL ULAPRS(BUFF(LOC3),TEXT(2),KSTP,KPER,NCOL,
     1           NROW,KKL,-ISBOCF(2),IOUT)
       IF(ISBOCF(2).GE.0) CALL ULAPRW(BUFF(LOC3),TEXT(2),KSTP,KPER,NCOL,
     1            NROW,KKL,ISBOCF(2),IOUT)
  120  CONTINUE
      ENDIF
C
C -------STORE COMPACTION BY LAYER.
      IF(OCFLGS(4,NNSTP)) THEN
       DO 125 KL=1,NLAY
       IF(.NOT.OCLAY(KL)) GO TO 125
       LOC3=(KL-1)*NCR+1
       KKL=KL
       CALL ULASAV(BUFF(LOC3),TEXT(2),KSTP,KPER,PERTIM,TOTIM,NCOL,NROW,
     1             KKL,ISBOCU(2))
  125  CONTINUE
      ENDIF
C
C ------CALCULATE VERTICAL DISPLACEMENT.
      IF(OCFLGS(7,NNSTP).OR.OCFLGS(8,NNSTP)) THEN
       NL1=NLAY-1
       IF(NLAY.GT.1) THEN
        DO 140 KL=NL1,1,-1
        LOCT3=(KL-1)*NCR
        DO 135 N=1,NCR
        LOC3=LOCT3+N
        LOC4=LOC3+NCR
        BUFF(LOC3)=BUFF(LOC3)+BUFF(LOC4)
  135   CONTINUE
  140   CONTINUE
       ENDIF
C ------PRINT VERTICAL DISPLACEMENT FOR ALL MODEL LAYERS.
       IF(OCFLGS(7,NNSTP)) THEN
        DO 145 KL=1,NLAY
        LOC3=(KL-1)*NCR+1
        KKL=KL
        IF(ISBOCF(4).LT.0) CALL ULAPRS(BUFF(LOC3),TEXT(5),KSTP,KPER,
     1            NCOL,NROW,KKL,-ISBOCF(4),IOUT)
        IF(ISBOCF(4).GE.0) CALL ULAPRW(BUFF(LOC3),TEXT(5),KSTP,KPER,
     1             NCOL,NROW,KKL,ISBOCF(4),IOUT)
  145   CONTINUE
       ENDIF
C
C ------SAVE VERTICAL DISPLACEMENT FOR ALL MODEL LAYERS.
       IF(OCFLGS(8,NNSTP)) THEN
        DO 150 KL=1,NLAY
        LOC3=(KL-1)*NCR+1
        KKL=KL
        CALL ULASAV(BUFF(LOC3),TEXT(5),KSTP,KPER,PERTIM,TOTIM,NCOL,NROW,
     1              KKL,ISBOCU(4))
  150   CONTINUE
       ENDIF
      ENDIF
C
C ------PRINT CRITICAL HEAD FOR SYSTEMS OF NO-DELAY INTERBEDS.
C ------STORAGE.
      IF(OCFLGS(9,NNSTP).OR.OCFLGS(10,NNSTP)) THEN
       IF(NNDF) THEN
       DO 155 NL=1,NLAY
       OCLAY(NL)=.TRUE.
  155  CONTINUE
        DO 160 KQ=1,NNDB
        K=LN(KQ)
        LOC2=(KQ-1)*NCR+1
        IF(.NOT.OCLAY(K)) GO TO 160
        NSYS=1
        ILSYS(1)=KQ
        IF(KQ.LT.NNDB) THEN
         KS1=KQ+1
         DO 152 KS=KS1,NNDB
         IF(LN(KS).EQ.K) THEN
          NSYS=NSYS+1
          ILSYS(NSYS)=KS
         ENDIF
  152    CONTINUE
        ENDIF
        OCLAY(K)=.FALSE.
        IF(OCFLGS(9,NNSTP)) THEN
         WRITE(IOUT,154) (ILSYS(NS),NS=1,NSYS)
  154  FORMAT(/,1X,' SYSTEM OR SYSTEMS OF NO-DELAY BEDS:',20I3)
         IF(ISBOCF(5).LT.0) CALL ULAPRS(HC(LOC2),TEXT(6),KSTP,KPER,NCOL,
     1            NROW,K,-ISBOCF(5),IOUT)
         IF(ISBOCF(5).GE.0) CALL ULAPRW(HC(LOC2),TEXT(6),KSTP,KPER,NCOL,
     1             NROW,K,ISBOCF(5),IOUT)
        ENDIF
        IF(OCFLGS(10,NNSTP)) THEN
         CALL ULASAV(HC(LOC2),TEXT(6),KSTP,KPER,PERTIM,TOTIM,NCOL,
     1            NROW,K,ISBOCU(5))
        ENDIF
  160   CONTINUE
       ENDIF
      ENDIF
C
C ------PRINT CRITICAL HEAD FOR ALL SYSTEMS OF DELAY INTERBED.
      IF(OCFLGS(11,NNSTP).OR.OCFLGS(12,NNSTP)) THEN
       IF(NDF) THEN
        LOC4=0
        DO 190 KQ=1,NDB
        K=LDN(KQ)
        LOCT=(KQ-1)*NCR
        DO 180 N=1,NCR
        BUFF(N)=0.
        LOC2=LOCT+N
        IF(RNB(LOC2).LT.1.0) GO TO 180
        LOC4=LOC4+NN
        BUFF(N)=DHC(LOC4)
  180   CONTINUE
        IF(OCFLGS(11,NNSTP)) THEN
         WRITE(IOUT,82) KQ
         IF(ISBOCF(6).LT.0) CALL ULAPRS(BUFF,TEXT(7),KSTP,KPER,NCOL,
     1             NROW,K,-ISBOCF(6),IOUT)
         IF(ISBOCF(6).GE.0) CALL ULAPRW(BUFF,TEXT(7),KSTP,KPER,NCOL,
     1              NROW,K,ISBOCF(6),IOUT)
        ENDIF
        IF(OCFLGS(12,NNSTP)) THEN
         CALL ULASAV(BUFF,TEXT(7),KSTP,KPER,PERTIM,TOTIM,NCOL,
     1            NROW,KQ,ISBOCU(6))
        ENDIF
  190   CONTINUE
       ENDIF
      ENDIF
C
C  -----PRINT VOLUMETRIC BUDGET FOR SYSTEMS OF DELAY INTERBEDS
      IF(NDF.AND.IBDPR) THEN
       WRITE(IOUT,230) KSTP,KPER
       SUMSV=0.0
       SUMBV=0.0
       SUMSR=0.0
       SUMBR=0.0
       DO 200 KQ=1,NDB
       DISCV=0.0
       DISCR=0.0
       SUMV=DVB(KQ,1)+DVB(KQ,2)
       SUMR=DVB(KQ,3)+DVB(KQ,4)
       SUMSV=SUMSV+DVB(KQ,1)
       SUMBV=SUMBV+DVB(KQ,2)
       SUMSR=SUMSR+DVB(KQ,3)
       SUMBR=SUMBR+DVB(KQ,4)
       IF(DVB(KQ,1).NE.0.) DISCV=100.*SUMV/DVB(KQ,1)
       IF(DVB(KQ,3).NE.0.) DISCR=100.*SUMR/DVB(KQ,3)
       WRITE(IOUT,240) KQ,DVB(KQ,1),DVB(KQ,2),SUMV,DISCV,
     1                    DVB(KQ,3),DVB(KQ,4),SUMR,DISCR
  200  CONTINUE
       IF(NDB.GT.1) THEN
        DISCV=0.0
        DISCR=0.0
        SUMV=SUMSV+SUMBV
        SUMR=SUMSR+SUMBR
        IF(SUMSV.NE.0.) DISCV=100.*SUMV/SUMSV
        IF(SUMSR.NE.0.) DISCR=100.*SUMR/SUMSR
        WRITE(IOUT,250) SUMSV,SUMBV,SUMV,DISCV,
     1                  SUMSR,SUMBR,SUMR,DISCR
       ENDIF
      ENDIF
C
C  -----RETURN
      RETURN
C
C    ---FORMATS
C
  230 FORMAT(/,31X,'VOLUMETRIC BUDGET FOR SYSTEMS OF DELAY INTERBEDS',
     1 /,42X,'AT END OF TIME STEP',I3,' IN ','STRESS PERIOD',I3,
     2 //,'          |   C U M U L A T I V E   ',
     3 'V O L U M E S   L**3           | R A T E S   F O R  T H I S',
     4 '  T I M E  S T E P   L**3/T  |',/,'   SYSTEM |    CHANGE IN',
     5 '     BOUNDARY                    PERCENT   |    CHANGE IN  ',
     6 '   BOUNDARY                    PERCENT   |',/,'   NUMBER | ',
     7 '    STORAGE        FLOW           SUM      DISCREPANCY |   ',
     8 '  STORAGE        FLOW           SUM      DISCREPANCY |',/,2X,
     9 8('-'),'|',56('-'),'|',56('-'),'|')
  240 FORMAT(I7,4G15.5,4G15.5)
  250 FORMAT(2X,8('-'),'|',56('-'),'|',56('-'),'|',/,' TOTALS:',
     1 4G15.5,4G15.5)
C
      END
      SUBROUTINE SGWF1SUB1A(HAQ,TLED,CI,SSE,SSV,DZ,DH,DHP,DHC,NN)
C
C-----VERSION 0000 03SEP2003 SGWF1SUB1A
C     ******************************************************************
C        ASSEMBLE COEFFICIENTS FOR SOLVING FOR HEAD DISTRIBUTION
C        IN ONE STRING OF CELLS REPRESENTING ONE-HALF OF A DOUBLY
C        DRAINING INTERBED
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS ,ONLY:A1,A2,BB
      DIMENSION DH(NN),DHP(NN),DHC(NN)
C     ------------------------------------------------------------------
C
C1------INITIALIZE
C
      CI2=CI*2.0
      DS=DZ*TLED
      NN1=NN-1
C2------SET COEFFICIENTS FOR CELL BORDERING AQUIFER
      SS=SSE
      A2(1)=CI
      HD=DH(1)
      HC=DHC(1)
      IF(HD.LT.HC) SS=SSV
      A1(1)=-3.*CI-DS*SS
      BB(1)=DS*(SSE*(HC-DHP(1))-HC*SS)-CI2*HAQ-A1(1)*HD
C3------SET COEFFICIENTS FOR INTERIOR CELLS
      BB(2)=-CI*HD
      DO 10 N=2,NN1
      SS=SSE
      A2(N)=CI
      HD=DH(N)
      HC=DHC(N)
      IF(HD.LT.HC) SS=SSV
      CHN=-CI*HD
      BB(N-1)=BB(N-1)+CHN
      BB(N+1)=CHN
      A1(N)=-CI2-DS*SS
      BB(N)=BB(N)+DS*(SSE*(HC-DHP(N))-HC*SS)-A1(N)*HD
   10 CONTINUE
C4------SET COEFFICIENTS FOR CELL BORDERING MIDPLANE OF INTERBED
      SS=SSE
      A2(NN)=CI
      HD=DH(NN)
      HC=DHC(NN)
      BB(NN1)=BB(NN1)-CI*HD
      IF(HD.LT.HC) SS=SSV
      A1(NN)=-CI-0.5*DS*SS
      BB(NN)=BB(NN)+DS*0.5*(SSE*(HC-DHP(NN))-HC*SS)-A1(NN)*HD
C5------RETURN
      RETURN
      END
      SUBROUTINE SGWF1SUB1S(NN)
C
C-----VERSION 0000 03SEP2003 SGWF1SUB1S
C     ******************************************************************
C        SOLVE SYSTEM OF EQUATIONS WITH A SYMMETRICAL TRI-DIAGONAL
C        COEFFICIENT MATRIX
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS ,ONLY: A1,A2,BB
C     ------------------------------------------------------------------
C
C1------TRIANGULARIZE LEFT-HAND SIDE MATRIX
      NN1=NN-1
      DO 30 N=1,NN1
      F=1./A1(N)
      C=A2(N)*F
      I=N+1
      A1(I)=A1(I)-C*A2(N)
      A2(N)=C
      BB(I)=BB(I)-C*BB(N)
      BB(N)=BB(N)*F
   30 CONTINUE
      BB(NN)=BB(NN)/A1(NN)
C..... BACK SUBSTITE FOR SOLUTION
      DO 40 N=NN1,1,-1
      BB(N)=BB(N)-A2(N)*BB(N+1)
   40 CONTINUE
      RETURN
      END
      SUBROUTINE GWF1SUB1SV(ND2,IDSAVE)
C
C-----VERSION 0000 03SEP2003 GWF1SUB1SV
C     ******************************************************************
C     SAVE INTERBED STORAGE DATA FOR FUTURE RESTART
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS ,ONLY: DH,DHC,NDF
C     ------------------------------------------------------------------
C
C1-----PROCESS IF SAVE OPTION SELECTED AND DELAY INTERBEDS EXIST
      IF(IDSAVE.GT.0.AND.NDF) THEN
C2-----WRITE OUT NUMBER OF NODAL HEAD AND PRECONSOLIDATION HEAD VALUES
C2-----THAT ARE BEING SAVED TO DISK
       WRITE(IDSAVE) ND2
C3-----WRITE ARRAYS FOR EACH SYSTEM OF INTERBEDS
       WRITE(IDSAVE) (DH(N),N=1,ND2)
       WRITE(IDSAVE) (DHC(N),N=1,ND2)
      ENDIF
C4-----RETURN
      RETURN
      END

      SUBROUTINE GWF1SUB1DA()
C
C-----VERSION 0000 03DEC2003 GWF1SUB1DA
C     ******************************************************************
C     DEALLOCATE DYNAMIC STORAGE FOR SUB PACKAGE ARRAYS
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE SUBARRAYS
C     ------------------------------------------------------------------
C
C1-----DEALLOCATE ARRAY MEMORY
      IF(ALLOCATED(OCFLGS)) DEALLOCATE (OCFLGS)
      IF(ALLOCATED(OCLAY)) DEALLOCATE (OCLAY)
      IF(ALLOCATED(ILSYS)) DEALLOCATE (ILSYS)
      IF(ALLOCATED(RNB)) DEALLOCATE (RNB)
      IF(ALLOCATED(LN)) DEALLOCATE (LN)
      IF(ALLOCATED(LDN)) DEALLOCATE (LDN)
      IF(ALLOCATED(DH)) DEALLOCATE (DH)
      IF(ALLOCATED(DHP)) DEALLOCATE (DHP)
      IF(ALLOCATED(DHC)) DEALLOCATE (DHC)
      IF(ALLOCATED(NZ)) DEALLOCATE (NZ)
      IF(ALLOCATED(DZ)) DEALLOCATE (DZ)
      IF(ALLOCATED(DP)) DEALLOCATE (DP)
      IF(ALLOCATED(HC)) DEALLOCATE (HC)
      IF(ALLOCATED(SCE)) DEALLOCATE (SCE)
      IF(ALLOCATED(SCV)) DEALLOCATE (SCV)
      IF(ALLOCATED(DCOM)) DEALLOCATE (DCOM)
      IF(ALLOCATED(DVB)) DEALLOCATE (DVB)
      IF(ALLOCATED(A1)) DEALLOCATE (A1)
      IF(ALLOCATED(A2)) DEALLOCATE (A2)
      IF(ALLOCATED(BB)) DEALLOCATE (BB)
      IF(ALLOCATED(SUB)) DEALLOCATE (SUB)
      IF(ALLOCATED(NTSSUM)) DEALLOCATE (NTSSUM)

C2-----RETURN
      RETURN
      END
