/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EIDSClientInstaller
extends EIDSInstaller {
    public static final String SERVER_ADDRESS = "server_address";
    public static final String SERVER_PORT = "server_port";
    public static final String ALTERNATES = "alternates";
    public static final String EIDS_HUB_1 = "eids1.cr.usgs.gov";
    public static final String EIDS_HUB_2 = "eids2.wr.usgs.gov";
    public static final String EIDS_HUB_3 = "eids3.gps.caltech.edu";
    public static final List EIDS_HUBS = new LinkedList();

    public EIDSClientInstaller(String[] args) {
        super(args);
    }

    public void install(boolean updateOnly) throws IOException {
        this.setServers(EIDSClientInstaller.promptServers());
    }

    public static List promptServers() {
        List servers;
        if (Prompt.promptYesNo("Connect to public EIDS hubs?", true)) {
            servers = EIDS_HUBS;
            Iterator i = servers.iterator();
            LinkedList<String> hubs = new LinkedList<String>();
            while (i.hasNext()) {
                hubs.add(((InetSocketAddress)i.next()).getHostName());
            }
            int selected = Prompt.promptSelect("Select nearest hub", hubs);
            servers.add(0, servers.remove(selected));
        } else {
            servers = EIDSInstaller.promptServers();
        }
        return servers;
    }

    static {
        EIDS_HUBS.add(new InetSocketAddress(EIDS_HUB_1, 39977));
        EIDS_HUBS.add(new InetSocketAddress(EIDS_HUB_2, 39977));
        EIDS_HUBS.add(new InetSocketAddress(EIDS_HUB_3, 39977));
    }
}

