/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;

public class EIDSCubeClientInstaller
extends EIDSClientInstaller {
    public static final String CUBE_CONFIG_RESOURCE = "etc/client/cubeClient.xml";
    public static final String CUBE_CONFIG = "conf/cubeClient.xml";
    public static final String CUBE_JAR_URL = "http://www.isti2.com/QWIDS/current_dist/QWCubeOutClient/QWCubeOutClient.jar";
    public static final String CUBE_JAR = "bin/QWCubeOutClient.jar";
    public static final String CUBE_INIT_RESOURCE = "etc/client/cube_init.sh";
    public static final String CUBE_BATCH_RESOURCE = "etc/client/cube_run.bat";
    public static final String CUBE_INIT = "cube_init.sh";
    public static final String CUBE_BATCH = "cube_run.bat";

    public EIDSCubeClientInstaller(String[] args) {
        super(args);
    }

    public void install(boolean updateOnly) throws IOException {
        File installDir = this.getInstallDirectory();
        this.startSection("Downloading JAR", true);
        System.out.print("QWCubeOutClient.jar\t");
        this.install(this.getDownload(CUBE_JAR_URL), new File(installDir, CUBE_JAR), true);
        if (updateOnly) {
            System.out.println();
            System.out.println("Update complete");
            return;
        }
        this.startSection("Configuring Client");
        File configFile = new File(installDir, CUBE_CONFIG);
        if (!configFile.exists() || Prompt.promptYesNo("WARNING: Client config file already exists!\n\t(" + configFile.getAbsolutePath() + ")\n" + "Replace existing config", false)) {
            super.install(updateOnly);
            System.out.println();
            this.installCustomResource(CUBE_CONFIG_RESOURCE, configFile, true);
            System.out.println(EIDSCubeClientInstaller.getAnsiBold("INFO: Client config file is " + configFile.getAbsolutePath()));
        } else {
            System.out.println("Not modified");
        }
        this.startSection("Installing Start Script");
        if (Installer.isWindows()) {
            this.installWindowsBatchFile(CUBE_BATCH_RESOURCE, CUBE_BATCH);
        } else {
            this.installUnixInitScript(CUBE_INIT_RESOURCE, CUBE_INIT);
        }
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        System.out.println("\n##############################");
        System.out.println("# EIDS CUBE Client Installer #");
        System.out.println("##############################");
        System.out.println("This program installs the EIDS QWCubeOutClient,");
        System.out.println("which outputs CUBE messages, and is equivalent to a QDDS client.");
        System.out.println("http://www.isti2.com/QWIDS/current_dist/QWCubeOutClient/doc/QWCubeOutClient.html");
        new EIDSCubeClientInstaller(args).run();
    }
}

