/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;

public class EIDSEQXMLClientInstaller
extends EIDSClientInstaller {
    public static final String EQXML_CONFIG_RESOURCE = "etc/client/eqxmlClient.xml";
    public static final String EQXML_CONFIG = "conf/eqxmlClient.xml";
    public static final String EQXML_JAR_URL = "http://www.isti2.com/QWIDS/current_dist/QWFileOutClient/QWFileOutClient.jar";
    public static final String EQXML_JAR = "bin/QWFileOutClient.jar";
    public static final String EQXML_INIT_RESOURCE = "etc/client/eqxml_init.sh";
    public static final String EQXML_BATCH_RESOURCE = "etc/client/eqxml_run.bat";
    public static final String EQXML_INIT = "eqxml_init.sh";
    public static final String EQXML_BATCH = "eqxml_run.bat";

    public EIDSEQXMLClientInstaller(String[] args) {
        super(args);
    }

    public void install(boolean updateOnly) throws IOException {
        File installDir = this.getInstallDirectory();
        this.startSection("Downloading JAR");
        System.out.print("QWFileOutClient.jar\t");
        this.install(this.getDownload(EQXML_JAR_URL), new File(installDir, EQXML_JAR), true);
        if (updateOnly) {
            System.out.println();
            System.out.println("Update complete");
            return;
        }
        this.startSection("Configuring Client");
        File configFile = new File(installDir, EQXML_CONFIG);
        if (!configFile.exists() || Prompt.promptYesNo("WARNING: Client config file already exists!\n\t(" + configFile.getAbsolutePath() + ")\n" + "Replace existing config", false)) {
            super.install(updateOnly);
            System.out.println(EIDSEQXMLClientInstaller.getAnsiBold("\nINFO: EQXML config file is " + configFile.getAbsolutePath()));
            this.installCustomResource(EQXML_CONFIG_RESOURCE, configFile, true);
        } else {
            System.out.println("Not modified");
        }
        this.startSection("Installing Start Script");
        if (Installer.isWindows()) {
            this.installWindowsBatchFile(EQXML_BATCH_RESOURCE, EQXML_BATCH);
        } else {
            this.installUnixInitScript(EQXML_INIT_RESOURCE, EQXML_INIT);
        }
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        System.out.println("\n###############################");
        System.out.println("# EIDS EQXML Client Installer #");
        System.out.println("###############################");
        System.out.println("This program installs the EIDS QWFileOutClient,");
        System.out.println("which outputs EQXML messages (NOT CUBE)");
        System.out.println("http://www.isti2.com/QWIDS/current_dist/QWFileOutClient/doc/QWFileOutClient.html");
        new EIDSEQXMLClientInstaller(args).run();
    }
}

