/*! \file rain_inp.c
\brief Establish linkage between two grids, map rainfall input data.

	This has a single function.\n
  
Note: documented with Doxygen, which expects specific syntax within special comments. \n
	
The Everglades Landscape Model (ELM). \n
last updated: Dec 2004 \n
*/
	
/* General notes on revisions to this source file. 
       Nov/Dec 2004 v2.3.2: documentation upgrade 
       		- Doxygen tags added 
	
*/
#include "rain.h"


/* \brief Get spatial input time series of rainfall 

	Using the grid_map functions, this obtains rain, at ELM (i.e., SME) grid scale. 
	
	\param rainSME Rainfall data array (tenths mm) at the ELM grid scale
	\return success 	*/
int rain_data_wmm(float* rainSME)           /* array of float of size s0*s1 */
{

  int i,j,k; 
  int success = 1, fail = -1;
  int stat = success;
  char gridmapfilename[135];

  if(SimTime.TIME==0)  {      

     // cleanUp(*elm_wmm_map, rainSME);
      
		/* elm_OG_map is data structure containing the mapping attributes at two scales */
      elm_wmm_map = elm_OG_map;

      if(elm_wmm_map == NULL) {
          sprintf(msgStr, "Mapping grids and setting up rain data...");
          usrErr (msgStr);
          
          sprintf(gridmapfilename, "%s%s/Data/gridmapping.txt", ModelPath, ProjName );   
          stat = mapGrids(gridmapfilename);
          elm_wmm_map = elm_OG_map;
      }

      if(debug > 4) {
          printGridMap();
          sprintf(msgStr,"rain_data_wmm==> Finished mapping grids");
          usrErr (msgStr);
      }

      sprintf(rain_binfilename, "%s%s/Data/rain.BIN", ModelPath, ProjName );
    /* initializing data structures, move pointer to initial date (gridmap.c) */
      stat = initDataStruct(rain_binfilename,&rain_struct);

      if(debug > 4) {
              /* printELM2Grid_io(); */
              /*drawELM2Grid_io(); */
          sprintf(msgStr,"rain_data_wmm==> Finished initializing");
          usrErr (msgStr); 
      }

  } /* end of SimTime.TIME=0 */
  
  
  if(rain_struct.day >= rain_struct.recRead) {      /* process the data in batch */
      sprintf(msgStr,"Processing batch of rain data...");
      usrErr (msgStr); 
      stat = processData(rain_binfilename,&rain_struct);

      if(debug > 4 ) {
              /*printBatchData(rainWMM,gridio_batch_len,widCnt);*/ /* TODO: remove this printBatchData function when sure is no longer needed */
          sprintf(msgStr,"rain_data_wmm==> Finished processing data");
          usrErr (msgStr); 
      }
  } /* end of if */


  if (rain_struct.day < rain_struct.recRead) {      /* pass the data day by day */
    returnData(rainSME,&rain_struct);   
    /* change the unit here */
    for(i = 0; i < s0; i++) {
      for(j = 0; j < s1; j++) {
        k = i*s1+j;
        rainSME[T((i+1),(j+1))] = rain_struct.dataELM[k] * conv_inTOtenths_mm;  /* convert data from inches to tenths of mm */
      }
    } 

    if(debug > 4) {
      sprintf(msgStr,"rain_data_wmm==> Finished returning data");
      usrErr (msgStr); 
    }

  } /* end of if */
    
  return success;
}

