/***************************************************************************
                          gridmap.h  -  description
                             -------------------
    begin                : Tue Feb 11 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GRIDMAP_H
#define GRIDMAP_H

using namespace std;

#include <string>
#include <vector>
#include <map>
#include "keyword.h"
#include "point.h"


/**
  *@author Beheen Trimble
  */
  
class KeywordMgr;
class ConsoleMsg;
class Grid;

  
class GridMap {
public: 
	GridMap();
	~GridMap();
  int readConfigFile(string file);
  int createDefaultCfgTemplate();
  int initKeywords();
  int populateGrids();
  int constructGrids();
  int defineEastWestBoundaryCells();
  int defineSouthNorthBoundaryCells();
  int findWestBoundaryCells(int destid);
  int findEastBoundaryCells(int destid);
  int drawOne2OneMap();
  int writeSrcGrid(string outfile);
  int mapGrids();
  int source2DestinationRURD();
  int source2DestinationRURU();
  int printEastWestBoundary();
  int printSouthNorthBoundary();
  int printClippedCells();
  int defineSearchSpace();
    
  void printMgrData();
  void printGrids();
  void printOne2manyMap();
  int writeBoundaryGrid(string);
  void printOne2OneMap();
  void drawGrid(string);
  void writeDestinationGrid(string outfile);
  void srcClippedGridID();
  void destClippedGridID();
  
private:
  ConsoleMsg* console;
  KeywordMgr* keyMgr;
  Grid* DestinationGrid;
  Grid* SourceGrid;
  map<string,Keyword*> keywords;
  vector<string> keyList;    // holds all the keywords name for faster access
                             // and less maintenance.

  enum corners {lowerLeft,upperRight,lowerRight,upperLeft};
  
  vector<int> clipID;        // contains lower left, upper right, lower right, 
                             // and upper left cell numbers of the src an then
                             // destination grid
  vector<Point*> clipCoord;  // Contains lower left,upper right,lower right, and
                             // upper left clip coordinate points  

  vector<int> srcClippedIDs;  // holds unique src ids within clip boundary
  vector<int> destClippedIDs; // holds unique dest ids within clip boundary
  
  map<int,int> westBoundary; // contains left side grid cell ids of a grid
  map<int,int> eastBoundary; // contains right side grid cell ids of a grid
  map<int,int> southBoundary;
  map<int,int> northBoundary;
  
  // these members best belong to GridMap not Grid! They are for
  // future access or testing.
  map<int,int> one2manyMap;  // contains cell numbers of the finer grid 
                             // mapped to coarser grid.
  map<int,int> one2oneMap;   // contains 2 cells with center point of one
                             // is inside the other.
  
};
#endif
