/***************************************************************************
                          keywordinputblock.cpp  -  description
                             -------------------
    begin                : Fri Feb 14 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "keywordinputblock.h"
#include "keywordinputterm.h"


KeywordInputBlock::KeywordInputBlock(){
  keyword = new Keyword();
}

KeywordInputBlock::~KeywordInputBlock(){

  #ifdef DEBUG
  cout << "KeywordInputBlock ==> Deleting KeywordInputBlock" << endl;
  #endif
  
  keyword->~Keyword();
  for(unsigned int  i= 0; i<keyInputTerm.size(); i++) 
    keyInputTerm[i]->~KeywordInputTerm();
}

/* 
 * This method populates the datamember keyword.
 */
void KeywordInputBlock::setKeyword(Keyword* ky) {
  keyword = ky;
}

Keyword* KeywordInputBlock::getKeyword(void) {
  return keyword;
}

//void KeywordInputBlock::setKeywordInputTerm(Keyword* ky) {
//
//  keyInputTerm[ky->keyword] = ky;
//}

/* Given a keyword, the input block class populates
 * its data member keyInputTerm.
 */
void KeywordInputBlock::setKeywordInputTerm(Keyword* key) {

  KeywordInputTerm* kit = new KeywordInputTerm(key);
  keyInputTerm.push_back(kit);
}

/* Given a key input block class, looks for its data member
 * keyInputTerm and returns the term that matches the ky.
 * It retunrm NULL otherwise.
 */
Keyword* KeywordInputBlock::getKeywordInputTerm(string ky) {

  for(unsigned int i=0; i<keyInputTerm.size(); ++i) {
    KeywordInputTerm* kit = keyInputTerm[i];
    Keyword* key = kit->getKeyword();
    if(key->keyword == ky)
      return key;
  }
  return NULL;
  //return (this->findKeywordFromMap(ky,keyInputTerm));
}

void KeywordInputBlock::printKeyword() {
  this->keyword->printKeyword();
}

//void KeywordInputBlock::printKeywordTerm() {
//
//  // Note that map->first returns the key, map->second returns the value
//  map<string, Keyword*> :: const_iterator ki;
//
//  for(ki = keyInputTerm.begin(); ki != keyInputTerm.end(); ++ki ) {
//    // check the type field before printing
//    ki->second->printKeyword();
//  }
//} 

void KeywordInputBlock::printKeywordTerm() {
  
  for(unsigned int i=0; i < keyInputTerm.size(); ++i ) {
    KeywordInputTerm* kit = keyInputTerm[i];
    kit->printKeyword();
  }
}


vector<Keyword*> KeywordInputBlock::getInputTermKeys()  {

  vector<Keyword*> klist;
  for(unsigned int i=0; i<keyInputTerm.size(); ++i) {
    KeywordInputTerm* kit = keyInputTerm[i];
    Keyword* key = kit->getKeyword();
    klist.push_back(key);
  }
  return klist;
}

vector<KeywordInputTerm*> KeywordInputBlock::getInputTerm()  {
  return keyInputTerm;
}
