/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Tue Feb 11 13:44:55 EST 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "gridmap.h"
#include "consolemsg.h"


int main(int argc, char *argv[])
{
  
  int status;
  ConsoleMsg *console = new ConsoleMsg();
  status = console->xstatus;
  GridMap *grmap = 0;
  string exStr = "bad_alloc while creating GridMap object";
 
  if(argc == 2) {
    if(argv[1] == string("createCfg")) {
      grmap = new GridMap();
      if(grmap == NULL)  {
        console->ErrMsg("main ==> ", exStr,console->estatus);
        return console->estatus;
      }
      int status = grmap->createDefaultCfgTemplate();
      delete grmap;
      return status;
    }
  }
  
  if(argc != 3) {
    cout << "Usage: " << argv[0] << " " << "createCfg" << endl;
    cout << "Usage: " << argv[0] << " " << "<config input file> <output file>" << endl;
    return -1;
  }
  
  // added -fcheck-new flag to produce NULL, object not allocated
  grmap = new GridMap();
  if(!grmap)  {  
    console->ErrMsg("main ==> ", exStr,console->estatus);
    delete console;
    exit(0);
  }

  
  status = grmap->readConfigFile(argv[1]);
  if(status == console->estatus) {
    grmap->~GridMap();
    return console->estatus;
  }

  
  //grmap->printMgrData(); 
  status = grmap->populateGrids();
  if(status == console->estatus) {
    delete grmap;
    grmap = 0; 
    return console->estatus;
  }

          
  status = grmap->constructGrids();
  if(status == console->estatus) {
    delete grmap;
    grmap = 0; 
    return(status);
  }
  
  // grmap->printGrids();
    
  status = grmap->mapGrids();
  if(status == console->estatus) {
    delete grmap;
    grmap = 0;
    return(status);
  }
    
  //grmap->drawGrid("SOURCE");
  //grmap->drawGrid("DESTINATION");
  //grmap->drawOne2OneMap();
  // this file must be completed, not used by any application
  string fname = argv[2];
  fname += ".d";
  grmap->writeDestinationGrid(fname);
  fname = argv[2];
  fname += ".s";
  grmap->writeSrcGrid(fname);
  fname = argv[2];
  fname += ".bnd";
  grmap->writeBoundaryGrid(fname);

  delete grmap;
  delete console; 
  return status;
}
