/***************************************************************************
                          polygon.h  -  description
                             -------------------
    begin                : Tue Feb 25 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POLYGON_H
#define POLYGON_H

/**
  *@author Beheen Trimble
  */

using namespace std;

#include "point.h"
#include <vector>

        
class Polygon {
public: 
	Polygon();
virtual	~Polygon();

void setPointList(vector<Point*>);
int pointInPolygon(const Point pt);
int getID();
int centroid(const std::vector<Point*>& pntlist,Point& centroid, double *area);
double calcArea(const std::vector<Point*>& pntlist);
Point* getCentroid();
vector<Point*>& getPointList();


protected:
  int ID;
  double Area;
  Point Centroid;
  ConsoleMsg* console;
  vector<Point*> pointList;
    
};

#endif
