/*! \file unitmod_vars.h
\brief Header file for global spatial variables for the ecological Unit Model. 

This declares spatial variables that are global to Unit_Mod.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

/* General notes on revisions to this source file. 
       Jan 2005 v2.3.3: documentation upgrade 
       		- Re-organized, clarified scopes, Doxygen tags added 
       		- Created quasi-automated unitmod_*.h header file generation for vars and parms 
	
*/

#ifndef UNITMOD_VARS_H
#define UNITMOD_VARS_H

/*! \remarks This header file is generated from the "ModelOutlist_creator_v?.xls" OpenOffice workbook.
Editing this .h header source directly is not recommended w/o changing ModelOutlist_creator. \n
To add/remove a spatial variable to/from the model: \n
1) Enter/delete the variable documentation in ModelOutlist_creator_v?.xls; \n
2) Add/remove the 2 lines of code in the alloc_memory function of UnitMod.c; \n
3) If you want it to be available for output, indicate so in ModelOutlist_creator, and add/remove the line of code in the gen_output function of Unit_Mod.c; \n
4) Export (cut&paste) the contents of this page into unitmod_vars.h; \n
5) Use/delete the variable in the code equations! */

float *TP_settlDays; /*!< _Units_: ; _Brief_: EWQM: cumulative days in which water depth is great enough for settling to occur (ESPmodeON (EWQModel emulation) ONLY) */


float *FLOC; /*!< _Units_: kgOM/m^2; _Brief_: FLOCculent organic matter at the interface between soil and surface water */
float *FLOC_DECOMP; /*!< _Units_: kgOM/m^2/d; _Brief_: FLOCculent organic matter - DECOMPosition losses */
float *FLOC_DECOMP_POT; /*!< _Units_: kgOM/m^2/d; _Brief_: FLOCculent organic matter -DECOMPosition POTential losses */
float *FLOC_DECOMP_QUAL_CF; /*!< _Units_: dimless; _Brief_: FLOCculent organic matter - DECOMPosition Control Function (0-1) of degree of nutrient QUALity limitation */
float *FLOC_DEPO; /*!< _Units_: kgOM/m^2/d; _Brief_: FLOCculent organic matter - DEPosition losses */
float *FLOC_DEPO_POT; /*!< _Units_: kgOM/m^2/d; _Brief_: FLOCculent organic matter - DEPosition POTential losses */
float *FLOC_FR_ALGAE; /*!< _Units_: kgOM/m^2/d; _Brief_: FLOCculent organic matter gained FRom mortality of periphyton (generalized, ALGAE)  */
float *Floc_fr_phBio; /*!< _Units_: kgOM/m^2/d; _Brief_: FLOCculent organic matter gained from mortality of photosynthetic Biomass of macrophytes */

float *FLOC_Z; /*!< _Units_: m; _Brief_: FLOCculent organic matter depth at the interface between soil and surface water */
float *FlocP; /*!< _Units_: kgP/m^2; _Brief_: Phosphorus in the FLOCculent organic matter at the interface between soil and surface water */
float *FlocP_DECOMP; /*!< _Units_: kgP/m^2/d; _Brief_: Phosphorus in the FLOCculent organic matter - DECOMPosition losses */

float *FlocP_DEPO; /*!< _Units_: kgP/m^2/d; _Brief_: Phosphorus in the FLOCculent organic matter - DEPosition losses */

float *FlocP_FR_ALGAE; /*!< _Units_: kgP/m^2/d; _Brief_: Phosphorus in the FLOCculent organic matter gained from FRom mortality of periphyton (generalized, ALGAE)  */
double *FlocP_OM; /*!< _Units_: kgP/kgOM; _Brief_: Phosphorus concentration in the Flocculent Organic Matter */
float *FlocP_OMrep; /*!< _Units_: mgP/kgOM; _Brief_: Phosphorus concentration of the Flocculent Organic Matter (units converted to this for reporting purposes) */
float *FlocP_PhBio; /*!< _Units_: kgP/m^2/d; _Brief_: Phosphorus in the FLOCculent organic matter gained from mortality of photosynthetic Biomass of macrophytes */

float *soil_MOIST_CF; /*!< _Units_: dimless; _Brief_: soil Control Function of degree of MOISTure limitation */
float *TP_SED_MINER; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus gained in SEDiment/soil water due to floc MINERalization */
float *TP_SFWT_MINER; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus gained in SurFace WaTer due to floc MINERalization */







float *AIR_TEMP; /*!< _Units_: deg C; _Brief_: Air temperature, daily average at ground level */
float *boundcond_depth; /*!< _Units_: m; _Brief_: External boundary condition input, ponded water depth */
float *boundcond_ETp; /*!< _Units_: tenths of mm/d; _Brief_: External boundary condition input, potential EvapoTranspiration */
float *boundcond_rain; /*!< _Units_: tenths of mm/d; _Brief_: External boundary condition input, rainfall */
double *DINdummy; /*!< _Units_: NA; _Brief_: UNUSED in calculations; placeholder for function arguements */
float *FIREdummy; /*!< _Units_: NA; _Brief_: UNUSED in calculations; placeholder for function arguements */
unsigned char *HAB; /*!< _Units_: dimless; _Brief_: Habitat, or vegetation community type (integer attribute, defining database parameter lookups) */
float *SOLRAD274; /*!< _Units_: cal/cm^2/d; _Brief_: Incomping solar radiation received at altitude of 274m in atmosphere (v2.2, no longer used in calc potential ET)  */
float *SOLRADGRD; /*!< _Units_: cal/cm^2/d; _Brief_: Incomping solar radiation received at ground surface, attenuated through atmosphere (v2.2, no longer used in calc potential ET)  */








float *H2O_TEMP; /*!< _Units_: deg C; _Brief_: Temperature of ponded surface water, daily average (=AIR_TEMP in v2.1) */
float *HYD_DOM_ACTWAT_PRES; /*!< _Units_: dimless; _Brief_: Logical flag (true or false) denoting PRESence of WATer in the DOM_ACTive zone depth (DOM_MAXDEPTH) */
float *HYD_DOM_ACTWAT_VOL; /*!< _Units_: m^3; _Brief_: HYDrologic, water VOLume storage in the DOM_ACTive zone depth (DOM_MAXDEPTH) */
float *HYD_ET; /*!< _Units_: m/d; _Brief_: actual total Evaporation plus Transpiration (ET) from all storages (reporting purposes only) */
float *HYD_EVAP_CALC; /*!< _Units_: m/d; _Brief_: HYDrologic, total potential EVAPotranspiration (was calculated variable in v2.1, now data input) */
float *HYD_MANNINGS_N; /*!< _Units_: d/(m^(1/3)); _Brief_: HYDrologic, calculated MANNING'S N surface roughness, (based on empirically-derived surface roughness coeficient) */
float *HYD_SAT_POT_TRANS; /*!< _Units_: m/d; _Brief_: HYDrologic, POTential TRANSpiration loss from SATurated water storage */
float *HYD_SED_WAT_VOL; /*!< _Units_: m^3; _Brief_: HYDrologic, WATer VOLume stored in soil/SEDiment storage */
float *HYD_TOT_POT_TRANSP; /*!< _Units_: m/d; _Brief_: HYDrologic, total POTential TRANSpiration loss (from saturated and unsaturated water storages) */
float *HYD_TRANSP; /*!< _Units_: m/d; _Brief_: HYDrologic, sum of actual TRANSPiration loss from saturated and unsaturated water storages (reporting purposes only) */
float *HYD_UNSAT_POT_TRANS; /*!< _Units_: m/d; _Brief_: HYDrologic, POTential TRANSpiration loss from UNSATurated water storage */
float *HYD_WATER_AVAIL; /*!< _Units_: dimless; _Brief_: HYDrologic, control function (0-1) of proportion of WATer in upper soil profile that is AVAILable for plant uptake, including unsaturated storage withdrawal, and small capillary withdrawal from saturated storage, depending on relative depths */
float *HydTotHd; /*!< _Units_: m; _Brief_: Hydrologic, Total hydraulic Head (or stage), not used in calculations, only for reporting purposes */
float *LAI_eff; /*!< _Units_: dimless; _Brief_: effective LAI estimates leaf area index that is above ponded surface water */
float *MAC_WATER_AVAIL_CF; /*!< _Units_: dimless; _Brief_: empirical data as a (0-1) control function, the proportion (Y) of water available to plants as a function of proportion (0-1) of water available in upper soil profile (X, HYD_WATER_AVAIL (generally, simply 1:1 relationship) */
float *SAT_TO_UNSAT_FL    ; /*!< _Units_: m/d; _Brief_: Effectively unused as recharge rate should be parameterized as 0: SATurated TO UNSATurated FLow with lowering water table due to recharge loss ONLY */
float *SAT_VS_UNSAT; /*!< _Units_: dimless; _Brief_: control function (0-1), determining relative magnitude of potential surface- to SATurated VS UNSATurated storage flow, having effects under conditions of extremely shallow ponded depths (ca. a couple cm or less) */
float *SAT_WATER; /*!< _Units_: m; _Brief_: height of the SATurated WATER storage volume (excluding soil/sediment volume) */
float *SAT_WT_HEAD; /*!< _Units_: m; _Brief_: SATurated WaTer hydraulic HEAD (does not include any overlying surface water) */
float *SAT_WT_RECHG      ; /*!< _Units_: m/d; _Brief_: Effectively unused as recharge rate should be parameterized as 0: SATurated WaTer RECHarGe loss to deep aquifer */
float *SAT_WT_TRANSP; /*!< _Units_: m/d; _Brief_: actual TRANSPiration loss from SATurated WaTer storage */

float *SF_WT_EVAP; /*!< _Units_: m/d; _Brief_: actual EVAPoration loss from SurFace WaTer storage */
float *SF_WT_FROM_RAIN; /*!< _Units_: m/d; _Brief_: RAINfall gain to the SurFace WaTer storage */
float *SF_WT_INFILTRATION; /*!< _Units_: m/d; _Brief_: SurFace WaTer loss due to INFILTRATION into the unsaturated storage zone */
float *SF_WT_POT_INF; /*!< _Units_: m/d; _Brief_: SurFace WaTer POTential loss due to INFiltration into the unsaturated storage zone */
float *SF_WT_TO_SAT_DOWNFLOW; /*!< _Units_: m/d; _Brief_: SurFace WaTer DOWNFLOW TO SATurated storage */
float *SFWT_VOL; /*!< _Units_: m^3; _Brief_: SurFace WaTer storage VOLume  */
float *SURFACE_WAT; /*!< _Units_: m; _Brief_: height of the SurFace WaTer storage VOLume  */
float *UNSAT_AVAIL; /*!< _Units_: dimless; _Brief_: proportion (0-1) of UNSATurated water storage in pore space that is AVAILable for gravitational flow (above field capacity) */
float *UNSAT_CAP; /*!< _Units_: m; _Brief_: potential total storage CAPacity (pore space) in the height of the current UNSATurated zone */
float *UNSAT_DEPTH; /*!< _Units_: m; _Brief_: DEPTH (height) of the UNSATurated zone (including pore space) */
float *UNSAT_HYD_COND_CF; /*!< _Units_: dimless; _Brief_: empirical data as a control function (0-1), the proportion (Y) of maximum vertical water infiltration rate through soil as a function of soil moisture proportion (0-1) (X, UNSAT_MOIST_PRP)  */
float *UNSAT_MOIST_PRP; /*!< _Units_: dimless; _Brief_: MOISTure PRoPortion (0-1) in UNSATurated storage */
float *UNSAT_PERC; /*!< _Units_: m/d; _Brief_: potential PERColation loss from UNSATurated storage to saturated storage */
float *UNSAT_TO_SAT_FL; /*!< _Units_: m/d; _Brief_: PERColation loss from UNSATurated storage to saturated storage */
float *UNSAT_TRANSP; /*!< _Units_: m/d; _Brief_: actual TRANSPiration loss from UNSATurated water storage */
float *UNSAT_WATER; /*!< _Units_: m; _Brief_: height of the UNSATurated WATER storage volume (excluding soil/sediment volume) */
float *UNSAT_WT_POT; /*!< _Units_: m; _Brief_: UNSATurated WaTer storage POTential storage that is not filled (<= UNSAT_CAP) */









int *basn; /*!< _Units_: dimless; _Brief_: Map array defining hydrologic basins and Indicator Regions */
float *Bathymetry; /*!< _Units_: m; _Brief_: Bathymetry of estuarine areas, as depth of the sediment/soil surface below NGVD 1929, positive values not including the model DATUM_DISTANCE depth below NGVD 1929 */
int *BCondFlow; /*!< _Units_: dimless; _Brief_: Map array defining boundary condition flow allowances */
float *BulkD; /*!< _Units_: kgSoil/m^3soil; _Brief_: Bulk Density of soil */
float *DIM; /*!< _Units_: kgIOM/m^2; _Brief_: Deposited Inorganic Matter mass in upper soil zone (inorganic component only) */
float *DOM_BD; /*!< _Units_: kgOM/m^3soil; _Brief_: Bulk Density of (only) the Deposited Organic Matter component of the soil */
float *ELEVATION; /*!< _Units_: m; _Brief_: initial land surface ELEVATION of the entire sediment/soil complex (m NGVD 1929), not including the model DATUM_DISTANCE depth below NGVD 1929 */
float *HYD_RCCONDUCT; /*!< _Units_: m/d; _Brief_: HYDraulic CONDUCTivity Rate Constant of surficial aquifer */
float *Inorg_Z; /*!< _Units_: m; _Brief_: deposited Inorganic matter in upper soil zone mass converted to depth (Z) (inorganic component only, accounting for bulk density) */
unsigned char *ON_MAP; /*!< _Units_: dimless; _Brief_: Map array (unsigned char) integer defining active grid cells of the model domain, and flow interaction attributes with levee presence */
float *SED_INACT_Z; /*!< _Units_: m; _Brief_: SEDiment/soil INACTive Zone height (=distance below DOM_MAXDEPTH parameter) */
float *WQMsettlVel; /*!< _Units_: m/d; _Brief_: EWQM: Map array defining  basin-based settling rates for Everglades Water Quality Model emulation (cell_dyn13) ONLY */








float *MAC_HEIGHT; /*!< _Units_: m; _Brief_: HEIGHT of MACrophytes above ground surface */
float *MAC_LAI; /*!< _Units_: dimless; _Brief_: MACrophyte Leaf Area Index of the proportion of leaf surface area to ground surface area */
float *MAC_LIGHT_CF; /*!< _Units_: dimless; _Brief_: MACrophyte growth Control Function (0-1) of degree of LIGHT limitation */
float *MAC_MAX_BIO; /*!< _Units_: kgC/m^2; _Brief_: MACrophytes MAXimum attainable BIOmass (sum of two parameters) */
float *MAC_NOPH_BIOMAS; /*!< _Units_: kgC/m^2; _Brief_: MACrophytes live NOn-PHotosynthetic tissue (carbon) BIOMASs */
double *mac_nph_CtoOM; /*!< _Units_: ; _Brief_:  */
double *mac_nph_OM; /*!< _Units_: kgOM/m^2; _Brief_: macophytes live non-photosynthetic tissue (Organic Matter) biomass (bookeeping, only used for mass balance when cell changes habitats) */
double *mac_nph_P; /*!< _Units_: kgP/m^2; _Brief_: macophytes live non-photosynthetic tissue (Phosphorus) biomass */
double *mac_nph_PC; /*!< _Units_: kgP/kgC; _Brief_: macrophyte nonphotosynthetic tissus Phosphorus to Carbon concentration */
float *mac_nph_PC_rep; /*!< _Units_: mgP/kgC; _Brief_: macrophyte nonphotosynthetic tissus Phosphorus to Carbon concentration (units converted for reporting purposes) */
float *MAC_NUT_CF; /*!< _Units_: dimless; _Brief_: MACrophyte growth Control Function (0-1) of degree of NUTrient limitation */
float *MAC_PH_BIOMAS; /*!< _Units_: kgC/m^2; _Brief_: MACrophytes live PHotosynthetic tissue (carbon) BIOMASs */
double *mac_ph_CtoOM; /*!< _Units_: kgC/kgOM; _Brief_: macrophyte nonphotosynthetic tissus Carbon to Organic Matter concentration */
double *mac_ph_OM; /*!< _Units_: kgOM/m^2; _Brief_: macophytes live photosynthetic tissue (Organic Matter) biomass (bookeeping, only used for mass balance when cell changes habitats) */
double *mac_ph_P; /*!< _Units_: kgP/m^2; _Brief_: macophytes live photosynthetic tissue (Phosphorus) biomass */
double *mac_ph_PC; /*!< _Units_: kgP/kgC; _Brief_: macrophyte photosynthetic tissus Phosphorus to Carbon concentration  */
float *mac_ph_PC_rep; /*!< _Units_: mgP/kgC; _Brief_: macrophyte photosynthetic tissus Phosphorus to Carbon concentration (units converted for reporting purposes) */
float *MAC_PROD_CF; /*!< _Units_: dimless; _Brief_: MACrophyte growth Control Function (0-1) of degree of combined  limitations on net carbon primary PRODuction */
float *MAC_REL_BIOM; /*!< _Units_: dimless; _Brief_: proportion of MACrophyte BIOMass RELative to its maximum attainable */
float *MAC_SALT_CF; /*!< _Units_: dimless; _Brief_: MACrophyte growth Control Function (0-1) of degree of SALT constraint;  inoperative in v2.2, hardwired=1.0 */
float *MAC_TEMP_CF; /*!< _Units_: dimless; _Brief_: MACrophyte growth Control Function (0-1) of degree of TEMPerature limitation */
float *MAC_TOT_BIOM; /*!< _Units_: kgC/m^2; _Brief_: MACrophytes live TOTal tissue  BIOMASs */
float *MAC_WATER_CF; /*!< _Units_: dimless; _Brief_: MACrophytes growth Control Function (0-1) of degree of WATer limitation */
float *NPHBIO_AVAIL; /*!< _Units_: kgC/m^2; _Brief_: NonPHototsynthetic macrophyte BIOmass AVAILable for losses via mortality and translocation  */
float *NPHBIO_MORT; /*!< _Units_: kgC/m^2/d; _Brief_: NonPHototsynthetic macrophyte BIOmass MORTality losses */
double *nphbio_mort_OM; /*!< _Units_: kgOM/m^2/d; _Brief_: nonphototsynthetic macrophyte Organic Matter mortality losses */
double *nphbio_mort_P; /*!< _Units_: kgP/m^2/d; _Brief_: nonphototsynthetic macrophyte Phosphorus mortality losses */
float *NPHBIO_MORT_POT; /*!< _Units_: kgC/m^2/d; _Brief_: NonPHototsynthetic macrophyte macrophyte BIOmass MORTality POTential losses */
float *NPHBIO_REFUGE; /*!< _Units_: kgC/m^2; _Brief_: NonPHototsynthetic macrophyte BIOmass REFUGE density (from losses) */
float *NPHBIO_SAT; /*!< _Units_: kgC/m^2; _Brief_: NonPHotosynthetic macrophyte BIOmass SATuration density (90% of the maximum attainable) */
double *nphbio_transl_OM; /*!< _Units_: kgOM/m^2/d; _Brief_: nonphotosynthetic macrophyte Organic Matter translocation gain from photosynthetic biomass */
double *nphbio_transl_P; /*!< _Units_: kgP/m^2/d; _Brief_: nonphotosynthetic macrophyte Phosphorus translocation gain from photosynthetic biomass */
float *NPHBIO_TRANSLOC; /*!< _Units_: kgC/m^2/d; _Brief_: NonPHotosynthetic macrophyte biomass TRANSLOCation gain from photosynthetic biomass */
float *NPHBIO_TRANSLOC_POT; /*!< _Units_: kgC/m^2/d; _Brief_: NonPHotosynthetic macrophyte biomass TRANSLOCation POTential gain from photosynthetic biomass */
float *PHBIO_AVAIL; /*!< _Units_: kgC/m^2; _Brief_: PHototsynthetic macrophyte BIOmass AVAILable for losses via mortality and translocation  */
float *PHBIO_MORT; /*!< _Units_: kgC/m^2/d; _Brief_: PHototsynthetic macrophyte BIOmass MORTality losses */
double *phbio_mort_OM; /*!< _Units_: kgOM/m^2/d; _Brief_: phototsynthetic macrophyte Organic Matter mortality losses */
double *phbio_mort_P; /*!< _Units_: kgP/m^2/d; _Brief_: phototsynthetic macrophyte Phosphorus mortality losses */
float *PHBIO_MORT_POT; /*!< _Units_: kgC/m^2/d; _Brief_: PHototsynthetic macrophyte macrophyte BIOmass MORTality POTential losses */
float *PHBIO_NPP; /*!< _Units_: kgC/m^2/d; _Brief_: PHototsynthetic macrophyte BIOmass Net Primary Production growth gain */
double *phbio_npp_OM; /*!< _Units_: kgOM/m^2/d; _Brief_: phototsynthetic macrophyte Organic Matter net primary production growth gain */
double *phbio_npp_P; /*!< _Units_: kgP/m^2/d; _Brief_: phototsynthetic macrophyte Phosphorus net primary production growth gain */
float *PHBIO_REFUGE; /*!< _Units_: kgC/m^2; _Brief_: PHototsynthetic macrophyte BIOmass REFUGE density (from losses) */
float *PHBIO_SAT; /*!< _Units_: kgC/m^2; _Brief_: PHotosynthetic macrophyte BIOmass SATuration density (90% of the maximum attainable) */
double *phbio_transl_OM; /*!< _Units_: kgOM/m^2/d; _Brief_: photosynthetic macrophyte Organic Matter translocation gain from photosynthetic biomass */
double *phbio_transl_P; /*!< _Units_: kgP/m^2/d; _Brief_: photosynthetic macrophyte Phosphorus translocation gain from photosynthetic biomass */
float *PHBIO_TRANSLOC; /*!< _Units_: kgC/m^2/d; _Brief_: PHotosynthetic macrophyte biomass TRANSLOCation gain from non-photosynthetic biomass */
float *PHBIO_TRANSLOC_POT; /*!< _Units_: kgC/m^2/d; _Brief_: PHotosynthetic macrophyte biomass TRANSLOCation POTential gain from non-photosynthetic biomass */
float *TP_SEDWT_UPTAKE; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus UPTAKE from SEDment/soil WaTer due to macrophyte net primary production */








float *ALG_INCID_LIGHT; /*!< _Units_: cal/cm^2/d; _Brief_: for ALGal growth, INCIDint LIGHT intensity reaching the water surface through macrophyte canopy */
float *ALG_LIGHT_CF; /*!< _Units_: dimless; _Brief_: total periphyton (generalized, ALGae) growth Control Function (0-1) of degree of LIGHT limitation */
float *ALG_LIGHT_EXTINCT; /*!< _Units_: dimless; _Brief_: for ALGal growth, LIGHT EXTINCTion through suspended particles etc in surface water column (STATIC, set= alg_light_ext_coef) */
float *ALG_REFUGE; /*!< _Units_: gC/m^2; _Brief_: total periphyton (generalized, ALGae) biomass REFUGE, below which resp/mortality losses do not occur (static, set= ALG_REF_MULT *  ALG_MAX[habitat] parmameters) */
float *ALG_SAT; /*!< _Units_: gC/m^2; _Brief_: Unused in calculations; potentially the saturation density of algae/periphyton */
float *ALG_TEMP_CF; /*!< _Units_: dimless; _Brief_: total periphyton (generalized, ALGae) growth Control Function (0-1) of degree of TEMPerature limitation */
float *ALG_TOT; /*!< _Units_: gC/m^2; _Brief_: sum TOTal of eutrophic and oligotrophic periphyton (generalized, ALGae) biomass  */
float *ALG_WAT_CF; /*!< _Units_: dimless; _Brief_: total periphyton (generalized, ALGae) growth Control Function (0-1) of degree of WATer limitation */
float *C_ALG; /*!< _Units_: gC/m^2; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) biomass  */
float *C_ALG_AVAIL_MORT; /*!< _Units_: gC/m^2; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) biomass AVAILable for MORTality losses */
float *C_ALG_GPP; /*!< _Units_: gC/m2/d; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) Gross Primary Production gains */
float *C_ALG_GPP_P; /*!< _Units_: gP/m2/d; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) Gross Primary Production Phosphorus gains */
float *C_ALG_MORT; /*!< _Units_: gC/m2/d; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) MORTality losses */
float *C_ALG_MORT_P; /*!< _Units_: gP/m2/d; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) MORTality Phosphorus losses */
float *C_ALG_MORT_POT; /*!< _Units_: gC/m2/d; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) MORTality POTential losses */
float *C_ALG_NPP; /*!< _Units_: gC/m2/d; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) Net Primary Production gains */
float *C_ALG_NUT_CF; /*!< _Units_: dimless; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) growth Control Function (0-1) of degree of NUTrient limitation */
float *C_ALG_P; /*!< _Units_: gP/m^2; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) phosphorus biomass  */
double *C_ALG_PC; /*!< _Units_: gP/gC; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) Phosphorus to Carbon concentration  */
float *C_ALG_PCrep; /*!< _Units_: mgP/kgC; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) Phosphorus to Carbon concentration (units converted for reporting purposes) */
float *C_ALG_PROD_CF; /*!< _Units_: dimless; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) growth Control Function (0-1) of degree of combined  limitations on gross carbon primary PRODuction */
float *C_ALG_RESP; /*!< _Units_: gC/m2/d; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) RESPiration losses */
float *C_ALG_RESP_POT; /*!< _Units_: gC/m2/d; _Brief_: oligotrophic periphyton (archaic, Calcareous, generalized, ALGae) RESPiration POTential losses */
float *NC_ALG; /*!< _Units_: gC/m^2; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) biomass  */
float *NC_ALG_AVAIL_MORT; /*!< _Units_: gC/m^2; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) biomass AVAILable for MORTality losses */
float *NC_ALG_GPP; /*!< _Units_: gC/m2/d; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) Gross Primary Production gains */
float *NC_ALG_GPP_P; /*!< _Units_: gP/m2/d; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) Gross Primary Production Phosphorus gains */
float *NC_ALG_MORT; /*!< _Units_: gC/m2/d; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) MORTality losses */
float *NC_ALG_MORT_P; /*!< _Units_: gP/m2/d; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) MORTality Phosphorus losses */
float *NC_ALG_MORT_POT; /*!< _Units_: gC/m2/d; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) MORTality POTential losses */
float *NC_ALG_NPP; /*!< _Units_: gC/m2/d; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) Net Primary Production gains */
float *NC_ALG_NUT_CF; /*!< _Units_: dimless; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) growth Control Function (0-1) of degree of NUTrient limitation */
float *NC_ALG_P; /*!< _Units_: gP/m^2; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) phosphorus biomass  */
double *NC_ALG_PC; /*!< _Units_: gP/gC; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) Phosphorus to Carbon concentration  */
float *NC_ALG_PCrep; /*!< _Units_: mgP/kgC; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) Phosphorus to Carbon concentration (units converted for reporting purposes) */
float *NC_ALG_PROD_CF; /*!< _Units_: dimless; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) growth Control Function (0-1) of degree of combined  limitations on PRODuction */
float *NC_ALG_RESP; /*!< _Units_: gC/m2/d; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) RESPiration losses */
float *NC_ALG_RESP_POT; /*!< _Units_: gC/m2/d; _Brief_: eutrophic periphyton (archaic, NonCalcareous, generalized, ALGae) RESPiration POTential losses */
float *TP_SFWT_UPTAK; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus UPTAKe from SurFace WaTer due to periphyton primary production */







double *TP_Act_to_Tot; /*!< _Units_: dimless; _Brief_: Total Phosphorus concentration in the upper Active DOM zone relative to average concentration the Total soil/sediment zone down to base_datum; PLACEHOLDER for dynamic variable */
float *TP_Act_to_TotRep; /*!< _Units_: dimless; _Brief_: Total Phosphorus concentration in the upper Active DOM zone relative to average concentration the Total soil/sediment zone down to base_datum; PLACEHOLDER for dynamic variable (was used when variables of type double were not output) */
float *TP_DNFLOW; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus DowNFLOW loss from surface water TP storage to saturated water TP storage via advection and diffusion */
float *TP_DNFLOW_POT; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus DowNFLOW POTential loss from surface water TP storage to saturated water TP storage via advection and diffusion */
float *TP_FR_RAIN; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus DowNFLOW gained from atmospheric deposition (via a rainfall TP concentration) */
float *TP_K; /*!< _Units_: mgP/L; _Brief_: Total Phosphorus K value calculated for Freundlich sorption eqn */
double *TP_SED_CONC; /*!< _Units_: kgP/m^3; _Brief_: Total Phosphorus CONCentration in entire SEDiment/soil water volume */
double *TP_SED_WT; /*!< _Units_: kgP; _Brief_: Total Phosphorus stored in entire SEDiment/soil WaTer volume */
double *TP_SED_WT_AZ; /*!< _Units_: kgP; _Brief_: Total Phosphorus stored in Active Zone of SEDiment/soil WaTer volume */
double *TP_SEDWT_CONCACT; /*!< _Units_: kgP/m^3; _Brief_: Total Phosphorus CONCentration in ACTive SEDiment/soil WaTer volume */
float *TP_SEDWT_CONCACTMG; /*!< _Units_: mgP/L; _Brief_: Total Phosphorus CONCentration in ACTive SEDiment/soil WaTer volume */
float *TP_settl; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus settled (deposited) out of storage in surface water (same varName used, but Everglades Water Quality Model module calc'd differently from ELM phosphorus module) */

double *TP_SF_WT; /*!< _Units_: kgP; _Brief_: Total Phosphorus stored in SurFace WaTer volume */
double *TP_SFWT_CONC; /*!< _Units_: kgP/m^3; _Brief_: Total Phosphorus CONCentration in SurFace WaTer volume */
float *TP_SFWT_CONC_MG; /*!< _Units_: mgP/L; _Brief_: Total Phosphorus CONCentration in SurFace WaTer volume */
double *TP_SORB; /*!< _Units_: kgP; _Brief_: Total Phosphorus storage that is SORBed to sediment/soils */
float *TP_SORB_POT; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus POTential flux of adSORBtion to (positive) or deSORBtion from (negative) sediment/soils (Note the negative values in this flux variable: neg values are not accomodated in default unsigned char map output) */
double *TP_SORBCONC; /*!< _Units_: gP/kg_soil; _Brief_: Total Phosphorus CONCentration SORBed to (organic and inorganic) soil mass (note units of gP/kg_soil) */
float *TP_SORBCONC_rep; /*!< _Units_: mgP/kg_soil; _Brief_: Total Phosphorus CONCentration SORBed to (organic and inorganic) soil mass (reporting purposes only) */
float *TP_SORBTION; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus flux of adSORBTION to (positive) or deSORBTION from (negative) sediment/soils (Note the negative values in this flux variable: neg values are not accomodated in default unsigned char map output) */
float *TP_UPFLOW; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus UPFLOW gain to surface water TP storage from saturated water TP storage via diffusion (advection handled separately in surface-ground water integration module within fluxes.c source) */
float *TP_UPFLOW_POT; /*!< _Units_: kgP/d; _Brief_: Total Phosphorus UPFLOW POTential gain to surface water TP storage from saturated water TP storage via diffusion (advection handled separately in surface-ground water integration module within fluxes.c source) */









double *SAL_SED_WT; /*!< _Units_: kgSalt/m^3; _Brief_: SALinity in SEDiment/soil WaTer storage (can be any conservative solute w/ consistent units - salt/tracer does not affect any other calculation in v2.2) */
float *SAL_SF_WT; /*!< _Units_: kgSalt/m^3; _Brief_: SALinity in SurFace WaTer storage when ponded depth is sufficiently non-trivial (can be any conservative solute w/ consistent units - salt/tracer does not affect any other calculation in v2.2) */
double *SAL_SF_WT_mb; /*!< _Units_: kgSalt/m^3; _Brief_: SALinity in SurFace WaTer storage when ponded depth is non-zero (can be any conservative solute w/ consistent units - salt/tracer does not affect any other calculation in v2.2) */
float *SALT_SED_TO_SF_FLOW; /*!< _Units_: kgSalt/d; _Brief_: SALT FLOW from SEDiment/soil water storage TO SurFace water storage via diffusion (advection handled separately in surface-ground water integration module within fluxes.c source) */

double *SALT_SED_WT; /*!< _Units_: kgSalt; _Brief_: SALT mass in SEDiment/soil WaTer storage (can be any conservative solute w/ consistent units - salt/tracer does not affect any other calculation in v2.2) */
float *SALT_SFWAT_DOWNFL; /*!< _Units_: kgSalt/d; _Brief_: SALT DOWNFLow from SurFace WATer storage to sediment/soil water storage via diffusion and advection  */
float *SALT_SFWAT_DOWNFL_POT; /*!< _Units_: kgSalt/d; _Brief_: SALT DOWNFLow POTential from SurFace WATer storage to sediment/soil water storage via diffusion and advection  */
double *SALT_SURF_WT; /*!< _Units_: kgSalt; _Brief_: SALT mass in SURFace WaTer storage (can be any conservative solute w/ consistent units - salt/tracer does not affect any other calculation in v2.2) */





double *DEPOS_ORG_MAT; /*!< _Units_: kgOM/m^2; _Brief_: DEPOSited ORGanic MATter (better name is accreted organic matter, AOM) mass in upper soil zone (not including floc layer) */
float *DOM_DECOMP; /*!< _Units_: kgOM/m^2/d; _Brief_: Deposited Organic Matter DECOMPosition losses */
float *DOM_DECOMP_POT; /*!< _Units_: kgOM/m^2/d; _Brief_: Deposited Organic Matter DECOMPosition POTential losses */
float *DOM_FR_FLOC; /*!< _Units_: kgOM/m^2/d; _Brief_: Deposited Organic Matter gained FRom FLOCculent organic matter deposition */
float *DOM_fr_nphBio; /*!< _Units_: kgOM/m^2/d; _Brief_: Deposited Organic Matter gained from mortality of non-photosynthetic Biomass of macrophytes */
double *DOM_P_OM; /*!< _Units_: kgP/kgOM; _Brief_: Deposited Organic Matter Phoshorus concentration (relative to Organic Matter) */
float *DOM_QUALITY_CF; /*!< _Units_: dimless; _Brief_: Deposited Organic Matter Control Function of degree of limitation by surrounding nutrient availability, i.e., QUALITY */
float *DOM_SED_AEROB_Z; /*!< _Units_: m; _Brief_: Deposited Organic Matter SEDiment/soil AEROBic profile depth (Z) (incl. pore space) */
float *DOM_SED_ANAEROB_Z; /*!< _Units_: m; _Brief_: Deposited Organic Matter SEDiment/soil ANAEROBic profile depth (Z) (incl. pore space) */
float *DOM_TEMP_CF; /*!< _Units_: dimless; _Brief_: Deposited Organic Matter Control Function of degree of TEMPerature limitation */
float *DOM_Z; /*!< _Units_: m; _Brief_: Deposited Organic Matter mass in upper soil zone converted to depth (Z) (organic component only, accounting for bulk density) */
double *DOP; /*!< _Units_: kgP/m^2; _Brief_: Deposited Organic Phosphorus (better name is accreted organic phosphorus AOP) mass in upper soil zone (not including floc layer, sorbed P, nor water P storage) */
float *DOP_DECOMP; /*!< _Units_: kgP/m^2/d; _Brief_: Deposited Organic Phosphorus DECOMPosition losses */
float *DOP_FLOC; /*!< _Units_: kgP/m^2/d; _Brief_: Deposited Organic Phosphorus added from FLOC deposition */
float *DOP_nphBio; /*!< _Units_: kgP/m^2/d; _Brief_: Deposited Organic Phosphorus added from nonphotosynthetic Biomass mortality */
float *P_SUM_CELL; /*!< _Units_: gP/m^2; _Brief_: SUM of all (biotic/abiotic) storages of Phosphorus (in CELLs) (for reporting only, thus units converted to gP/m^2) */
float *SED_ELEV; /*!< _Units_: m (see descript); _Brief_: total land surface ELEVation of the entire SEDiment/soil complex, including model DATUM_DISTANCE depth below NGVD 1929 (i.e., NGVD'29+DATUM_DISTANCE) */


float *TPtoSOIL; /*!< _Units_: kgP/kg_soil; _Brief_: Total Phosphorus concentration in SOIL mass */
float *TPtoSOIL_rep; /*!< _Units_: mgP/kg_soil; _Brief_: Total Phosphorus concentration in SOIL mass (reporting purposes only) */
float *TPtoVOL; /*!< _Units_: kgP/m^3_soil; _Brief_: Total Phosphorus concentration in soil VOLume */
float *TPtoVOL_rep; /*!< _Units_: ug/cm^3; _Brief_: Total Phosphorus concentration in soil VOLume (reporting purposes only) */





#endif /* UNITMOD_VARS_H */
